/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.WireFormats;
import org.apache.pekko.remote.serialization.ProtobufSerializer$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public class ProtobufSerializer
implements Serializer,
BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ProtobufSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private final AtomicReference<Map<Class<?>, Method>> parsingMethodBindingRef;
    private final AtomicReference<Map<Class<?>, Method>> toByteArrayMethodBindingRef;
    private final Set<String> allowedClassNames;
    private volatile Object serialization$lzy1;
    private final MarkerLoggingAdapter log;

    public static ActorRef deserializeActorRef(ExtendedActorSystem extendedActorSystem, WireFormats.ActorRefData actorRefData) {
        return ProtobufSerializer$.MODULE$.deserializeActorRef(extendedActorSystem, actorRefData);
    }

    public static WireFormats.ActorRefData serializeActorRef(ActorRef actorRef) {
        return ProtobufSerializer$.MODULE$.serializeActorRef(actorRef);
    }

    public ProtobufSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        this.parsingMethodBindingRef = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.toByteArrayMethodBindingRef = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.allowedClassNames = package.JavaConverters$.MODULE$.ListHasAsScala(system.settings().config().getStringList("pekko.serialization.protobuf.allowed-classes")).asScala().toSet();
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, ProtobufSerializer.class, LogSource$.MODULE$.fromAnyClass());
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean includeManifest() {
        return true;
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        Option<Class<?>> option = manifest;
        if (option instanceof Some) {
            Class clazz = (Class)((Some)option).value();
            return this.parsingMethod$1(clazz, ProtobufSerializer.parsingMethod$default$1$1()).invoke(null, new Object[]{bytes});
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Need a protobuf message class to be able to serialize bytes using protobuf");
        }
        throw new MatchError(option);
    }

    public byte[] toBinary(Object obj) {
        Class<?> clazz = obj.getClass();
        return (byte[])this.toByteArrayMethod$1(clazz, ProtobufSerializer.toByteArrayMethod$default$1$1()).invoke(obj, new Object[0]);
    }

    private void checkAllowedClass(Class<?> clazz) {
        if (!this.isInAllowList(clazz)) {
            String warnMsg = new StringBuilder(230).append("Can't deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Only classes that are on the allow list are allowed for security reasons. ").append("Configure allowed classes with pekko.actor.serialization-bindings or ").append("pekko.serialization.protobuf.allowed-classes").toString();
            this.log.warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private boolean isInAllowList(Class<?> clazz) {
        return this.isBoundToProtobufSerializer(clazz) || this.isInAllowListClassName(clazz);
    }

    private boolean isBoundToProtobufSerializer(Class<?> clazz) {
        boolean bl;
        try {
            Serializer boundSerializer = this.serialization().serializerFor(clazz);
            bl = boundSerializer instanceof ProtobufSerializer;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private boolean isInAllowListClassName(Class<?> clazz) {
        Object object;
        return this.allowedClassNames.apply((Object)clazz.getName()) || this.allowedClassNames.apply((Object)clazz.getSuperclass().getName()) || ArrayOps$.MODULE$.exists$extension(object = Predef$.MODULE$.refArrayOps((Object[])clazz.getInterfaces()), (Function1 & Serializable)c -> this.allowedClassNames.apply((Object)c.getName()));
    }

    private final Method parsingMethod$1(Class clazz$1, Method method) {
        Option option;
        while (true) {
            Method unCachedParsingMethod;
            Map<Class<?>, Method> parsingMethodBinding;
            if ((option = (parsingMethodBinding = this.parsingMethodBindingRef.get()).get((Object)clazz$1)) instanceof Some) {
                Method cachedParsingMethod = (Method)((Some)option).value();
                return cachedParsingMethod;
            }
            if (!None$.MODULE$.equals(option)) break;
            this.checkAllowedClass(clazz$1);
            Method method2 = unCachedParsingMethod = method == null ? clazz$1.getDeclaredMethod("parseFrom", ProtobufSerializer$.org$apache$pekko$remote$serialization$ProtobufSerializer$$$ARRAY_OF_BYTE_ARRAY) : method;
            if (this.parsingMethodBindingRef.compareAndSet(parsingMethodBinding, (Map<Class<?>, Method>)parsingMethodBinding.updated((Object)clazz$1, (Object)unCachedParsingMethod))) {
                return unCachedParsingMethod;
            }
            method = unCachedParsingMethod;
        }
        throw new MatchError((Object)option);
    }

    private static final Method parsingMethod$default$1$1() {
        return null;
    }

    private final Method toByteArrayMethod$1(Class clazz$2, Method method) {
        Option option;
        while (true) {
            Method unCachedtoByteArrayMethod;
            Map<Class<?>, Method> toByteArrayMethodBinding;
            if ((option = (toByteArrayMethodBinding = this.toByteArrayMethodBindingRef.get()).get((Object)clazz$2)) instanceof Some) {
                Method cachedtoByteArrayMethod = (Method)((Some)option).value();
                return cachedtoByteArrayMethod;
            }
            if (!None$.MODULE$.equals(option)) break;
            Method method2 = unCachedtoByteArrayMethod = method == null ? clazz$2.getMethod("toByteArray", new Class[0]) : method;
            if (this.toByteArrayMethodBindingRef.compareAndSet(toByteArrayMethodBinding, (Map<Class<?>, Method>)toByteArrayMethodBinding.updated((Object)clazz$2, (Object)unCachedtoByteArrayMethod))) {
                return unCachedtoByteArrayMethod;
            }
            method = unCachedtoByteArrayMethod;
        }
        throw new MatchError((Object)option);
    }

    private static final Method toByteArrayMethod$default$1$1() {
        return null;
    }
}

