/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.List;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public class PekkoProtocolSettings {
    private final Config TransportFailureDetectorConfig;
    private final String TransportFailureDetectorImplementationClass;
    private final FiniteDuration TransportHeartBeatInterval;
    private final FiniteDuration HandshakeTimeout;
    private final String ManagerNamePrefix;
    private final String PekkoScheme;

    public PekkoProtocolSettings(Config config) {
        FiniteDuration finiteDuration;
        this.TransportFailureDetectorConfig = config.getConfig("pekko.remote.classic.transport-failure-detector");
        this.TransportFailureDetectorImplementationClass = this.TransportFailureDetectorConfig().getString("implementation-class");
        FiniteDuration finiteDuration2 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.TransportFailureDetectorConfig()), "heartbeat-interval"));
        this.TransportHeartBeatInterval = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration2, (Function1 & Serializable)_$1 -> _$1.$greater((Object)Duration$.MODULE$.Zero()), PekkoProtocolSettings::$init$$$anonfun$2);
        List enabledTransports = config.getStringList("pekko.remote.classic.enabled-transports");
        if (enabledTransports.contains("pekko.remote.classic.netty.tcp")) {
            finiteDuration = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.netty.tcp.connection-timeout");
        } else if (enabledTransports.contains("pekko.remote.classic.netty.ssl")) {
            finiteDuration = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.netty.ssl.connection-timeout");
        } else {
            FiniteDuration finiteDuration3 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.remote.classic.handshake-timeout"));
            finiteDuration = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration3, (Function1 & Serializable)_$2 -> _$2.$greater((Object)Duration$.MODULE$.Zero()), PekkoProtocolSettings::$init$$$anonfun$4);
        }
        this.HandshakeTimeout = finiteDuration;
        this.ManagerNamePrefix = config.getString("pekko.remote.classic.manager-name-prefix");
        this.PekkoScheme = new RemoteSettings(config).ProtocolName();
    }

    public Config TransportFailureDetectorConfig() {
        return this.TransportFailureDetectorConfig;
    }

    public String TransportFailureDetectorImplementationClass() {
        return this.TransportFailureDetectorImplementationClass;
    }

    public FiniteDuration TransportHeartBeatInterval() {
        return this.TransportHeartBeatInterval;
    }

    public FiniteDuration HandshakeTimeout() {
        return this.HandshakeTimeout;
    }

    public String ManagerNamePrefix() {
        return this.ManagerNamePrefix;
    }

    public String PekkoScheme() {
        return this.PekkoScheme;
    }

    private static final Object $init$$$anonfun$2() {
        return "transport-failure-detector.heartbeat-interval must be > 0";
    }

    private static final Object $init$$$anonfun$4() {
        return "handshake-timeout must be > 0";
    }
}

