/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.remote.transport.ActorTransportAdapter;
import org.apache.pekko.remote.transport.ActorTransportAdapter$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.ThrottlerManager;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Direction$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$ForceDisassociate$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$ForceDisassociateAck$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$ForceDisassociateExplicitly$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$SetThrottle$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$SetThrottleAck$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$TokenBucket$;
import org.apache.pekko.remote.transport.Transport;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ThrottlerTransportAdapter
extends ActorTransportAdapter {
    public static String SchemeIdentifier() {
        return ThrottlerTransportAdapter$.MODULE$.SchemeIdentifier();
    }

    public static AtomicInteger UniqueId() {
        return ThrottlerTransportAdapter$.MODULE$.UniqueId();
    }

    public static ThrottleMode blackholeThrottleMode() {
        return ThrottlerTransportAdapter$.MODULE$.blackholeThrottleMode();
    }

    public static Direction bothDirection() {
        return ThrottlerTransportAdapter$.MODULE$.bothDirection();
    }

    public static Direction receiveDirection() {
        return ThrottlerTransportAdapter$.MODULE$.receiveDirection();
    }

    public static Direction sendDirection() {
        return ThrottlerTransportAdapter$.MODULE$.sendDirection();
    }

    public static ThrottleMode unthrottledThrottleMode() {
        return ThrottlerTransportAdapter$.MODULE$.unthrottledThrottleMode();
    }

    public ThrottlerTransportAdapter(Transport _wrappedTransport, ExtendedActorSystem _system) {
        super(_wrappedTransport, (ActorSystem)_system);
    }

    @Override
    public String addedSchemeIdentifier() {
        return ThrottlerTransportAdapter$.MODULE$.SchemeIdentifier();
    }

    @Override
    public int maximumOverhead() {
        return 0;
    }

    @Override
    public String managerName() {
        return new StringBuilder(17).append("throttlermanager.").append(this.wrappedTransport().schemeIdentifier()).append(ThrottlerTransportAdapter$.MODULE$.UniqueId().getAndIncrement()).toString();
    }

    @Override
    public Props managerProps() {
        Transport wt = this.wrappedTransport();
        return Props$.MODULE$.apply(ThrottlerManager.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{wt}));
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        Object object = cmd;
        if (object instanceof SetThrottle) {
            SetThrottle s = (SetThrottle)object;
            ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(this.manager());
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)s, ActorTransportAdapter$.MODULE$.AskTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)s)).map((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (ThrottlerTransportAdapter$SetThrottleAck$.MODULE$.equals(object)) {
                    return true;
                }
                throw new IllegalStateException();
            }, this.ec());
        }
        if (object instanceof ForceDisassociate) {
            ForceDisassociate f = (ForceDisassociate)object;
            ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(this.manager());
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)f, ActorTransportAdapter$.MODULE$.AskTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)f)).map((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (ThrottlerTransportAdapter$ForceDisassociateAck$.MODULE$.equals(object)) {
                    return true;
                }
                throw new IllegalStateException();
            }, this.ec());
        }
        if (object instanceof ForceDisassociateExplicitly) {
            ForceDisassociateExplicitly f = (ForceDisassociateExplicitly)object;
            ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(this.manager());
            return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)f, ActorTransportAdapter$.MODULE$.AskTimeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)f)).map((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (ThrottlerTransportAdapter$ForceDisassociateAck$.MODULE$.equals(object)) {
                    return true;
                }
                throw new IllegalStateException();
            }, this.ec());
        }
        return this.wrappedTransport().managementCommand(cmd);
    }

    public static interface Direction {
        public static int ordinal(Direction direction) {
            return ThrottlerTransportAdapter$Direction$.MODULE$.ordinal(direction);
        }

        public boolean includes(Direction var1);
    }

    public static final class ForceDisassociate
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Address address;

        public static ForceDisassociate apply(Address address) {
            return ThrottlerTransportAdapter$ForceDisassociate$.MODULE$.apply(address);
        }

        public static ForceDisassociate fromProduct(Product product) {
            return ThrottlerTransportAdapter$ForceDisassociate$.MODULE$.fromProduct(product);
        }

        public static ForceDisassociate unapply(ForceDisassociate forceDisassociate) {
            return ThrottlerTransportAdapter$ForceDisassociate$.MODULE$.unapply(forceDisassociate);
        }

        public ForceDisassociate(Address address) {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ForceDisassociate)) return false;
            ForceDisassociate forceDisassociate = (ForceDisassociate)object;
            Address address = this.address();
            Address address2 = forceDisassociate.address();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ForceDisassociate;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ForceDisassociate";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address address() {
            return this.address;
        }

        public ForceDisassociate copy(Address address) {
            return new ForceDisassociate(address);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public Address _1() {
            return this.address();
        }
    }

    public static final class ForceDisassociateExplicitly
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Address address;
        private final AssociationHandle.DisassociateInfo reason;

        public static ForceDisassociateExplicitly apply(Address address, AssociationHandle.DisassociateInfo disassociateInfo) {
            return ThrottlerTransportAdapter$ForceDisassociateExplicitly$.MODULE$.apply(address, disassociateInfo);
        }

        public static ForceDisassociateExplicitly fromProduct(Product product) {
            return ThrottlerTransportAdapter$ForceDisassociateExplicitly$.MODULE$.fromProduct(product);
        }

        public static ForceDisassociateExplicitly unapply(ForceDisassociateExplicitly forceDisassociateExplicitly) {
            return ThrottlerTransportAdapter$ForceDisassociateExplicitly$.MODULE$.unapply(forceDisassociateExplicitly);
        }

        public ForceDisassociateExplicitly(Address address, AssociationHandle.DisassociateInfo reason) {
            this.address = address;
            this.reason = reason;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ForceDisassociateExplicitly)) return false;
            ForceDisassociateExplicitly forceDisassociateExplicitly = (ForceDisassociateExplicitly)object;
            Address address = this.address();
            Address address2 = forceDisassociateExplicitly.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            AssociationHandle.DisassociateInfo disassociateInfo = this.reason();
            AssociationHandle.DisassociateInfo disassociateInfo2 = forceDisassociateExplicitly.reason();
            if (disassociateInfo == null) {
                if (disassociateInfo2 == null) return true;
                return false;
            } else {
                if (!disassociateInfo.equals(disassociateInfo2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ForceDisassociateExplicitly;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ForceDisassociateExplicitly";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            if (1 == n2) {
                return "reason";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address address() {
            return this.address;
        }

        public AssociationHandle.DisassociateInfo reason() {
            return this.reason;
        }

        public ForceDisassociateExplicitly copy(Address address, AssociationHandle.DisassociateInfo reason) {
            return new ForceDisassociateExplicitly(address, reason);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public AssociationHandle.DisassociateInfo copy$default$2() {
            return this.reason();
        }

        public Address _1() {
            return this.address();
        }

        public AssociationHandle.DisassociateInfo _2() {
            return this.reason();
        }
    }

    public static final class SetThrottle
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Address address;
        private final Direction direction;
        private final ThrottleMode mode;

        public static SetThrottle apply(Address address, Direction direction, ThrottleMode throttleMode) {
            return ThrottlerTransportAdapter$SetThrottle$.MODULE$.apply(address, direction, throttleMode);
        }

        public static SetThrottle fromProduct(Product product) {
            return ThrottlerTransportAdapter$SetThrottle$.MODULE$.fromProduct(product);
        }

        public static SetThrottle unapply(SetThrottle setThrottle) {
            return ThrottlerTransportAdapter$SetThrottle$.MODULE$.unapply(setThrottle);
        }

        public SetThrottle(Address address, Direction direction, ThrottleMode mode) {
            this.address = address;
            this.direction = direction;
            this.mode = mode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SetThrottle)) return false;
            SetThrottle setThrottle = (SetThrottle)object;
            Address address = this.address();
            Address address2 = setThrottle.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            Direction direction = this.direction();
            Direction direction2 = setThrottle.direction();
            if (direction == null) {
                if (direction2 != null) {
                    return false;
                }
            } else if (!direction.equals(direction2)) return false;
            ThrottleMode throttleMode = this.mode();
            ThrottleMode throttleMode2 = setThrottle.mode();
            if (throttleMode == null) {
                if (throttleMode2 == null) return true;
                return false;
            } else {
                if (!throttleMode.equals(throttleMode2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SetThrottle;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SetThrottle";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "address";
                }
                case 1: {
                    return "direction";
                }
                case 2: {
                    return "mode";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address address() {
            return this.address;
        }

        public Direction direction() {
            return this.direction;
        }

        public ThrottleMode mode() {
            return this.mode;
        }

        public SetThrottle copy(Address address, Direction direction, ThrottleMode mode) {
            return new SetThrottle(address, direction, mode);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public Direction copy$default$2() {
            return this.direction();
        }

        public ThrottleMode copy$default$3() {
            return this.mode();
        }

        public Address _1() {
            return this.address();
        }

        public Direction _2() {
            return this.direction();
        }

        public ThrottleMode _3() {
            return this.mode();
        }
    }

    public static interface ThrottleMode
    extends NoSerializationVerificationNeeded {
        public Tuple2<ThrottleMode, Object> tryConsumeTokens(long var1, int var3);

        public FiniteDuration timeToAvailable(long var1, int var3);
    }

    public static final class TokenBucket
    implements ThrottleMode,
    Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int capacity;
        private final double tokensPerSecond;
        private final long nanoTimeOfLastSend;
        private final int availableTokens;

        public static TokenBucket apply(int n, double d, long l, int n2) {
            return ThrottlerTransportAdapter$TokenBucket$.MODULE$.apply(n, d, l, n2);
        }

        public static TokenBucket fromProduct(Product product) {
            return ThrottlerTransportAdapter$TokenBucket$.MODULE$.fromProduct(product);
        }

        public static TokenBucket unapply(TokenBucket tokenBucket) {
            return ThrottlerTransportAdapter$TokenBucket$.MODULE$.unapply(tokenBucket);
        }

        public TokenBucket(int capacity, double tokensPerSecond, long nanoTimeOfLastSend, int availableTokens) {
            this.capacity = capacity;
            this.tokensPerSecond = tokensPerSecond;
            this.nanoTimeOfLastSend = nanoTimeOfLastSend;
            this.availableTokens = availableTokens;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.capacity());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.tokensPerSecond()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.nanoTimeOfLastSend()));
            n = Statics.mix((int)n, (int)this.availableTokens());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TokenBucket)) return false;
            TokenBucket tokenBucket = (TokenBucket)object;
            if (this.capacity() != tokenBucket.capacity()) return false;
            if (this.tokensPerSecond() != tokenBucket.tokensPerSecond()) return false;
            if (this.nanoTimeOfLastSend() != tokenBucket.nanoTimeOfLastSend()) return false;
            if (this.availableTokens() != tokenBucket.availableTokens()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TokenBucket;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "TokenBucket";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "capacity";
                }
                case 1: {
                    return "tokensPerSecond";
                }
                case 2: {
                    return "nanoTimeOfLastSend";
                }
                case 3: {
                    return "availableTokens";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int capacity() {
            return this.capacity;
        }

        public double tokensPerSecond() {
            return this.tokensPerSecond;
        }

        public long nanoTimeOfLastSend() {
            return this.nanoTimeOfLastSend;
        }

        public int availableTokens() {
            return this.availableTokens;
        }

        private boolean isAvailable(long nanoTimeOfSend, int tokens) {
            if (tokens > this.capacity() && this.availableTokens() > 0) {
                return true;
            }
            return package$.MODULE$.min(this.availableTokens() + this.tokensGenerated(nanoTimeOfSend), this.capacity()) >= tokens;
        }

        @Override
        public Tuple2<ThrottleMode, Object> tryConsumeTokens(long nanoTimeOfSend, int tokens) {
            if (this.isAvailable(nanoTimeOfSend, tokens)) {
                int n = package$.MODULE$.min(this.availableTokens() - tokens + this.tokensGenerated(nanoTimeOfSend), this.capacity());
                int n2 = this.copy$default$1();
                double d = this.copy$default$2();
                return Tuple2$.MODULE$.apply((Object)this.copy(n2, d, nanoTimeOfSend, n), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            return Tuple2$.MODULE$.apply((Object)this, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }

        @Override
        public FiniteDuration timeToAvailable(long currentNanoTime, int tokens) {
            int needed = (tokens > this.capacity() ? 1 : tokens) - this.tokensGenerated(currentNanoTime);
            return new package.DurationDouble(scala.concurrent.duration.package$.MODULE$.DurationDouble((double)needed / this.tokensPerSecond())).seconds();
        }

        private int tokensGenerated(long nanoTimeOfSend) {
            return (int)((double)TimeUnit.NANOSECONDS.toMillis(nanoTimeOfSend - this.nanoTimeOfLastSend()) * this.tokensPerSecond() / 1000.0);
        }

        public TokenBucket copy(int capacity, double tokensPerSecond, long nanoTimeOfLastSend, int availableTokens) {
            return new TokenBucket(capacity, tokensPerSecond, nanoTimeOfLastSend, availableTokens);
        }

        public int copy$default$1() {
            return this.capacity();
        }

        public double copy$default$2() {
            return this.tokensPerSecond();
        }

        public long copy$default$3() {
            return this.nanoTimeOfLastSend();
        }

        public int copy$default$4() {
            return this.availableTokens();
        }

        public int _1() {
            return this.capacity();
        }

        public double _2() {
            return this.tokensPerSecond();
        }

        public long _3() {
            return this.nanoTimeOfLastSend();
        }

        public int _4() {
            return this.availableTokens();
        }
    }
}

