/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import io.netty.channel.Channel;
import java.io.Serializable;
import java.net.SocketAddress;
import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.netty.CommonHandlers;
import org.apache.pekko.remote.transport.netty.NettyChannelHandlerAdapter;
import org.apache.pekko.remote.transport.netty.NettyClientHelpers;
import org.apache.pekko.remote.transport.netty.NettyTransport;
import scala.Function1;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public abstract class ClientHandler
extends NettyChannelHandlerAdapter
implements NettyClientHelpers,
CommonHandlers {
    private final NettyTransport transport;
    private final Address remoteAddress;
    private final Promise statusPromise;

    public ClientHandler(NettyTransport transport, Address remoteAddress) {
        this.transport = transport;
        this.remoteAddress = remoteAddress;
        this.statusPromise = Promise$.MODULE$.apply();
    }

    @Override
    public final NettyTransport transport() {
        return this.transport;
    }

    public final Promise<AssociationHandle> statusPromise() {
        return this.statusPromise;
    }

    public Future<AssociationHandle> statusFuture() {
        return this.statusPromise().future();
    }

    public final void initOutbound(Channel channel, SocketAddress remoteSocketAddress) {
        this.init(channel, remoteSocketAddress, this.remoteAddress, (Function1 & Serializable)value -> this.statusPromise().success(value));
    }
}

