/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import org.apache.pekko.remote.transport.netty.SSLSettings;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public class NettyTransportSettings {
    private final Config config;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option WriteBufferHighWaterMark;
    private final Option WriteBufferLowWaterMark;
    private final Option SendBufferSize;
    private final Option ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public NettyTransportSettings(Config config) {
        int n;
        String value;
        String value2;
        None$ none$;
        this.config = config;
        this.EnableSsl = config.getBoolean("enable-ssl");
        this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
        String string = config.getString("use-dispatcher-for-io");
        if ("".equals(string) || string == null) {
            none$ = None$.MODULE$;
        } else {
            String dispatcher = string;
            none$ = Some$.MODULE$.apply((Object)dispatcher);
        }
        this.UseDispatcherForIo = none$;
        this.ConnectionTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "connection-timeout");
        this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
        this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
        this.SendBufferSize = this.optionSize("send-buffer-size");
        this.ReceiveBufferSize = this.optionSize("receive-buffer-size");
        Integer n2 = (Integer)Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size")))));
        this.MaxFrameSize = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension((Object)n2, (Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 >= 32000, NettyTransportSettings::$init$$$anonfun$2));
        this.Backlog = config.getInt("backlog");
        this.TcpNodelay = config.getBoolean("tcp-nodelay");
        this.TcpKeepalive = config.getBoolean("tcp-keepalive");
        String string2 = config.getString("tcp-reuse-addr");
        this.TcpReuseAddr = "off-for-windows".equals(string2) ? !Helpers$.MODULE$.isWindows() : config.getBoolean("tcp-reuse-addr");
        String string3 = config.getString("hostname");
        this.Hostname = "".equals(string3) ? InetAddress.getLocalHost().getHostAddress() : (value2 = string3);
        String string4 = config.getString("bind-hostname");
        this.BindHostname = "".equals(string4) ? this.Hostname() : (value = string4);
        this.PortSelector = config.getInt("port");
        String string5 = config.getString("bind-port");
        if ("".equals(string5)) {
            n = this.PortSelector();
        } else {
            String value3 = string5;
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value3));
        }
        this.BindPortSelector = n;
        this.SslSettings = this.EnableSsl() ? Some$.MODULE$.apply((Object)new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
        this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
        this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
    }

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        if (0 == n) {
            return None$.MODULE$;
        }
        int x = n;
        if (x < 0) {
            throw new ConfigurationException(new StringBuilder(52).append("Setting '").append(s).append("' must be 0 or positive (and fit in an Int)").toString());
        }
        int other = n;
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)other));
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    private static final Object $init$$$anonfun$2() {
        return "Setting 'maximum-frame-size' must be at least 32000 bytes";
    }
}

