/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import org.apache.pekko.util.ccompat.package;
import scala.collection.immutable.Set;

public class SSLSettings {
    private final String SSLKeyStore;
    private final String SSLTrustStore;
    private final String SSLKeyStorePassword;
    private final String SSLKeyPassword;
    private final String SSLTrustStorePassword;
    private final Set SSLEnabledAlgorithms;
    private final String SSLProtocol;
    private final String SSLRandomNumberGenerator;
    private final boolean SSLRequireMutualAuthentication;

    public SSLSettings(Config config) {
        this.SSLKeyStore = config.getString("key-store");
        this.SSLTrustStore = config.getString("trust-store");
        this.SSLKeyStorePassword = config.getString("key-store-password");
        this.SSLKeyPassword = config.getString("key-password");
        this.SSLTrustStorePassword = config.getString("trust-store-password");
        this.SSLEnabledAlgorithms = package.JavaConverters$.MODULE$.ListHasAsScala(config.getStringList("enabled-algorithms")).asScala().toSet();
        this.SSLProtocol = config.getString("protocol");
        this.SSLRandomNumberGenerator = config.getString("random-number-generator");
        this.SSLRequireMutualAuthentication = config.getBoolean("require-mutual-authentication");
    }

    public String SSLKeyStore() {
        return this.SSLKeyStore;
    }

    public String SSLTrustStore() {
        return this.SSLTrustStore;
    }

    public String SSLKeyStorePassword() {
        return this.SSLKeyStorePassword;
    }

    public String SSLKeyPassword() {
        return this.SSLKeyPassword;
    }

    public String SSLTrustStorePassword() {
        return this.SSLTrustStorePassword;
    }

    public Set<String> SSLEnabledAlgorithms() {
        return this.SSLEnabledAlgorithms;
    }

    public String SSLProtocol() {
        return this.SSLProtocol;
    }

    public String SSLRandomNumberGenerator() {
        return this.SSLRandomNumberGenerator;
    }

    public boolean SSLRequireMutualAuthentication() {
        return this.SSLRequireMutualAuthentication;
    }
}

