/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.netty.NettyTransport;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.util.ByteString;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public class TcpAssociationHandle
implements AssociationHandle {
    private final Address localAddress;
    private final Address remoteAddress;
    private final NettyTransport transport;
    private final Channel channel;
    private final Promise readHandlerPromise;

    public TcpAssociationHandle(Address localAddress, Address remoteAddress, NettyTransport transport, Channel channel) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.transport = transport;
        this.channel = channel;
        this.readHandlerPromise = Promise$.MODULE$.apply();
    }

    @Override
    public Address localAddress() {
        return this.localAddress;
    }

    @Override
    public Address remoteAddress() {
        return this.remoteAddress;
    }

    public NettyTransport transport() {
        return this.transport;
    }

    private Channel channel() {
        return this.channel;
    }

    @Override
    public Promise<AssociationHandle.HandleEventListener> readHandlerPromise() {
        return this.readHandlerPromise;
    }

    @Override
    public boolean write(ByteString payload) {
        if (this.channel().isWritable() && this.channel().isOpen()) {
            this.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((ByteBuffer)payload.asByteBuffer()));
            return true;
        }
        return false;
    }

    @Override
    public void disassociate() {
        NettyTransport$.MODULE$.gracefulClose(this.channel(), this.transport().executionContext());
    }
}

