/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperFactory;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperProvider;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class JacksonObjectMapperProvider$
implements ExtensionId<JacksonObjectMapperProvider>,
ExtensionIdProvider {
    public static final JacksonObjectMapperProvider$ MODULE$ = new JacksonObjectMapperProvider$();

    private JacksonObjectMapperProvider$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JacksonObjectMapperProvider$.class);
    }

    public JacksonObjectMapperProvider get(ActorSystem system) {
        return (JacksonObjectMapperProvider)ExtensionId.get$((ExtensionId)this, (ActorSystem)system);
    }

    public JacksonObjectMapperProvider get(ClassicActorSystemProvider system) {
        return (JacksonObjectMapperProvider)ExtensionId.get$((ExtensionId)this, (ClassicActorSystemProvider)system);
    }

    public ExtensionId<? extends Extension> lookup() {
        return this;
    }

    public JacksonObjectMapperProvider createExtension(ExtendedActorSystem system) {
        return new JacksonObjectMapperProvider(system);
    }

    public Config configForBinding(String bindingName, Config systemConfig) {
        String basePath = "pekko.serialization.jackson";
        Config baseConf = systemConfig.getConfig("pekko.serialization.jackson");
        if (systemConfig.hasPath(new StringBuilder(1).append(basePath).append(".").append(bindingName).toString())) {
            return systemConfig.getConfig(new StringBuilder(1).append(basePath).append(".").append(bindingName).toString()).withFallback((ConfigMergeable)baseConf);
        }
        return baseConf;
    }

    private JsonFactory createJsonFactory(String bindingName, JacksonObjectMapperFactory objectMapperFactory, Config config, Option<JsonFactory> baseJsonFactory) {
        JsonFactory jsonFactory;
        Option<JsonFactory> option = baseJsonFactory;
        if (option instanceof Some) {
            JsonFactory factory;
            jsonFactory = factory = (JsonFactory)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            jsonFactory = new JsonFactoryBuilder().build();
        } else {
            throw new MatchError(option);
        }
        JsonFactory jsonFactory2 = jsonFactory;
        Seq configuredStreamReadFeatures = (Seq)this.features(config, "stream-read-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                StreamReadFeature streamReadFeature = (StreamReadFeature)Predef$.MODULE$.ArrowAssoc((Object)StreamReadFeature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)streamReadFeature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<StreamReadFeature, Object>> streamReadFeatures = objectMapperFactory.overrideConfiguredStreamReadFeatures(bindingName, (Seq<Tuple2<StreamReadFeature, Object>>)configuredStreamReadFeatures);
        streamReadFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StreamReadFeature feature = (StreamReadFeature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq configuredStreamWriteFeatures = (Seq)this.features(config, "stream-write-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                StreamWriteFeature streamWriteFeature = (StreamWriteFeature)Predef$.MODULE$.ArrowAssoc((Object)StreamWriteFeature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)streamWriteFeature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<StreamWriteFeature, Object>> streamWriteFeatures = objectMapperFactory.overrideConfiguredStreamWriteFeatures(bindingName, (Seq<Tuple2<StreamWriteFeature, Object>>)configuredStreamWriteFeatures);
        streamWriteFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                StreamWriteFeature feature = (StreamWriteFeature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq configuredJsonReadFeatures = (Seq)this.features(config, "json-read-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                JsonReadFeature jsonReadFeature = (JsonReadFeature)Predef$.MODULE$.ArrowAssoc((Object)JsonReadFeature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsonReadFeature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<JsonReadFeature, Object>> jsonReadFeatures = objectMapperFactory.overrideConfiguredJsonReadFeatures(bindingName, (Seq<Tuple2<JsonReadFeature, Object>>)configuredJsonReadFeatures);
        jsonReadFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JsonReadFeature feature = (JsonReadFeature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq configuredJsonWriteFeatures = (Seq)this.features(config, "json-write-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                JsonWriteFeature jsonWriteFeature = (JsonWriteFeature)Predef$.MODULE$.ArrowAssoc((Object)JsonWriteFeature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsonWriteFeature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<JsonWriteFeature, Object>> jsonWriteFeatures = objectMapperFactory.overrideConfiguredJsonWriteFeatures(bindingName, (Seq<Tuple2<JsonWriteFeature, Object>>)configuredJsonWriteFeatures);
        jsonWriteFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JsonWriteFeature feature = (JsonWriteFeature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return jsonFactory2.configure(feature.mappedFeature(), value);
            }
            throw new MatchError((Object)tuple2);
        });
        return jsonFactory2;
    }

    private void configureObjectMapperFeatures(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config) {
        Seq configuredSerializationFeatures = (Seq)this.features(config, "serialization-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                SerializationFeature serializationFeature = (SerializationFeature)Predef$.MODULE$.ArrowAssoc((Object)SerializationFeature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)serializationFeature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<SerializationFeature, Object>> serializationFeatures = objectMapperFactory.overrideConfiguredSerializationFeatures(bindingName, (Seq<Tuple2<SerializationFeature, Object>>)configuredSerializationFeatures);
        serializationFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SerializationFeature feature = (SerializationFeature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return objectMapper.configure(feature, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq configuredDeserializationFeatures = (Seq)this.features(config, "deserialization-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                DeserializationFeature deserializationFeature = (DeserializationFeature)Predef$.MODULE$.ArrowAssoc((Object)DeserializationFeature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)deserializationFeature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<DeserializationFeature, Object>> deserializationFeatures = objectMapperFactory.overrideConfiguredDeserializationFeatures(bindingName, (Seq<Tuple2<DeserializationFeature, Object>>)configuredDeserializationFeatures);
        deserializationFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DeserializationFeature feature = (DeserializationFeature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return objectMapper.configure(feature, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq configuredMapperFeatures = (Seq)this.features(config, "mapper-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                MapperFeature mapperFeature = (MapperFeature)Predef$.MODULE$.ArrowAssoc((Object)MapperFeature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)mapperFeature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<MapperFeature, Object>> mapperFeatures = objectMapperFactory.overrideConfiguredMapperFeatures(bindingName, (Seq<Tuple2<MapperFeature, Object>>)configuredMapperFeatures);
        mapperFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MapperFeature feature = (MapperFeature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return objectMapper.configure(feature, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq configuredJsonParserFeatures = (Seq)this.features(config, "json-parser-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                JsonParser.Feature feature = (JsonParser.Feature)Predef$.MODULE$.ArrowAssoc((Object)JsonParser.Feature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)feature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<JsonParser.Feature, Object>> jsonParserFeatures = objectMapperFactory.overrideConfiguredJsonParserFeatures(bindingName, (Seq<Tuple2<JsonParser.Feature, Object>>)configuredJsonParserFeatures);
        jsonParserFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JsonParser.Feature feature = (JsonParser.Feature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return objectMapper.configure(feature, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq configuredJsonGeneratorFeatures = (Seq)this.features(config, "json-generator-features").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String enumName = (String)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                JsonGenerator.Feature feature = (JsonGenerator.Feature)Predef$.MODULE$.ArrowAssoc((Object)JsonGenerator.Feature.valueOf((String)enumName));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)feature, (Object)BoxesRunTime.boxToBoolean((boolean)value));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<JsonGenerator.Feature, Object>> jsonGeneratorFeatures = objectMapperFactory.overrideConfiguredJsonGeneratorFeatures(bindingName, (Seq<Tuple2<JsonGenerator.Feature, Object>>)configuredJsonGeneratorFeatures);
        jsonGeneratorFeatures.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JsonGenerator.Feature feature = (JsonGenerator.Feature)tuple2._1();
                boolean value = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return objectMapper.configure(feature, value);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void configureObjectVisibility(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config) {
        Seq configuredVisibility = (Seq)this.configPairs(config, "visibility").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String property = (String)tuple2._1();
                String visibility = (String)tuple2._2();
                PropertyAccessor propertyAccessor = (PropertyAccessor)Predef$.MODULE$.ArrowAssoc((Object)PropertyAccessor.valueOf((String)property));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)propertyAccessor, (Object)JsonAutoDetect.Visibility.valueOf((String)visibility));
            }
            throw new MatchError((Object)tuple2);
        });
        Seq<Tuple2<PropertyAccessor, JsonAutoDetect.Visibility>> visibility = objectMapperFactory.overrideConfiguredVisibility(bindingName, (Seq<Tuple2<PropertyAccessor, JsonAutoDetect.Visibility>>)configuredVisibility);
        visibility.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                PropertyAccessor property = (PropertyAccessor)tuple2._1();
                JsonAutoDetect.Visibility visibility = (JsonAutoDetect.Visibility)tuple2._2();
                return objectMapper.setVisibility(property, visibility);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void configureObjectMapperModules(String bindingName, ObjectMapper objectMapper, JacksonObjectMapperFactory objectMapperFactory, Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> log) {
        Buffer configuredModules = package.JavaConverters$.MODULE$.ListHasAsScala(config.getStringList("jackson-modules")).asScala();
        Buffer modules1 = (Buffer)configuredModules.flatMap((Function1 & Serializable)fqcn -> {
            if (this.isModuleEnabled((String)fqcn, dynamicAccess)) {
                Try try_ = dynamicAccess.createInstanceFor(fqcn, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Module.class));
                if (try_ instanceof Success) {
                    Module m = (Module)((Success)try_).value();
                    return Some$.MODULE$.apply((Object)m);
                }
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    log.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.error(e, new StringBuilder(179).append("Could not load configured Jackson module [").append((String)fqcn).append("], ").append("please verify classpath dependencies or amend the configuration ").append("[pekko.serialization.jackson-modules]. Continuing without this module.").toString()));
                    return None$.MODULE$;
                }
                throw new MatchError((Object)try_);
            }
            return None$.MODULE$;
        });
        List modules2 = ((IterableOnceOps)modules1.map((Function1 & Serializable)module -> {
            if (module instanceof ParameterNamesModule) {
                return new ParameterNamesModule(JsonCreator.Mode.PROPERTIES);
            }
            return module;
        })).toList();
        Seq<Module> modules3 = objectMapperFactory.overrideConfiguredModules(bindingName, (Seq<Module>)modules2);
        modules3.foreach((Function1)(JProcedure1 & Serializable)module -> {
            objectMapper.registerModule(module);
            log.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.debug("Registered Jackson module [{}]", (Object)module.getClass().getName()));
        });
    }

    @InternalStableApi
    public ObjectMapper createObjectMapper(String bindingName, Option<JsonFactory> jsonFactory, JacksonObjectMapperFactory objectMapperFactory, Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> log) {
        JsonFactory configuredJsonFactory = this.createJsonFactory(bindingName, objectMapperFactory, config, jsonFactory);
        ObjectMapper mapper = objectMapperFactory.newObjectMapper(bindingName, configuredJsonFactory);
        this.configureObjectMapperFeatures(bindingName, mapper, objectMapperFactory, config);
        this.configureObjectMapperModules(bindingName, mapper, objectMapperFactory, config, dynamicAccess, log);
        this.configureObjectVisibility(bindingName, mapper, objectMapperFactory, config);
        return mapper;
    }

    private boolean isModuleEnabled(String fqcn, DynamicAccess dynamicAccess) {
        String string = fqcn;
        if ("org.apache.pekko.serialization.jackson.PekkoTypedJacksonModule".equals(string)) {
            return dynamicAccess.classIsOnClasspath("org.apache.pekko.actor.typed.ActorRef");
        }
        if ("org.apache.pekko.serialization.jackson.PekkoStreamJacksonModule".equals(string)) {
            return dynamicAccess.classIsOnClasspath("org.apache.pekko.stream.Graph");
        }
        return true;
    }

    private Seq<Tuple2<String, Object>> features(Config config, String section) {
        Config cfg = config.getConfig(section);
        return ((IterableOnceOps)package.JavaConverters$.MODULE$.SetHasAsScala(cfg.root().keySet()).asScala().map((Function1 & Serializable)key -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(key);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)cfg.getBoolean(key)));
        })).toList();
    }

    private Seq<Tuple2<String, String>> configPairs(Config config, String section) {
        Config cfg = config.getConfig(section);
        return ((IterableOnceOps)package.JavaConverters$.MODULE$.SetHasAsScala(cfg.root().keySet()).asScala().map((Function1 & Serializable)key -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(key);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)cfg.getString(key));
        })).toList();
    }
}

