/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.impl.SubTypeValidator;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.jackson.Compression;
import org.apache.pekko.serialization.jackson.Compression$GZip$;
import org.apache.pekko.serialization.jackson.Compression$LZ4$;
import org.apache.pekko.serialization.jackson.Compression$Off$;
import org.apache.pekko.serialization.jackson.JacksonMigration;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperProvider$;
import org.apache.pekko.serialization.jackson.JacksonSerializer$;
import org.apache.pekko.serialization.jackson.JacksonSerializer$LZ4Meta$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public abstract class JacksonSerializer
extends SerializerWithStringManifest {
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(JacksonSerializer.class.getDeclaredField("lz4Decompressor$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(JacksonSerializer.class.getDeclaredField("lz4Compressor$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(JacksonSerializer.class.getDeclaredField("lz4Factory$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(JacksonSerializer.class.getDeclaredField("deserializationType$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JacksonSerializer.class.getDeclaredField("serialization$lzy1"));
    private final ExtendedActorSystem system;
    private final String bindingName;
    private final ObjectMapper objectMapper;
    private final MarkerLoggingAdapter log;
    private final boolean isDebugEnabled;
    private final Compression.Algoritm compressionAlgorithm;
    private final Map<String, JacksonMigration> migrations;
    private final GadgetClassDenyList denyList;
    private final Vector<String> allowedClassPrefix;
    private final boolean typeInManifest;
    private Option<Class<? extends Object>> configuredDeserializationType;
    private volatile Object serialization$lzy1;
    private volatile Object deserializationType$lzy1;
    private boolean serializationBindingsCheckedOk;
    private volatile Object lz4Factory$lzy1;
    private volatile Object lz4Compressor$lzy1;
    private volatile Object lz4Decompressor$lzy1;
    private final int identifier;

    public static scala.collection.immutable.Set<Class<?>> disallowedSerializationBindings() {
        return JacksonSerializer$.MODULE$.disallowedSerializationBindings();
    }

    public static boolean isGZipped(byte[] byArray) {
        return JacksonSerializer$.MODULE$.isGZipped(byArray);
    }

    public static boolean isLZ4(byte[] byArray) {
        return JacksonSerializer$.MODULE$.isLZ4(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public JacksonSerializer(ExtendedActorSystem system, String bindingName, ObjectMapper objectMapper) {
        None$ none$;
        Compression.Algoritm algoritm;
        Config conf;
        block10: {
            this.system = system;
            this.bindingName = bindingName;
            this.objectMapper = objectMapper;
            this.log = Logging$.MODULE$.withMarker((ActorSystem)system, JacksonSerializer.class, LogSource$.MODULE$.fromAnyClass());
            conf = JacksonObjectMapperProvider$.MODULE$.configForBinding(bindingName, system.settings().config());
            this.isDebugEnabled = conf.getBoolean("verbose-debug-logging") && this.log.isDebugEnabled();
            int BufferSize = 4096;
            String string = Helpers$.MODULE$.toRootLowerCase(conf.getString("compression.algorithm"));
            switch (string == null ? 0 : string.hashCode()) {
                case 107622: {
                    if (!"lz4".equals(string)) break;
                    Long compressLargerThan = conf.getBytes("compression.compress-larger-than");
                    algoritm = Compression$LZ4$.MODULE$.apply(Predef$.MODULE$.Long2long(compressLargerThan));
                    break block10;
                }
                case 109935: {
                    if (!"off".equals(string)) break;
                    algoritm = Compression$Off$.MODULE$;
                    break block10;
                }
                case 3189082: {
                    if (!"gzip".equals(string)) break;
                    Long compressLargerThan = conf.getBytes("compression.compress-larger-than");
                    algoritm = Compression$GZip$.MODULE$.apply(Predef$.MODULE$.Long2long(compressLargerThan));
                    break block10;
                }
            }
            String other = string;
            throw new IllegalArgumentException(new StringBuilder(69).append("Unknown compression algorithm [").append(other).append("], possible values are ").append("\"off\" or \"gzip\"").toString());
        }
        this.compressionAlgorithm = algoritm;
        this.migrations = (Map)package.JavaConverters$.MODULE$.MapHasAsScala(conf.getConfig("migrations").root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                JacksonMigration transformer = (JacksonMigration)system.dynamicAccess().createInstanceFor(v.toString(), (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(JacksonMigration.class)).get();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)transformer);
            }
            throw new MatchError((Object)tuple2);
        });
        this.denyList = new GadgetClassDenyList();
        this.allowedClassPrefix = package.JavaConverters$.MODULE$.ListHasAsScala(conf.getStringList("allowed-class-prefix")).asScala().toVector();
        this.typeInManifest = conf.getBoolean("type-in-manifest");
        String string = conf.getString("deserialization-type");
        if ("".equals(string)) {
            none$ = None$.MODULE$;
        } else {
            String className = string;
            Try try_ = system.dynamicAccess().getClassFor(className, ClassTag$.MODULE$.apply(Object.class));
            if (try_ instanceof Success) {
                Class c = (Class)((Success)try_).value();
                none$ = Some$.MODULE$.apply((Object)c);
            } else {
                if (try_ instanceof Failure) {
                    throw new IllegalArgumentException(new StringBuilder(61).append("Cannot find deserialization-type [").append(className).append("] for Jackson serializer [").append(bindingName).append("]").toString());
                }
                throw new MatchError((Object)try_);
            }
        }
        this.configuredDeserializationType = none$;
        this.serializationBindingsCheckedOk = false;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig(bindingName, system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public String bindingName() {
        return this.bindingName;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<Class<? extends Object>> deserializationType() {
        Object object = this.deserializationType$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.deserializationType$lzyINIT1();
    }

    private Object deserializationType$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.deserializationType$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    None$ none$ = null;
                    try {
                        none$ = this.typeInManifest ? None$.MODULE$ : this.configuredDeserializationType.orElse(this::deserializationType$lzyINIT1$$anonfun$1);
                        object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                        this.configuredDeserializationType = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.deserializationType$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return none$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private LZ4Factory lz4Factory() {
        Object object = this.lz4Factory$lzy1;
        if (object instanceof LZ4Factory) {
            return (LZ4Factory)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LZ4Factory)this.lz4Factory$lzyINIT1();
    }

    private Object lz4Factory$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.lz4Factory$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LZ4Factory lZ4Factory = null;
                    try {
                        lZ4Factory = LZ4Factory.fastestInstance();
                        object2 = lZ4Factory == null ? LazyVals.NullValue$.MODULE$ : lZ4Factory;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.lz4Factory$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return lZ4Factory;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private LZ4Compressor lz4Compressor() {
        Object object = this.lz4Compressor$lzy1;
        if (object instanceof LZ4Compressor) {
            return (LZ4Compressor)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LZ4Compressor)this.lz4Compressor$lzyINIT1();
    }

    private Object lz4Compressor$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.lz4Compressor$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LZ4Compressor lZ4Compressor = null;
                    try {
                        lZ4Compressor = this.lz4Factory().fastCompressor();
                        object2 = lZ4Compressor == null ? LazyVals.NullValue$.MODULE$ : lZ4Compressor;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.lz4Compressor$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return lZ4Compressor;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private LZ4SafeDecompressor lz4Decompressor() {
        Object object = this.lz4Decompressor$lzy1;
        if (object instanceof LZ4SafeDecompressor) {
            return (LZ4SafeDecompressor)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LZ4SafeDecompressor)this.lz4Decompressor$lzyINIT1();
    }

    private Object lz4Decompressor$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.lz4Decompressor$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LZ4SafeDecompressor lZ4SafeDecompressor = null;
                    try {
                        lZ4SafeDecompressor = this.lz4Factory().safeDecompressor();
                        object2 = lZ4SafeDecompressor == null ? LazyVals.NullValue$.MODULE$ : lZ4SafeDecompressor;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.lz4Decompressor$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return lZ4SafeDecompressor;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int identifier() {
        return this.identifier;
    }

    public String manifest(Object obj) {
        this.checkAllowedSerializationBindings();
        Option<Class<? extends Object>> option = this.deserializationType();
        if (option instanceof Some) {
            Class clazz = (Class)((Some)option).value();
            Option option2 = this.migrations.get((Object)clazz.getName());
            if (option2 instanceof Some) {
                JacksonMigration transformer = (JacksonMigration)((Some)option2).value();
                return new StringBuilder(1).append("#").append(transformer.currentVersion()).toString();
            }
            if (None$.MODULE$.equals(option2)) {
                return "";
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String className = obj.getClass().getName();
            this.checkAllowedClassName(className);
            this.checkAllowedClass(obj.getClass());
            Option option3 = this.migrations.get((Object)className);
            if (option3 instanceof Some) {
                JacksonMigration transformer = (JacksonMigration)((Some)option3).value();
                return new StringBuilder(1).append(className).append("#").append(transformer.currentVersion()).toString();
            }
            if (None$.MODULE$.equals(option3)) {
                return className;
            }
            throw new MatchError((Object)option3);
        }
        throw new MatchError(option);
    }

    public byte[] toBinary(Object obj) {
        this.checkAllowedSerializationBindings();
        long startTime = this.isDebugEnabled ? System.nanoTime() : 0L;
        byte[] bytes = this.objectMapper().writeValueAsBytes(obj);
        byte[] result = this.compress(bytes);
        this.logToBinaryDuration(obj, startTime, bytes, result);
        return result;
    }

    private void logToBinaryDuration(Object obj, long startTime, byte[] bytes, byte[] result) {
        if (this.isDebugEnabled) {
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == result.length) {
                this.log.debug("Serialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length));
                return;
            }
            this.log.debug("Serialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length), (Object)BoxesRunTime.boxToInteger((int)bytes.length));
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object fromBinary(byte[] bytes, String manifest) {
        this.checkAllowedSerializationBindings();
        startTime = this.isDebugEnabled != false ? System.nanoTime() : 0L;
        var6_4 = this.parseManifest(manifest);
        if (var6_4 == null) {
            throw new MatchError(var6_4);
        }
        fromVersion = BoxesRunTime.unboxToInt((Object)var6_4._1());
        manifestClassName = (String)var6_4._2();
        var5_7 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
        fromVersion = BoxesRunTime.unboxToInt((Object)var5_7._1());
        manifestClassName = (String)var5_7._2();
        if (this.typeInManifest) {
            this.checkAllowedClassName(manifestClassName);
        }
        if (!((var13_11 = (migration = this.migrations.get(this.deserializationType().fold((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$2(java.lang.String ), ()Ljava/lang/String;)((String)manifestClassName), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$3(java.lang.Class ), (Ljava/lang/Class;)Ljava/lang/String;)())))) instanceof Some)) ** GOTO lbl30
        var14_12 = (JacksonMigration)((Some)var13_11).value();
        transformer = var14_12;
        if (fromVersion < transformer.currentVersion()) {
            v0 = transformer.transformClassName(fromVersion, manifestClassName);
        } else {
            transformer = var14_12;
            if (fromVersion == transformer.currentVersion()) {
                v0 = manifestClassName;
            } else {
                transformer = var14_12;
                if (fromVersion <= transformer.supportedForwardVersion()) {
                    v0 = transformer.transformClassName(fromVersion, manifestClassName);
                } else {
                    transformer = var14_12;
                    if (fromVersion > transformer.supportedForwardVersion()) {
                        throw new IllegalStateException(new StringBuilder(22).append("Migration version ").append(transformer.supportedForwardVersion()).append(" is ").append(new StringBuilder(39).append("behind version ").append(fromVersion).append(" of deserialized type [").append(manifestClassName).append("]").toString()).toString());
                    }
lbl30:
                    // 3 sources

                    v0 = className = manifestClassName;
                }
            }
        }
        if (this.typeInManifest && className != manifestClassName) {
            this.checkAllowedClassName(className);
        }
        if (this.isCaseObject(className)) {
            var20_18 = this.system().dynamicAccess().getObjectFor(className, ClassTag$.MODULE$.apply(Object.class));
            if (!(var20_18 instanceof Success)) {
                if (var20_18 instanceof Failure) {
                    throw new NotSerializableException(new StringBuilder(54).append("Cannot find manifest case object [").append(className).append("] for serializer [").append(this.getClass().getName()).append("].").toString());
                }
                throw new MatchError((Object)var20_18);
            }
            obj = ((Success)var20_18).value();
            result = obj;
            clazz = result.getClass();
            this.checkAllowedClass(clazz);
            this.logFromBinaryDuration(bytes, bytes, startTime, clazz);
            return result;
        }
        clazz = (Class)this.deserializationType().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(java.lang.String ), ()Ljava/lang/Class;)((JacksonSerializer)this, (String)className));
        if (this.typeInManifest) {
            this.checkAllowedClass(clazz);
        }
        decompressedBytes = this.decompress(bytes);
        var26_24 = migration;
        if (!(var26_24 instanceof Some)) ** GOTO lbl-1000
        var27_25 = (JacksonMigration)((Some)var26_24).value();
        transformer = var27_25;
        if (fromVersion < transformer.currentVersion()) {
            jsonTree = this.objectMapper().readTree(decompressedBytes);
            newJsonTree = transformer.transform(fromVersion, jsonTree);
            v1 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
        } else {
            transformer = var27_25;
            if (fromVersion == transformer.currentVersion()) {
                v1 = this.objectMapper().readValue(decompressedBytes, clazz);
            } else {
                transformer = var27_25;
                if (fromVersion <= transformer.supportedForwardVersion()) {
                    jsonTree = this.objectMapper().readTree(decompressedBytes);
                    newJsonTree = transformer.transform(fromVersion, jsonTree);
                    v1 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
                } else lbl-1000:
                // 2 sources

                {
                    v1 = this.objectMapper().readValue(decompressedBytes, clazz);
                }
            }
        }
        result = v1;
        this.logFromBinaryDuration(bytes, decompressedBytes, startTime, clazz);
        return result;
    }

    private void logFromBinaryDuration(byte[] bytes, byte[] decompressBytes, long startTime, Class<? extends Object> clazz) {
        if (this.isDebugEnabled) {
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == decompressBytes.length) {
                this.log.debug("Deserialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
                return;
            }
            this.log.debug("Deserialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)bytes.length), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
            return;
        }
    }

    private boolean isCaseObject(String className) {
        return className.length() > 0 && className.charAt(className.length() - 1) == '$';
    }

    private void checkAllowedClassName(String className) {
        if (!this.denyList.isAllowedClassName(className)) {
            String warnMsg = new StringBuilder(100).append("Can't serialize/deserialize object of type [").append(className).append("] in [").append(this.getClass().getName()).append("]. ").append("Disallowed (on deny list) for security reasons.").toString();
            this.log.warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private void checkAllowedClass(Class<?> clazz) {
        if (!this.denyList.isAllowedClass(clazz)) {
            String warnMsg = new StringBuilder(86).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Not allowed for security reasons.").toString();
            this.log.warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
        if (!this.isInAllowList(clazz)) {
            String warnMsg = new StringBuilder(245).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Only classes that are listed as allowed are allowed for security reasons. ").append("Configure allowed classes with pekko.actor.serialization-bindings or ").append("pekko.serialization.jackson.allowed-class-prefix.").toString();
            this.log.warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private boolean isInAllowList(Class<?> clazz) {
        return this.isBoundToJacksonSerializer(clazz) || this.hasAllowedClassPrefix(clazz.getName());
    }

    private boolean isBoundToJacksonSerializer(Class<?> clazz) {
        boolean bl;
        try {
            Serializer boundSerializer = this.serialization().serializerFor(clazz);
            bl = boundSerializer instanceof JacksonSerializer;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private boolean hasAllowedClassPrefix(String className) {
        return this.allowedClassPrefix.exists((Function1 & Serializable)x$0 -> className.startsWith((String)x$0));
    }

    private void checkAllowedSerializationBindings() {
        if (!this.serializationBindingsCheckedOk) {
            JacksonSerializer$.MODULE$.disallowedSerializationBindings().foreach((Function1)(JProcedure1 & Serializable)clazz -> {
                if (!this.isBindingOk$1((Class)clazz)) {
                    String warnMsg = new StringBuilder(134).append("For security reasons it's not allowed to bind open-ended interfaces like ").append(new StringBuilder(10).append("[").append(clazz.getName()).append("] to [").append(this.getClass().getName()).append("]. ").toString()).append("Change your pekko.actor.serialization-bindings configuration.").toString();
                    this.log.warning(LogMarker$.MODULE$.Security(), warnMsg);
                    throw new IllegalArgumentException(warnMsg);
                }
            });
            this.serializationBindingsCheckedOk = true;
            return;
        }
    }

    private Tuple2<Object, String> parseManifest(String manifest) {
        int i = manifest.lastIndexOf(35);
        int fromVersion = i == -1 ? 1 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(manifest.substring(i + 1)));
        String manifestClassName = i == -1 ? manifest : manifest.substring(0, i);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
    }

    public byte[] compress(byte[] bytes) {
        Compression.Algoritm algoritm = this.compressionAlgorithm;
        if (Compression$Off$.MODULE$.equals(algoritm)) {
            return bytes;
        }
        if (algoritm instanceof Compression.GZip) {
            Compression.GZip gZip = Compression$GZip$.MODULE$.unapply((Compression.GZip)algoritm);
            long l = gZip._1();
            long largerThan = l;
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
                zip.write(bytes);
            }
            return bos.toByteArray();
        }
        if (algoritm instanceof Compression.LZ4) {
            Compression.LZ4 lZ4 = Compression$LZ4$.MODULE$.unapply((Compression.LZ4)algoritm);
            long l = lZ4._1();
            long largerThan = l;
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
            LZ4Meta meta = JacksonSerializer$LZ4Meta$.MODULE$.apply(bytes);
            byte[] compressed = this.lz4Compressor().compress(bytes);
            return meta.prependTo(compressed);
        }
        throw new MatchError((Object)algoritm);
    }

    public byte[] decompress(byte[] bytes) {
        if (JacksonSerializer$.MODULE$.isGZipped(bytes)) {
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            try {
                JacksonSerializer.readChunk$1(in, out, buffer);
            }
            finally {
                in.close();
            }
            return out.toByteArray();
        }
        LZ4Meta lZ4Meta = JacksonSerializer$LZ4Meta$.MODULE$.get(bytes);
        LZ4Meta lZ4Meta2 = (LZ4Meta)OptionVal.Some$.MODULE$.unapply((Object)lZ4Meta);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lZ4Meta2)) {
            LZ4Meta lZ4Meta3;
            LZ4Meta meta = lZ4Meta3 = (LZ4Meta)OptionVal$.MODULE$.get$extension((Object)lZ4Meta2);
            int srcLen = bytes.length - meta.offset();
            return this.lz4Decompressor().decompress(bytes, meta.offset(), srcLen, meta.length());
        }
        return bytes;
    }

    private final Option deserializationType$lzyINIT1$$anonfun$1() {
        Tuple2 tuple2;
        SeqOps seqOps;
        Seq bindings;
        Seq seq = bindings = (Seq)this.serialization().bindings().filter((Function1 & Serializable)_$1 -> ((Serializer)_$1._2()).identifier() == this.identifier());
        Nil$ nil$ = package$.MODULE$.Nil();
        Seq seq2 = seq;
        if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
            throw new IllegalArgumentException(new StringBuilder(160).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").append(" a deserialization-type or have exactly one binding configured, but none were configured").toString());
        }
        if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq), 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) != null) {
            Class clazz = (Class)tuple2._1();
            return Some$.MODULE$.apply(clazz.asSubclass(Object.class));
        }
        Seq multiple = seq;
        throw new IllegalArgumentException(new StringBuilder(157).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").append(" a deserialization-type or have exactly one binding configured, but multiple bindings").append(new StringBuilder(19).append(" were configured [").append(multiple.mkString(", ")).append("]").toString()).toString());
    }

    private static final String $anonfun$2(String manifestClassName$1) {
        return manifestClassName$1;
    }

    private static final /* synthetic */ String $anonfun$3(Class _$2) {
        return _$2.getName();
    }

    private final Class $anonfun$4(String className$1) {
        Try try_ = this.system().dynamicAccess().getClassFor(className$1, ClassTag$.MODULE$.apply(Object.class));
        if (try_ instanceof Success) {
            Class c = (Class)((Success)try_).value();
            return c;
        }
        if (try_ instanceof Failure) {
            throw new NotSerializableException(new StringBuilder(48).append("Cannot find manifest class [").append(className$1).append("] for serializer [").append(this.getClass().getName()).append("].").toString());
        }
        throw new MatchError((Object)try_);
    }

    private final boolean isBindingOk$1(Class clazz) {
        boolean bl;
        try {
            bl = this.serialization().serializerFor(clazz) != this;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                bl = true;
            }
            throw throwable;
        }
        return bl;
    }

    private static final void readChunk$1(GZIPInputStream in$1, ByteArrayOutputStream out$1, byte[] buffer$1) {
        int n;
        while (-1 != (n = in$1.read(buffer$1))) {
            int n2 = n;
            out$1.write(buffer$1, 0, n2);
        }
        return;
    }

    public static class GadgetClassDenyList
    extends SubTypeValidator {
        private final String prefixSpring;
        private final String prefixC3P0;

        public GadgetClassDenyList() {
            this.prefixSpring = "org.springframework.";
            this.prefixC3P0 = "com.mchange.v2.c3p0.";
        }

        private Set<String> defaultNoDeserClassNames() {
            return SubTypeValidator.DEFAULT_NO_DESER_CLASS_NAMES;
        }

        public boolean isAllowedClassName(String className) {
            if (this.defaultNoDeserClassNames().contains(className)) {
                return false;
            }
            return !className.startsWith(this.prefixC3P0) || !className.endsWith("DataSource");
        }

        public boolean isAllowedClass(Class<?> clazz) {
            if (clazz.getName().startsWith(this.prefixSpring)) {
                return this.isAllowedSpringClass(clazz);
            }
            return true;
        }

        private boolean isAllowedSpringClass(Class<?> clazz) {
            while (clazz != null && !clazz.equals(Object.class)) {
                String name = clazz.getSimpleName();
                if ("AbstractPointcutAdvisor".equals(name) || "AbstractApplicationContext".equals(name)) {
                    return false;
                }
                clazz = clazz.getSuperclass();
            }
            return true;
        }
    }

    public static final class LZ4Meta
    implements Product,
    Serializable {
        private final int offset;
        private final int length;

        public static int LZ4_MAGIC() {
            return JacksonSerializer$LZ4Meta$.MODULE$.LZ4_MAGIC();
        }

        public static LZ4Meta apply(byte[] byArray) {
            return JacksonSerializer$LZ4Meta$.MODULE$.apply(byArray);
        }

        public static LZ4Meta apply(int n, int n2) {
            return JacksonSerializer$LZ4Meta$.MODULE$.apply(n, n2);
        }

        public static LZ4Meta fromProduct(Product product) {
            return JacksonSerializer$LZ4Meta$.MODULE$.fromProduct(product);
        }

        public static LZ4Meta get(ByteBuffer byteBuffer) {
            return JacksonSerializer$LZ4Meta$.MODULE$.get(byteBuffer);
        }

        public static LZ4Meta get(byte[] byArray) {
            return JacksonSerializer$LZ4Meta$.MODULE$.get(byArray);
        }

        public static LZ4Meta unapply(LZ4Meta lZ4Meta) {
            return JacksonSerializer$LZ4Meta$.MODULE$.unapply(lZ4Meta);
        }

        public LZ4Meta(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.offset());
            n = Statics.mix((int)n, (int)this.length());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LZ4Meta)) return false;
            LZ4Meta lZ4Meta = (LZ4Meta)object;
            if (this.offset() != lZ4Meta.offset()) return false;
            if (this.length() != lZ4Meta.length()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LZ4Meta;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LZ4Meta";
        }

        public Object productElement(int n) {
            int n2;
            int n3 = n;
            if (0 == n3) {
                n2 = this._1();
            } else if (1 == n3) {
                n2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)n2);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "offset";
            }
            if (1 == n2) {
                return "length";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int offset() {
            return this.offset;
        }

        public int length() {
            return this.length;
        }

        public void putInto(ByteBuffer buffer) {
            buffer.putInt(JacksonSerializer$LZ4Meta$.MODULE$.LZ4_MAGIC());
            buffer.putInt(this.length());
        }

        public byte[] prependTo(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + this.offset());
            this.putInto(buffer);
            buffer.put(bytes);
            return buffer.array();
        }

        public LZ4Meta copy(int offset, int length) {
            return new LZ4Meta(offset, length);
        }

        public int copy$default$1() {
            return this.offset();
        }

        public int copy$default$2() {
            return this.length();
        }

        public int _1() {
            return this.offset();
        }

        public int _2() {
            return this.length();
        }
    }
}

