/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.serialization.jackson.ActorSystemAccess;
import scala.runtime.BoxesRunTime;

public final class PekkoSerializationSerializer
extends StdScalarSerializer<Object>
implements ActorSystemAccess {
    public PekkoSerializationSerializer() {
        super(Object.class);
    }

    public Serialization serialization() {
        return (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.currentSystem());
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) {
        Serializer serializer = this.serialization().findSerializerFor(value);
        int serId = serializer.identifier();
        String manifest = Serializers$.MODULE$.manifestFor(serializer, value);
        byte[] serialized = serializer.toBinary(value);
        jgen.writeStartObject();
        jgen.writeStringField("serId", BoxesRunTime.boxToInteger((int)serId).toString());
        jgen.writeStringField("serManifest", manifest);
        jgen.writeBinaryField("payload", serialized);
        jgen.writeEndObject();
    }
}

