/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.TypeModifier;
import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.jackson.JacksonModule$;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

@InternalApi
public interface JacksonModule {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JacksonModule$.class.getDeclaredField("version$lzy1"));

    public static void $init$(JacksonModule $this) {
        $this.org$apache$pekko$serialization$jackson$JacksonModule$_setter_$org$apache$pekko$serialization$jackson$JacksonModule$$initializers_$eq(package$.MODULE$.Seq().newBuilder());
    }

    public Builder<Function1<Module.SetupContext, BoxedUnit>, Seq<Function1<Module.SetupContext, BoxedUnit>>> org$apache$pekko$serialization$jackson$JacksonModule$$initializers();

    public void org$apache$pekko$serialization$jackson$JacksonModule$_setter_$org$apache$pekko$serialization$jackson$JacksonModule$$initializers_$eq(Builder var1);

    public static Version version$(JacksonModule $this) {
        return $this.version();
    }

    default public Version version() {
        return JacksonModule$.MODULE$.version();
    }

    public static void setupModule$(JacksonModule $this, Module.SetupContext context) {
        $this.setupModule(context);
    }

    default public void setupModule(Module.SetupContext context) {
        ((IterableOnceOps)this.org$apache$pekko$serialization$jackson$JacksonModule$$initializers().result()).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.apply((Object)context));
    }

    public static JacksonModule addSerializer$(JacksonModule $this, Class clazz, Function0 serializer, Function0 deserializer) {
        return $this.addSerializer(clazz, serializer, deserializer);
    }

    default public JacksonModule addSerializer(Class<?> clazz, Function0<JsonSerializer<?>> serializer, Function0<JsonDeserializer<?>> deserializer) {
        return this.$plus$eq((Function1<Module.SetupContext, BoxedUnit>)(JProcedure1 & Serializable)ctx -> {
            ctx.addSerializers((Serializers)new SerializerResolverByClass(clazz, serializer));
            ctx.addDeserializers((Deserializers)new DeserializerResolverByClass(clazz, deserializer));
        });
    }

    public static JacksonModule $plus$eq$(JacksonModule $this, Function1 init) {
        return $this.$plus$eq((Function1<Module.SetupContext, BoxedUnit>)init);
    }

    default public JacksonModule $plus$eq(Function1<Module.SetupContext, BoxedUnit> init) {
        this.org$apache$pekko$serialization$jackson$JacksonModule$$initializers().$plus$eq(init);
        return this;
    }

    public static JacksonModule $plus$eq$(JacksonModule $this, Serializers ser) {
        return $this.$plus$eq(ser);
    }

    default public JacksonModule $plus$eq(Serializers ser) {
        return this.$plus$eq((Function1<Module.SetupContext, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.addSerializers(ser));
    }

    public static JacksonModule $plus$eq$(JacksonModule $this, Deserializers deser) {
        return $this.$plus$eq(deser);
    }

    default public JacksonModule $plus$eq(Deserializers deser) {
        return this.$plus$eq((Function1<Module.SetupContext, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> _$3.addDeserializers(deser));
    }

    public static JacksonModule $plus$eq$(JacksonModule $this, TypeModifier typeMod) {
        return $this.$plus$eq(typeMod);
    }

    default public JacksonModule $plus$eq(TypeModifier typeMod) {
        return this.$plus$eq((Function1<Module.SetupContext, BoxedUnit>)(JProcedure1 & Serializable)_$4 -> _$4.addTypeModifier(typeMod));
    }

    public static JacksonModule $plus$eq$(JacksonModule $this, BeanSerializerModifier beanSerMod) {
        return $this.$plus$eq(beanSerMod);
    }

    default public JacksonModule $plus$eq(BeanSerializerModifier beanSerMod) {
        return this.$plus$eq((Function1<Module.SetupContext, BoxedUnit>)(JProcedure1 & Serializable)_$5 -> _$5.addBeanSerializerModifier(beanSerMod));
    }

    public static class DeserializerResolverByClass
    extends Deserializers.Base {
        private final Class<?> clazz;
        private final Function0<JsonDeserializer<?>> serializer;

        public DeserializerResolverByClass(Class<?> clazz, Function0<JsonDeserializer<?>> serializer) {
            this.clazz = clazz;
            this.serializer = serializer;
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig config, BeanDescription beanDesc) {
            if (this.clazz.isAssignableFrom(javaType.getRawClass())) {
                return (JsonDeserializer)this.serializer.apply();
            }
            return super.findBeanDeserializer(javaType, config, beanDesc);
        }
    }

    public static class SerializerResolverByClass
    extends Serializers.Base {
        private final Class<?> clazz;
        private final Function0<JsonSerializer<?>> deserializer;

        public SerializerResolverByClass(Class<?> clazz, Function0<JsonSerializer<?>> deserializer) {
            this.clazz = clazz;
            this.deserializer = deserializer;
        }

        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType javaType, BeanDescription beanDesc) {
            if (this.clazz.isAssignableFrom(javaType.getRawClass())) {
                return (JsonSerializer)this.deserializer.apply();
            }
            return super.findSerializer(config, javaType, beanDesc);
        }
    }
}

