/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperFactory;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperProvider$;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperProviderSetup;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.reflect.ClassTag$;

public final class JacksonObjectMapperProvider
implements Extension {
    private final ExtendedActorSystem system;
    private final ConcurrentHashMap<String, ObjectMapper> objectMappers;

    public static Extension apply(ActorSystem actorSystem) {
        return JacksonObjectMapperProvider$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return JacksonObjectMapperProvider$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Config configForBinding(String string, Config config) {
        return JacksonObjectMapperProvider$.MODULE$.configForBinding(string, config);
    }

    public static JacksonObjectMapperProvider createExtension(ExtendedActorSystem extendedActorSystem) {
        return JacksonObjectMapperProvider$.MODULE$.createExtension(extendedActorSystem);
    }

    @InternalStableApi
    public static ObjectMapper createObjectMapper(String string, Option<JsonFactory> option, JacksonObjectMapperFactory jacksonObjectMapperFactory, Config config, DynamicAccess dynamicAccess, Option<LoggingAdapter> option2) {
        return JacksonObjectMapperProvider$.MODULE$.createObjectMapper(string, option, jacksonObjectMapperFactory, config, dynamicAccess, option2);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return JacksonObjectMapperProvider$.MODULE$.get(actorSystem);
    }

    public static JacksonObjectMapperProvider get(ActorSystem actorSystem) {
        return JacksonObjectMapperProvider$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return JacksonObjectMapperProvider$.MODULE$.get(classicActorSystemProvider);
    }

    public static JacksonObjectMapperProvider get(ClassicActorSystemProvider classicActorSystemProvider) {
        return JacksonObjectMapperProvider$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return JacksonObjectMapperProvider$.MODULE$.lookup();
    }

    public JacksonObjectMapperProvider(ExtendedActorSystem system) {
        this.system = system;
        this.objectMappers = new ConcurrentHashMap();
    }

    public ObjectMapper getOrCreate(String bindingName, Option<JsonFactory> jsonFactory) {
        return this.objectMappers.computeIfAbsent(bindingName, _$3 -> this.create(bindingName, jsonFactory));
    }

    public ObjectMapper getOrCreate(String bindingName, Optional<JsonFactory> jsonFactory) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(jsonFactory);
        return this.getOrCreate(bindingName, (Option<JsonFactory>)OptionConverters.RichOptional$.MODULE$.toScala$extension(optional));
    }

    public ObjectMapper create(String bindingName, Option<JsonFactory> jsonFactory) {
        JacksonObjectMapperFactory jacksonObjectMapperFactory;
        LoggingAdapter log = Logging$.MODULE$.getLogger((ActorSystem)this.system, JacksonObjectMapperProvider$.MODULE$.getClass());
        DynamicAccess dynamicAccess = this.system.dynamicAccess();
        Config config = JacksonObjectMapperProvider$.MODULE$.configForBinding(bindingName, this.system.settings().config());
        Option option = this.system.settings().setup().get(ClassTag$.MODULE$.apply(JacksonObjectMapperProviderSetup.class));
        if (option instanceof Some) {
            JacksonObjectMapperProviderSetup setup = (JacksonObjectMapperProviderSetup)((Object)((Some)option).value());
            jacksonObjectMapperFactory = setup.factory();
        } else if (None$.MODULE$.equals(option)) {
            jacksonObjectMapperFactory = new JacksonObjectMapperFactory();
        } else {
            throw new MatchError((Object)option);
        }
        JacksonObjectMapperFactory factory = jacksonObjectMapperFactory;
        return JacksonObjectMapperProvider$.MODULE$.createObjectMapper(bindingName, jsonFactory, factory, config, dynamicAccess, (Option<LoggingAdapter>)Some$.MODULE$.apply((Object)log));
    }

    public ObjectMapper create(String bindingName, Optional<JsonFactory> jsonFactory) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(jsonFactory);
        return this.create(bindingName, (Option<JsonFactory>)OptionConverters.RichOptional$.MODULE$.toScala$extension(optional));
    }
}

