/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.testkit.scaladsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer;
import org.apache.pekko.stream.impl.StreamSupervisor;
import org.apache.pekko.stream.snapshot.ConnectionSnapshot;
import org.apache.pekko.stream.snapshot.ConnectionSnapshotImpl;
import org.apache.pekko.stream.snapshot.InterpreterSnapshot;
import org.apache.pekko.stream.snapshot.LogicSnapshot;
import org.apache.pekko.stream.snapshot.LogicSnapshotImpl;
import org.apache.pekko.stream.snapshot.MaterializerState$;
import org.apache.pekko.stream.snapshot.RunningInterpreter;
import org.apache.pekko.stream.snapshot.RunningInterpreterImpl;
import org.apache.pekko.stream.snapshot.StreamSnapshotImpl;
import org.apache.pekko.testkit.TestProbe;
import org.apache.pekko.testkit.TestProbe$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class StreamTestKit$ {
    public static final StreamTestKit$ MODULE$ = new StreamTestKit$();

    public <T> T assertAllStagesStopped(Function0<T> block, Materializer materializer) {
        Materializer materializer2 = materializer;
        if (materializer2 instanceof PhasedFusingActorMaterializer) {
            PhasedFusingActorMaterializer phasedFusingActorMaterializer = (PhasedFusingActorMaterializer)materializer2;
            this.stopAllChildren(phasedFusingActorMaterializer.system(), phasedFusingActorMaterializer.supervisor());
            Object result = block.apply();
            this.assertNoChildren(phasedFusingActorMaterializer.system(), phasedFusingActorMaterializer.supervisor());
            return (T)result;
        }
        return (T)block.apply();
    }

    @InternalApi
    public void stopAllChildren(ActorSystem sys, ActorRef supervisor) {
        TestProbe probe = TestProbe$.MODULE$.apply(sys);
        probe.send(supervisor, (Object)StreamSupervisor.StopChildren$.MODULE$);
        probe.expectMsg((Object)StreamSupervisor.StoppedChildren$.MODULE$);
    }

    @InternalApi
    public void assertNoChildren(ActorSystem sys, ActorRef supervisor) {
        TestProbe probe = TestProbe$.MODULE$.apply(sys);
        Config c = sys.settings().config().getConfig("pekko.stream.testkit");
        FiniteDuration timeout = new package.DurationLong(package$.MODULE$.DurationLong(c.getDuration("all-stages-stopped-timeout", TimeUnit.MILLISECONDS))).millis();
        probe.within(timeout, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                probe.awaitAssert((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    supervisor.tell((Object)StreamSupervisor.GetChildren$.MODULE$, probe.ref());
                    Set children = ((StreamSupervisor.Children)probe.expectMsgType(ClassTag$.MODULE$.apply(StreamSupervisor.Children.class))).children();
                    Predef$.MODULE$.assert(children.isEmpty(), (Function0 & Serializable)() -> new java.lang.StringBuilder(49).append("expected no StreamSupervisor children, but got [").append(children.mkString(", ")).append("]").toString());
                }, probe.awaitAssert$default$2(), probe.awaitAssert$default$3());
            }
            catch (Throwable ex) {
                MODULE$.printDebugDump(supervisor, (ExecutionContext)sys.dispatcher());
                throw ex;
            }
        });
    }

    @InternalApi
    public void printDebugDump(ActorRef streamSupervisor, ExecutionContext ec) {
        Future doneDumping = MaterializerState$.MODULE$.requestFromSupervisor(streamSupervisor, ec).map((Function1 & Serializable)snapshots -> {
            snapshots.foreach((Function1 & Serializable)s -> {
                Predef$.MODULE$.println((Object)StreamTestKit$.MODULE$.snapshotString((StreamSnapshotImpl)s));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }, ec);
        Await$.MODULE$.result((Awaitable)doneDumping, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
    }

    @InternalApi
    public String snapshotString(StreamSnapshotImpl snapshot) {
        StringBuilder builder = new StringBuilder();
        builder.append(new java.lang.StringBuilder(24).append("activeShells (actor: ").append(snapshot.self()).append("):\n").toString());
        snapshot.activeInterpreters().foreach((Function1 & Serializable)shell -> {
            builder.append("  ");
            MODULE$.appendShellSnapshot(builder, (InterpreterSnapshot)shell);
            builder.append("\n");
            MODULE$.appendInterpreterSnapshot(builder, (RunningInterpreterImpl)shell);
            return builder.append("\n");
        });
        builder.append("newShells:\n");
        snapshot.newShells().foreach((Function1 & Serializable)shell -> {
            builder.append("  ");
            MODULE$.appendShellSnapshot(builder, (InterpreterSnapshot)shell);
            builder.append("\n");
            builder.append("    Not initialized");
            return builder.append("\n");
        });
        return builder.toString();
    }

    private void appendShellSnapshot(StringBuilder builder, InterpreterSnapshot shell) {
        builder.append("GraphInterpreterShell(\n  logics: [\n");
        Seq logicsToPrint = shell.logics();
        logicsToPrint.foreach((Function1 & Serializable)logic -> builder.append("    ").append(logic.label()).append(" attrs: [").append(logic.attributes().attributeList().mkString(", ")).append("],\n"));
        builder.setLength(builder.length() - 2);
        InterpreterSnapshot interpreterSnapshot = shell;
        if (interpreterSnapshot instanceof RunningInterpreter) {
            RunningInterpreter runningInterpreter = (RunningInterpreter)interpreterSnapshot;
            builder.append("\n  ],\n  connections: [\n");
            runningInterpreter.connections().foreach((Function1 & Serializable)connection -> builder.append("    ").append("Connection(").append(((ConnectionSnapshotImpl)connection).id()).append(", ").append(connection.in().label()).append(", ").append(connection.out().label()).append(", ").append((Object)connection.state()).append(")\n"));
            builder.setLength(builder.length() - 2);
        }
        builder.append("\n  ]\n)");
        builder.toString();
    }

    private void appendInterpreterSnapshot(StringBuilder builder, RunningInterpreterImpl snapshot) {
        try {
            builder.append("\ndot format graph for deadlock analysis:\n");
            builder.append("================================================================\n");
            builder.append("digraph waits {\n");
            snapshot.logics().indices().foreach((Function1 & Serializable)i -> StreamTestKit$.$anonfun$appendInterpreterSnapshot$1(snapshot, builder, BoxesRunTime.unboxToInt((Object)i)));
            snapshot.connections().foreach((Function1 & Serializable)connection -> {
                String inName = new java.lang.StringBuilder(1).append("N").append(((LogicSnapshotImpl)connection.in()).index()).toString();
                String outName = new java.lang.StringBuilder(1).append("N").append(((LogicSnapshotImpl)connection.out()).index()).toString();
                builder.append(new java.lang.StringBuilder(7).append("  ").append(inName).append(" -> ").append(outName).append(" ").toString());
                ConnectionSnapshot.ConnectionState connectionState = connection.state();
                if (ConnectionSnapshot.ShouldPull$.MODULE$.equals(connectionState)) {
                    builder.append("[label=shouldPull, color=blue];");
                } else if (ConnectionSnapshot.ShouldPush$.MODULE$.equals(connectionState)) {
                    builder.append("[label=shouldPush, color=red, dir=back];");
                } else if (ConnectionSnapshot.Closed$.MODULE$.equals(connectionState)) {
                    builder.append("[style=dotted, label=closed, dir=both];");
                } else if (connectionState == null) {
                } else {
                    throw new MatchError((Object)connectionState);
                }
                return builder.append("\n");
            });
            builder.append("}\n================================================================\n");
            builder.append(new java.lang.StringBuilder(25).append("// ").append(snapshot.queueStatus()).append(" (running=").append(snapshot.runningLogicsCount()).append(", shutdown=").append(snapshot.stoppedLogics().mkString(",")).append(")").toString());
            builder.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            builder.append("Not all logics has a stage listed, cannot create graph");
        }
    }

    public static final /* synthetic */ StringBuilder $anonfun$appendInterpreterSnapshot$1(RunningInterpreterImpl snapshot$1, StringBuilder builder$3, int i) {
        LogicSnapshot logic = (LogicSnapshot)snapshot$1.logics().apply(i);
        return builder$3.append(new java.lang.StringBuilder(15).append("  N").append(i).append(" [label=\"").append(logic.label()).append("\"];").toString()).append('\n');
    }

    private StreamTestKit$() {
    }
}

