/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.testkit;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.japi.function.Creator;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.testkit.TestSubscriber$;
import org.apache.pekko.stream.testkit.TestSubscriber$ManualProbe$;
import org.apache.pekko.stream.testkit.TestSubscriber$OnComplete$;
import org.apache.pekko.stream.testkit.TestSubscriber$OnError$;
import org.apache.pekko.stream.testkit.TestSubscriber$OnNext$;
import org.apache.pekko.stream.testkit.TestSubscriber$OnSubscribe$;
import org.apache.pekko.stream.testkit.TestSubscriber$Probe$;
import org.apache.pekko.testkit.TestProbe;
import org.apache.pekko.testkit.TestProbe$;
import org.apache.pekko.testkit.package;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.ccompat.package;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class TestSubscriber {
    public static <T> ManualProbe<T> manualProbe(ActorSystem actorSystem) {
        return TestSubscriber$.MODULE$.manualProbe(actorSystem);
    }

    public static <T> Probe<T> probe(ActorSystem actorSystem) {
        return TestSubscriber$.MODULE$.probe(actorSystem);
    }

    public static class ManualProbe<I>
    implements Subscriber<I> {
        private final ActorSystem system;
        private final TestProbe probe;
        private volatile Subscription _subscription;
        private final ManualProbe self;

        public static <T> ManualProbe<T> apply(ClassicActorSystemProvider classicActorSystemProvider) {
            return TestSubscriber$ManualProbe$.MODULE$.apply(classicActorSystemProvider);
        }

        public static <T> ManualProbe<T> create(ClassicActorSystemProvider classicActorSystemProvider) {
            return TestSubscriber$ManualProbe$.MODULE$.create(classicActorSystemProvider);
        }

        public ManualProbe(ActorSystem system) {
            this.system = system;
            this.probe = TestProbe$.MODULE$.apply(system);
            this.self = this;
        }

        public Subscription expectSubscription() {
            this._subscription = ((OnSubscribe)this.probe.expectMsgType(ClassTag$.MODULE$.apply(OnSubscribe.class))).subscription();
            return this._subscription;
        }

        public SubscriberEvent expectEvent() {
            return (SubscriberEvent)this.probe.expectMsgType(ClassTag$.MODULE$.apply(SubscriberEvent.class));
        }

        public SubscriberEvent expectEvent(FiniteDuration max) {
            return (SubscriberEvent)this.probe.expectMsgType(max, ClassTag$.MODULE$.apply(SubscriberEvent.class));
        }

        public SubscriberEvent expectEvent(java.time.Duration max) {
            return this.expectEvent(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)));
        }

        public ManualProbe expectEvent(SubscriberEvent event) {
            this.probe.expectMsg((Object)event);
            return this.self;
        }

        public I expectNext() {
            return this.expectNext(package.TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(this.probe.testKitSettings().SingleExpectDefaultTimeout()), this.system));
        }

        public I expectNext(FiniteDuration d) {
            FiniteDuration t = this.probe.remainingOr(d);
            Object object = this.probe.receiveOne((Duration)t);
            if (object == null) {
                throw new AssertionError((Object)new StringBuilder(51).append("Expected OnNext(_), yet no element signaled during ").append(t).toString());
            }
            if (object instanceof OnNext) {
                Object i;
                OnNext onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object);
                Object elem = i = onNext._1();
                return elem;
            }
            Object other = object;
            throw new AssertionError((Object)new StringBuilder(23).append("expected OnNext, found ").append(other).toString());
        }

        public I expectNext(java.time.Duration d) {
            return this.expectNext(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(d)));
        }

        public ManualProbe expectNext(I element) {
            this.probe.expectMsg(TestSubscriber$OnNext$.MODULE$.apply(element));
            return this.self;
        }

        public ManualProbe expectNext(FiniteDuration d, I element) {
            this.probe.expectMsg(d, TestSubscriber$OnNext$.MODULE$.apply(element));
            return this.self;
        }

        public ManualProbe expectNext(java.time.Duration d, I element) {
            return this.expectNext(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(d)), element);
        }

        public ManualProbe expectNext(I e1, I e2, scala.collection.immutable.Seq<I> es) {
            return this.expectNextN((scala.collection.immutable.Seq)((IterableOnce)((SeqOps)es.$plus$colon(e2)).$plus$colon(e1)).iterator().map((Function1 & Serializable)x -> Predef$.MODULE$.identity(x)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$)));
        }

        public ManualProbe expectNext(I e1, I e2, I ... es) {
            return this.expectNext(e1, e2, (scala.collection.immutable.Seq<I>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])es));
        }

        public ManualProbe expectNextUnordered(I e1, I e2, scala.collection.immutable.Seq<I> es) {
            return this.expectNextUnorderedN((scala.collection.immutable.Seq)((IterableOnce)((SeqOps)es.$plus$colon(e2)).$plus$colon(e1)).iterator().map((Function1 & Serializable)x -> Predef$.MODULE$.identity(x)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$)));
        }

        public ManualProbe expectNextUnordered(I e1, I e2, I ... es) {
            return this.expectNextUnordered(e1, e2, (scala.collection.immutable.Seq<I>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])es));
        }

        public scala.collection.immutable.Seq<I> expectNextN(long n) {
            Builder b = Seq$.MODULE$.newBuilder();
            int i = 0;
            while ((long)i < n) {
                OnNext next = (OnNext)this.probe.expectMsgType(ClassTag$.MODULE$.apply(OnNext.class));
                b.$plus$eq(next.element());
                ++i;
            }
            return (scala.collection.immutable.Seq)b.result();
        }

        public ManualProbe expectNextN(scala.collection.immutable.Seq<I> all) {
            all.foreach((Function1 & Serializable)e -> (OnNext)this.probe.expectMsg(TestSubscriber$OnNext$.MODULE$.apply(e)));
            return this.self;
        }

        public ManualProbe expectNextN(List<I> elems) {
            elems.forEach(e -> this.probe.expectMsg(TestSubscriber$OnNext$.MODULE$.apply(e)));
            return this.self;
        }

        public ManualProbe expectNextUnorderedN(scala.collection.immutable.Seq<I> all) {
            this.expectOneOf$1(all);
            return this.self;
        }

        public ManualProbe expectNextUnorderedN(List<I> all) {
            return this.expectNextUnorderedN(Util$.MODULE$.immutableSeq(all));
        }

        public ManualProbe expectComplete() {
            this.probe.expectMsg((Object)TestSubscriber$OnComplete$.MODULE$);
            return this.self;
        }

        public Throwable expectError() {
            return ((OnError)this.probe.expectMsgType(ClassTag$.MODULE$.apply(OnError.class))).cause();
        }

        public ManualProbe expectError(Throwable cause) {
            this.probe.expectMsg((Object)TestSubscriber$OnError$.MODULE$.apply(cause));
            return this.self;
        }

        public Throwable expectSubscriptionAndError() {
            return this.expectSubscriptionAndError(true);
        }

        public Throwable expectSubscriptionAndError(boolean signalDemand) {
            Subscription sub = this.expectSubscription();
            if (signalDemand) {
                sub.request(1L);
            }
            return this.expectError();
        }

        public ManualProbe expectSubscriptionAndError(Throwable cause) {
            return this.expectSubscriptionAndError(cause, true);
        }

        public ManualProbe expectSubscriptionAndError(Throwable cause, boolean signalDemand) {
            Subscription sub = this.expectSubscription();
            if (signalDemand) {
                sub.request(1L);
            }
            this.expectError(cause);
            return this.self;
        }

        public ManualProbe expectSubscriptionAndComplete() {
            return this.expectSubscriptionAndComplete(true);
        }

        public ManualProbe expectSubscriptionAndComplete(boolean signalDemand) {
            Subscription sub = this.expectSubscription();
            if (signalDemand) {
                sub.request(1L);
            }
            this.expectComplete();
            return this.self;
        }

        public Either<Throwable, I> expectNextOrError() {
            OnNext onNext;
            Object i;
            String string = "OnNext(_) or error";
            Duration duration = this.probe.fishForMessage$default$1();
            Object object = this.probe.fishForMessage(duration, string, (PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        OnNext<I> onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object);
                        I i = onNext._1();
                        return true;
                    }
                    if (object instanceof OnError) {
                        OnError onError = TestSubscriber$OnError$.MODULE$.unapply((OnError)object);
                        Throwable throwable = onError._1();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        OnNext<I> onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object);
                        I i = onNext._1();
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    if (object instanceof OnError) {
                        OnError onError = TestSubscriber$OnError$.MODULE$.unapply((OnError)object);
                        Throwable throwable = onError._1();
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    return function1.apply(x);
                }
            });
            if (object instanceof OnNext && (i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object))._1()) instanceof Object) {
                Object n = i;
                return scala.package$.MODULE$.Right().apply(n);
            }
            if (object instanceof OnError) {
                Throwable throwable;
                OnError onError = TestSubscriber$OnError$.MODULE$.unapply((OnError)object);
                Throwable err = throwable = onError._1();
                return scala.package$.MODULE$.Left().apply((Object)err);
            }
            throw new RuntimeException();
        }

        public Either<Throwable, I> expectNextOrError(I element, Throwable cause) {
            OnNext onNext;
            Object i;
            String string = new StringBuilder(12).append("OnNext(").append(element).append(") or ").append(cause.getClass().getName()).toString();
            Duration duration = this.probe.fishForMessage$default$1();
            Object object = this.probe.fishForMessage(duration, string, (PartialFunction)new Serializable(element, cause){
                private final Object element$1;
                private final Throwable cause$2;
                {
                    this.element$1 = element$3;
                    this.cause$2 = cause$4;
                }

                public final boolean isDefinedAt(Object x) {
                    OnNext<I> onNext;
                    I i;
                    Object object = x;
                    if (object instanceof OnNext && BoxesRunTime.equals((Object)this.element$1, i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object))._1())) {
                        return true;
                    }
                    if (object instanceof OnError) {
                        OnError onError = TestSubscriber$OnError$.MODULE$.unapply((OnError)object);
                        Throwable throwable = onError._1();
                        Throwable throwable2 = this.cause$2;
                        Throwable throwable3 = throwable;
                        if (!(throwable2 != null ? !throwable2.equals(throwable3) : throwable3 != null)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    OnNext<I> onNext;
                    I i;
                    Object object = x;
                    if (object instanceof OnNext && BoxesRunTime.equals((Object)this.element$1, i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object))._1())) {
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    if (object instanceof OnError) {
                        OnError onError = TestSubscriber$OnError$.MODULE$.unapply((OnError)object);
                        Throwable throwable = onError._1();
                        Throwable throwable2 = this.cause$2;
                        Throwable throwable3 = throwable;
                        if (!(throwable2 != null ? !throwable2.equals(throwable3) : throwable3 != null)) {
                            return BoxesRunTime.boxToBoolean((boolean)true);
                        }
                    }
                    return function1.apply(x);
                }
            });
            if (object instanceof OnNext && (i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object))._1()) instanceof Object) {
                Object n = i;
                return scala.package$.MODULE$.Right().apply(n);
            }
            if (object instanceof OnError) {
                Throwable throwable;
                OnError onError = TestSubscriber$OnError$.MODULE$.unapply((OnError)object);
                Throwable err = throwable = onError._1();
                return scala.package$.MODULE$.Left().apply((Object)err);
            }
            throw new RuntimeException();
        }

        public Either<TestSubscriber$OnComplete$, I> expectNextOrComplete() {
            OnNext onNext;
            Object i;
            String string = "OnNext(_) or OnComplete";
            Duration duration = this.probe.fishForMessage$default$1();
            Object object = this.probe.fishForMessage(duration, string, (PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        OnNext<I> onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object);
                        I i = onNext._1();
                        return true;
                    }
                    return TestSubscriber$OnComplete$.MODULE$.equals(object);
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        OnNext<I> onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object);
                        I i = onNext._1();
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    if (TestSubscriber$OnComplete$.MODULE$.equals(object)) {
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    return function1.apply(x);
                }
            });
            if (TestSubscriber$OnComplete$.MODULE$.equals(object)) {
                return scala.package$.MODULE$.Left().apply((Object)TestSubscriber$OnComplete$.MODULE$);
            }
            if (object instanceof OnNext && (i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object))._1()) instanceof Object) {
                Object n = i;
                return scala.package$.MODULE$.Right().apply(n);
            }
            throw new RuntimeException();
        }

        public ManualProbe expectNextOrComplete(I element) {
            String string = new StringBuilder(22).append("OnNext(").append(element).append(") or OnComplete").toString();
            Duration duration = this.probe.fishForMessage$default$1();
            this.probe.fishForMessage(duration, string, (PartialFunction)new Serializable(element){
                private final Object element$2;
                {
                    this.element$2 = element$4;
                }

                public final boolean isDefinedAt(Object x) {
                    OnNext<I> onNext;
                    I i;
                    Object object = x;
                    if (object instanceof OnNext && BoxesRunTime.equals((Object)this.element$2, i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object))._1())) {
                        return true;
                    }
                    return TestSubscriber$OnComplete$.MODULE$.equals(object);
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    OnNext<I> onNext;
                    I i;
                    Object object = x;
                    if (object instanceof OnNext && BoxesRunTime.equals((Object)this.element$2, i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object))._1())) {
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    if (TestSubscriber$OnComplete$.MODULE$.equals(object)) {
                        return BoxesRunTime.boxToBoolean((boolean)true);
                    }
                    return function1.apply(x);
                }
            });
            return this.self;
        }

        public ManualProbe expectNoMsg() {
            this.probe.expectNoMsg();
            return this.self;
        }

        public ManualProbe expectNoMsg(FiniteDuration remaining) {
            this.probe.expectNoMsg(remaining);
            return this.self;
        }

        public ManualProbe expectNoMessage(FiniteDuration remaining) {
            this.probe.expectNoMessage(remaining);
            return this.self;
        }

        public ManualProbe expectNoMessage() {
            this.probe.expectNoMessage();
            return this.self;
        }

        public ManualProbe expectNoMessage(java.time.Duration remaining) {
            this.probe.expectNoMessage(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(remaining)));
            return this.self;
        }

        public <T> T expectNextPF(PartialFunction<Object, T> f) {
            return this.expectNextWithTimeoutPF((Duration)Duration$.MODULE$.Undefined(), f);
        }

        public <T> T expectNextWithTimeoutPF(Duration max, PartialFunction<Object, T> f) {
            Serializable pf = new Serializable(f){
                private final PartialFunction f$6;
                {
                    this.f$6 = f$7;
                }

                public final boolean isDefinedAt(SubscriberEvent x) {
                    OnNext<I> onNext;
                    I i;
                    I n;
                    SubscriberEvent subscriberEvent = x;
                    return subscriberEvent instanceof OnNext && this.f$6.isDefinedAt(n = (i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)subscriberEvent))._1()));
                }

                public final Object applyOrElse(SubscriberEvent x, Function1 function1) {
                    OnNext<I> onNext;
                    I i;
                    I n;
                    SubscriberEvent subscriberEvent = x;
                    if (subscriberEvent instanceof OnNext && this.f$6.isDefinedAt(n = (i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)subscriberEvent))._1()))) {
                        return this.f$6.apply(n);
                    }
                    return function1.apply((Object)x);
                }
            };
            return this.expectEventWithTimeoutPF(max, (PartialFunction<SubscriberEvent, T>)pf);
        }

        public <T> T expectNextWithTimeoutPF(java.time.Duration max, PartialFunction<Object, T> f) {
            return this.expectEventWithTimeoutPF((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), f);
        }

        public ManualProbe expectNextChainingPF(Duration max, PartialFunction<Object, Object> f) {
            return (ManualProbe)this.expectNextWithTimeoutPF(max, f.andThen((Function1 & Serializable)_$2 -> this.self));
        }

        public ManualProbe expectNextChainingPF(java.time.Duration max, PartialFunction<Object, Object> f) {
            return this.expectNextChainingPF((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), f);
        }

        public ManualProbe expectNextChainingPF(PartialFunction<Object, Object> f) {
            return this.expectNextChainingPF((Duration)Duration$.MODULE$.Undefined(), f);
        }

        public <T> T expectEventWithTimeoutPF(Duration max, PartialFunction<SubscriberEvent, T> f) {
            return (T)this.probe.expectMsgPF(max, "message matching partial function", f);
        }

        public <T> T expectEventWithTimeoutPF(java.time.Duration max, PartialFunction<SubscriberEvent, T> f) {
            return this.expectEventWithTimeoutPF((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), f);
        }

        public <T> T expectEventPF(PartialFunction<SubscriberEvent, T> f) {
            return this.expectEventWithTimeoutPF((Duration)Duration$.MODULE$.Undefined(), f);
        }

        public <T> scala.collection.immutable.Seq<T> receiveWhile(Duration max, Duration idle, int messages, PartialFunction<SubscriberEvent, T> f) {
            return this.probe.receiveWhile(max, idle, messages, f);
        }

        public <T> Duration receiveWhile$default$1() {
            return Duration$.MODULE$.Undefined();
        }

        public <T> Duration receiveWhile$default$2() {
            return Duration$.MODULE$.Inf();
        }

        public int receiveWhile$default$3() {
            return Integer.MAX_VALUE;
        }

        public <T> List<T> receiveWhile(java.time.Duration max, java.time.Duration idle, int messages, PartialFunction<SubscriberEvent, T> f) {
            return package.JavaConverters$.MODULE$.SeqHasAsJava(this.receiveWhile((Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), (Duration)JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(idle)), messages, f)).asJava();
        }

        public scala.collection.immutable.Seq<I> receiveWithin(FiniteDuration max, int messages) {
            return (scala.collection.immutable.Seq)this.probe.receiveWhile((Duration)max, (Duration)max, messages, (PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        I i;
                        OnNext<I> onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object);
                        I i2 = i = onNext._1();
                        return true;
                    }
                    return true;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof OnNext) {
                        I i;
                        OnNext<I> onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)object);
                        I i2 = i = onNext._1();
                        return Some$.MODULE$.apply(i2);
                    }
                    return None$.MODULE$;
                }
            }).flatten(Predef$.MODULE$.$conforms());
        }

        public int receiveWithin$default$2() {
            return Integer.MAX_VALUE;
        }

        public List<I> receiveWithin(java.time.Duration max, int messages) {
            return package.JavaConverters$.MODULE$.SeqHasAsJava(this.receiveWithin(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), messages)).asJava();
        }

        public scala.collection.immutable.Seq<I> toStrict(FiniteDuration atMost) {
            Deadline deadline = Deadline$.MODULE$.now().$plus(atMost);
            Builder b = Seq$.MODULE$.newBuilder();
            if (this._subscription == null) {
                this.self.expectSubscription();
            }
            this._subscription.request(Long.MAX_VALUE);
            return this.drain$1(deadline, b);
        }

        public List<I> toStrict(java.time.Duration atMost) {
            return package.JavaConverters$.MODULE$.SeqHasAsJava(this.toStrict(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(atMost)))).asJava();
        }

        public <T> T within(FiniteDuration min, FiniteDuration max, Function0<T> f) {
            return (T)this.probe.within(min, max, f);
        }

        public <T> T within(java.time.Duration min, java.time.Duration max, Creator<T> creator) {
            return this.within(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(min)), JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), () -> this.within$$anonfun$5(creator));
        }

        public <T> T within(FiniteDuration max, Function0<T> f) {
            return (T)this.probe.within(max, f);
        }

        public <T> T within(java.time.Duration max, Creator<T> creator) {
            return this.within(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(max)), () -> this.within$$anonfun$6(creator));
        }

        public void onSubscribe(Subscription subscription) {
            ActorRef actorRef = this.probe.ref();
            OnSubscribe onSubscribe = TestSubscriber$OnSubscribe$.MODULE$.apply(subscription);
            actorRef.$bang((Object)onSubscribe, actorRef.$bang$default$2((Object)onSubscribe));
        }

        public void onNext(I element) {
            ActorRef actorRef = this.probe.ref();
            OnNext<I> onNext = TestSubscriber$OnNext$.MODULE$.apply(element);
            actorRef.$bang(onNext, actorRef.$bang$default$2(onNext));
        }

        public void onComplete() {
            ActorRef actorRef = this.probe.ref();
            actorRef.$bang((Object)TestSubscriber$OnComplete$.MODULE$, actorRef.$bang$default$2((Object)TestSubscriber$OnComplete$.MODULE$));
        }

        public void onError(Throwable cause) {
            ActorRef actorRef = this.probe.ref();
            OnError onError = TestSubscriber$OnError$.MODULE$.apply(cause);
            actorRef.$bang((Object)onError, actorRef.$bang$default$2((Object)onError));
        }

        private final void expectOneOf$1(scala.collection.immutable.Seq all) {
            while (true) {
                scala.collection.immutable.Seq seq = all;
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                scala.collection.immutable.Seq seq2 = seq;
                if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
                    return;
                }
                I next = this.expectNext();
                if (!all.contains(next)) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(31).append("expected one of ").append(all).append(", but received ").append(next).toString());
                }
                all = (scala.collection.immutable.Seq)all.diff((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{next})));
            }
        }

        private final scala.collection.immutable.Seq drain$1(Deadline deadline$1, Builder b$1) {
            while (true) {
                OnNext onNext;
                Object i;
                SubscriberEvent subscriberEvent;
                if ((subscriberEvent = this.self.expectEvent(deadline$1.timeLeft())) instanceof OnError) {
                    Throwable throwable;
                    OnError onError = TestSubscriber$OnError$.MODULE$.unapply((OnError)subscriberEvent);
                    Throwable ex = throwable = onError._1();
                    throw new AssertionError(new StringBuilder(71).append("toStrict received OnError while draining stream! Accumulated elements: ").append(b$1.result()).toString(), ex);
                }
                if (TestSubscriber$OnComplete$.MODULE$.equals(subscriberEvent)) {
                    return (scala.collection.immutable.Seq)b$1.result();
                }
                if (!(subscriberEvent instanceof OnNext) || !((i = (onNext = TestSubscriber$OnNext$.MODULE$.unapply((OnNext)subscriberEvent))._1()) instanceof Object)) break;
                Object i2 = i;
                b$1.$plus$eq(i2);
            }
            throw new RuntimeException();
        }

        private final Object within$$anonfun$5(Creator creator$3) {
            return creator$3.create();
        }

        private final Object within$$anonfun$6(Creator creator$4) {
            return creator$4.create();
        }
    }

    public static final class OnError
    implements SubscriberEvent,
    Product,
    Serializable {
        private final Throwable cause;

        public static OnError apply(Throwable throwable) {
            return TestSubscriber$OnError$.MODULE$.apply(throwable);
        }

        public static OnError fromProduct(Product product) {
            return TestSubscriber$OnError$.MODULE$.fromProduct(product);
        }

        public static OnError unapply(OnError onError) {
            return TestSubscriber$OnError$.MODULE$.unapply(onError);
        }

        public OnError(Throwable cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnError)) return false;
            OnError onError = (OnError)object;
            Throwable throwable = this.cause();
            Throwable throwable2 = onError.cause();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof OnError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "OnError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable cause() {
            return this.cause;
        }

        public String toString() {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            out.print("OnError(");
            this.cause().printStackTrace(out);
            out.print(")");
            return str.toString();
        }

        public OnError copy(Throwable cause) {
            return new OnError(cause);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public Throwable _1() {
            return this.cause();
        }
    }

    public static final class OnNext<I>
    implements SubscriberEvent,
    Product,
    Serializable {
        private final Object element;

        public static <I> OnNext<I> apply(I i) {
            return TestSubscriber$OnNext$.MODULE$.apply(i);
        }

        public static OnNext<?> fromProduct(Product product) {
            return TestSubscriber$OnNext$.MODULE$.fromProduct(product);
        }

        public static <I> OnNext<I> unapply(OnNext<I> onNext) {
            return TestSubscriber$OnNext$.MODULE$.unapply(onNext);
        }

        public OnNext(I element) {
            this.element = element;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnNext)) return false;
            OnNext onNext = (OnNext)object;
            if (!BoxesRunTime.equals(this.element(), onNext.element())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OnNext;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "OnNext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "element";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public I element() {
            return (I)this.element;
        }

        public <I> OnNext<I> copy(I element) {
            return new OnNext<I>(element);
        }

        public <I> I copy$default$1() {
            return this.element();
        }

        public I _1() {
            return this.element();
        }
    }

    public static final class OnSubscribe
    implements SubscriberEvent,
    Product,
    Serializable {
        private final Subscription subscription;

        public static OnSubscribe apply(Subscription subscription) {
            return TestSubscriber$OnSubscribe$.MODULE$.apply(subscription);
        }

        public static OnSubscribe fromProduct(Product product) {
            return TestSubscriber$OnSubscribe$.MODULE$.fromProduct(product);
        }

        public static OnSubscribe unapply(OnSubscribe onSubscribe) {
            return TestSubscriber$OnSubscribe$.MODULE$.unapply(onSubscribe);
        }

        public OnSubscribe(Subscription subscription) {
            this.subscription = subscription;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnSubscribe)) return false;
            OnSubscribe onSubscribe = (OnSubscribe)object;
            Subscription subscription = this.subscription();
            Subscription subscription2 = onSubscribe.subscription();
            if (subscription != null) {
                if (!subscription.equals(subscription2)) return false;
                return true;
            }
            if (subscription2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OnSubscribe;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "OnSubscribe";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscription";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Subscription subscription() {
            return this.subscription;
        }

        public OnSubscribe copy(Subscription subscription) {
            return new OnSubscribe(subscription);
        }

        public Subscription copy$default$1() {
            return this.subscription();
        }

        public Subscription _1() {
            return this.subscription();
        }
    }

    public static class Probe<T>
    extends ManualProbe<T> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Probe.class.getDeclaredField("subscription$lzy2"));
        private volatile Object subscription$lzy2;

        public static <T> Probe<T> apply(ClassicActorSystemProvider classicActorSystemProvider) {
            return TestSubscriber$Probe$.MODULE$.apply(classicActorSystemProvider);
        }

        public static <T> Probe<T> create(ClassicActorSystemProvider classicActorSystemProvider) {
            return TestSubscriber$Probe$.MODULE$.create(classicActorSystemProvider);
        }

        public Probe(ActorSystem system) {
            super(system);
        }

        private Subscription subscription() {
            Object object = this.subscription$lzy2;
            if (object instanceof Subscription) {
                return (Subscription)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Subscription)this.subscription$lzyINIT2();
        }

        private Object subscription$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.subscription$lzy2) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Subscription subscription = null;
                        try {
                            subscription = this.expectSubscription();
                            object2 = subscription == null ? LazyVals.NullValue$.MODULE$ : subscription;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.subscription$lzy2;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return subscription;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Probe<T> ensureSubscription() {
            this.subscription();
            return this;
        }

        public Probe<T> request(long n) {
            this.subscription().request(n);
            return this;
        }

        public Probe<T> requestNext(T element) {
            this.subscription().request(1L);
            this.expectNext(element);
            return this;
        }

        public Probe<T> cancel() {
            this.subscription().cancel();
            return this;
        }

        public Probe<T> cancel(Throwable cause) {
            Subscription subscription = this.subscription();
            if (subscription instanceof SubscriptionWithCancelException) {
                SubscriptionWithCancelException s = (SubscriptionWithCancelException)subscription;
                s.cancel(cause);
                return this;
            }
            throw new IllegalStateException("Tried to cancel with cause but upstream subscription doesn't support cancellation with cause");
        }

        public T requestNext() {
            this.subscription().request(1L);
            return (T)this.expectNext();
        }

        public T requestNext(FiniteDuration d) {
            this.subscription().request(1L);
            return (T)this.expectNext(d);
        }

        public T requestNext(java.time.Duration d) {
            return this.requestNext(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(d)));
        }
    }

    public static interface SubscriberEvent
    extends DeadLetterSuppression,
    NoSerializationVerificationNeeded {
    }
}

