/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.testkit.scaladsl;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer;
import org.apache.pekko.stream.impl.StreamSupervisor;
import org.apache.pekko.stream.snapshot.ConnectionSnapshot;
import org.apache.pekko.stream.snapshot.ConnectionSnapshotImpl;
import org.apache.pekko.stream.snapshot.InterpreterSnapshot;
import org.apache.pekko.stream.snapshot.LogicSnapshot;
import org.apache.pekko.stream.snapshot.LogicSnapshotImpl;
import org.apache.pekko.stream.snapshot.MaterializerState$;
import org.apache.pekko.stream.snapshot.RunningInterpreter;
import org.apache.pekko.stream.snapshot.RunningInterpreterImpl;
import org.apache.pekko.stream.snapshot.StreamSnapshotImpl;
import org.apache.pekko.testkit.TestProbe;
import org.apache.pekko.testkit.TestProbe$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public final class StreamTestKit$
implements Serializable {
    public static final StreamTestKit$ MODULE$ = new StreamTestKit$();

    private StreamTestKit$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StreamTestKit$.class);
    }

    public <T> T assertAllStagesStopped(Function0<T> block, FiniteDuration overrideTimeout, Materializer materializer) {
        Materializer materializer2 = materializer;
        if (materializer2 instanceof PhasedFusingActorMaterializer) {
            PhasedFusingActorMaterializer impl = (PhasedFusingActorMaterializer)materializer2;
            this.stopAllChildren(impl.system(), impl.supervisor());
            Object result = block.apply();
            this.assertNoChildren(impl.system(), impl.supervisor(), (Option<FiniteDuration>)Some$.MODULE$.apply((Object)overrideTimeout));
            return (T)result;
        }
        return (T)block.apply();
    }

    public <T> T assertAllStagesStopped(Function0<T> block, Materializer materializer) {
        Materializer materializer2 = materializer;
        if (materializer2 instanceof PhasedFusingActorMaterializer) {
            PhasedFusingActorMaterializer impl = (PhasedFusingActorMaterializer)materializer2;
            this.stopAllChildren(impl.system(), impl.supervisor());
            Object result = block.apply();
            this.assertNoChildren(impl.system(), impl.supervisor(), (Option<FiniteDuration>)None$.MODULE$);
            return (T)result;
        }
        return (T)block.apply();
    }

    @InternalApi
    public void stopAllChildren(ActorSystem sys, ActorRef supervisor) {
        TestProbe probe = TestProbe$.MODULE$.apply(sys);
        probe.send(supervisor, (Object)StreamSupervisor.StopChildren$.MODULE$);
        probe.expectMsg((Object)StreamSupervisor.StoppedChildren$.MODULE$);
    }

    @InternalApi
    public void assertNoChildren(ActorSystem sys, ActorRef supervisor, Option<FiniteDuration> overrideTimeout) {
        TestProbe probe = TestProbe$.MODULE$.apply(sys);
        FiniteDuration timeout = (FiniteDuration)overrideTimeout.getOrElse(() -> StreamTestKit$.$anonfun$1(sys));
        probe.within(timeout, (Function0 & Serializable)() -> {
            StreamTestKit$.assertNoChildren$$anonfun$1(probe, supervisor, sys);
            return BoxedUnit.UNIT;
        });
    }

    @InternalApi
    public void printDebugDump(ActorRef streamSupervisor, ExecutionContext ec) {
        Future doneDumping = MaterializerState$.MODULE$.requestFromSupervisor(streamSupervisor, ec).map((Function1)(JProcedure1 & Serializable)snapshots -> snapshots.foreach((Function1)(JProcedure1 & Serializable)s -> Predef$.MODULE$.println((Object)MODULE$.snapshotString((StreamSnapshotImpl)s))), ec);
        Await$.MODULE$.result((Awaitable)doneDumping, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
    }

    @InternalApi
    public String snapshotString(StreamSnapshotImpl snapshot) {
        StringBuilder builder = new StringBuilder();
        builder.append(new java.lang.StringBuilder(24).append("activeShells (actor: ").append(snapshot.self()).append("):\n").toString());
        snapshot.activeInterpreters().foreach((Function1 & Serializable)shell -> {
            builder.append("  ");
            MODULE$.appendShellSnapshot(builder, (InterpreterSnapshot)shell);
            builder.append("\n");
            MODULE$.appendInterpreterSnapshot(builder, (RunningInterpreterImpl)shell);
            return builder.append("\n");
        });
        builder.append("newShells:\n");
        snapshot.newShells().foreach((Function1 & Serializable)shell -> {
            builder.append("  ");
            MODULE$.appendShellSnapshot(builder, (InterpreterSnapshot)shell);
            builder.append("\n");
            builder.append("    Not initialized");
            return builder.append("\n");
        });
        return builder.toString();
    }

    private void appendShellSnapshot(StringBuilder builder, InterpreterSnapshot shell) {
        builder.append("GraphInterpreterShell(\n  logics: [\n");
        Seq logicsToPrint = shell.logics();
        logicsToPrint.foreach((Function1 & Serializable)logic -> builder.append("    ").append(logic.label()).append(" attrs: [").append(logic.attributes().attributeList().mkString(", ")).append("],\n"));
        builder.setLength(builder.length() - 2);
        InterpreterSnapshot interpreterSnapshot = shell;
        if (interpreterSnapshot instanceof RunningInterpreter) {
            RunningInterpreter running = (RunningInterpreter)interpreterSnapshot;
            builder.append("\n  ],\n  connections: [\n");
            running.connections().foreach((Function1 & Serializable)connection -> builder.append("    ").append("Connection(").append(((ConnectionSnapshotImpl)connection).id()).append(", ").append(connection.in().label()).append(", ").append(connection.out().label()).append(", ").append((Object)connection.state()).append(")\n"));
            builder.setLength(builder.length() - 2);
        }
        builder.append("\n  ]\n)");
        builder.toString();
    }

    private void appendInterpreterSnapshot(StringBuilder builder, RunningInterpreterImpl snapshot) {
        try {
            builder.append("\ndot format graph for deadlock analysis:\n");
            builder.append("================================================================\n");
            builder.append("digraph waits {\n");
            snapshot.logics().indices().foreach((Function1 & Serializable)i -> StreamTestKit$.appendInterpreterSnapshot$$anonfun$1(snapshot, builder, BoxesRunTime.unboxToInt((Object)i)));
            snapshot.connections().foreach((Function1 & Serializable)connection -> {
                StringBuilder stringBuilder;
                String inName = new java.lang.StringBuilder(1).append("N").append(((LogicSnapshotImpl)connection.in()).index()).toString();
                String outName = new java.lang.StringBuilder(1).append("N").append(((LogicSnapshotImpl)connection.out()).index()).toString();
                builder.append(new java.lang.StringBuilder(7).append("  ").append(inName).append(" -> ").append(outName).append(" ").toString());
                ConnectionSnapshot.ConnectionState connectionState = connection.state();
                if (ConnectionSnapshot.ShouldPull$.MODULE$.equals(connectionState)) {
                    stringBuilder = builder.append("[label=shouldPull, color=blue];");
                } else if (ConnectionSnapshot.ShouldPush$.MODULE$.equals(connectionState)) {
                    stringBuilder = builder.append("[label=shouldPush, color=red, dir=back];");
                } else if (ConnectionSnapshot.Closed$.MODULE$.equals(connectionState)) {
                    stringBuilder = builder.append("[style=dotted, label=closed, dir=both];");
                } else if (connectionState == null) {
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)connectionState);
                }
                return builder.append("\n");
            });
            builder.append("}\n================================================================\n");
            builder.append(new java.lang.StringBuilder(25).append("// ").append(snapshot.queueStatus()).append(" (running=").append(snapshot.runningLogicsCount()).append(", shutdown=").append(snapshot.stoppedLogics().mkString(",")).append(")").toString());
            builder.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            builder.append("Not all logics has a stage listed, cannot create graph");
        }
    }

    private static final FiniteDuration $anonfun$1(ActorSystem sys$1) {
        Config c = sys$1.settings().config().getConfig("pekko.stream.testkit");
        return new package.DurationLong(package$.MODULE$.DurationLong(c.getDuration("all-stages-stopped-timeout", TimeUnit.MILLISECONDS))).millis();
    }

    private static final void assertNoChildren$$anonfun$1$$anonfun$1(ActorRef supervisor$2, TestProbe probe$2) {
        supervisor$2.tell((Object)StreamSupervisor.GetChildren$.MODULE$, probe$2.ref());
        Set children = ((StreamSupervisor.Children)probe$2.expectMsgType(ClassTag$.MODULE$.apply(StreamSupervisor.Children.class))).children();
        if (!children.isEmpty()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new java.lang.StringBuilder(49).append("expected no StreamSupervisor children, but got [").append(children.mkString(", ")).append("]").toString());
        }
    }

    private static final void assertNoChildren$$anonfun$1(TestProbe probe$1, ActorRef supervisor$1, ActorSystem sys$2) {
        try {
            probe$1.awaitAssert((Function0 & Serializable)() -> {
                StreamTestKit$.assertNoChildren$$anonfun$1$$anonfun$1(supervisor$1, probe$1);
                return BoxedUnit.UNIT;
            }, probe$1.awaitAssert$default$2(), probe$1.awaitAssert$default$3());
        }
        catch (Throwable ex) {
            MODULE$.printDebugDump(supervisor$1, (ExecutionContext)sys$2.dispatcher());
            throw ex;
        }
    }

    private static final /* synthetic */ StringBuilder appendInterpreterSnapshot$$anonfun$1(RunningInterpreterImpl snapshot$1, StringBuilder builder$5, int i) {
        LogicSnapshot logic = (LogicSnapshot)snapshot$1.logics().apply(i);
        return builder$5.append(new java.lang.StringBuilder(15).append("  N").append(i).append(" [label=\"").append(logic.label()).append("\"];").toString()).append('\n');
    }
}

