/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.util.function.BiConsumer;
import java.util.stream.Collector;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.CollectorState;
import org.apache.pekko.stream.impl.MutableCollectorState;
import scala.Function0;

@InternalApi
public final class FirstCollectorState<T, R>
implements CollectorState<T, R> {
    private final Function0<Collector<T, Object, R>> collectorFactory;

    public FirstCollectorState(Function0<Collector<T, Object, R>> collectorFactory) {
        this.collectorFactory = collectorFactory;
    }

    @Override
    public CollectorState<T, R> update(T elem) {
        Collector collector = (Collector)this.collectorFactory.apply();
        BiConsumer accumulator = collector.accumulator();
        Object accumulated = collector.supplier().get();
        accumulator.accept(accumulated, elem);
        return new MutableCollectorState(collector, accumulator, accumulated);
    }

    @Override
    public Object accumulated() {
        Collector collector = (Collector)this.collectorFactory.apply();
        return collector.supplier().get();
    }

    @Override
    public R finish() {
        Collector collector = (Collector)this.collectorFactory.apply();
        return collector.finisher().apply(collector.supplier().get());
    }
}

