/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.util.ArrayList;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.ActorMaterializerSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.InPort;
import org.apache.pekko.stream.OutPort;
import org.apache.pekko.stream.impl.ForwardWire;
import org.apache.pekko.stream.impl.ForwardWire$;
import org.apache.pekko.stream.impl.IslandTag;
import org.apache.pekko.stream.impl.Phase;
import org.apache.pekko.stream.impl.PhaseIsland;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer$;
import org.apache.pekko.stream.impl.SavedIslandData;
import org.apache.pekko.stream.impl.SavedIslandData$;
import org.apache.pekko.stream.impl.SegmentInfo;
import org.apache.pekko.stream.impl.SegmentInfo$;
import org.reactivestreams.Publisher;
import scala.Predef$;
import scala.collection.immutable.Map;

@InternalApi
public class IslandTracking {
    private final Map phases;
    private final ActorMaterializerSettings settings;
    private final PhasedFusingActorMaterializer materializer;
    private final String islandNamePrefix;
    private int islandNameCounter;
    private int currentGlobalOffset;
    private int currentSegmentGlobalOffset;
    private int currentIslandGlobalOffset;
    private int currentIslandSkippedSlots;
    private ArrayList<SegmentInfo> segments;
    private ArrayList<PhaseIsland<Object>> activePhases;
    private ArrayList<ForwardWire> forwardWires;
    private ArrayList<SavedIslandData> islandStateStack;
    private PhaseIsland<Object> currentPhase;

    public IslandTracking(Map<IslandTag, Phase<Object>> phases, ActorMaterializerSettings settings, Attributes attributes, Phase<Object> defaultPhase, PhasedFusingActorMaterializer materializer, String islandNamePrefix) {
        this.phases = phases;
        this.settings = settings;
        this.materializer = materializer;
        this.islandNamePrefix = islandNamePrefix;
        this.islandNameCounter = 0;
        this.currentGlobalOffset = 0;
        this.currentSegmentGlobalOffset = 0;
        this.currentIslandGlobalOffset = 0;
        this.currentIslandSkippedSlots = 0;
        this.currentPhase = defaultPhase.apply(settings, attributes, materializer, this.nextIslandName());
    }

    public Map<IslandTag, Phase<Object>> phases() {
        return this.phases;
    }

    public ActorMaterializerSettings settings() {
        return this.settings;
    }

    public PhasedFusingActorMaterializer materializer() {
        return this.materializer;
    }

    private String nextIslandName() {
        String s = new StringBuilder(0).append(this.islandNamePrefix).append(this.islandNameCounter).toString();
        ++this.islandNameCounter;
        return s;
    }

    @InternalApi
    public PhaseIsland<Object> getCurrentPhase() {
        return this.currentPhase;
    }

    @InternalApi
    public int getCurrentOffset() {
        return this.currentGlobalOffset;
    }

    private void completeSegment() {
        int length = this.currentGlobalOffset - this.currentSegmentGlobalOffset;
        if (this.activePhases == null) {
            this.activePhases = new ArrayList(8);
            this.islandStateStack = new ArrayList(4);
        }
        if (length > 0) {
            SegmentInfo previousSegment = SegmentInfo$.MODULE$.apply(this.currentIslandGlobalOffset, this.currentGlobalOffset - this.currentSegmentGlobalOffset, this.currentSegmentGlobalOffset, this.currentSegmentGlobalOffset - this.currentIslandGlobalOffset - this.currentIslandSkippedSlots, this.currentPhase);
            if (this.segments == null) {
                this.segments = new ArrayList(8);
            }
            this.segments.add(previousSegment);
            if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                Predef$.MODULE$.println((Object)new StringBuilder(18).append("Completed segment ").append(previousSegment).toString());
                return;
            }
            return;
        }
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)"Skipped zero length segment");
            return;
        }
    }

    @InternalApi
    public void enterIsland(IslandTag tag, Attributes attributes) {
        this.completeSegment();
        PhaseIsland<Object> previousPhase = this.currentPhase;
        int previousIslandOffset = this.currentIslandGlobalOffset;
        this.islandStateStack.add(SavedIslandData$.MODULE$.apply(previousIslandOffset, this.currentGlobalOffset, this.currentIslandSkippedSlots, previousPhase));
        this.currentPhase = ((Phase)this.phases().apply((Object)tag)).apply(this.settings(), attributes, this.materializer(), this.nextIslandName());
        this.activePhases.add(this.currentPhase);
        this.currentIslandGlobalOffset = this.currentGlobalOffset;
        this.currentSegmentGlobalOffset = this.currentGlobalOffset;
        this.currentIslandSkippedSlots = 0;
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)new StringBuilder(46).append("Entering island starting at offset = ").append(this.currentIslandGlobalOffset).append(" phase = ").append(this.currentPhase).toString());
            return;
        }
    }

    @InternalApi
    public void exitIsland() {
        SavedIslandData parentIsland = this.islandStateStack.remove(this.islandStateStack.size() - 1);
        this.completeSegment();
        this.currentSegmentGlobalOffset = this.currentGlobalOffset;
        this.currentIslandGlobalOffset = parentIsland.islandGlobalOffset();
        this.currentPhase = parentIsland.phase();
        this.currentIslandSkippedSlots = parentIsland.skippedSlots() + (this.currentGlobalOffset - parentIsland.lastVisitedOffset());
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)new StringBuilder(47).append("Exited to island starting at offset = ").append(this.currentIslandGlobalOffset).append(" phase = ").append(this.currentPhase).toString());
            return;
        }
    }

    @InternalApi
    public void wireIn(InPort in, Object logic) {
        int localInSlot = this.currentGlobalOffset - this.currentIslandGlobalOffset - this.currentIslandSkippedSlots;
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)new StringBuilder(42).append("  wiring port ").append(in).append(" inOffs absolute = ").append(this.currentGlobalOffset).append(" local = ").append(localInSlot).toString());
        }
        this.currentPhase.assignPort(in, localInSlot, logic);
        ForwardWire forwardWire = null;
        if (this.forwardWires != null && !this.forwardWires.isEmpty()) {
            int i = 0;
            while (i < this.forwardWires.size()) {
                forwardWire = this.forwardWires.get(i);
                if (forwardWire.toGlobalOffset() == this.currentGlobalOffset) {
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(41).append("    there is a forward wire to this slot ").append(forwardWire).toString());
                    }
                    this.forwardWires.remove(i);
                    i = Integer.MAX_VALUE;
                    continue;
                }
                forwardWire = null;
                ++i;
            }
        }
        if (forwardWire != null) {
            if (forwardWire.phase() == this.currentPhase) {
                if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(62).append("    in-island forward wiring from port ").append(forwardWire.from()).append(" wired to local slot = ").append(localInSlot).toString());
                }
                forwardWire.phase().assignPort(forwardWire.from(), localInSlot, forwardWire.outStage());
            } else {
                if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(65).append("    cross island forward wiring from port ").append(forwardWire.from()).append(" wired to local slot = ").append(localInSlot).toString());
                }
                Publisher<Object> publisher = forwardWire.phase().createPublisher(forwardWire.from(), forwardWire.outStage());
                this.currentPhase.takePublisher(localInSlot, publisher, null);
            }
        }
        ++this.currentGlobalOffset;
    }

    @InternalApi
    public void wireOut(OutPort out, int absoluteOffset, Object logic) {
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)new StringBuilder(24).append("  wiring ").append(out).append(" to absolute = ").append(absoluteOffset).toString());
        }
        if (absoluteOffset < this.currentGlobalOffset) {
            if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                Predef$.MODULE$.println((Object)"    backward wiring");
            }
            if (absoluteOffset >= this.currentSegmentGlobalOffset) {
                int localInSlot = absoluteOffset - this.currentIslandGlobalOffset - this.currentIslandSkippedSlots;
                if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(42).append("    in-segment wiring to local (").append(absoluteOffset).append(" - ").append(this.currentIslandGlobalOffset).append(" - ").append(this.currentIslandSkippedSlots).append(") = ").append(localInSlot).toString());
                }
                this.currentPhase.assignPort(out, localInSlot, logic);
                return;
            }
            int i = this.segments.size() - 1;
            SegmentInfo targetSegment = this.segments.get(i);
            while (i > 0 && targetSegment.globalBaseOffset() > absoluteOffset) {
                targetSegment = this.segments.get(--i);
            }
            int distanceFromSegmentStart = absoluteOffset - targetSegment.globalBaseOffset();
            int localInSlot = distanceFromSegmentStart + targetSegment.relativeBaseOffset();
            if (targetSegment.phase() == this.currentPhase) {
                if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(50).append("    cross-segment, in-island wiring to local slot ").append(localInSlot).toString());
                }
                this.currentPhase.assignPort(out, localInSlot, logic);
                return;
            }
            if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                Predef$.MODULE$.println((Object)new StringBuilder(55).append("    cross-island wiring to local slot ").append(localInSlot).append(" in target island").toString());
            }
            Publisher<Object> publisher = this.currentPhase.createPublisher(out, logic);
            targetSegment.phase().takePublisher(localInSlot, publisher, null);
            return;
        }
        if (this.forwardWires == null) {
            this.forwardWires = new ArrayList(8);
        }
        ForwardWire forwardWire = ForwardWire$.MODULE$.apply(this.currentIslandGlobalOffset, out, absoluteOffset, logic, this.currentPhase);
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)new StringBuilder(33).append("    wiring is forward, recording ").append(forwardWire).toString());
        }
        this.forwardWires.add(forwardWire);
    }

    @InternalApi
    public void allNestedIslandsReady() {
        if (this.activePhases != null) {
            for (int i = 0; i < this.activePhases.size(); ++i) {
                this.activePhases.get(i).onIslandReady();
            }
            return;
        }
    }
}

