/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BidiShape;
import org.apache.pekko.stream.BidiShape$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.ContextPropagation;
import org.apache.pekko.stream.impl.ContextPropagation$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.Timers$;
import org.apache.pekko.stream.impl.Timers$GraphStageLogicTimer$;
import org.apache.pekko.stream.impl.Timers$IdleTimeoutBidi$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogic;
import scala.Function0;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.Scala3RunTime$;

@InternalApi
public final class Timers {
    public static FiniteDuration timeoutCheckInterval(FiniteDuration finiteDuration) {
        return Timers$.MODULE$.timeoutCheckInterval(finiteDuration);
    }

    public static final class BackpressureTimeout<T>
    extends GraphStages.SimpleLinearGraphStage<T> {
        private final FiniteDuration timeout;

        public BackpressureTimeout(FiniteDuration timeout) {
            this.timeout = timeout;
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.backpressureTimeout();
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private long nextDeadline;
                private boolean waitingDemand;
                private final /* synthetic */ BackpressureTimeout $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.nextDeadline = System.nanoTime() + $outer.timeout().toNanos();
                    this.waitingDemand = true;
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    this.push(this.$outer.out(), this.grab(this.$outer.in()));
                    this.nextDeadline = System.nanoTime() + this.$outer.timeout().toNanos();
                    this.waitingDemand = true;
                }

                public void onPull() {
                    this.waitingDemand = false;
                    this.pull(this.$outer.in());
                }

                public final void onTimer(Object key) {
                    if (this.waitingDemand && this.nextDeadline - System.nanoTime() < 0L) {
                        this.failStage(new TimeoutException(new StringBuilder(33).append("No demand signalled in the last ").append(this.$outer.timeout()).append(".").toString()));
                        return;
                    }
                }

                public void preStart() {
                    this.scheduleWithFixedDelay((Object)Timers$GraphStageLogicTimer$.MODULE$, Timers$.MODULE$.timeoutCheckInterval(this.$outer.timeout()), Timers$.MODULE$.timeoutCheckInterval(this.$outer.timeout()));
                }
            };
        }

        public String toString() {
            return "BackpressureTimeout";
        }
    }

    public static final class Completion<T>
    extends GraphStages.SimpleLinearGraphStage<T> {
        private final FiniteDuration timeout;

        public Completion(FiniteDuration timeout) {
            this.timeout = timeout;
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.completion();
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private final /* synthetic */ Completion $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    this.push(this.$outer.out(), this.grab(this.$outer.in()));
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public final void onTimer(Object key) {
                    this.failStage(new TimeoutException(new StringBuilder(38).append("The stream has not been completed in ").append(this.$outer.timeout()).append(".").toString()));
                }

                public void preStart() {
                    this.scheduleOnce((Object)Timers$GraphStageLogicTimer$.MODULE$, this.$outer.timeout());
                }
            };
        }

        public String toString() {
            return "CompletionTimeout";
        }
    }

    public static final class DelayInitial<T>
    extends GraphStages.SimpleLinearGraphStage<T> {
        private final FiniteDuration delay;

        public DelayInitial(FiniteDuration delay) {
            this.delay = delay;
        }

        public FiniteDuration delay() {
            return this.delay;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.delayInitial();
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private boolean open;
                private final /* synthetic */ DelayInitial $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.open = false;
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void preStart() {
                    FiniteDuration finiteDuration = this.$outer.delay();
                    FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                    if (!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null)) {
                        this.open = true;
                        return;
                    }
                    this.scheduleOnce((Object)Timers$GraphStageLogicTimer$.MODULE$, this.$outer.delay());
                }

                public void onPush() {
                    this.push(this.$outer.out(), this.grab(this.$outer.in()));
                }

                public void onPull() {
                    if (this.open) {
                        this.pull(this.$outer.in());
                        return;
                    }
                }

                public void onTimer(Object timerKey) {
                    this.open = true;
                    if (this.isAvailable(this.$outer.out())) {
                        this.pull(this.$outer.in());
                        return;
                    }
                }
            };
        }

        public String toString() {
            return "DelayTimer";
        }
    }

    public static final class Idle<T>
    extends GraphStages.SimpleLinearGraphStage<T> {
        private final FiniteDuration timeout;

        public Idle(FiniteDuration timeout) {
            this.timeout = timeout;
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.idle();
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private long nextDeadline;
                private final /* synthetic */ Idle $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.nextDeadline = System.nanoTime() + $outer.timeout().toNanos();
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    this.nextDeadline = System.nanoTime() + this.$outer.timeout().toNanos();
                    this.push(this.$outer.out(), this.grab(this.$outer.in()));
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public final void onTimer(Object key) {
                    if (this.nextDeadline - System.nanoTime() < 0L) {
                        this.failStage(new TimeoutException(new StringBuilder(32).append("No elements passed in the last ").append(this.$outer.timeout()).append(".").toString()));
                        return;
                    }
                }

                public void preStart() {
                    this.scheduleWithFixedDelay((Object)Timers$GraphStageLogicTimer$.MODULE$, Timers$.MODULE$.timeoutCheckInterval(this.$outer.timeout()), Timers$.MODULE$.timeoutCheckInterval(this.$outer.timeout()));
                }
            };
        }

        public String toString() {
            return "IdleTimeout";
        }
    }

    public static final class IdleInject<I, O>
    extends GraphStage<FlowShape<I, O>> {
        private final FiniteDuration timeout;
        private final Function0 inject;
        private final Inlet in;
        private final Outlet out;
        private final FlowShape shape;

        public IdleInject(FiniteDuration timeout, Function0<O> inject) {
            this.timeout = timeout;
            this.inject = inject;
            this.in = Inlet$.MODULE$.apply("IdleInject.in");
            this.out = Outlet$.MODULE$.apply("IdleInject.out");
            this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        public Function0<O> inject() {
            return this.inject;
        }

        public Inlet<I> in() {
            return this.in;
        }

        public Outlet<O> out() {
            return this.out;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.idleInject();
        }

        @Override
        public FlowShape<I, O> shape() {
            return this.shape;
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private long nextDeadline;
                private final ContextPropagation contextPropagation;
                private final /* synthetic */ IdleInject $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.nextDeadline = System.nanoTime() + $outer.timeout().toNanos();
                    this.contextPropagation = ContextPropagation$.MODULE$.apply();
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void preStart() {
                    this.pull(this.$outer.in());
                }

                public void onPush() {
                    this.nextDeadline = System.nanoTime() + this.$outer.timeout().toNanos();
                    this.cancelTimer(Timers$GraphStageLogicTimer$.MODULE$);
                    if (this.isAvailable(this.$outer.out())) {
                        this.push(this.$outer.out(), this.grab(this.$outer.in()));
                        this.pull(this.$outer.in());
                        return;
                    }
                    this.contextPropagation.suspendContext();
                }

                public void onUpstreamFinish() {
                    if (!this.isAvailable(this.$outer.in())) {
                        this.completeStage();
                        return;
                    }
                }

                public void onPull() {
                    if (this.isAvailable(this.$outer.in())) {
                        this.contextPropagation.resumeContext();
                        this.push(this.$outer.out(), this.grab(this.$outer.in()));
                        if (this.isClosed(this.$outer.in())) {
                            this.completeStage();
                            return;
                        }
                        this.pull(this.$outer.in());
                        return;
                    }
                    long now = System.nanoTime();
                    if (now - this.nextDeadline >= 0L) {
                        this.nextDeadline = now + this.$outer.timeout().toNanos();
                        this.push(this.$outer.out(), this.$outer.inject().apply());
                        return;
                    }
                    this.scheduleOnce((Object)Timers$GraphStageLogicTimer$.MODULE$, FiniteDuration$.MODULE$.apply(this.nextDeadline - now, TimeUnit.NANOSECONDS));
                }

                public void onTimer(Object timerKey) {
                    long now = System.nanoTime();
                    if (now - this.nextDeadline < 0L) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(84).append("Timer should have triggered only after deadline but now is ").append(now).append(" and deadline was ").append(this.nextDeadline).append(" diff ").append(now - this.nextDeadline).append(".").toString());
                    }
                    this.push(this.$outer.out(), this.$outer.inject().apply());
                    this.nextDeadline = now + this.$outer.timeout().toNanos();
                }
            };
        }

        public String toString() {
            return "IdleTimer";
        }
    }

    public static final class IdleTimeoutBidi<I, O>
    extends GraphStage<BidiShape<I, I, O, O>> {
        private final FiniteDuration timeout;
        private final Inlet in1;
        private final Inlet in2;
        private final Outlet out1;
        private final Outlet out2;
        private final BidiShape shape;

        public IdleTimeoutBidi(FiniteDuration timeout) {
            this.timeout = timeout;
            this.in1 = Inlet$.MODULE$.apply("in1");
            this.in2 = Inlet$.MODULE$.apply("in2");
            this.out1 = Outlet$.MODULE$.apply("out1");
            this.out2 = Outlet$.MODULE$.apply("out2");
            this.shape = BidiShape$.MODULE$.apply(this.in1(), this.out1(), this.in2(), this.out2());
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        public Inlet<I> in1() {
            return this.in1;
        }

        public Inlet<O> in2() {
            return this.in2;
        }

        public Outlet<I> out1() {
            return this.out1;
        }

        public Outlet<O> out2() {
            return this.out2;
        }

        @Override
        public BidiShape<I, I, O, O> shape() {
            return this.shape;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.idleTimeoutBidi();
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new TimerGraphStageLogic(this){
                private long nextDeadline;
                private final /* synthetic */ IdleTimeoutBidi $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.nextDeadline = System.nanoTime() + $outer.timeout().toNanos();
                    this.setHandlers($outer.in1(), $outer.out1(), new IdleTimeoutBidi$$anon$5$IdleBidiHandler<P>(this, $outer.in1(), $outer.out1()));
                    this.setHandlers($outer.in2(), $outer.out2(), new IdleTimeoutBidi$$anon$5$IdleBidiHandler<P>(this, $outer.in2(), $outer.out2()));
                }

                public void org$apache$pekko$stream$impl$Timers$IdleTimeoutBidi$$anon$5$$onActivity() {
                    this.nextDeadline = System.nanoTime() + this.$outer.timeout().toNanos();
                }

                public final void onTimer(Object key) {
                    if (this.nextDeadline - System.nanoTime() < 0L) {
                        this.failStage(new TimeoutException(new StringBuilder(32).append("No elements passed in the last ").append(this.$outer.timeout()).append(".").toString()));
                        return;
                    }
                }

                public void preStart() {
                    this.scheduleWithFixedDelay((Object)Timers$GraphStageLogicTimer$.MODULE$, Timers$.MODULE$.timeoutCheckInterval(this.$outer.timeout()), Timers$.MODULE$.timeoutCheckInterval(this.$outer.timeout()));
                }

                public void protected$push(Outlet out, Object elem) {
                    this.push(out, elem);
                }

                public Object protected$grab(Inlet in) {
                    return this.grab(in);
                }

                public void protected$pull(Inlet in) {
                    this.pull(in);
                }

                public void protected$complete(Outlet out) {
                    this.complete(out);
                }

                public void protected$cancel(Inlet in, Throwable cause) {
                    this.cancel(in, cause);
                }
            };
        }

        public String toString() {
            return "IdleTimeoutBidi";
        }
    }

    public static final class Initial<T>
    extends GraphStages.SimpleLinearGraphStage<T> {
        private final FiniteDuration timeout;

        public Initial(FiniteDuration timeout) {
            this.timeout = timeout;
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.initial();
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private boolean initialHasPassed;
                private final /* synthetic */ Initial $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.initialHasPassed = false;
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    this.initialHasPassed = true;
                    this.push(this.$outer.out(), this.grab(this.$outer.in()));
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public final void onTimer(Object key) {
                    if (!this.initialHasPassed) {
                        this.failStage(new TimeoutException(new StringBuilder(49).append("The first element has not yet passed through in ").append(this.$outer.timeout()).append(".").toString()));
                        return;
                    }
                }

                public void preStart() {
                    this.scheduleOnce((Object)Timers$GraphStageLogicTimer$.MODULE$, this.$outer.timeout());
                }
            };
        }

        public String toString() {
            return "InitialTimeoutTimer";
        }
    }
}

