/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.impl.Buffer;
import org.apache.pekko.stream.impl.Buffer$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.TraversalBuilder$;
import org.apache.pekko.stream.impl.fusing.FlattenMerge$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class FlattenMerge<T, M>
extends GraphStage<FlowShape<Graph<SourceShape<T>, M>, T>> {
    private final int breadth;
    public final Inlet<Graph<SourceShape<T>, M>> org$apache$pekko$stream$impl$fusing$FlattenMerge$$in;
    public final Outlet<T> org$apache$pekko$stream$impl$fusing$FlattenMerge$$out;
    private final FlowShape shape;

    public FlattenMerge(int breadth) {
        this.breadth = breadth;
        this.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in = Inlet$.MODULE$.apply("flatten.in");
        this.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out = Outlet$.MODULE$.apply("flatten.out");
        this.shape = FlowShape$.MODULE$.apply(this.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in, this.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out);
    }

    public int breadth() {
        return this.breadth;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.flattenMerge();
    }

    @Override
    public FlowShape<Graph<SourceShape<T>, M>, T> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes enclosingAttributes) {
        return new OutHandler(enclosingAttributes, this){
            private final Attributes enclosingAttributes$1;
            private Set sources;
            private int pendingSingleSources;
            private Buffer queue;
            private final /* synthetic */ FlattenMerge $outer;
            {
                this.enclosingAttributes$1 = enclosingAttributes$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.sources = Predef$.MODULE$.Set().empty();
                this.pendingSingleSources = 0;
                this.setHandlers($outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in, $outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out, this);
            }

            public Set sources() {
                return this.sources;
            }

            public void sources_$eq(Set x$1) {
                this.sources = x$1;
            }

            public int pendingSingleSources() {
                return this.pendingSingleSources;
            }

            public void pendingSingleSources_$eq(int x$1) {
                this.pendingSingleSources = x$1;
            }

            public int activeSources() {
                return this.sources().size() + this.pendingSingleSources();
            }

            public Buffer queue() {
                return this.queue;
            }

            public void queue_$eq(Buffer x$1) {
                this.queue = x$1;
            }

            public void preStart() {
                this.queue_$eq(Buffer$.MODULE$.apply(this.$outer.breadth(), this.enclosingAttributes$1));
            }

            public void pushOut() {
                T t = this.queue().dequeue();
                if (t instanceof GraphStageLogic.SubSinkInlet && ((GraphStageLogic.SubSinkInlet)t).org$apache$pekko$stream$stage$GraphStageLogic$SubSinkInlet$$$outer() == this) {
                    GraphStageLogic.SubSinkInlet src = (GraphStageLogic.SubSinkInlet)t;
                    this.push(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out, src.grab());
                    if (!src.isClosed()) {
                        src.pull();
                        return;
                    }
                    this.removeSource(src);
                    return;
                }
                if (t instanceof GraphStages.SingleSource) {
                    GraphStages.SingleSource single = (GraphStages.SingleSource)t;
                    this.push(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out, single.elem());
                    this.removeSource(single);
                    return;
                }
                T other = t;
                throw new IllegalStateException(new StringBuilder(35).append("Unexpected source type in queue: '").append(other.getClass()).append("'").toString());
            }

            public void onPush() {
                Graph<SourceShape<T>, M> source = this.grab(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in);
                this.addSource(source);
                if (this.activeSources() < this.$outer.breadth()) {
                    this.tryPull(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in);
                    return;
                }
            }

            public void onUpstreamFinish() {
                if (this.activeSources() == 0) {
                    this.completeStage();
                    return;
                }
            }

            public void onPull() {
                this.pull(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in);
                this.setHandler(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out, new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        if (this.$outer.queue().nonEmpty() && this.$outer.isAvailable(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$_$$anon$$$outer().org$apache$pekko$stream$impl$fusing$FlattenMerge$$out)) {
                            this.$outer.pushOut();
                            return;
                        }
                    }
                });
            }

            public void addSource(Graph source) {
                GraphStages.SingleSource singleSource = TraversalBuilder$.MODULE$.getSingleSource(source);
                GraphStages.SingleSource singleSource2 = (GraphStages.SingleSource)OptionVal.Some$.MODULE$.unapply((Object)singleSource);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)singleSource2)) {
                    GraphStages.SingleSource singleSource3;
                    GraphStages.SingleSource single = singleSource3 = (GraphStages.SingleSource)OptionVal$.MODULE$.get$extension((Object)singleSource2);
                    if (this.isAvailable(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out) && this.queue().isEmpty()) {
                        this.push(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$out, single.elem());
                        return;
                    }
                    this.queue().enqueue(single);
                    this.pendingSingleSources_$eq(this.pendingSingleSources() + 1);
                    return;
                }
                GraphStageLogic.SubSinkInlet<T> sinkIn = new GraphStageLogic.SubSinkInlet<T>(this, "FlattenMergeSink");
                sinkIn.setHandler(new InHandler(sinkIn, this){
                    private final GraphStageLogic.SubSinkInlet sinkIn$1;
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        this.sinkIn$1 = sinkIn$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        if (this.$outer.isAvailable(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$_$$anon$$$outer().org$apache$pekko$stream$impl$fusing$FlattenMerge$$out)) {
                            this.$outer.protected$push(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$_$$anon$$$outer().org$apache$pekko$stream$impl$fusing$FlattenMerge$$out, this.sinkIn$1.grab());
                            this.sinkIn$1.pull();
                            return;
                        }
                        this.$outer.queue().enqueue(this.sinkIn$1);
                    }

                    public void onUpstreamFinish() {
                        if (!this.sinkIn$1.isAvailable()) {
                            this.$outer.removeSource(this.sinkIn$1);
                            return;
                        }
                    }
                });
                sinkIn.pull();
                this.sources_$eq((Set)this.sources().$plus(sinkIn));
                Object graph = Source$.MODULE$.fromGraph(source).to(sinkIn.sink());
                this.interpreter().subFusingMaterializer().materialize(graph, this.enclosingAttributes$1);
            }

            public void removeSource(Object src) {
                boolean pullSuppressed = this.activeSources() == this.$outer.breadth();
                Object object = src;
                if (object instanceof GraphStageLogic.SubSinkInlet && ((GraphStageLogic.SubSinkInlet)object).org$apache$pekko$stream$stage$GraphStageLogic$SubSinkInlet$$$outer() == this) {
                    GraphStageLogic.SubSinkInlet sub = (GraphStageLogic.SubSinkInlet)object;
                    this.sources_$eq((Set)this.sources().$minus((Object)sub));
                } else if (object instanceof GraphStages.SingleSource) {
                    this.pendingSingleSources_$eq(this.pendingSingleSources() - 1);
                } else {
                    Object other = object;
                    throw new IllegalArgumentException(new StringBuilder(26).append("Unexpected source type: '").append(other.getClass()).append("'").toString());
                }
                if (pullSuppressed) {
                    this.tryPull(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in);
                }
                if (this.activeSources() == 0 && this.isClosed(this.$outer.org$apache$pekko$stream$impl$fusing$FlattenMerge$$in)) {
                    this.completeStage();
                    return;
                }
            }

            public void postStop() {
                this.sources().foreach((Function1)((JProcedure1 & Serializable)FlattenMerge::org$apache$pekko$stream$impl$fusing$FlattenMerge$$anon$1$$_$postStop$$anonfun$1));
            }

            public void protected$push(Outlet out, Object elem) {
                this.push(out, elem);
            }

            public final /* synthetic */ FlattenMerge org$apache$pekko$stream$impl$fusing$FlattenMerge$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$stream$impl$fusing$FlattenMerge$$anon$1$$_$postStop$$anonfun$1(org.apache.pekko.stream.stage.GraphStageLogic$SubSinkInlet )}, serializedLambda);
            }
        };
    }

    public String toString() {
        return new StringBuilder(14).append("FlattenMerge(").append(this.breadth()).append(")").toString();
    }

    public static final /* synthetic */ void org$apache$pekko$stream$impl$fusing$FlattenMerge$$anon$1$$_$postStop$$anonfun$1(GraphStageLogic.SubSinkInlet _$2) {
        _$2.cancel();
    }
}

