/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.io.IO$;
import org.apache.pekko.io.Inet;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.IgnoreComplete$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.TLSClosing;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.TLSRole$;
import org.apache.pekko.stream.impl.fusing.GraphStages$;
import org.apache.pekko.stream.impl.io.ConnectionSourceStage;
import org.apache.pekko.stream.impl.io.OutgoingConnectionStage;
import org.apache.pekko.stream.impl.io.TcpIdleTimeout$;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.FlowOps;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.RunnableGraph;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.TLS$;
import org.apache.pekko.stream.scaladsl.Tcp$;
import org.apache.pekko.stream.scaladsl.Tcp$IncomingConnection$;
import org.apache.pekko.stream.scaladsl.Tcp$OutgoingConnection$;
import org.apache.pekko.stream.scaladsl.Tcp$ServerBinding$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Success$;
import scala.util.Try;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Tcp
implements Extension {
    private final ExtendedActorSystem system;
    private final FiniteDuration bindShutdownTimeout;

    public static Extension apply(ActorSystem actorSystem) {
        return Tcp$.MODULE$.apply(actorSystem);
    }

    public static Tcp apply(ActorSystem actorSystem) {
        return Tcp$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Tcp$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Tcp createExtension(ExtendedActorSystem extendedActorSystem) {
        return Tcp$.MODULE$.createExtension(extendedActorSystem);
    }

    public static int defaultBacklog() {
        return Tcp$.MODULE$.defaultBacklog();
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return Tcp$.MODULE$.get(actorSystem);
    }

    public static Tcp get(ActorSystem actorSystem) {
        return Tcp$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Tcp$.MODULE$.get(classicActorSystemProvider);
    }

    public static Tcp get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Tcp$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return Tcp$.MODULE$.lookup();
    }

    public Tcp(ExtendedActorSystem system) {
        this.system = system;
        this.bindShutdownTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(system.settings().config().getDuration("pekko.stream.materializer.subscription-timeout.timeout")));
    }

    public FiniteDuration bindShutdownTimeout() {
        return this.bindShutdownTimeout;
    }

    public Source<IncomingConnection, Future<ServerBinding>> bind(String string, int port, int backlog, Iterable<Inet.SocketOption> options, boolean halfClose, Duration idleTimeout) {
        return Source$.MODULE$.fromGraph(new ConnectionSourceStage(IO$.MODULE$.apply((ExtensionId)org.apache.pekko.io.Tcp$.MODULE$, (ActorSystem)this.system), new InetSocketAddress(string, port), backlog, (Iterable<Inet.SocketOption>)options.toList(), halfClose, idleTimeout, this.bindShutdownTimeout()));
    }

    public int bind$default$3() {
        return Tcp$.MODULE$.defaultBacklog();
    }

    public Iterable<Inet.SocketOption> bind$default$4() {
        return package$.MODULE$.Nil();
    }

    public boolean bind$default$5() {
        return false;
    }

    public Duration bind$default$6() {
        return Duration$.MODULE$.Inf();
    }

    public Future<ServerBinding> bindAndHandle(Flow<ByteString, ByteString, ?> handler, String string, int port, int backlog, Iterable<Inet.SocketOption> options, boolean halfClose, Duration idleTimeout, Materializer m) {
        return (Future)((RunnableGraph)this.bind(string, port, backlog, options, halfClose, idleTimeout).to((Graph)Sink$.MODULE$.foreach((JProcedure1 & Serializable)conn -> conn.flow().join(handler).run(m)))).run(m);
    }

    public int bindAndHandle$default$4() {
        return Tcp$.MODULE$.defaultBacklog();
    }

    public Iterable<Inet.SocketOption> bindAndHandle$default$5() {
        return package$.MODULE$.Nil();
    }

    public boolean bindAndHandle$default$6() {
        return false;
    }

    public Duration bindAndHandle$default$7() {
        return Duration$.MODULE$.Inf();
    }

    public Flow<ByteString, ByteString, Future<OutgoingConnection>> outgoingConnection(InetSocketAddress remoteAddress, Option<InetSocketAddress> localAddress, Iterable<Inet.SocketOption> options, boolean halfClose, Duration connectTimeout, Duration idleTimeout) {
        FlowOps tcpFlow = Flow$.MODULE$.fromGraph(new OutgoingConnectionStage(IO$.MODULE$.apply((ExtensionId)org.apache.pekko.io.Tcp$.MODULE$, (ActorSystem)this.system), remoteAddress, localAddress, (Iterable<Inet.SocketOption>)options.toList(), halfClose, connectTimeout)).via((Graph)GraphStages$.MODULE$.detacher());
        Duration duration = idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            return ((Flow)tcpFlow).join(TcpIdleTimeout$.MODULE$.apply(d, (Option<InetSocketAddress>)Some$.MODULE$.apply((Object)remoteAddress)));
        }
        return tcpFlow;
    }

    public Option<InetSocketAddress> outgoingConnection$default$2() {
        return None$.MODULE$;
    }

    public Iterable<Inet.SocketOption> outgoingConnection$default$3() {
        return package$.MODULE$.Nil();
    }

    public boolean outgoingConnection$default$4() {
        return true;
    }

    public Duration outgoingConnection$default$5() {
        return Duration$.MODULE$.Inf();
    }

    public Duration outgoingConnection$default$6() {
        return Duration$.MODULE$.Inf();
    }

    public Flow<ByteString, ByteString, Future<OutgoingConnection>> outgoingConnection(String host, int port) {
        return this.outgoingConnection(InetSocketAddress.createUnresolved(host, port), this.outgoingConnection$default$2(), this.outgoingConnection$default$3(), this.outgoingConnection$default$4(), this.outgoingConnection$default$5(), this.outgoingConnection$default$6());
    }

    public Flow<ByteString, ByteString, Future<OutgoingConnection>> outgoingTlsConnection(String host, int port, SSLContext sslContext, TLSProtocol.NegotiateNewSession negotiateNewSession) {
        return this.outgoingTlsConnection(InetSocketAddress.createUnresolved(host, port), sslContext, negotiateNewSession, this.outgoingTlsConnection$default$4(), this.outgoingTlsConnection$default$5(), this.outgoingTlsConnection$default$6(), this.outgoingTlsConnection$default$7());
    }

    public Flow<ByteString, ByteString, Future<OutgoingConnection>> outgoingTlsConnection(InetSocketAddress remoteAddress, SSLContext sslContext, TLSProtocol.NegotiateNewSession negotiateNewSession, Option<InetSocketAddress> localAddress, Iterable<Inet.SocketOption> options, Duration connectTimeout, Duration idleTimeout) {
        Flow<ByteString, ByteString, Future<OutgoingConnection>> connection = this.outgoingConnection(remoteAddress, localAddress, options, true, connectTimeout, idleTimeout);
        BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> tls = TLS$.MODULE$.apply(sslContext, negotiateNewSession, TLSRole$.MODULE$.client());
        return connection.join(Tcp$.org$apache$pekko$stream$scaladsl$Tcp$$$tlsWrapping.atop(tls).reversed());
    }

    public Option<InetSocketAddress> outgoingTlsConnection$default$4() {
        return None$.MODULE$;
    }

    public Iterable<Inet.SocketOption> outgoingTlsConnection$default$5() {
        return package$.MODULE$.Nil();
    }

    public Duration outgoingTlsConnection$default$6() {
        return Duration$.MODULE$.Inf();
    }

    public Duration outgoingTlsConnection$default$7() {
        return Duration$.MODULE$.Inf();
    }

    public Flow<ByteString, ByteString, Future<OutgoingConnection>> outgoingConnectionWithTls(InetSocketAddress remoteAddress, Function0<SSLEngine> createSSLEngine) {
        return this.outgoingConnectionWithTls(remoteAddress, createSSLEngine, (Option<InetSocketAddress>)None$.MODULE$, (Seq<Inet.SocketOption>)package$.MODULE$.Nil(), (Duration)Duration$.MODULE$.Inf(), (Duration)Duration$.MODULE$.Inf(), (Function1<SSLSession, Try<BoxedUnit>>)(Function1 & Serializable)_$1 -> Success$.MODULE$.apply((Object)BoxedUnit.UNIT), IgnoreComplete$.MODULE$);
    }

    public Flow<ByteString, ByteString, Future<OutgoingConnection>> outgoingConnectionWithTls(InetSocketAddress remoteAddress, Function0<SSLEngine> createSSLEngine, Option<InetSocketAddress> localAddress, Seq<Inet.SocketOption> options, Duration connectTimeout, Duration idleTimeout, Function1<SSLSession, Try<BoxedUnit>> verifySession, TLSClosing closing) {
        Flow<ByteString, ByteString, Future<OutgoingConnection>> connection = this.outgoingConnection(remoteAddress, localAddress, (Iterable<Inet.SocketOption>)options, true, connectTimeout, idleTimeout);
        BidiFlow<TLSProtocol.SslTlsOutbound, ByteString, ByteString, TLSProtocol.SslTlsInbound, NotUsed> tls = TLS$.MODULE$.apply(createSSLEngine, verifySession, closing);
        return connection.join(Tcp$.org$apache$pekko$stream$scaladsl$Tcp$$$tlsWrapping.atop(tls).reversed());
    }

    public Source<IncomingConnection, Future<ServerBinding>> bindTls(String string, int port, SSLContext sslContext, TLSProtocol.NegotiateNewSession negotiateNewSession, int backlog, Iterable<Inet.SocketOption> options, Duration idleTimeout) {
        BidiFlow tls = Tcp$.org$apache$pekko$stream$scaladsl$Tcp$$$tlsWrapping.atop(TLS$.MODULE$.apply(sslContext, negotiateNewSession, TLSRole$.MODULE$.server())).reversed();
        return (Source)this.bind(string, port, backlog, options, false, idleTimeout).map((Function1 & Serializable)incomingConnection -> {
            Flow<ByteString, ByteString, NotUsed> flow = incomingConnection.flow().join(tls);
            InetSocketAddress inetSocketAddress = incomingConnection.copy$default$1();
            InetSocketAddress inetSocketAddress2 = incomingConnection.copy$default$2();
            return incomingConnection.copy(inetSocketAddress, inetSocketAddress2, flow);
        });
    }

    public int bindTls$default$5() {
        return Tcp$.MODULE$.defaultBacklog();
    }

    public Iterable<Inet.SocketOption> bindTls$default$6() {
        return package$.MODULE$.Nil();
    }

    public Duration bindTls$default$7() {
        return Duration$.MODULE$.Inf();
    }

    public Source<IncomingConnection, Future<ServerBinding>> bindWithTls(String string, int port, Function0<SSLEngine> createSSLEngine) {
        return this.bindWithTls(string, port, createSSLEngine, Tcp$.MODULE$.defaultBacklog(), (Seq<Inet.SocketOption>)package$.MODULE$.Nil(), (Duration)Duration$.MODULE$.Inf(), (Function1<SSLSession, Try<BoxedUnit>>)(Function1 & Serializable)_$2 -> Success$.MODULE$.apply((Object)BoxedUnit.UNIT), IgnoreComplete$.MODULE$);
    }

    public Source<IncomingConnection, Future<ServerBinding>> bindWithTls(String string, int port, Function0<SSLEngine> createSSLEngine, int backlog, Seq<Inet.SocketOption> options, Duration idleTimeout, Function1<SSLSession, Try<BoxedUnit>> verifySession, TLSClosing closing) {
        BidiFlow tls = Tcp$.org$apache$pekko$stream$scaladsl$Tcp$$$tlsWrapping.atop(TLS$.MODULE$.apply(createSSLEngine, verifySession, closing)).reversed();
        return (Source)this.bind(string, port, backlog, (Iterable<Inet.SocketOption>)options, true, idleTimeout).map((Function1 & Serializable)incomingConnection -> {
            Flow<ByteString, ByteString, NotUsed> flow = incomingConnection.flow().join(tls);
            InetSocketAddress inetSocketAddress = incomingConnection.copy$default$1();
            InetSocketAddress inetSocketAddress2 = incomingConnection.copy$default$2();
            return incomingConnection.copy(inetSocketAddress, inetSocketAddress2, flow);
        });
    }

    public Future<ServerBinding> bindAndHandleWithTls(Flow<ByteString, ByteString, ?> handler, String string, int port, Function0<SSLEngine> createSSLEngine, Materializer m) {
        return this.bindAndHandleWithTls(handler, string, port, createSSLEngine, Tcp$.MODULE$.defaultBacklog(), (Seq<Inet.SocketOption>)package$.MODULE$.Nil(), (Duration)Duration$.MODULE$.Inf(), (Function1<SSLSession, Try<BoxedUnit>>)(Function1 & Serializable)_$3 -> Success$.MODULE$.apply((Object)BoxedUnit.UNIT), IgnoreComplete$.MODULE$, m);
    }

    public Future<ServerBinding> bindAndHandleWithTls(Flow<ByteString, ByteString, ?> handler, String string, int port, Function0<SSLEngine> createSSLEngine, int backlog, Seq<Inet.SocketOption> options, Duration idleTimeout, Function1<SSLSession, Try<BoxedUnit>> verifySession, TLSClosing closing, Materializer m) {
        return (Future)((RunnableGraph)this.bindWithTls(string, port, createSSLEngine, backlog, options, idleTimeout, verifySession, closing).to((Graph)Sink$.MODULE$.foreach((JProcedure1 & Serializable)conn -> conn.handleWith(handler, m)))).run(m);
    }

    public Future<ServerBinding> bindAndHandleTls(Flow<ByteString, ByteString, ?> handler, String string, int port, SSLContext sslContext, TLSProtocol.NegotiateNewSession negotiateNewSession, int backlog, Iterable<Inet.SocketOption> options, Duration idleTimeout, Materializer m) {
        return (Future)((RunnableGraph)this.bindTls(string, port, sslContext, negotiateNewSession, backlog, options, idleTimeout).to((Graph)Sink$.MODULE$.foreach((JProcedure1 & Serializable)conn -> conn.handleWith(handler, m)))).run(m);
    }

    public int bindAndHandleTls$default$6() {
        return Tcp$.MODULE$.defaultBacklog();
    }

    public Iterable<Inet.SocketOption> bindAndHandleTls$default$7() {
        return package$.MODULE$.Nil();
    }

    public Duration bindAndHandleTls$default$8() {
        return Duration$.MODULE$.Inf();
    }

    public static final class IncomingConnection
    implements Product,
    Serializable {
        private final InetSocketAddress localAddress;
        private final InetSocketAddress remoteAddress;
        private final Flow flow;

        public static IncomingConnection apply(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, Flow<ByteString, ByteString, NotUsed> flow) {
            return Tcp$IncomingConnection$.MODULE$.apply(inetSocketAddress, inetSocketAddress2, flow);
        }

        public static IncomingConnection fromProduct(Product product) {
            return Tcp$IncomingConnection$.MODULE$.fromProduct(product);
        }

        public static IncomingConnection unapply(IncomingConnection incomingConnection) {
            return Tcp$IncomingConnection$.MODULE$.unapply(incomingConnection);
        }

        public IncomingConnection(InetSocketAddress localAddress, InetSocketAddress remoteAddress, Flow<ByteString, ByteString, NotUsed> flow) {
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
            this.flow = flow;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IncomingConnection)) return false;
            IncomingConnection incomingConnection = (IncomingConnection)object;
            InetSocketAddress inetSocketAddress = this.localAddress();
            InetSocketAddress inetSocketAddress2 = incomingConnection.localAddress();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            InetSocketAddress inetSocketAddress3 = this.remoteAddress();
            InetSocketAddress inetSocketAddress4 = incomingConnection.remoteAddress();
            if (inetSocketAddress3 == null) {
                if (inetSocketAddress4 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress3).equals(inetSocketAddress4)) return false;
            Flow<ByteString, ByteString, NotUsed> flow = this.flow();
            Flow<ByteString, ByteString, NotUsed> flow2 = incomingConnection.flow();
            if (flow == null) {
                if (flow2 == null) return true;
                return false;
            } else {
                if (!flow.equals(flow2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IncomingConnection;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "IncomingConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "localAddress";
                }
                case 1: {
                    return "remoteAddress";
                }
                case 2: {
                    return "flow";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        public InetSocketAddress remoteAddress() {
            return this.remoteAddress;
        }

        public Flow<ByteString, ByteString, NotUsed> flow() {
            return this.flow;
        }

        public <Mat> Mat handleWith(Flow<ByteString, ByteString, Mat> handler, Materializer materializer) {
            return (Mat)this.flow().joinMat(handler, Keep$.MODULE$.right()).run(materializer);
        }

        public IncomingConnection copy(InetSocketAddress localAddress, InetSocketAddress remoteAddress, Flow<ByteString, ByteString, NotUsed> flow) {
            return new IncomingConnection(localAddress, remoteAddress, flow);
        }

        public InetSocketAddress copy$default$1() {
            return this.localAddress();
        }

        public InetSocketAddress copy$default$2() {
            return this.remoteAddress();
        }

        public Flow<ByteString, ByteString, NotUsed> copy$default$3() {
            return this.flow();
        }

        public InetSocketAddress _1() {
            return this.localAddress();
        }

        public InetSocketAddress _2() {
            return this.remoteAddress();
        }

        public Flow<ByteString, ByteString, NotUsed> _3() {
            return this.flow();
        }
    }

    public static final class OutgoingConnection
    implements Product,
    Serializable {
        private final InetSocketAddress remoteAddress;
        private final InetSocketAddress localAddress;

        public static OutgoingConnection apply(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            return Tcp$OutgoingConnection$.MODULE$.apply(inetSocketAddress, inetSocketAddress2);
        }

        public static OutgoingConnection fromProduct(Product product) {
            return Tcp$OutgoingConnection$.MODULE$.fromProduct(product);
        }

        public static OutgoingConnection unapply(OutgoingConnection outgoingConnection) {
            return Tcp$OutgoingConnection$.MODULE$.unapply(outgoingConnection);
        }

        public OutgoingConnection(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OutgoingConnection)) return false;
            OutgoingConnection outgoingConnection = (OutgoingConnection)object;
            InetSocketAddress inetSocketAddress = this.remoteAddress();
            InetSocketAddress inetSocketAddress2 = outgoingConnection.remoteAddress();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            InetSocketAddress inetSocketAddress3 = this.localAddress();
            InetSocketAddress inetSocketAddress4 = outgoingConnection.localAddress();
            if (inetSocketAddress3 == null) {
                if (inetSocketAddress4 == null) return true;
                return false;
            } else {
                if (!((Object)inetSocketAddress3).equals(inetSocketAddress4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OutgoingConnection;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OutgoingConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "remoteAddress";
            }
            if (1 == n2) {
                return "localAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetSocketAddress remoteAddress() {
            return this.remoteAddress;
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        public OutgoingConnection copy(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
            return new OutgoingConnection(remoteAddress, localAddress);
        }

        public InetSocketAddress copy$default$1() {
            return this.remoteAddress();
        }

        public InetSocketAddress copy$default$2() {
            return this.localAddress();
        }

        public InetSocketAddress _1() {
            return this.remoteAddress();
        }

        public InetSocketAddress _2() {
            return this.localAddress();
        }
    }

    public static final class ServerBinding
    implements Product,
    Serializable {
        private final InetSocketAddress localAddress;
        private final Function0 unbindAction;
        private final Future whenUnbound;

        public static ServerBinding apply(InetSocketAddress inetSocketAddress, Function0<Future<BoxedUnit>> function0, Future<Done> future) {
            return Tcp$ServerBinding$.MODULE$.apply(inetSocketAddress, function0, future);
        }

        public static ServerBinding unapply(ServerBinding serverBinding) {
            return Tcp$ServerBinding$.MODULE$.unapply(serverBinding);
        }

        @InternalApi
        public ServerBinding(InetSocketAddress localAddress, Function0<Future<BoxedUnit>> unbindAction, Future<Done> whenUnbound) {
            this.localAddress = localAddress;
            this.unbindAction = unbindAction;
            this.whenUnbound = whenUnbound;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ServerBinding)) return false;
            ServerBinding serverBinding = (ServerBinding)object;
            InetSocketAddress inetSocketAddress = this.localAddress();
            InetSocketAddress inetSocketAddress2 = serverBinding.localAddress();
            if (inetSocketAddress != null) {
                if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
                return true;
            }
            if (inetSocketAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ServerBinding;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ServerBinding";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        private Function0<Future<BoxedUnit>> unbindAction() {
            return this.unbindAction;
        }

        public Future<Done> whenUnbound() {
            return this.whenUnbound;
        }

        public Future<BoxedUnit> unbind() {
            return (Future)this.unbindAction().apply();
        }

        public ServerBinding copy(InetSocketAddress localAddress, Function0<Future<BoxedUnit>> unbindAction, Future<Done> whenUnbound) {
            return new ServerBinding(localAddress, unbindAction, whenUnbound);
        }

        public InetSocketAddress copy$default$1() {
            return this.localAddress();
        }

        public InetSocketAddress _1() {
            return this.localAddress();
        }
    }
}

