/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.ResizableMultiReaderRingBuffer$NothingToReadException$;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.math.package$;

@InternalApi
public class ResizableMultiReaderRingBuffer<T> {
    private final Cursors cursors;
    private final int maxSizeBit;
    private Object[] array;
    private int writeIx;
    private int readIx;

    public ResizableMultiReaderRingBuffer(int initialSize, int maxSize, Cursors cursors) {
        this.cursors = cursors;
        Predef$.MODULE$.require(Integer.lowestOneBit(maxSize) == maxSize && 0 < maxSize && maxSize <= 0x3FFFFFFF, ResizableMultiReaderRingBuffer::$init$$$anonfun$1);
        Predef$.MODULE$.require(Integer.lowestOneBit(initialSize) == initialSize && 0 < initialSize && initialSize <= maxSize, ResizableMultiReaderRingBuffer::$init$$$anonfun$2);
        this.maxSizeBit = Integer.numberOfTrailingZeros(maxSize);
        this.array = new Object[initialSize];
        this.writeIx = 0;
        this.readIx = 0;
    }

    public Cursors cursors() {
        return this.cursors;
    }

    private int lenBit() {
        return Integer.numberOfTrailingZeros(this.array.length);
    }

    private int mask() {
        return Integer.MAX_VALUE >> 31 - this.lenBit();
    }

    public int size() {
        return this.writeIx - this.readIx;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int immediatelyAvailable() {
        return this.array.length - this.size();
    }

    public int maxAvailable() {
        return (1 << this.maxSizeBit) - this.size();
    }

    public int count(Cursor cursor) {
        return this.writeIx - cursor.cursor();
    }

    public void initCursor(Cursor cursor) {
        cursor.cursor_$eq(this.readIx);
    }

    public boolean write(T value) {
        if (this.size() < this.array.length) {
            this.array[this.writeIx & this.mask()] = value;
            ++this.writeIx;
            return true;
        }
        if (this.lenBit() < this.maxSizeBit) {
            int r = this.readIx & this.mask();
            Object[] newArray = new Object[this.array.length << 1];
            System.arraycopy(this.array, r, newArray, 0, this.array.length - r);
            System.arraycopy(this.array, 0, newArray, this.array.length - r, r);
            this.rebaseCursors$1(this.cursors().cursors());
            this.array = newArray;
            int w = this.size();
            this.array[w & this.mask()] = value;
            this.writeIx = w + 1;
            this.readIx = 0;
            return true;
        }
        return false;
    }

    public T read(Cursor cursor) {
        int c = cursor.cursor();
        if (c - this.writeIx < 0) {
            cursor.cursor_$eq(cursor.cursor() + 1);
            Object ret = this.array[c & this.mask()];
            if (c == this.readIx) {
                this.updateReadIx();
            }
            return (T)ret;
        }
        throw ResizableMultiReaderRingBuffer$NothingToReadException$.MODULE$;
    }

    public void onCursorRemoved(Cursor cursor) {
        if (cursor.cursor() == this.readIx) {
            this.updateReadIx();
            return;
        }
    }

    private void updateReadIx() {
        int newReadIx = this.writeIx + this.minCursor$1(this.cursors().cursors(), 0);
        while (this.readIx != newReadIx) {
            this.array[this.readIx & this.mask()] = null;
            ++this.readIx;
        }
    }

    public Object[] underlyingArray() {
        return this.array;
    }

    public String toString() {
        return new StringBuilder(66).append("ResizableMultiReaderRingBuffer(size=").append(this.size()).append(", writeIx=").append(this.writeIx).append(", readIx=").append(this.readIx).append(", cursors=").append(this.cursors().cursors().size()).append(")").toString();
    }

    private static final Object $init$$$anonfun$1() {
        return "maxSize must be a power of 2 that is > 0 and < Int.MaxValue/2";
    }

    private static final Object $init$$$anonfun$2() {
        return "initialSize must be a power of 2 that is > 0 and <= maxSize";
    }

    private final void rebaseCursors$1(List remaining) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            Cursor head = (Cursor)colon2.head();
            List tail = list2;
            head.cursor_$eq(head.cursor() - this.readIx);
            remaining = tail;
        }
    }

    private final int minCursor$1(List remaining, int result) {
        List list;
        while ((list = remaining) instanceof .colon.colon) {
            List tail;
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            Cursor head = (Cursor)colon2.head();
            List list3 = tail = list2;
            int n = package$.MODULE$.min(head.cursor() - this.writeIx, result);
            remaining = list3;
            result = n;
        }
        return result;
    }

    public static interface Cursor {
        public int cursor();

        public void cursor_$eq(int var1);
    }

    public static interface Cursors {
        public List<Cursor> cursors();
    }
}

