/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BufferOverflowException$;
import org.apache.pekko.stream.OverflowStrategies;
import org.apache.pekko.stream.OverflowStrategy;
import org.apache.pekko.stream.impl.Buffer$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.StageLogging;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class Buffer<T>
extends GraphStages.SimpleLinearGraphStage<T>
implements Product,
Serializable {
    private final int size;
    private final OverflowStrategy overflowStrategy;

    public static <T> Buffer<T> apply(int n, OverflowStrategy overflowStrategy) {
        return org.apache.pekko.stream.impl.fusing.Buffer$.MODULE$.apply(n, overflowStrategy);
    }

    public static Buffer<?> fromProduct(Product product) {
        return org.apache.pekko.stream.impl.fusing.Buffer$.MODULE$.fromProduct(product);
    }

    public static <T> Buffer<T> unapply(Buffer<T> buffer) {
        return org.apache.pekko.stream.impl.fusing.Buffer$.MODULE$.unapply(buffer);
    }

    public Buffer(int size, OverflowStrategy overflowStrategy) {
        this.size = size;
        this.overflowStrategy = overflowStrategy;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.size());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.overflowStrategy()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Buffer)) return false;
        Buffer buffer = (Buffer)object;
        if (this.size() != buffer.size()) return false;
        OverflowStrategy overflowStrategy = this.overflowStrategy();
        OverflowStrategy overflowStrategy2 = buffer.overflowStrategy();
        if (overflowStrategy != null) {
            if (!overflowStrategy.equals(overflowStrategy2)) return false;
            return true;
        }
        if (overflowStrategy2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Buffer;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Buffer";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToInteger((int)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "size";
        }
        if (1 == n2) {
            return "overflowStrategy";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int size() {
        return this.size;
    }

    public OverflowStrategy overflowStrategy() {
        return this.overflowStrategy;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(inheritedAttributes, this){
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final org.apache.pekko.stream.impl.Buffer buffer;
            private final String name;
            private final Function1 enqueueAction;
            private final /* synthetic */ Buffer $outer;
            {
                JProcedure1 & Serializable intersect;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$(this);
                this.buffer = Buffer$.MODULE$.apply($outer.size(), inheritedAttributes$11);
                this.name = inheritedAttributes$11.nameOrDefault(this.getClass().toString());
                OverflowStrategy overflowStrategy = $outer.overflowStrategy();
                if (overflowStrategy instanceof OverflowStrategies.DropHead) {
                    OverflowStrategies.DropHead s = (OverflowStrategies.DropHead)overflowStrategy;
                    intersect = (JProcedure1 & Serializable)elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s.logLevel(), "Dropping the head element because buffer is full and overflowStrategy is: [DropHead] in stream [{}]", (Object)this.name);
                            this.buffer.dropHead();
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.DropTail) {
                    OverflowStrategies.DropTail s = (OverflowStrategies.DropTail)overflowStrategy;
                    intersect = (JProcedure1 & Serializable)elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s.logLevel(), "Dropping the tail element because buffer is full and overflowStrategy is: [DropTail] in stream [{}]", (Object)this.name);
                            this.buffer.dropTail();
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.DropBuffer) {
                    OverflowStrategies.DropBuffer s = (OverflowStrategies.DropBuffer)overflowStrategy;
                    intersect = (JProcedure1 & Serializable)elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s.logLevel(), "Dropping all the buffered elements because buffer is full and overflowStrategy is: [DropBuffer] in stream [{}]", (Object)this.name);
                            this.buffer.clear();
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.DropNew) {
                    OverflowStrategies.DropNew s = (OverflowStrategies.DropNew)overflowStrategy;
                    intersect = (JProcedure1 & Serializable)elem -> {
                        if (!this.buffer.isFull()) {
                            this.buffer.enqueue(elem);
                        } else {
                            this.log().log(s.logLevel(), "Dropping the new element because buffer is full and overflowStrategy is: [DropNew] in stream [{}]", (Object)this.name);
                        }
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.Backpressure) {
                    OverflowStrategies.Backpressure s = (OverflowStrategies.Backpressure)overflowStrategy;
                    intersect = (JProcedure1 & Serializable)elem -> {
                        this.buffer.enqueue(elem);
                        if (!this.buffer.isFull()) {
                            this.pull($outer.in());
                            return;
                        }
                        this.log().log(s.logLevel(), "Backpressuring because buffer is full and overflowStrategy is: [Backpressure] in stream [{}]", (Object)this.name);
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.Fail) {
                    OverflowStrategies.Fail s = (OverflowStrategies.Fail)overflowStrategy;
                    intersect = (JProcedure1 & Serializable)elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s.logLevel(), "Failing because buffer is full and overflowStrategy is: [Fail] in stream [{}]", (Object)this.name);
                            this.failStage(BufferOverflowException$.MODULE$.apply(new StringBuilder(37).append("Buffer overflow (max capacity was: ").append($outer.size()).append(")!").toString()));
                            return;
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else {
                    throw new MatchError((Object)overflowStrategy);
                }
                this.enqueueAction = intersect;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            public Class logSource() {
                return Buffer.class;
            }

            public Function1 enqueueAction() {
                return this.enqueueAction;
            }

            public void preStart() {
                this.pull(this.$outer.in());
            }

            public void onPush() {
                T elem = this.grab(this.$outer.in());
                if (this.isAvailable(this.$outer.out())) {
                    this.push(this.$outer.out(), elem);
                    this.pull(this.$outer.in());
                    return;
                }
                this.enqueueAction().apply(elem);
            }

            public void onPull() {
                if (this.buffer.nonEmpty()) {
                    this.push(this.$outer.out(), this.buffer.dequeue());
                }
                if (this.isClosed(this.$outer.in())) {
                    if (this.buffer.isEmpty()) {
                        this.completeStage();
                        return;
                    }
                    return;
                }
                if (!this.hasBeenPulled(this.$outer.in())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void onUpstreamFinish() {
                if (this.buffer.isEmpty()) {
                    this.completeStage();
                    return;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$8(org.apache.pekko.stream.OverflowStrategies$DropHead org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$9(org.apache.pekko.stream.OverflowStrategies$DropTail org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$10(org.apache.pekko.stream.OverflowStrategies$DropBuffer org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$11(org.apache.pekko.stream.OverflowStrategies$DropNew org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$12(org.apache.pekko.stream.impl.fusing.Buffer org.apache.pekko.stream.OverflowStrategies$Backpressure java.lang.Object ), $init$$$anonfun$13(org.apache.pekko.stream.OverflowStrategies$Fail org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <T> Buffer<T> copy(int size, OverflowStrategy overflowStrategy) {
        return new Buffer<T>(size, overflowStrategy);
    }

    public int copy$default$1() {
        return this.size();
    }

    public <T> OverflowStrategy copy$default$2() {
        return this.overflowStrategy();
    }

    public int _1() {
        return this.size();
    }

    public OverflowStrategy _2() {
        return this.overflowStrategy();
    }
}

