/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.stream.AbruptStageTerminationException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowMonitor;
import org.apache.pekko.stream.FlowMonitorState;
import org.apache.pekko.stream.FlowMonitorState$Failed$;
import org.apache.pekko.stream.FlowMonitorState$Finished$;
import org.apache.pekko.stream.FlowMonitorState$Initialized$;
import org.apache.pekko.stream.FlowMonitorState$Received$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.StreamDetachedException;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.GraphStages$;
import org.apache.pekko.stream.impl.fusing.GraphStages$FutureFlattenSource$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class GraphStages {
    public static <T> GraphStage<FlowShape<T, T>> detacher() {
        return GraphStages$.MODULE$.detacher();
    }

    public static <T> SimpleLinearGraphStage<T> identity() {
        return GraphStages$.MODULE$.identity();
    }

    public static <T> GraphStageWithMaterializedValue<FlowShape<T, T>, FlowMonitor<T>> monitor() {
        return GraphStages$.MODULE$.monitor();
    }

    public static <T> GraphStageWithMaterializedValue<FlowShape<T, T>, Future<Done>> terminationWatcher() {
        return GraphStages$.MODULE$.terminationWatcher();
    }

    @InternalApi
    public static <T> Graph<UniformFanInShape<T, T>, NotUsed> withDetachedInputs(GraphStage<UniformFanInShape<T, T>> graphStage) {
        return GraphStages$.MODULE$.withDetachedInputs(graphStage);
    }

    public static class FlowMonitorImpl<T>
    extends AtomicReference<Object>
    implements FlowMonitor<T> {
        public FlowMonitorImpl() {
            super(FlowMonitorState$Initialized$.MODULE$);
        }

        @Override
        public FlowMonitorState.StreamState<T> state() {
            Object v = this.get();
            if (v instanceof FlowMonitorState.StreamState) {
                FlowMonitorState.StreamState s = (FlowMonitorState.StreamState)v;
                return s;
            }
            Object msg = v;
            return FlowMonitorState$Received$.MODULE$.apply(msg);
        }
    }

    public static final class FutureFlattenSource<T, M>
    extends GraphStageWithMaterializedValue<SourceShape<T>, Future<M>> {
        public final Future<Graph<SourceShape<T>, M>> org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$futureSource;
        private final Outlet out;
        private final SourceShape shape;

        public FutureFlattenSource(Future<Graph<SourceShape<T>, M>> futureSource) {
            this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$futureSource = futureSource;
            ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(futureSource);
            this.out = Outlet$.MODULE$.apply("FutureFlattenSource.out");
            this.shape = SourceShape$.MODULE$.apply(this.out());
        }

        public Outlet<T> out() {
            return this.out;
        }

        @Override
        public SourceShape<T> shape() {
            return this.shape;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.futureFlattenSource();
        }

        @Override
        public Tuple2<GraphStageLogic, Future<M>> createLogicAndMaterializedValue(Attributes attr) {
            Promise materialized = Promise$.MODULE$.apply();
            InHandler logic = new InHandler(materialized, attr, this){
                private final Attributes attr$2;
                public final Promise org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$materialized$3;
                public final GraphStageLogic.SubSinkInlet org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn;
                private final /* synthetic */ FutureFlattenSource $outer;
                {
                    this.attr$2 = attr$1;
                    this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$materialized$3 = materialized$1;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn = new GraphStageLogic.SubSinkInlet<T>(this, "FutureFlattenSource.in");
                    this.setHandler($outer.out(), new OutHandler(materialized$1, this){
                        private final Promise materialized$2;
                        {
                            this.materialized$2 = materialized$4;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                        }

                        public void onPull() {
                        }

                        public void onDownstreamFinish(Throwable cause) {
                            if (!this.materialized$2.isCompleted()) {
                                this.materialized$2.tryFailure(new StreamDetachedException("Stream cancelled before Source Future completed").initCause(cause));
                            }
                            OutHandler.onDownstreamFinish$(this, cause);
                        }
                    });
                }

                public void preStart() {
                    Option option = this.$outer.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$futureSource.value();
                    if (option instanceof Some) {
                        Try it = (Try)((Some)option).value();
                        this.onFutureSourceCompleted(it);
                        return;
                    }
                    AsyncCallback<T> asyncCallback = this.getAsyncCallback((JProcedure1 & Serializable)result -> this.onFutureSourceCompleted((Try)result));
                    JProcedure1 & Serializable cb = arg_0 -> GraphStages$.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$_$_$$anonfun$2(asyncCallback, arg_0);
                    this.$outer.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$futureSource.onComplete((Function1)cb, ExecutionContexts$.MODULE$.parasitic());
                }

                public void onPush() {
                    this.push(this.$outer.out(), this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn.grab());
                }

                public void onPull() {
                    this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn.pull();
                }

                public void onUpstreamFinish() {
                    this.completeStage();
                }

                public void onDownstreamFinish(Throwable cause) {
                    this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn.cancel(cause);
                    OutHandler.onDownstreamFinish$(this, cause);
                }

                public void onFutureSourceCompleted(Try result) {
                    result.map((Function1)(JProcedure1 & Serializable)graph -> {
                        Graph runnable = Source$.MODULE$.fromGraph(graph).toMat(this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn.sink(), (Function2)Keep$.MODULE$.left());
                        Mat matVal = this.interpreter().subFusingMaterializer().materialize(runnable, this.attr$2);
                        this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$materialized$3.success(matVal);
                        this.setHandler(this.$outer.out(), this);
                        this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn.setHandler(this);
                        if (this.isAvailable(this.$outer.out())) {
                            this.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn.pull();
                            return;
                        }
                    }).recover((PartialFunction)new Serializable(this){
                        private final /* synthetic */ FutureFlattenSource$$anon$7 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable;
                            Throwable t = throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable;
                            Throwable t = throwable = x;
                            this.$outer.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$sinkIn.cancel();
                            this.$outer.org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$materialized$3.failure(t);
                            this.$outer.failStage(t);
                            return BoxedUnit.UNIT;
                        }
                    });
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$1(scala.util.Try ), org$apache$pekko$stream$impl$fusing$GraphStages$FutureFlattenSource$$anon$7$$_$_$$anonfun$2(org.apache.pekko.stream.stage.AsyncCallback scala.util.Try ), onFutureSourceCompleted$$anonfun$1(org.apache.pekko.stream.Graph )}, serializedLambda);
                }
            };
            return Tuple2$.MODULE$.apply((Object)logic, (Object)materialized.future());
        }

        public String toString() {
            return "FutureFlattenSource";
        }
    }

    public static final class FutureSource<T>
    extends GraphStage<SourceShape<T>> {
        private final Future future;
        private final SourceShape shape;
        private final Outlet out;

        public FutureSource(Future<T> future) {
            this.future = future;
            ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(future);
            this.shape = SourceShape$.MODULE$.apply(Outlet$.MODULE$.apply("FutureSource.out"));
            this.out = ((SourceShape)this.shape()).out();
        }

        public Future<T> future() {
            return this.future;
        }

        @Override
        public SourceShape<T> shape() {
            return this.shape;
        }

        public Outlet<T> out() {
            return this.out;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.futureSource();
        }

        @Override
        public GraphStageLogic createLogic(Attributes attr) {
            return new OutHandler(this){
                private final /* synthetic */ FutureSource $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandler($outer.out(), this);
                }

                public void onPull() {
                    Option option = this.$outer.future().value();
                    if (option instanceof Some) {
                        Try completed = (Try)((Some)option).value();
                        this.onFutureCompleted$1(completed);
                    } else if (None$.MODULE$.equals(option)) {
                        AsyncCallback<T> asyncCallback = this.getAsyncCallback((JProcedure1 & Serializable)result -> this.onFutureCompleted$1((Try)result));
                        JProcedure1 & Serializable cb = arg_0 -> GraphStages$.org$apache$pekko$stream$impl$fusing$GraphStages$FutureSource$$anon$10$$_$_$$anonfun$4(asyncCallback, arg_0);
                        this.$outer.future().onComplete((Function1)cb, ExecutionContexts$.MODULE$.parasitic());
                    } else {
                        throw new MatchError((Object)option);
                    }
                    this.setHandler(this.$outer.out(), this.eagerTerminateOutput());
                }

                private final void onFutureCompleted$1(Try result) {
                    Try try_ = result;
                    if (try_ instanceof Success) {
                        Object object = ((Success)try_).value();
                        if (object == null) {
                            this.completeStage();
                            return;
                        }
                        Object v = object;
                        this.emit(this.$outer.out(), v, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Throwable t = ((Failure)try_).exception();
                        this.failStage(t);
                        return;
                    }
                    throw new MatchError((Object)try_);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$3(scala.util.Try ), org$apache$pekko$stream$impl$fusing$GraphStages$FutureSource$$anon$10$$_$_$$anonfun$4(org.apache.pekko.stream.stage.AsyncCallback scala.util.Try ), onFutureCompleted$1$$anonfun$1()}, serializedLambda);
                }
            };
        }

        public String toString() {
            return "FutureSource";
        }
    }

    public static class MonitorFlow<T>
    extends GraphStageWithMaterializedValue<FlowShape<T, T>, FlowMonitor<T>> {
        private final Inlet in = Inlet$.MODULE$.apply("FlowMonitor.in");
        private final Outlet out = Outlet$.MODULE$.apply("FlowMonitor.out");
        private final FlowShape shape = FlowShape$.MODULE$.of(this.in(), this.out());

        public Inlet<T> in() {
            return this.in;
        }

        public Outlet<T> out() {
            return this.out;
        }

        @Override
        public FlowShape<T, T> shape() {
            return this.shape;
        }

        @Override
        public Tuple2<GraphStageLogic, FlowMonitor<T>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            FlowMonitorImpl monitor = new FlowMonitorImpl();
            InHandler logic = new InHandler(monitor, this){
                private final FlowMonitorImpl monitor$1;
                private final /* synthetic */ MonitorFlow $outer;
                {
                    this.monitor$1 = monitor$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandler($outer.in(), this);
                    this.setHandler($outer.out(), this);
                }

                public void onPush() {
                    T msg = this.grab(this.$outer.in());
                    this.push(this.$outer.out(), msg);
                    this.monitor$1.set(msg instanceof FlowMonitorState.StreamState ? FlowMonitorState$Received$.MODULE$.apply(msg) : msg);
                }

                public void onUpstreamFinish() {
                    InHandler.onUpstreamFinish$(this);
                    this.monitor$1.set(FlowMonitorState$Finished$.MODULE$);
                }

                public void onUpstreamFailure(Throwable ex) {
                    InHandler.onUpstreamFailure$(this, ex);
                    this.monitor$1.set(FlowMonitorState$Failed$.MODULE$.apply(ex));
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }

                public void onDownstreamFinish(Throwable cause) {
                    OutHandler.onDownstreamFinish$(this, cause);
                    this.monitor$1.set(FlowMonitorState$Finished$.MODULE$);
                }

                public void postStop() {
                    FlowMonitorState.StreamState<T> streamState = this.monitor$1.state();
                    if (FlowMonitorState$Finished$.MODULE$.equals(streamState) || streamState instanceof FlowMonitorState.Failed) {
                        return;
                    }
                    this.monitor$1.set(FlowMonitorState$Failed$.MODULE$.apply(new AbruptStageTerminationException(this)));
                }

                public String toString() {
                    return "MonitorFlowLogic";
                }
            };
            return Tuple2$.MODULE$.apply((Object)logic, monitor);
        }

        public String toString() {
            return "MonitorFlow";
        }
    }

    @InternalApi
    public static abstract class SimpleLinearGraphStage<T>
    extends GraphStage<FlowShape<T, T>> {
        private final Inlet in = Inlet$.MODULE$.apply(new StringBuilder(3).append(Logging$.MODULE$.simpleName((Object)this)).append(".in").toString());
        private final Outlet out = Outlet$.MODULE$.apply(new StringBuilder(4).append(Logging$.MODULE$.simpleName((Object)this)).append(".out").toString());
        private final FlowShape shape = FlowShape$.MODULE$.apply(this.in(), this.out());

        public Inlet<T> in() {
            return this.in;
        }

        public Outlet<T> out() {
            return this.out;
        }

        @Override
        public FlowShape<T, T> shape() {
            return this.shape;
        }
    }

    public static final class SingleSource<T>
    extends GraphStage<SourceShape<T>> {
        private final Object elem;
        private final Outlet out;
        private final SourceShape shape;

        public SingleSource(T elem) {
            this.elem = elem;
            ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(elem);
            this.out = Outlet$.MODULE$.apply("single.out");
            this.shape = SourceShape$.MODULE$.apply(this.out());
        }

        public T elem() {
            return (T)this.elem;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.singleSource();
        }

        public Outlet<T> out() {
            return this.out;
        }

        @Override
        public SourceShape<T> shape() {
            return this.shape;
        }

        @Override
        public GraphStageLogic createLogic(Attributes attr) {
            return new OutHandler(this){
                private final /* synthetic */ SingleSource $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandler($outer.out(), this);
                }

                public void onPull() {
                    this.push(this.$outer.out(), this.$outer.elem());
                    this.completeStage();
                }
            };
        }

        public String toString() {
            return "SingleSource";
        }
    }

    public static final class TickSource<T>
    extends GraphStageWithMaterializedValue<SourceShape<T>, Cancellable> {
        private final FiniteDuration initialDelay;
        private final FiniteDuration interval;
        private final Object tick;
        private final SourceShape shape;
        private final Outlet out;

        public TickSource(FiniteDuration initialDelay, FiniteDuration interval, T tick) {
            this.initialDelay = initialDelay;
            this.interval = interval;
            this.tick = tick;
            this.shape = SourceShape$.MODULE$.apply(Outlet$.MODULE$.apply("TickSource.out"));
            this.out = ((SourceShape)this.shape()).out();
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        public FiniteDuration interval() {
            return this.interval;
        }

        public T tick() {
            return (T)this.tick;
        }

        @Override
        public SourceShape<T> shape() {
            return this.shape;
        }

        public Outlet<T> out() {
            return this.out;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.tickSource();
        }

        @Override
        public Tuple2<GraphStageLogic, Cancellable> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            Cancellable logic = new Cancellable(this){
                private final AtomicBoolean cancelled;
                private final AtomicReference cancelCallback;
                private final /* synthetic */ TickSource $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.cancelled = new AtomicBoolean(false);
                    this.cancelCallback = new AtomicReference<None$>(None$.MODULE$);
                    this.setHandler($outer.out(), this.eagerTerminateOutput());
                }

                public AtomicBoolean cancelled() {
                    return this.cancelled;
                }

                public AtomicReference cancelCallback() {
                    return this.cancelCallback;
                }

                public void preStart() {
                    this.cancelCallback().set(Some$.MODULE$.apply(this.getAsyncCallback((JProcedure1 & Serializable)_$1 -> this.completeStage())));
                    if (this.cancelled().get()) {
                        this.completeStage();
                        return;
                    }
                    this.scheduleWithFixedDelay((Object)"TickTimer", this.$outer.initialDelay(), this.$outer.interval());
                }

                public void onTimer(Object timerKey) {
                    if (this.isAvailable(this.$outer.out()) && !this.isCancelled()) {
                        this.push(this.$outer.out(), this.$outer.tick());
                        return;
                    }
                }

                public boolean cancel() {
                    boolean success;
                    boolean bl = success = !this.cancelled().getAndSet(true);
                    if (success) {
                        ((Option)this.cancelCallback().get()).foreach((Function1)((JProcedure1 & Serializable)GraphStages$::org$apache$pekko$stream$impl$fusing$GraphStages$TickSource$$anon$5$$_$cancel$$anonfun$1));
                    }
                    return success;
                }

                public boolean isCancelled() {
                    return this.cancelled().get();
                }

                public String toString() {
                    return "TickSourceLogic";
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{preStart$$anonfun$1(scala.runtime.BoxedUnit ), org$apache$pekko$stream$impl$fusing$GraphStages$TickSource$$anon$5$$_$cancel$$anonfun$1(org.apache.pekko.stream.stage.AsyncCallback )}, serializedLambda);
                }
            };
            return Tuple2$.MODULE$.apply((Object)logic, (Object)logic);
        }

        public String toString() {
            return new StringBuilder(16).append("TickSource(").append(this.initialDelay()).append(", ").append(this.interval()).append(", ").append(this.tick()).append(")").toString();
        }
    }
}

