/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.impl.fusing.RecoverWith$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.PartialFunction;

@InternalApi
public final class RecoverWith<T, M>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final int maximumRetries;
    private final PartialFunction pf;

    public RecoverWith(int maximumRetries, PartialFunction<Throwable, Graph<SourceShape<T>, M>> pf) {
        this.maximumRetries = maximumRetries;
        this.pf = pf;
    }

    public int maximumRetries() {
        return this.maximumRetries;
    }

    public PartialFunction<Throwable, Graph<SourceShape<T>, M>> pf() {
        return this.pf;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.recoverWith();
    }

    @Override
    public GraphStageLogic createLogic(Attributes attr) {
        return new GraphStageLogic(this){
            private int attempt;
            private final /* synthetic */ RecoverWith $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.attempt = 0;
                this.setHandler($outer.in(), new InHandler(this){
                    private final /* synthetic */ $anon$44 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        this.$outer.protected$push(this.$outer.org$apache$pekko$stream$impl$fusing$RecoverWith$_$$anon$$$outer().out(), this.$outer.protected$grab(this.$outer.org$apache$pekko$stream$impl$fusing$RecoverWith$_$$anon$$$outer().in()));
                    }

                    public void onUpstreamFailure(Throwable ex) {
                        this.$outer.onFailure(ex);
                    }
                });
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$44 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        this.$outer.protected$pull(this.$outer.org$apache$pekko$stream$impl$fusing$RecoverWith$_$$anon$$$outer().in());
                    }
                });
            }

            public int attempt() {
                return this.attempt;
            }

            public void attempt_$eq(int x$1) {
                this.attempt = x$1;
            }

            public void onFailure(Throwable ex) {
                if ((this.$outer.maximumRetries() < 0 || this.attempt() < this.$outer.maximumRetries()) && this.$outer.pf().isDefinedAt((Object)ex)) {
                    this.switchTo((Graph)this.$outer.pf().apply((Object)ex));
                    this.attempt_$eq(this.attempt() + 1);
                    return;
                }
                this.failStage(ex);
            }

            public void switchTo(Graph source) {
                GraphStageLogic.SubSinkInlet<T> sinkIn = new GraphStageLogic.SubSinkInlet<T>(this, "RecoverWithSink");
                sinkIn.setHandler(new InHandler(sinkIn, this){
                    private final GraphStageLogic.SubSinkInlet sinkIn$1;
                    private final /* synthetic */ $anon$44 $outer;
                    {
                        this.sinkIn$1 = sinkIn$3;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPush() {
                        this.$outer.protected$push(this.$outer.org$apache$pekko$stream$impl$fusing$RecoverWith$_$$anon$$$outer().out(), this.sinkIn$1.grab());
                    }

                    public void onUpstreamFinish() {
                        this.$outer.completeStage();
                    }

                    public void onUpstreamFailure(Throwable ex) {
                        this.$outer.onFailure(ex);
                    }
                });
                OutHandler outHandler = new OutHandler(sinkIn){
                    private final GraphStageLogic.SubSinkInlet sinkIn$2;
                    {
                        this.sinkIn$2 = sinkIn$4;
                    }

                    public void onPull() {
                        this.sinkIn$2.pull();
                    }

                    public void onDownstreamFinish(Throwable cause) {
                        this.sinkIn$2.cancel(cause);
                    }
                };
                Source$.MODULE$.fromGraph(source).runWith(sinkIn.sink(), this.interpreter().subFusingMaterializer());
                this.setHandler(this.$outer.out(), outHandler);
                if (this.isAvailable(this.$outer.out())) {
                    sinkIn.pull();
                    return;
                }
            }

            public void protected$push(Outlet out, Object elem) {
                this.push(out, elem);
            }

            public Object protected$grab(Inlet in) {
                return this.grab(in);
            }

            public void protected$pull(Inlet in) {
                this.pull(in);
            }

            public final /* synthetic */ RecoverWith org$apache$pekko$stream$impl$fusing$RecoverWith$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    public String toString() {
        return "RecoverWith";
    }
}

