/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteOrder;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Framing$;
import org.apache.pekko.stream.scaladsl.Framing$DelimiterFramingStage$;
import org.apache.pekko.stream.scaladsl.Framing$DelimiterFramingStage$$anon$2$FrameIterator$;
import org.apache.pekko.stream.scaladsl.Framing$DelimiterFramingStage$$anon$2$LightArray$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteIterator;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.CompactByteString;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Framing {
    public static Flow<ByteString, ByteString, NotUsed> delimiter(ByteString byteString, int n, boolean bl) {
        return Framing$.MODULE$.delimiter(byteString, n, bl);
    }

    public static Flow<ByteString, ByteString, NotUsed> lengthField(int n, int n2, int n3, ByteOrder byteOrder) {
        return Framing$.MODULE$.lengthField(n, n2, n3, byteOrder);
    }

    public static Flow<ByteString, ByteString, NotUsed> lengthField(int n, int n2, int n3, ByteOrder byteOrder, Function2<byte[], Object, Object> function2) {
        return Framing$.MODULE$.lengthField(n, n2, n3, byteOrder, function2);
    }

    public static BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> simpleFramingProtocol(int n) {
        return Framing$.MODULE$.simpleFramingProtocol(n);
    }

    public static Flow<ByteString, ByteString, NotUsed> simpleFramingProtocolDecoder(int n) {
        return Framing$.MODULE$.simpleFramingProtocolDecoder(n);
    }

    public static Flow<ByteString, ByteString, NotUsed> simpleFramingProtocolEncoder(int n) {
        return Framing$.MODULE$.simpleFramingProtocolEncoder(n);
    }

    public static int lengthField$default$2() {
        return Framing$.MODULE$.lengthField$default$2();
    }

    public static boolean delimiter$default$3() {
        return Framing$.MODULE$.delimiter$default$3();
    }

    public static ByteOrder lengthField$default$4() {
        return Framing$.MODULE$.lengthField$default$4();
    }

    public static class DelimiterFramingStage
    extends GraphStage<FlowShape<ByteString, ByteString>> {
        private final ByteString separatorBytes;
        private final int maximumLineBytes;
        private final boolean allowTruncation;
        private final Inlet in;
        private final Outlet out;
        private final FlowShape shape;

        public DelimiterFramingStage(ByteString separatorBytes, int maximumLineBytes, boolean allowTruncation) {
            this.separatorBytes = separatorBytes;
            this.maximumLineBytes = maximumLineBytes;
            this.allowTruncation = allowTruncation;
            this.in = Inlet$.MODULE$.apply("DelimiterFramingStage.in");
            this.out = Outlet$.MODULE$.apply("DelimiterFramingStage.out");
            this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
        }

        public ByteString separatorBytes() {
            return this.separatorBytes;
        }

        public int maximumLineBytes() {
            return this.maximumLineBytes;
        }

        public boolean allowTruncation() {
            return this.allowTruncation;
        }

        public Inlet<ByteString> in() {
            return this.in;
        }

        public Outlet<ByteString> out() {
            return this.out;
        }

        @Override
        public FlowShape<ByteString, ByteString> shape() {
            return this.shape;
        }

        @Override
        public Attributes initialAttributes() {
            return Stages$DefaultAttributes$.MODULE$.delimiterFraming();
        }

        public String toString() {
            return "DelimiterFraming";
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private final byte firstSeparatorByte;
                public ByteString org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer;
                private int nextPossibleMatch;
                public final DelimiterFramingStage$$anon$2$LightArray org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices;
                public final Framing$DelimiterFramingStage$$anon$2$FrameIterator$ FrameIterator$lzy1;
                public final Framing$DelimiterFramingStage$$anon$2$LightArray$ LightArray$lzy1;
                private final /* synthetic */ DelimiterFramingStage $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.FrameIterator$lzy1 = new Framing$DelimiterFramingStage$$anon$2$FrameIterator$();
                    this.LightArray$lzy1 = new Framing$DelimiterFramingStage$$anon$2$LightArray$();
                    this.firstSeparatorByte = $outer.separatorBytes().head();
                    this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer = ByteString$.MODULE$.empty();
                    this.nextPossibleMatch = 0;
                    this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices = new DelimiterFramingStage$$anon$2$LightArray<T>(256, this.LightArray().$lessinit$greater$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer = this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.$plus$plus(this.grab(this.$outer.in()));
                    this.searchIndices();
                }

                public void onPull() {
                    this.searchIndices();
                }

                public void onUpstreamFinish() {
                    if (this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.isEmpty()) {
                        this.completeStage();
                        return;
                    }
                    if (this.isAvailable(this.$outer.out())) {
                        this.searchIndices();
                        return;
                    }
                }

                private void tryPull() {
                    if (this.isClosed(this.$outer.in())) {
                        if (this.$outer.allowTruncation()) {
                            this.push(this.$outer.out(), this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer);
                            this.completeStage();
                            return;
                        }
                        this.failStage(new FramingException("Stream finished but there was a truncated final frame in the buffer"));
                        return;
                    }
                    this.pull(this.$outer.in());
                }

                private void searchIndices() {
                    while (true) {
                        int previous;
                        int n;
                        Tuple2 tuple2;
                        Tuple2 tuple22;
                        int possibleMatchPos = this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.indexOf((Object)BoxesRunTime.boxToByte((byte)this.firstSeparatorByte), this.nextPossibleMatch);
                        Tuple2 tuple23 = (Tuple2)this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.lastOption();
                        Tuple2 tuple24 = (Tuple2)OptionVal.Some$.MODULE$.unapply((Object)tuple23);
                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)tuple24) && (tuple22 = (tuple2 = (Tuple2)OptionVal$.MODULE$.get$extension((Object)tuple24))) != null) {
                            int i = tuple22._2$mcI$sp();
                            n = i + this.$outer.separatorBytes().size();
                        } else {
                            n = previous = 0;
                        }
                        if (possibleMatchPos - previous > this.$outer.maximumLineBytes()) {
                            this.failStage(new FramingException(new StringBuilder(12).append("Read ").append(possibleMatchPos - previous).append(" bytes ").append(new StringBuilder(52).append("which is more than ").append(this.$outer.maximumLineBytes()).append(" without seeing a line terminator").toString()).toString()));
                            return;
                        }
                        if (possibleMatchPos == -1) {
                            if (this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.length() - previous > this.$outer.maximumLineBytes()) {
                                this.failStage(new FramingException(new StringBuilder(12).append("Read ").append(this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.length() - previous).append(" bytes ").append(new StringBuilder(52).append("which is more than ").append(this.$outer.maximumLineBytes()).append(" without seeing a line terminator").toString()).toString()));
                                return;
                            }
                            this.nextPossibleMatch = this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.length();
                            this.doParse();
                            return;
                        }
                        if (possibleMatchPos + this.$outer.separatorBytes().length() > this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.length()) {
                            this.nextPossibleMatch = possibleMatchPos;
                            this.doParse();
                            return;
                        }
                        ByteString byteString = this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.slice(possibleMatchPos, possibleMatchPos + this.$outer.separatorBytes().length());
                        ByteString byteString2 = this.$outer.separatorBytes();
                        if (!(byteString != null ? !byteString.equals(byteString2) : byteString2 != null)) {
                            Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)previous));
                            this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)BoxesRunTime.boxToInteger((int)possibleMatchPos)));
                            this.nextPossibleMatch = possibleMatchPos + this.$outer.separatorBytes().length();
                            if (this.nextPossibleMatch != this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.length() && !this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.isFull()) continue;
                            this.doParse();
                            return;
                        }
                        ++this.nextPossibleMatch;
                    }
                }

                private void doParse() {
                    if (this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.isEmpty()) {
                        this.tryPull();
                        return;
                    }
                    if (this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.length() == 1) {
                        Tuple2 indice = (Tuple2)this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.apply(0);
                        this.push(this.$outer.out(), this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.slice(indice._1$mcI$sp(), indice._2$mcI$sp()).compact());
                        this.reset();
                        if (this.isClosed(this.$outer.in()) && this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.isEmpty()) {
                            this.completeStage();
                            return;
                        }
                        return;
                    }
                    this.emitMultiple(this.$outer.out(), new DelimiterFramingStage$$anon$2$FrameIterator(this, this.FrameIterator().$lessinit$greater$default$1()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        this.reset();
                        if (this.isClosed(this.$outer.in()) && this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.isEmpty()) {
                            this.completeStage();
                            return;
                        }
                    });
                }

                private void reset() {
                    int n;
                    Tuple2 tuple2;
                    Tuple2 tuple22;
                    Tuple2 tuple23 = (Tuple2)this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.lastOption();
                    Tuple2 tuple24 = (Tuple2)OptionVal.Some$.MODULE$.unapply((Object)tuple23);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)tuple24) && (tuple22 = (tuple2 = (Tuple2)OptionVal$.MODULE$.get$extension((Object)tuple24))) != null) {
                        int i = tuple22._2$mcI$sp();
                        n = i + this.$outer.separatorBytes().size();
                    } else {
                        n = 0;
                    }
                    int previous = n;
                    this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer = this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$buffer.drop(previous).compact();
                    this.org$apache$pekko$stream$scaladsl$Framing$DelimiterFramingStage$$anon$2$$indices.setLength(0);
                    this.nextPossibleMatch = 0;
                }

                private final Framing$DelimiterFramingStage$$anon$2$FrameIterator$ FrameIterator() {
                    return this.FrameIterator$lzy1;
                }

                private final Framing$DelimiterFramingStage$$anon$2$LightArray$ LightArray() {
                    return this.LightArray$lzy1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{doParse$$anonfun$1()}, serializedLambda);
                }
            };
        }
    }

    public static class FramingException
    extends RuntimeException {
        public FramingException(String msg) {
            super(msg);
        }
    }

    public static final class LengthFieldFramingStage
    extends GraphStage<FlowShape<ByteString, ByteString>> {
        private final int lengthFieldLength;
        private final int lengthFieldOffset;
        private final int maximumFrameLength;
        private final ByteOrder byteOrder;
        public final Option<Function2<byte[], Object, Object>> org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$computeFrameSize;
        public final int org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$minimumChunkSize;
        public final Function2<ByteIterator, Object, Object> org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$intDecoder;
        private final Inlet in;
        private final Outlet out;
        private final FlowShape shape;

        public LengthFieldFramingStage(int lengthFieldLength, int lengthFieldOffset, int maximumFrameLength, ByteOrder byteOrder, Option<Function2<byte[], Object, Object>> computeFrameSize) {
            Function2<ByteIterator, Object, Object> function2;
            this.lengthFieldLength = lengthFieldLength;
            this.lengthFieldOffset = lengthFieldOffset;
            this.maximumFrameLength = maximumFrameLength;
            this.byteOrder = byteOrder;
            this.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$computeFrameSize = computeFrameSize;
            this.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$minimumChunkSize = lengthFieldOffset + lengthFieldLength;
            ByteOrder byteOrder2 = byteOrder;
            ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
            ByteOrder byteOrder4 = byteOrder2;
            if (!(byteOrder3 != null ? !byteOrder3.equals(byteOrder4) : byteOrder4 != null)) {
                function2 = Framing$.org$apache$pekko$stream$scaladsl$Framing$$$bigEndianDecoder;
            } else {
                ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
                ByteOrder byteOrder6 = byteOrder2;
                if (!(byteOrder5 != null ? !byteOrder5.equals(byteOrder6) : byteOrder6 != null)) {
                    function2 = Framing$.org$apache$pekko$stream$scaladsl$Framing$$$littleEndianDecoder;
                } else {
                    throw new RuntimeException();
                }
            }
            this.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$intDecoder = function2;
            this.in = Inlet$.MODULE$.apply("LengthFieldFramingStage.in");
            this.out = Outlet$.MODULE$.apply("LengthFieldFramingStage.out");
            this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
        }

        public int lengthFieldLength() {
            return this.lengthFieldLength;
        }

        public int lengthFieldOffset() {
            return this.lengthFieldOffset;
        }

        public int maximumFrameLength() {
            return this.maximumFrameLength;
        }

        public ByteOrder byteOrder() {
            return this.byteOrder;
        }

        public LengthFieldFramingStage(int lengthFieldLength, int lengthFieldOffset, int maximumFrameLength, ByteOrder byteOrder) {
            this(lengthFieldLength, lengthFieldOffset, maximumFrameLength, byteOrder, (Option<Function2<byte[], Object, Object>>)None$.MODULE$);
        }

        public Inlet<ByteString> in() {
            return this.in;
        }

        public Outlet<ByteString> out() {
            return this.out;
        }

        @Override
        public FlowShape<ByteString, ByteString> shape() {
            return this.shape;
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private ByteString buffer;
                private int frameSize;
                private final /* synthetic */ LengthFieldFramingStage $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.buffer = ByteString$.MODULE$.empty();
                    this.frameSize = Integer.MAX_VALUE;
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                private void pushFrame() {
                    CompactByteString emit = this.buffer.take(this.frameSize).compact();
                    this.buffer = this.buffer.drop(this.frameSize);
                    this.frameSize = Integer.MAX_VALUE;
                    this.push(this.$outer.out(), emit);
                    if (this.buffer.isEmpty() && this.isClosed(this.$outer.in())) {
                        this.completeStage();
                        return;
                    }
                }

                private void tryPushFrame() {
                    int buffSize = this.buffer.size();
                    if (buffSize >= this.frameSize) {
                        this.pushFrame();
                        return;
                    }
                    if (buffSize >= this.$outer.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$minimumChunkSize) {
                        int n;
                        int parsedLength = BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$intDecoder.apply((Object)this.buffer.iterator().drop(this.$outer.lengthFieldOffset()), (Object)BoxesRunTime.boxToInteger((int)this.$outer.lengthFieldLength())));
                        Option<Function2<byte[], Object, Object>> option = this.$outer.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$computeFrameSize;
                        if (option instanceof Some) {
                            Function2 f = (Function2)((Some)option).value();
                            n = BoxesRunTime.unboxToInt((Object)f.apply((Object)this.buffer.take(this.$outer.lengthFieldOffset()).toArrayUnsafe(), (Object)BoxesRunTime.boxToInteger((int)parsedLength)));
                        } else if (None$.MODULE$.equals(option)) {
                            n = parsedLength + this.$outer.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$minimumChunkSize;
                        } else {
                            throw new MatchError(option);
                        }
                        this.frameSize = n;
                        if (this.frameSize > this.$outer.maximumFrameLength()) {
                            this.failStage(new FramingException(new StringBuilder(70).append("Maximum allowed frame size is ").append(this.$outer.maximumFrameLength()).append(" but decoded frame header reported size ").append(this.frameSize).toString()));
                            return;
                        }
                        if (this.$outer.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$computeFrameSize.isEmpty() && parsedLength < 0) {
                            this.failStage(new FramingException(new StringBuilder(44).append("Decoded frame header reported negative size ").append(parsedLength).toString()));
                            return;
                        }
                        if (this.frameSize < this.$outer.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$minimumChunkSize) {
                            this.failStage(new FramingException(new StringBuilder(53).append("Computed frame size ").append(this.frameSize).append(" is less than minimum chunk size ").append(this.$outer.org$apache$pekko$stream$scaladsl$Framing$LengthFieldFramingStage$$minimumChunkSize).toString()));
                            return;
                        }
                        if (buffSize >= this.frameSize) {
                            this.pushFrame();
                            return;
                        }
                        this.tryPull();
                        return;
                    }
                    this.tryPull();
                }

                private void tryPull() {
                    if (this.isClosed(this.$outer.in())) {
                        this.failStage(new FramingException("Stream finished but there was a truncated final frame in the buffer"));
                        return;
                    }
                    this.pull(this.$outer.in());
                }

                public void onPush() {
                    this.buffer = this.buffer.$plus$plus(this.grab(this.$outer.in()));
                    this.tryPushFrame();
                }

                public void onPull() {
                    this.tryPushFrame();
                }

                public void onUpstreamFinish() {
                    if (this.buffer.isEmpty()) {
                        this.completeStage();
                        return;
                    }
                    if (this.isAvailable(this.$outer.out())) {
                        this.tryPushFrame();
                        return;
                    }
                }
            };
        }
    }

    public static class SimpleFramingProtocolEncoder
    extends GraphStages.SimpleLinearGraphStage<ByteString> {
        public final long org$apache$pekko$stream$scaladsl$Framing$SimpleFramingProtocolEncoder$$maximumMessageLength;

        public SimpleFramingProtocolEncoder(long maximumMessageLength) {
            this.org$apache$pekko$stream$scaladsl$Framing$SimpleFramingProtocolEncoder$$maximumMessageLength = maximumMessageLength;
        }

        @Override
        public GraphStageLogic createLogic(Attributes inheritedAttributes) {
            return new InHandler(this){
                private final /* synthetic */ SimpleFramingProtocolEncoder $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    ByteString message = (ByteString)this.grab(this.$outer.in());
                    int msgSize = message.size();
                    if ((long)msgSize > this.$outer.org$apache$pekko$stream$scaladsl$Framing$SimpleFramingProtocolEncoder$$maximumMessageLength) {
                        this.failStage(new FramingException(new StringBuilder(57).append("Maximum allowed message size is ").append(this.$outer.org$apache$pekko$stream$scaladsl$Framing$SimpleFramingProtocolEncoder$$maximumMessageLength).append(" but tried to send ").append(msgSize).append(" bytes").toString()));
                        return;
                    }
                    ByteString header = ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{msgSize >> 24 & 0xFF, msgSize >> 16 & 0xFF, msgSize >> 8 & 0xFF, msgSize & 0xFF}), (Integral)Numeric.IntIsIntegral$.MODULE$);
                    this.push(this.$outer.out(), header.$plus$plus(message));
                }

                public void onPull() {
                    this.pull(this.$outer.in());
                }
            };
        }
    }
}

