/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.impl.TraversalBuilder;
import org.apache.pekko.stream.scaladsl.GenericGraphWithChangedAttributes;
import scala.Function1;

public final class GenericGraph<S extends Shape, Mat>
implements Graph<S, Mat> {
    private final Shape shape;
    private final TraversalBuilder traversalBuilder;

    public GenericGraph(S shape, TraversalBuilder traversalBuilder) {
        this.shape = shape;
        this.traversalBuilder = traversalBuilder;
    }

    @Override
    public S shape() {
        return (S)this.shape;
    }

    @Override
    public TraversalBuilder traversalBuilder() {
        return this.traversalBuilder;
    }

    public String toString() {
        return new StringBuilder(14).append("GenericGraph(").append(this.shape()).append(")").toString();
    }

    @Override
    public Graph<S, Mat> withAttributes(Attributes attr) {
        return new GenericGraphWithChangedAttributes(this.shape(), this.traversalBuilder(), attr);
    }

    public <Mat2> GenericGraph<S, Mat2> mapMaterializedValue(Function1<Mat, Mat2> f) {
        return new GenericGraph<S, Mat>(this.shape(), this.traversalBuilder().transformMat(f));
    }
}

