/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.TraversalBuilder$;
import org.apache.pekko.stream.impl.fusing.Collect$NotApplied$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.impl.fusing.RecoverWith$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@InternalApi
public final class RecoverWith<T, M>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final int maximumRetries;
    private final PartialFunction pf;

    public RecoverWith(int maximumRetries, PartialFunction<Throwable, Graph<SourceShape<T>, M>> pf) {
        this.maximumRetries = maximumRetries;
        this.pf = pf;
    }

    public int maximumRetries() {
        return this.maximumRetries;
    }

    public PartialFunction<Throwable, Graph<SourceShape<T>, M>> pf() {
        return this.pf;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.recoverWith();
    }

    @Override
    public GraphStageLogic createLogic(Attributes attr) {
        return new InHandler(this){
            private int attempt;
            private final /* synthetic */ RecoverWith $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.attempt = 0;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public int attempt() {
                return this.attempt;
            }

            public void attempt_$eq(int x$1) {
                this.attempt = x$1;
            }

            public void onPush() {
                this.push(this.$outer.out(), this.grab(this.$outer.in()));
            }

            public void onUpstreamFailure(Throwable ex) {
                this.onFailure(ex);
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onFailure(Throwable ex) {
                if (this.$outer.maximumRetries() < 0 || this.attempt() < this.$outer.maximumRetries()) {
                    Object object = this.$outer.pf().applyOrElse((Object)ex, (Function1)Collect$NotApplied$.MODULE$);
                    if (object == Collect$NotApplied$.MODULE$) {
                        this.failStage(ex);
                        return;
                    }
                    if (object instanceof Graph) {
                        Graph graph = (Graph)object;
                        Graph source = graph;
                        if (TraversalBuilder$.MODULE$.isEmptySource(source)) {
                            this.completeStage();
                            return;
                        }
                        Graph other = graph;
                        GraphStages.SingleSource singleSource = TraversalBuilder$.MODULE$.getSingleSource(other);
                        GraphStages.SingleSource singleSource2 = (GraphStages.SingleSource)OptionVal.Some$.MODULE$.unapply((Object)singleSource);
                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)singleSource2)) {
                            GraphStages.SingleSource singleSource3;
                            GraphStages.SingleSource singleSource4 = singleSource3 = (GraphStages.SingleSource)OptionVal$.MODULE$.get$extension((Object)singleSource2);
                            this.emit(this.$outer.out(), singleSource4.elem(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
                            return;
                        }
                        this.switchTo(other);
                        this.attempt_$eq(this.attempt() + 1);
                        return;
                    }
                    throw new IllegalStateException();
                }
                this.failStage(ex);
            }

            public void switchTo(Graph source) {
                InHandler sinkIn = new InHandler(this){
                    private final /* synthetic */ $anon$42 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer, "RecoverWithSink");
                        this.setHandler(this);
                    }

                    public void onPush() {
                        this.$outer.protected$push(this.$outer.org$apache$pekko$stream$impl$fusing$RecoverWith$_$$anon$$$outer().out(), this.grab());
                    }

                    public void onUpstreamFinish() {
                        this.$outer.completeStage();
                    }

                    public void onUpstreamFailure(Throwable ex) {
                        this.$outer.onFailure(ex);
                    }

                    public void onPull() {
                        this.pull();
                    }

                    public void onDownstreamFinish(Throwable cause) {
                        this.cancel(cause);
                    }
                };
                Source$.MODULE$.fromGraph(source).runWith(((GraphStageLogic.SubSinkInlet)((Object)sinkIn)).sink(), this.interpreter().subFusingMaterializer());
                this.setHandler(this.$outer.out(), (OutHandler)((Object)sinkIn));
                if (this.isAvailable(this.$outer.out())) {
                    ((GraphStageLogic.SubSinkInlet)((Object)sinkIn)).pull();
                    return;
                }
            }

            public void protected$push(Outlet out, Object elem) {
                this.push(out, elem);
            }

            public final /* synthetic */ RecoverWith org$apache$pekko$stream$impl$fusing$RecoverWith$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onFailure$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public String toString() {
        return "RecoverWith";
    }
}

