/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.TLSClosing;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.TLSProtocol$SendBytes$;
import org.apache.pekko.stream.TLSProtocol$SessionBytes$;
import org.apache.pekko.stream.TLSProtocol$SessionTruncated$;
import org.apache.pekko.stream.impl.FanIn;
import org.apache.pekko.stream.impl.FanOut;
import org.apache.pekko.stream.impl.Pump;
import org.apache.pekko.stream.impl.TransferPhase;
import org.apache.pekko.stream.impl.TransferPhase$;
import org.apache.pekko.stream.impl.TransferState;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$Snapshot$;
import org.apache.pekko.stream.impl.io.TLSActor$;
import org.apache.pekko.stream.impl.io.TlsUtils$;
import org.apache.pekko.stream.snapshot.RunningInterpreter;
import org.apache.pekko.stream.snapshot.StreamSnapshotImpl$;
import org.apache.pekko.stream.snapshot.UninitializedInterpreter;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public class TLSActor
implements Actor,
ActorLogging,
Pump {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private TransferState org$apache$pekko$stream$impl$Pump$$transferState;
    private Function0 org$apache$pekko$stream$impl$Pump$$currentAction;
    private TransferPhase completedPhase;
    public final int org$apache$pekko$stream$impl$io$TLSActor$$maxInputBufferSize;
    private final Function1<ActorSystem, SSLEngine> createSSLEngine;
    private final Function2<ActorSystem, SSLSession, Try<BoxedUnit>> verifySession;
    private final TLSClosing closing;
    public final boolean org$apache$pekko$stream$impl$io$TLSActor$$tracing;
    private final int maxTLSIterations;
    private int unwrapPutBackCounter;
    private final FanOut.OutputBunch outputBunch;
    private final FanIn.InputBunch inputBunch;
    private final ByteBuffer transportOutBuffer;
    private final ByteBuffer userOutBuffer;
    private final ByteBuffer transportInBuffer;
    private final ByteBuffer userInBuffer;
    public final ChoppingBlock org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock;
    private final ChoppingBlock transportInChoppingBlock;
    private SSLEngineResult.HandshakeStatus lastHandshakeStatus;
    private boolean corkUser;
    private final SSLEngine engine;
    private SSLSession currentSession;
    private final TransferState engineNeedsWrap;
    private final TransferState engineInboundOpen;
    private final TransferState userHasData;
    private final TransferState userOutCancelled;
    private final TransferState outbound;
    private final TransferState inbound;
    private final TransferState outboundHalfClosed;
    private final TransferState inboundHalfClosed;
    private final TransferPhase bidirectional;
    private final TransferPhase flushingOutbound;
    private final TransferPhase awaitingClose;
    private final TransferPhase outboundClosed;
    private final TransferPhase inboundClosed;

    public static int TransportIn() {
        return TLSActor$.MODULE$.TransportIn();
    }

    public static int TransportOut() {
        return TLSActor$.MODULE$.TransportOut();
    }

    public static int UserIn() {
        return TLSActor$.MODULE$.UserIn();
    }

    public static int UserOut() {
        return TLSActor$.MODULE$.UserOut();
    }

    public static Props props(int n, Function1<ActorSystem, SSLEngine> function1, Function2<ActorSystem, SSLSession, Try<BoxedUnit>> function2, TLSClosing tLSClosing, boolean bl) {
        return TLSActor$.MODULE$.props(n, function1, function2, tLSClosing, bl);
    }

    public static boolean props$default$5() {
        return TLSActor$.MODULE$.props$default$5();
    }

    public TLSActor(int maxInputBufferSize, Function1<ActorSystem, SSLEngine> createSSLEngine, Function2<ActorSystem, SSLSession, Try<BoxedUnit>> verifySession, TLSClosing closing, boolean tracing) {
        this.org$apache$pekko$stream$impl$io$TLSActor$$maxInputBufferSize = maxInputBufferSize;
        this.createSSLEngine = createSSLEngine;
        this.verifySession = verifySession;
        this.closing = closing;
        this.org$apache$pekko$stream$impl$io$TLSActor$$tracing = tracing;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        Pump.$init$(this);
        this.maxTLSIterations = 1000;
        this.unwrapPutBackCounter = 0;
        this.outputBunch = new FanOut.OutputBunch(2, this.self(), this);
        this.outputBunch().markAllOutputs();
        this.inputBunch = new FanIn.InputBunch(this){
            private final /* synthetic */ TLSActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(2, $outer.org$apache$pekko$stream$impl$io$TLSActor$$maxInputBufferSize, $outer);
            }

            public void onError(int input, Throwable e) {
                this.$outer.fail(e, this.$outer.fail$default$2());
            }
        };
        this.transportOutBuffer = ByteBuffer.allocate(18713);
        this.userOutBuffer = ByteBuffer.allocate(35378);
        this.transportInBuffer = ByteBuffer.allocate(18713);
        this.userInBuffer = ByteBuffer.allocate(18713);
        this.org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock = new ChoppingBlock(this, 1, "UserIn");
        this.org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock.prepare(this.userInBuffer);
        this.transportInChoppingBlock = new ChoppingBlock(this, 0, "TransportIn");
        this.transportInChoppingBlock.prepare(this.transportInBuffer);
        this.lastHandshakeStatus = null;
        this.corkUser = true;
        this.engine = this.liftedTree1$1(createSSLEngine);
        this.engine().beginHandshake();
        this.lastHandshakeStatus_$eq(this.engine().getHandshakeStatus());
        this.currentSession = this.engine().getSession();
        this.engineNeedsWrap = new TransferState(this){
            private final /* synthetic */ TLSActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean isReady() {
                SSLEngineResult.HandshakeStatus handshakeStatus = this.$outer.lastHandshakeStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus2 = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                return !(handshakeStatus != null ? !((Object)((Object)handshakeStatus)).equals((Object)((Object)handshakeStatus2)) : handshakeStatus2 != null);
            }

            public boolean isCompleted() {
                return this.$outer.engine().isOutboundDone();
            }
        };
        this.engineInboundOpen = new TransferState(this){
            private final /* synthetic */ TLSActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean isReady() {
                return true;
            }

            public boolean isCompleted() {
                return this.$outer.engine().isInboundDone();
            }
        };
        this.userHasData = new TransferState(this){
            private final /* synthetic */ TLSActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isReady() {
                if (this.$outer.corkUser()) return false;
                if (!this.$outer.org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock.isReady()) return false;
                SSLEngineResult.HandshakeStatus handshakeStatus = this.$outer.lastHandshakeStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus2 = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                if (handshakeStatus == null) {
                    if (handshakeStatus2 == null) return false;
                    return true;
                } else if (((Object)((Object)handshakeStatus)).equals((Object)((Object)handshakeStatus2))) return false;
                return true;
            }

            public boolean isCompleted() {
                return this.$outer.inputBunch().isCancelled(1) || this.$outer.inputBunch().isDepleted(1);
            }
        };
        this.userOutCancelled = new TransferState(this){
            private final /* synthetic */ TLSActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean isReady() {
                return this.$outer.outputBunch().isCancelled(1);
            }

            public boolean isCompleted() {
                return this.$outer.engine().isInboundDone() || this.$outer.outputBunch().isErrored(1);
            }
        };
        this.outbound = this.userHasData().$bar$bar(this.engineNeedsWrap()).$amp$amp(this.outputBunch().demandAvailableFor(0));
        this.inbound = this.transportInChoppingBlock.$amp$amp(this.outputBunch().demandAvailableFor(1)).$bar$bar(this.userOutCancelled());
        this.outboundHalfClosed = this.engineNeedsWrap().$amp$amp(this.outputBunch().demandAvailableFor(0));
        this.inboundHalfClosed = this.transportInChoppingBlock.$amp$amp(this.engineInboundOpen());
        this.bidirectional = TransferPhase$.MODULE$.apply(this.outbound().$bar$bar(this.inbound()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            boolean bl;
            if (tracing) {
                this.log().debug("bidirectional");
            }
            if (bl = this.doInbound(false, this.inbound())) {
                if (tracing) {
                    this.log().debug("bidirectional continue");
                }
                this.doOutbound(false);
                return;
            }
        });
        this.flushingOutbound = TransferPhase$.MODULE$.apply(this.outboundHalfClosed(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (tracing) {
                this.log().debug("flushingOutbound");
            }
            try {
                this.doWrap();
            }
            catch (SSLException sSLException) {
                this.nextPhase(this.completedPhase());
            }
        });
        this.awaitingClose = TransferPhase$.MODULE$.apply(this.inputBunch().inputsAvailableFor(0).$amp$amp(this.engineInboundOpen()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (tracing) {
                this.log().debug("awaitingClose");
            }
            this.transportInChoppingBlock.chopInto(this.transportInBuffer);
            try {
                this.doUnwrap(true);
            }
            catch (SSLException sSLException) {
                this.nextPhase(this.completedPhase());
            }
        });
        this.outboundClosed = TransferPhase$.MODULE$.apply(this.outboundHalfClosed().$bar$bar(this.inbound()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            boolean bl;
            if (tracing) {
                this.log().debug("outboundClosed");
            }
            if ((bl = this.doInbound(true, this.inbound())) && this.outboundHalfClosed().isReady()) {
                if (tracing) {
                    this.log().debug("outboundClosed continue");
                }
                try {
                    this.doWrap();
                }
                catch (SSLException sSLException) {
                    this.nextPhase(this.completedPhase());
                }
                return;
            }
        });
        this.inboundClosed = TransferPhase$.MODULE$.apply(this.outbound().$bar$bar(this.inboundHalfClosed()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            boolean bl;
            if (tracing) {
                this.log().debug("inboundClosed");
            }
            if (bl = this.doInbound(false, this.inboundHalfClosed())) {
                if (tracing) {
                    this.log().debug("inboundClosed continue");
                }
                this.doOutbound(true);
                return;
            }
        });
        this.initialPhase(2, this.bidirectional());
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public TransferState org$apache$pekko$stream$impl$Pump$$transferState() {
        return this.org$apache$pekko$stream$impl$Pump$$transferState;
    }

    public Function0 org$apache$pekko$stream$impl$Pump$$currentAction() {
        return this.org$apache$pekko$stream$impl$Pump$$currentAction;
    }

    @Override
    public final TransferPhase completedPhase() {
        return this.completedPhase;
    }

    @Override
    public void org$apache$pekko$stream$impl$Pump$$transferState_$eq(TransferState x$1) {
        this.org$apache$pekko$stream$impl$Pump$$transferState = x$1;
    }

    public void org$apache$pekko$stream$impl$Pump$$currentAction_$eq(Function0 x$1) {
        this.org$apache$pekko$stream$impl$Pump$$currentAction = x$1;
    }

    @Override
    public void org$apache$pekko$stream$impl$Pump$_setter_$completedPhase_$eq(TransferPhase x$0) {
        this.completedPhase = x$0;
    }

    public FanOut.OutputBunch outputBunch() {
        return this.outputBunch;
    }

    public FanIn.InputBunch inputBunch() {
        return this.inputBunch;
    }

    public SSLEngineResult.HandshakeStatus lastHandshakeStatus() {
        return this.lastHandshakeStatus;
    }

    public void lastHandshakeStatus_$eq(SSLEngineResult.HandshakeStatus x$1) {
        this.lastHandshakeStatus = x$1;
    }

    public boolean corkUser() {
        return this.corkUser;
    }

    public void corkUser_$eq(boolean x$1) {
        this.corkUser = x$1;
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public SSLSession currentSession() {
        return this.currentSession;
    }

    public void currentSession_$eq(SSLSession x$1) {
        this.currentSession = x$1;
    }

    public void setNewSessionParameters(TLSProtocol.NegotiateNewSession params) {
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug(new StringBuilder(9).append("applying ").append(params).toString());
        }
        this.currentSession().invalidate();
        TlsUtils$.MODULE$.applySessionParameters(this.engine(), params);
        this.engine().beginHandshake();
        this.lastHandshakeStatus_$eq(this.engine().getHandshakeStatus());
        this.corkUser_$eq(true);
    }

    public TransferState engineNeedsWrap() {
        return this.engineNeedsWrap;
    }

    public TransferState engineInboundOpen() {
        return this.engineInboundOpen;
    }

    public TransferState userHasData() {
        return this.userHasData;
    }

    public TransferState userOutCancelled() {
        return this.userOutCancelled;
    }

    public TransferState outbound() {
        return this.outbound;
    }

    public TransferState inbound() {
        return this.inbound;
    }

    public TransferState outboundHalfClosed() {
        return this.outboundHalfClosed;
    }

    public TransferState inboundHalfClosed() {
        return this.inboundHalfClosed;
    }

    public TransferPhase bidirectional() {
        return this.bidirectional;
    }

    public TransferPhase flushingOutbound() {
        return this.flushingOutbound;
    }

    public TransferPhase awaitingClose() {
        return this.awaitingClose;
    }

    public TransferPhase outboundClosed() {
        return this.outboundClosed;
    }

    public TransferPhase inboundClosed() {
        return this.inboundClosed;
    }

    public void completeOrFlush() {
        if (this.engine().isOutboundDone() || this.engine().isInboundDone() && this.org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock.isEmpty()) {
            this.nextPhase(this.completedPhase());
            return;
        }
        this.nextPhase(this.flushingOutbound());
    }

    private boolean doInbound(boolean isOutboundClosed, TransferState inboundState) {
        if (this.inputBunch().isDepleted(0) && this.transportInChoppingBlock.isEmpty()) {
            if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                this.log().debug("closing inbound");
            }
            try {
                this.engine().closeInbound();
            }
            catch (SSLException sSLException) {
                this.outputBunch().enqueue(1, TLSProtocol$SessionTruncated$.MODULE$);
            }
            this.lastHandshakeStatus_$eq(this.engine().getHandshakeStatus());
            this.completeOrFlush();
            return false;
        }
        TransferState transferState = inboundState;
        TransferState transferState2 = this.inboundHalfClosed();
        if ((transferState == null ? transferState2 != null : !transferState.equals(transferState2)) && this.outputBunch().isCancelled(1)) {
            if (!isOutboundClosed && this.closing.ignoreCancel()) {
                if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.log().debug("ignoring UserIn cancellation");
                }
                this.nextPhase(this.inboundClosed());
            } else {
                if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.log().debug("closing inbound due to UserOut cancellation");
                }
                this.engine().closeOutbound();
                this.lastHandshakeStatus_$eq(this.engine().getHandshakeStatus());
                this.nextPhase(this.flushingOutbound());
            }
            return true;
        }
        if (inboundState.isReady()) {
            boolean bl;
            this.transportInChoppingBlock.chopInto(this.transportInBuffer);
            try {
                this.doUnwrap(false);
                bl = true;
            }
            catch (SSLException ex) {
                if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.log().debug(new StringBuilder(30).append("SSLException during doUnwrap: ").append(ex).toString());
                }
                this.fail(ex, false);
                this.engine().closeInbound();
                this.completeOrFlush();
                bl = false;
            }
            return bl;
        }
        return true;
    }

    private void doOutbound(boolean isInboundClosed) {
        if (this.inputBunch().isDepleted(1) && this.org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock.isEmpty() && this.mayCloseOutbound()) {
            if (!isInboundClosed && this.closing.ignoreComplete()) {
                if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.log().debug("ignoring closeOutbound");
                }
            } else {
                if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.log().debug("closing outbound directly");
                }
                this.engine().closeOutbound();
                this.lastHandshakeStatus_$eq(this.engine().getHandshakeStatus());
            }
            this.nextPhase(this.outboundClosed());
            return;
        }
        if (this.outputBunch().isCancelled(0)) {
            if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                this.log().debug("shutting down because TransportOut is cancelled");
            }
            this.nextPhase(this.completedPhase());
            return;
        }
        if (this.outbound().isReady()) {
            if (this.userHasData().isReady()) {
                this.org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock.chopInto(this.userInBuffer);
            }
            try {
                this.doWrap();
            }
            catch (SSLException ex) {
                if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.log().debug(new StringBuilder(28).append("SSLException during doWrap: ").append(ex).toString());
                }
                this.fail(ex, false);
                this.completeOrFlush();
            }
            return;
        }
    }

    private boolean mayCloseOutbound() {
        block6: {
            block3: {
                SSLEngineResult.HandshakeStatus handshakeStatus;
                SSLEngineResult.HandshakeStatus handshakeStatus2;
                block5: {
                    SSLEngineResult.HandshakeStatus handshakeStatus3;
                    block4: {
                        SSLEngineResult.HandshakeStatus handshakeStatus4;
                        SSLEngineResult.HandshakeStatus handshakeStatus5;
                        block2: {
                            handshakeStatus3 = this.lastHandshakeStatus();
                            handshakeStatus5 = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                            handshakeStatus4 = handshakeStatus3;
                            if (handshakeStatus5 != null) break block2;
                            if (handshakeStatus4 == null) break block3;
                            break block4;
                        }
                        if (((Object)((Object)handshakeStatus5)).equals((Object)handshakeStatus4)) break block3;
                    }
                    handshakeStatus2 = SSLEngineResult.HandshakeStatus.FINISHED;
                    handshakeStatus = handshakeStatus3;
                    if (handshakeStatus2 != null) break block5;
                    if (handshakeStatus == null) break block3;
                    break block6;
                }
                if (!((Object)((Object)handshakeStatus2)).equals((Object)handshakeStatus)) break block6;
            }
            return true;
        }
        return false;
    }

    public void flushToTransport() {
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug("flushToTransport");
        }
        this.transportOutBuffer.flip();
        if (this.transportOutBuffer.hasRemaining()) {
            ByteString bs = ByteString$.MODULE$.apply(this.transportOutBuffer);
            this.outputBunch().enqueue(0, bs);
            if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                this.log().debug(new StringBuilder(14).append("sending ").append(bs.size()).append(" bytes").toString());
            }
        }
        this.transportOutBuffer.clear();
    }

    public void flushToUser() {
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug("flushToUser");
        }
        if (this.unwrapPutBackCounter > 0) {
            this.unwrapPutBackCounter = 0;
        }
        this.userOutBuffer.flip();
        if (this.userOutBuffer.hasRemaining()) {
            ByteString bs = ByteString$.MODULE$.apply(this.userOutBuffer);
            this.outputBunch().enqueue(1, TLSProtocol$SessionBytes$.MODULE$.apply(this.currentSession(), bs));
        }
        this.userOutBuffer.clear();
    }

    private void doWrap() {
        SSLEngineResult result = this.engine().wrap(this.userInBuffer, this.transportOutBuffer);
        this.lastHandshakeStatus_$eq(result.getHandshakeStatus());
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug(new StringBuilder(40).append("wrap: status=").append((Object)result.getStatus()).append(" handshake=").append((Object)this.lastHandshakeStatus()).append(" remaining=").append(this.userInBuffer.remaining()).append(" out=").append(this.transportOutBuffer.position()).toString());
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.lastHandshakeStatus();
        SSLEngineResult.HandshakeStatus handshakeStatus2 = SSLEngineResult.HandshakeStatus.FINISHED;
        if (!(handshakeStatus != null ? !((Object)((Object)handshakeStatus)).equals((Object)handshakeStatus2) : handshakeStatus2 != null)) {
            this.handshakeFinished();
        }
        this.runDelegatedTasks();
        SSLEngineResult.Status status = result.getStatus();
        SSLEngineResult.Status status2 = SSLEngineResult.Status.OK;
        SSLEngineResult.Status status3 = status;
        if (!(status2 != null ? !((Object)((Object)status2)).equals((Object)status3) : status3 != null)) {
            if (this.transportOutBuffer.position() == 0) {
                SSLEngineResult.HandshakeStatus handshakeStatus3 = this.lastHandshakeStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus4 = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                if (!(handshakeStatus3 != null ? !((Object)((Object)handshakeStatus3)).equals((Object)handshakeStatus4) : handshakeStatus4 != null)) {
                    throw new IllegalStateException("SSLEngine trying to loop NEED_WRAP without producing output");
                }
            }
            this.flushToTransport();
            this.org$apache$pekko$stream$impl$io$TLSActor$$userInChoppingBlock.putBack(this.userInBuffer);
            return;
        }
        SSLEngineResult.Status status4 = SSLEngineResult.Status.CLOSED;
        SSLEngineResult.Status status5 = status;
        if (!(status4 != null ? !((Object)((Object)status4)).equals((Object)status5) : status5 != null)) {
            this.flushToTransport();
            if (this.engine().isInboundDone()) {
                this.nextPhase(this.completedPhase());
                return;
            }
            this.nextPhase(this.awaitingClose());
            return;
        }
        SSLEngineResult.Status s = status;
        this.fail(new IllegalStateException(new StringBuilder(30).append("unexpected status ").append((Object)s).append(" in doWrap()").toString()), this.fail$default$2());
    }

    private void doUnwrap(boolean ignoreOutput) {
        SSLEngineResult.Status status;
        block12: {
            while (true) {
                int oldInPosition = this.transportInBuffer.position();
                SSLEngineResult result = this.engine().unwrap(this.transportInBuffer, this.userOutBuffer);
                if (ignoreOutput) {
                    this.userOutBuffer.clear();
                }
                this.lastHandshakeStatus_$eq(result.getHandshakeStatus());
                if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.log().debug(new StringBuilder(42).append("unwrap: status=").append((Object)result.getStatus()).append(" handshake=").append((Object)this.lastHandshakeStatus()).append(" remaining=").append(this.transportInBuffer.remaining()).append(" out=").append(this.userOutBuffer.position()).toString());
                }
                this.runDelegatedTasks();
                status = result.getStatus();
                SSLEngineResult.Status status2 = SSLEngineResult.Status.OK;
                SSLEngineResult.Status status3 = status;
                if (status2 != null ? !((Object)((Object)status2)).equals((Object)status3) : status3 != null) break block12;
                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus2 = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                SSLEngineResult.HandshakeStatus handshakeStatus3 = handshakeStatus;
                if (!(handshakeStatus2 != null ? !((Object)((Object)handshakeStatus2)).equals((Object)handshakeStatus3) : handshakeStatus3 != null)) {
                    ++this.unwrapPutBackCounter;
                    if (this.unwrapPutBackCounter > this.maxTLSIterations) {
                        throw new IllegalStateException(new StringBuilder(105).append("Stuck in unwrap loop, bailing out, last handshake status [").append((Object)this.lastHandshakeStatus()).append("], ").append(new StringBuilder(18).append("remaining=").append(this.transportInBuffer.remaining()).append(", out=").append(this.userOutBuffer.position()).append(", ").toString()).append("(https://github.com/apache/pekko/issues/442)").toString());
                    }
                    this.transportInChoppingBlock.putBack(this.transportInBuffer);
                    return;
                }
                SSLEngineResult.HandshakeStatus handshakeStatus4 = SSLEngineResult.HandshakeStatus.FINISHED;
                SSLEngineResult.HandshakeStatus handshakeStatus5 = handshakeStatus;
                if (!(handshakeStatus4 != null ? !((Object)((Object)handshakeStatus4)).equals((Object)handshakeStatus5) : handshakeStatus5 != null)) {
                    this.flushToUser();
                    this.handshakeFinished();
                    this.transportInChoppingBlock.putBack(this.transportInBuffer);
                    return;
                }
                SSLEngineResult.HandshakeStatus handshakeStatus6 = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                SSLEngineResult.HandshakeStatus handshakeStatus7 = handshakeStatus;
                if (!(handshakeStatus6 != null ? !((Object)((Object)handshakeStatus6)).equals((Object)handshakeStatus7) : handshakeStatus7 != null)) {
                    if (this.transportInBuffer.hasRemaining() && this.userOutBuffer.position() == 0 && this.transportInBuffer.position() == oldInPosition) {
                        throw new IllegalStateException("SSLEngine trying to loop NEED_UNWRAP without producing output");
                    }
                }
                if (!this.transportInBuffer.hasRemaining()) break;
                ignoreOutput = false;
            }
            this.flushToUser();
            return;
        }
        SSLEngineResult.Status status4 = SSLEngineResult.Status.CLOSED;
        SSLEngineResult.Status status5 = status;
        if (!(status4 != null ? !((Object)((Object)status4)).equals((Object)status5) : status5 != null)) {
            this.flushToUser();
            this.completeOrFlush();
            return;
        }
        SSLEngineResult.Status status6 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
        SSLEngineResult.Status status7 = status;
        if (!(status6 != null ? !((Object)((Object)status6)).equals((Object)status7) : status7 != null)) {
            this.flushToUser();
            return;
        }
        SSLEngineResult.Status status8 = SSLEngineResult.Status.BUFFER_OVERFLOW;
        SSLEngineResult.Status status9 = status;
        if (!(status8 != null ? !((Object)((Object)status8)).equals((Object)status9) : status9 != null)) {
            this.flushToUser();
            this.transportInChoppingBlock.putBack(this.transportInBuffer);
            return;
        }
        if (status == null) {
            this.fail(new IllegalStateException("unexpected status 'null' in doUnwrap()"), this.fail$default$2());
            return;
        }
        throw new MatchError((Object)status);
    }

    private void runDelegatedTasks() {
        Runnable task;
        while ((task = this.engine().getDelegatedTask()) != null) {
            if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                this.log().debug("running task");
            }
            task.run();
        }
        SSLEngineResult.HandshakeStatus st = this.lastHandshakeStatus();
        this.lastHandshakeStatus_$eq(this.engine().getHandshakeStatus());
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            SSLEngineResult.HandshakeStatus handshakeStatus = st;
            SSLEngineResult.HandshakeStatus handshakeStatus2 = this.lastHandshakeStatus();
            if (handshakeStatus == null ? handshakeStatus2 != null : !((Object)((Object)handshakeStatus)).equals((Object)handshakeStatus2)) {
                this.log().debug(new StringBuilder(30).append("handshake status after tasks: ").append((Object)this.lastHandshakeStatus()).toString());
                return;
            }
        }
    }

    private void handshakeFinished() {
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug("handshake finished");
        }
        SSLSession session = this.engine().getSession();
        Try try_ = (Try)this.verifySession.apply((Object)this.context().system(), (Object)session);
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = ((Success)try_).value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                this.currentSession_$eq(session);
                this.corkUser_$eq(false);
                this.flushToUser();
                return;
            }
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            this.fail(ex, true);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.inputBunch().subreceive().orElse(this.outputBunch().subreceive()).orElse((PartialFunction)new Serializable(this){
            private final /* synthetic */ TLSActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return ActorGraphInterpreter$Snapshot$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (ActorGraphInterpreter$Snapshot$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)StreamSnapshotImpl$.MODULE$.apply(this.$outer.self().path(), (Seq<RunningInterpreter>)((Seq)package$.MODULE$.Seq().empty()), (Seq<UninitializedInterpreter>)((Seq)package$.MODULE$.Seq().empty())), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        });
    }

    public void fail(Throwable e, boolean closeTransport) {
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug("fail {} due to: {}", (Object)this.self(), (Object)e.getMessage());
        }
        this.inputBunch().cancel();
        if (closeTransport) {
            this.log().debug("closing output");
            this.outputBunch().error(0, e);
        }
        this.outputBunch().error(1, e);
        this.pump();
    }

    public boolean fail$default$2() {
        return true;
    }

    public void postStop() {
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug("postStop");
        }
        Actor.postStop$((Actor)this);
    }

    @Override
    public void pumpFailed(Throwable e) {
        this.fail(e, this.fail$default$2());
    }

    @Override
    public void pumpFinished() {
        this.inputBunch().cancel();
        this.outputBunch().complete();
        if (this.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
            this.log().debug(new StringBuilder(39).append("STOP Outbound Closed: ").append(this.engine().isOutboundDone()).append(" Inbound closed: ").append(this.engine().isInboundDone()).toString());
        }
        this.context().stop(this.self());
    }

    private final SSLEngine liftedTree1$1(Function1 createSSLEngine$1) {
        SSLEngine sSLEngine;
        try {
            sSLEngine = (SSLEngine)createSSLEngine$1.apply((Object)this.context().system());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                this.fail(ex, true);
                throw ex;
            }
            throw throwable;
        }
        return sSLEngine;
    }

    public class ChoppingBlock
    implements TransferState {
        private final int idx;
        private final String name;
        private ByteString buffer;
        private final /* synthetic */ TLSActor $outer;

        public ChoppingBlock(TLSActor $outer, int idx, String name) {
            this.idx = idx;
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.buffer = ByteString$.MODULE$.empty();
        }

        @Override
        public boolean isReady() {
            return this.buffer.nonEmpty() || this.$outer.inputBunch().isPending(this.idx) || this.$outer.inputBunch().isDepleted(this.idx);
        }

        @Override
        public boolean isCompleted() {
            return this.$outer.inputBunch().isCancelled(this.idx);
        }

        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        public void chopInto(ByteBuffer b) {
            b.compact();
            if (this.buffer.isEmpty()) {
                ByteString byteString;
                Object object = this.$outer.inputBunch().dequeue(this.idx);
                if (object instanceof ByteString) {
                    ByteString bs;
                    byteString = bs = (ByteString)object;
                } else if (object instanceof TLSProtocol.SendBytes) {
                    ByteString byteString2;
                    ByteString bs;
                    TLSProtocol.SendBytes sendBytes = TLSProtocol$SendBytes$.MODULE$.unapply((TLSProtocol.SendBytes)object);
                    byteString = bs = (byteString2 = sendBytes._1());
                } else if (object instanceof TLSProtocol.NegotiateNewSession) {
                    TLSProtocol.NegotiateNewSession n = (TLSProtocol.NegotiateNewSession)object;
                    this.$outer.setNewSessionParameters(n);
                    byteString = ByteString$.MODULE$.empty();
                } else {
                    throw new RuntimeException();
                }
                this.buffer = byteString;
                if (this.$outer.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.$outer.log().debug(new StringBuilder(36).append("chopping from new chunk of ").append(this.buffer.size()).append(" into ").append(this.name).append(" (").append(b.position()).append(")").toString());
                }
            } else if (this.$outer.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                this.$outer.log().debug(new StringBuilder(36).append("chopping from old chunk of ").append(this.buffer.size()).append(" into ").append(this.name).append(" (").append(b.position()).append(")").toString());
            }
            int copied = this.buffer.copyToBuffer(b);
            this.buffer = this.buffer.drop(copied);
            b.flip();
        }

        public void putBack(ByteBuffer b) {
            if (b.hasRemaining()) {
                ByteString bs;
                if (this.$outer.org$apache$pekko$stream$impl$io$TLSActor$$tracing) {
                    this.$outer.log().debug(new StringBuilder(25).append("putting back ").append(b.remaining()).append(" bytes into ").append(this.name).toString());
                }
                if ((bs = ByteString$.MODULE$.apply(b)).nonEmpty()) {
                    this.buffer = bs.$plus$plus(this.buffer);
                }
                this.prepare(b);
                return;
            }
        }

        public void prepare(ByteBuffer b) {
            b.clear();
            b.limit(0);
        }

        public final /* synthetic */ TLSActor org$apache$pekko$stream$impl$io$TLSActor$ChoppingBlock$$$outer() {
            return this.$outer;
        }
    }
}

