/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.stream.impl.ActorPublisher;
import org.apache.pekko.stream.impl.ActorSubscription;
import org.apache.pekko.stream.impl.Cancel;
import org.apache.pekko.stream.impl.Cancel$;
import org.apache.pekko.stream.impl.DefaultOutputTransferStates;
import org.apache.pekko.stream.impl.ExposedPublisher;
import org.apache.pekko.stream.impl.ExposedPublisher$;
import org.apache.pekko.stream.impl.Outputs;
import org.apache.pekko.stream.impl.Pump;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.RequestMore;
import org.apache.pekko.stream.impl.RequestMore$;
import org.apache.pekko.stream.impl.SubReceive;
import org.apache.pekko.stream.impl.SubscribePending$;
import org.apache.pekko.stream.impl.TransferState;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public class SimpleOutputs
implements Outputs,
DefaultOutputTransferStates {
    private TransferState NeedsDemand;
    private final ActorRef actor;
    private final Pump pump;
    private ActorPublisher exposedPublisher;
    private Subscriber subscriber;
    private long downstreamDemand;
    private boolean downstreamCompleted;
    private final SubReceive _subreceive;

    public SimpleOutputs(ActorRef actor, Pump pump) {
        this.actor = actor;
        this.pump = pump;
        DefaultOutputTransferStates.$init$(this);
        this.downstreamDemand = 0L;
        this.downstreamCompleted = false;
        this._subreceive = new SubReceive(this.waitingExposedPublisher());
        Statics.releaseFence();
    }

    @Override
    public TransferState NeedsDemand() {
        return this.NeedsDemand;
    }

    @Override
    public void org$apache$pekko$stream$impl$DefaultOutputTransferStates$_setter_$NeedsDemand_$eq(TransferState x$0) {
        this.NeedsDemand = x$0;
    }

    public ActorRef actor() {
        return this.actor;
    }

    public Pump pump() {
        return this.pump;
    }

    public ActorPublisher<Object> exposedPublisher() {
        return this.exposedPublisher;
    }

    public void exposedPublisher_$eq(ActorPublisher<Object> x$1) {
        this.exposedPublisher = x$1;
    }

    public Subscriber<Object> subscriber() {
        return this.subscriber;
    }

    public void subscriber_$eq(Subscriber<Object> x$1) {
        this.subscriber = x$1;
    }

    public long downstreamDemand() {
        return this.downstreamDemand;
    }

    public void downstreamDemand_$eq(long x$1) {
        this.downstreamDemand = x$1;
    }

    public boolean downstreamCompleted() {
        return this.downstreamCompleted;
    }

    public void downstreamCompleted_$eq(boolean x$1) {
        this.downstreamCompleted = x$1;
    }

    @Override
    public boolean demandAvailable() {
        return this.downstreamDemand() > 0L;
    }

    @Override
    public long demandCount() {
        return this.downstreamDemand();
    }

    @Override
    public SubReceive subreceive() {
        return this._subreceive;
    }

    public boolean isSubscribed() {
        return this.subscriber() != null;
    }

    @Override
    public void enqueueOutputElement(Object elem) {
        ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(elem);
        this.downstreamDemand_$eq(this.downstreamDemand() - 1L);
        ReactiveStreamsCompliance$.MODULE$.tryOnNext(this.subscriber(), elem);
    }

    @Override
    public void complete() {
        if (!this.downstreamCompleted()) {
            this.downstreamCompleted_$eq(true);
            if (this.exposedPublisher() != null) {
                this.exposedPublisher().shutdown((Option<Throwable>)None$.MODULE$);
            }
            if (this.subscriber() != null) {
                ReactiveStreamsCompliance$.MODULE$.tryOnComplete(this.subscriber());
                return;
            }
            return;
        }
    }

    @Override
    public void cancel() {
        if (!this.downstreamCompleted()) {
            this.downstreamCompleted_$eq(true);
            if (this.exposedPublisher() != null) {
                this.exposedPublisher().shutdown((Option<Throwable>)None$.MODULE$);
                return;
            }
            return;
        }
    }

    @Override
    public void error(Throwable e) {
        if (!this.downstreamCompleted()) {
            this.downstreamCompleted_$eq(true);
            if (this.exposedPublisher() != null) {
                this.exposedPublisher().shutdown((Option<Throwable>)Some$.MODULE$.apply((Object)e));
            }
            if (this.subscriber() != null && !(e instanceof ReactiveStreamsCompliance.SpecViolation)) {
                ReactiveStreamsCompliance$.MODULE$.tryOnError(this.subscriber(), e);
                return;
            }
            return;
        }
    }

    @Override
    public boolean isClosed() {
        return this.downstreamCompleted() && this.subscriber() != null;
    }

    public Subscription createSubscription() {
        return new ActorSubscription<Object>(this.actor(), this.subscriber());
    }

    public void org$apache$pekko$stream$impl$SimpleOutputs$$subscribePending(Seq<Subscriber<Object>> subscribers) {
        subscribers.foreach((Function1)(JProcedure1 & Serializable)sub -> {
            if (this.subscriber() == null) {
                this.subscriber_$eq((Subscriber<Object>)sub);
                ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(this.subscriber(), this.createSubscription());
                return;
            }
            ReactiveStreamsCompliance$.MODULE$.rejectAdditionalSubscriber(sub, String.valueOf(Logging$.MODULE$.simpleName((Object)this)));
        });
    }

    public PartialFunction<Object, BoxedUnit> waitingExposedPublisher() {
        return new Serializable(this){
            private final /* synthetic */ SimpleOutputs $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ExposedPublisher) {
                    ActorPublisher<Object> actorPublisher;
                    ExposedPublisher exposedPublisher = ExposedPublisher$.MODULE$.unapply((ExposedPublisher)object);
                    ActorPublisher<Object> publisher = actorPublisher = exposedPublisher._1();
                    return true;
                }
                Object other = object;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                ActorPublisher<Object> actorPublisher;
                Object object = x;
                if (!(object instanceof ExposedPublisher)) {
                    Object other = object;
                    throw new IllegalStateException(new StringBuilder(53).append("The first message must be ExposedPublisher but was [").append(other).append("]").toString());
                }
                ExposedPublisher exposedPublisher = ExposedPublisher$.MODULE$.unapply((ExposedPublisher)object);
                ActorPublisher<Object> publisher = actorPublisher = exposedPublisher._1();
                this.$outer.exposedPublisher_$eq(publisher);
                this.$outer.subreceive().become(this.$outer.downstreamRunning());
                return BoxedUnit.UNIT;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> downstreamRunning() {
        return new Serializable(this){
            private final /* synthetic */ SimpleOutputs $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (SubscribePending$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RequestMore) {
                    long l;
                    RequestMore<T> requestMore = RequestMore$.MODULE$.unapply((RequestMore)object);
                    ActorSubscription<T> actorSubscription = requestMore._1();
                    long elements = l = requestMore._2();
                    return true;
                }
                if (object instanceof Cancel) {
                    Cancel<T> cancel = Cancel$.MODULE$.unapply((Cancel)object);
                    ActorSubscription<T> actorSubscription = cancel._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (SubscribePending$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$stream$impl$SimpleOutputs$$subscribePending(this.$outer.exposedPublisher().takePendingSubscribers());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RequestMore) {
                    RequestMore<T> requestMore = RequestMore$.MODULE$.unapply((RequestMore)object);
                    ActorSubscription<T> actorSubscription = requestMore._1();
                    long l = requestMore._2();
                    long elements = l;
                    if (elements < 1L) {
                        this.$outer.error(ReactiveStreamsCompliance$.MODULE$.numberOfElementsInRequestMustBePositiveException());
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.downstreamDemand_$eq(this.$outer.downstreamDemand() + elements);
                    if (this.$outer.downstreamDemand() < 1L) {
                        this.$outer.downstreamDemand_$eq(Long.MAX_VALUE);
                    }
                    this.$outer.pump().pump();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Cancel) {
                    Cancel<T> cancel = Cancel$.MODULE$.unapply((Cancel)object);
                    ActorSubscription<T> actorSubscription = cancel._1();
                    this.$outer.downstreamCompleted_$eq(true);
                    this.$outer.exposedPublisher().shutdown((Option<Throwable>)Some$.MODULE$.apply((Object)new ActorPublisher.NormalShutdownException()));
                    this.$outer.pump().pump();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }
}

