/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io.compression;

import java.util.zip.Deflater;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.io.compression.Compressor;
import org.apache.pekko.stream.impl.io.compression.DeflateCompressor$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

@InternalApi
public class DeflateCompressor
extends Compressor {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DeflateCompressor.class.getDeclaredField("deflater$lzy1"));
    private final int level;
    private final boolean nowrap;
    private volatile Object deflater$lzy1;

    public static int MinBufferSize() {
        return DeflateCompressor$.MODULE$.MinBufferSize();
    }

    public static ByteString drainDeflater(Deflater deflater, byte[] byArray, ByteStringBuilder byteStringBuilder) {
        return DeflateCompressor$.MODULE$.drainDeflater(deflater, byArray, byteStringBuilder);
    }

    public static int $lessinit$greater$default$1() {
        return DeflateCompressor$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean $lessinit$greater$default$2() {
        return DeflateCompressor$.MODULE$.$lessinit$greater$default$2();
    }

    public static ByteStringBuilder drainDeflater$default$3() {
        return DeflateCompressor$.MODULE$.drainDeflater$default$3();
    }

    public DeflateCompressor(int level, boolean nowrap) {
        this.level = level;
        this.nowrap = nowrap;
    }

    public Deflater deflater() {
        Object object = this.deflater$lzy1;
        if (object instanceof Deflater) {
            return (Deflater)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Deflater)this.deflater$lzyINIT1();
    }

    private Object deflater$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.deflater$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Deflater deflater = null;
                    try {
                        deflater = new Deflater(this.level, this.nowrap);
                        object2 = deflater == null ? LazyVals.NullValue$.MODULE$ : deflater;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.deflater$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return deflater;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final ByteString compressAndFlush(ByteString input) {
        byte[] buffer = this.newTempBuffer(input.length());
        return this.compressWithBuffer(input, buffer).$plus$plus(this.flushWithBuffer(buffer));
    }

    @Override
    public final ByteString compressAndFinish(ByteString input) {
        byte[] buffer = this.newTempBuffer(input.length());
        return this.compressWithBuffer(input, buffer).$plus$plus(this.finishWithBuffer(buffer));
    }

    @Override
    public final ByteString compress(ByteString input) {
        return this.compressWithBuffer(input, this.newTempBuffer(this.newTempBuffer$default$1()));
    }

    @Override
    public final ByteString flush() {
        return this.flushWithBuffer(this.newTempBuffer(this.newTempBuffer$default$1()));
    }

    @Override
    public final ByteString finish() {
        return this.finishWithBuffer(this.newTempBuffer(this.newTempBuffer$default$1()));
    }

    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        Predef$.MODULE$.require(this.deflater().needsInput());
        this.deflater().setInput(input.toArrayUnsafe());
        return DeflateCompressor$.MODULE$.drainDeflater(this.deflater(), buffer, DeflateCompressor$.MODULE$.drainDeflater$default$3());
    }

    public ByteString flushWithBuffer(byte[] buffer) {
        int written = this.deflater().deflate(buffer, 0, buffer.length, 2);
        return ByteString$.MODULE$.fromArray(buffer, 0, written);
    }

    public ByteString finishWithBuffer(byte[] buffer) {
        this.deflater().finish();
        ByteString res = DeflateCompressor$.MODULE$.drainDeflater(this.deflater(), buffer, DeflateCompressor$.MODULE$.drainDeflater$default$3());
        this.deflater().end();
        return res;
    }

    @Override
    public void close() {
        this.deflater().end();
    }

    private byte[] newTempBuffer(int size) {
        return new byte[package$.MODULE$.max(size, DeflateCompressor$.MODULE$.MinBufferSize())];
    }

    private int newTempBuffer$default$1() {
        return 65536;
    }
}

