/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.Supervision;
import org.apache.pekko.stream.Supervision$Restart$;
import org.apache.pekko.stream.Supervision$Resume$;
import org.apache.pekko.stream.Supervision$Stop$;
import org.apache.pekko.stream.impl.ContextPropagation;
import org.apache.pekko.stream.impl.ContextPropagation$;
import org.apache.pekko.stream.impl.fusing.Batch$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@InternalApi
public final class Batch<In, Out>
extends GraphStage<FlowShape<In, Out>>
implements Product,
Serializable {
    private final long max;
    private final Function1 costFn;
    private final Function1 seed;
    private final Function2 aggregate;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public static <In, Out> Batch<In, Out> apply(long l, Function1<In, Object> function1, Function1<In, Out> function12, Function2<Out, In, Out> function2) {
        return Batch$.MODULE$.apply(l, function1, function12, function2);
    }

    public static Batch<?, ?> fromProduct(Product product) {
        return Batch$.MODULE$.fromProduct(product);
    }

    public static <In, Out> Batch<In, Out> unapply(Batch<In, Out> batch) {
        return Batch$.MODULE$.unapply(batch);
    }

    public Batch(long max, Function1<In, Object> costFn, Function1<In, Out> seed, Function2<Out, In, Out> aggregate) {
        this.max = max;
        this.costFn = costFn;
        this.seed = seed;
        this.aggregate = aggregate;
        this.in = Inlet$.MODULE$.apply("Batch.in");
        this.out = Outlet$.MODULE$.apply("Batch.out");
        this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.max()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.costFn()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.seed()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.aggregate()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Batch)) return false;
        Batch batch = (Batch)object;
        if (this.max() != batch.max()) return false;
        Function1<In, Object> function1 = this.costFn();
        Function1<In, Object> function12 = batch.costFn();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function1<In, Out> function13 = this.seed();
        Function1<In, Out> function14 = batch.seed();
        if (function13 == null) {
            if (function14 != null) {
                return false;
            }
        } else if (!function13.equals(function14)) return false;
        Function2<Out, In, Out> function2 = this.aggregate();
        Function2<Out, In, Out> function22 = batch.aggregate();
        if (function2 == null) {
            if (function22 == null) return true;
            return false;
        } else {
            if (!function2.equals(function22)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Batch;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "Batch";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "max";
            }
            case 1: {
                return "costFn";
            }
            case 2: {
                return "seed";
            }
            case 3: {
                return "aggregate";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long max() {
        return this.max;
    }

    public Function1<In, Object> costFn() {
        return this.costFn;
    }

    public Function1<In, Out> seed() {
        return this.seed;
    }

    public Function2<Out, In, Out> aggregate() {
        return this.aggregate;
    }

    public Inlet<In> in() {
        return this.in;
    }

    public Outlet<Out> out() {
        return this.out;
    }

    @Override
    public FlowShape<In, Out> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(inheritedAttributes, this){
            private final Attributes inheritedAttributes$12;
            public static final long OFFSET$0;
            private volatile Object decider$lzy8;
            private Object agg;
            private long left;
            private Object pending;
            private final ContextPropagation contextPropagation;
            private final /* synthetic */ Batch $outer;
            {
                this.inheritedAttributes$12 = inheritedAttributes$31;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.agg = null;
                this.left = $outer.max();
                this.pending = null;
                this.contextPropagation = ContextPropagation$.MODULE$.apply();
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$25.class.getDeclaredField("decider$lzy8"));
            }

            public Function1 decider() {
                Object object = this.decider$lzy8;
                if (object instanceof Function1) {
                    return (Function1)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (Function1)this.decider$lzyINIT8();
            }

            private Object decider$lzyINIT8() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.decider$lzy8) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Function1<Throwable, Supervision.Directive> function1 = null;
                            Function1<Throwable, Supervision.Directive> function12 = null;
                            try {
                                function12 = ((ActorAttributes.SupervisionStrategy)this.inheritedAttributes$12.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.SupervisionStrategy.class))).decider();
                                function1 = function12 == null ? LazyVals.NullValue$.MODULE$ : function12;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, function1)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.decider$lzy8;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, function1);
                                    waiting.countDown();
                                }
                            }
                            return function12;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private void flush() {
                if (this.agg != null) {
                    this.push(this.$outer.out(), this.agg);
                    this.left = this.$outer.max();
                }
                if (this.pending != null) {
                    try {
                        this.agg = this.$outer.seed().apply(this.pending);
                        this.left -= BoxesRunTime.unboxToLong((Object)this.$outer.costFn().apply(this.pending));
                        this.pending = null;
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable ex = throwable3 = (Throwable)option.get();
                            Supervision.Directive directive = (Supervision.Directive)this.decider().apply((Object)ex);
                            if (Supervision$Stop$.MODULE$.equals(directive)) {
                                this.failStage(ex);
                            }
                            if (Supervision$Restart$.MODULE$.equals(directive)) {
                                this.restartState();
                            }
                            if (Supervision$Resume$.MODULE$.equals(directive)) {
                                this.pending = null;
                            }
                            throw new MatchError((Object)directive);
                        }
                        throw throwable;
                    }
                    return;
                }
                this.agg = null;
            }

            public void preStart() {
                this.pull(this.$outer.in());
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Lifted jumps to return sites
             */
            public void onPush() {
                block13: {
                    In elem = this.grab(this.$outer.in());
                    long cost = BoxesRunTime.unboxToLong((Object)this.$outer.costFn().apply(elem));
                    this.contextPropagation.suspendContext();
                    if (this.agg == null) {
                        try {
                            this.agg = this.$outer.seed().apply(elem);
                            this.left -= cost;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            Throwable throwable3 = throwable;
                            if (throwable3 == null) throw throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable3);
                            if (option.isEmpty()) throw throwable;
                            Throwable ex = throwable2 = (Throwable)option.get();
                            Supervision.Directive directive = (Supervision.Directive)this.decider().apply((Object)ex);
                            if (Supervision$Stop$.MODULE$.equals(directive)) {
                                this.failStage(ex);
                                break block13;
                            }
                            if (Supervision$Restart$.MODULE$.equals(directive)) {
                                this.restartState();
                                break block13;
                            }
                            if (!Supervision$Resume$.MODULE$.equals(directive)) throw new MatchError((Object)directive);
                        }
                    } else if (this.left < cost) {
                        this.pending = elem;
                    } else {
                        try {
                            this.agg = this.$outer.aggregate().apply(this.agg, elem);
                            this.left -= cost;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable4;
                            Throwable throwable5 = throwable;
                            if (throwable5 == null) throw throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable5);
                            if (option.isEmpty()) throw throwable;
                            Throwable ex = throwable4 = (Throwable)option.get();
                            Supervision.Directive directive = (Supervision.Directive)this.decider().apply((Object)ex);
                            if (Supervision$Stop$.MODULE$.equals(directive)) {
                                this.failStage(ex);
                            }
                            if (Supervision$Restart$.MODULE$.equals(directive)) {
                                this.restartState();
                            }
                            if (!Supervision$Resume$.MODULE$.equals(directive)) throw new MatchError((Object)directive);
                        }
                    }
                }
                if (this.isAvailable(this.$outer.out())) {
                    this.flush();
                }
                if (this.pending != null) return;
                this.pull(this.$outer.in());
            }

            public void onUpstreamFinish() {
                if (this.agg == null) {
                    this.completeStage();
                    return;
                }
            }

            public void onPull() {
                if (this.agg == null) {
                    if (this.isClosed(this.$outer.in())) {
                        this.completeStage();
                        return;
                    }
                    if (!this.hasBeenPulled(this.$outer.in())) {
                        this.pull(this.$outer.in());
                        return;
                    }
                    return;
                }
                if (this.isClosed(this.$outer.in())) {
                    block12: {
                        this.contextPropagation.resumeContext();
                        this.push(this.$outer.out(), this.agg);
                        if (this.pending == null) {
                            this.completeStage();
                            return;
                        }
                        try {
                            this.agg = this.$outer.seed().apply(this.pending);
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3;
                                Throwable ex = throwable3 = (Throwable)option.get();
                                Supervision.Directive directive = (Supervision.Directive)this.decider().apply((Object)ex);
                                if (Supervision$Stop$.MODULE$.equals(directive)) {
                                    this.failStage(ex);
                                }
                                if (Supervision$Resume$.MODULE$.equals(directive)) break block12;
                                if (Supervision$Restart$.MODULE$.equals(directive)) {
                                    this.restartState();
                                    if (!this.hasBeenPulled(this.$outer.in())) {
                                        this.pull(this.$outer.in());
                                    }
                                }
                                throw new MatchError((Object)directive);
                            }
                            throw throwable;
                        }
                    }
                    this.pending = null;
                    return;
                }
                this.contextPropagation.resumeContext();
                this.flush();
                if (!this.hasBeenPulled(this.$outer.in())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            private void restartState() {
                this.agg = null;
                this.left = this.$outer.max();
                this.pending = null;
            }
        };
    }

    public <In, Out> Batch<In, Out> copy(long max, Function1<In, Object> costFn, Function1<In, Out> seed, Function2<Out, In, Out> aggregate) {
        return new Batch<In, Out>(max, costFn, seed, aggregate);
    }

    public long copy$default$1() {
        return this.max();
    }

    public <In, Out> Function1<In, Object> copy$default$2() {
        return this.costFn();
    }

    public <In, Out> Function1<In, Out> copy$default$3() {
        return this.seed();
    }

    public <In, Out> Function2<Out, In, Out> copy$default$4() {
        return this.aggregate();
    }

    public long _1() {
        return this.max();
    }

    public Function1<In, Object> _2() {
        return this.costFn();
    }

    public Function1<In, Out> _3() {
        return this.seed();
    }

    public Function2<Out, In, Out> _4() {
        return this.aggregate();
    }
}

