/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$LogLevels$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$Cancelled$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$Empty$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$Failed$;
import org.apache.pekko.stream.snapshot.ConnectionSnapshot;
import org.apache.pekko.stream.snapshot.ConnectionSnapshot$Closed$;
import org.apache.pekko.stream.snapshot.ConnectionSnapshot$ShouldPull$;
import org.apache.pekko.stream.snapshot.ConnectionSnapshot$ShouldPush$;
import org.apache.pekko.stream.snapshot.ConnectionSnapshotImpl;
import org.apache.pekko.stream.snapshot.ConnectionSnapshotImpl$;
import org.apache.pekko.stream.snapshot.LogicSnapshot;
import org.apache.pekko.stream.snapshot.LogicSnapshotImpl;
import org.apache.pekko.stream.snapshot.LogicSnapshotImpl$;
import org.apache.pekko.stream.snapshot.RunningInterpreter;
import org.apache.pekko.stream.snapshot.RunningInterpreterImpl$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageLogic$;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Promise;
import scala.deriving.Mirror;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@InternalApi
public final class GraphInterpreter {
    private final Materializer materializer;
    private final LoggingAdapter log;
    private final GraphStageLogic[] logics;
    private final Connection[] connections;
    private final Function4 onAsyncInput;
    private final boolean fuzzingMode;
    private final ActorRef context;
    private final int ChaseLimit;
    @InternalApi
    private GraphStageLogic activeStage;
    private int runningStages;
    private final int[] shutdownCounter;
    private Materializer _subFusingMaterializer;
    private final Connection[] eventQueue;
    private final int mask;
    private int queueHead;
    private int queueTail;
    private int chaseCounter;
    private Connection chasedPush;
    private Connection chasedPull;
    private String _Name;

    public static boolean Debug() {
        return GraphInterpreter$.MODULE$.Debug();
    }

    public static int InClosed() {
        return GraphInterpreter$.MODULE$.InClosed();
    }

    public static int InFailed() {
        return GraphInterpreter$.MODULE$.InFailed();
    }

    public static int InReady() {
        return GraphInterpreter$.MODULE$.InReady();
    }

    public static int KeepGoingFlag() {
        return GraphInterpreter$.MODULE$.KeepGoingFlag();
    }

    public static int KeepGoingMask() {
        return GraphInterpreter$.MODULE$.KeepGoingMask();
    }

    public static Null$ NoEvent() {
        return GraphInterpreter$.MODULE$.NoEvent();
    }

    public static int OutClosed() {
        return GraphInterpreter$.MODULE$.OutClosed();
    }

    public static int OutReady() {
        return GraphInterpreter$.MODULE$.OutReady();
    }

    public static int PullEndFlip() {
        return GraphInterpreter$.MODULE$.PullEndFlip();
    }

    public static int PullStartFlip() {
        return GraphInterpreter$.MODULE$.PullStartFlip();
    }

    public static int Pulling() {
        return GraphInterpreter$.MODULE$.Pulling();
    }

    public static int PushEndFlip() {
        return GraphInterpreter$.MODULE$.PushEndFlip();
    }

    public static int PushStartFlip() {
        return GraphInterpreter$.MODULE$.PushStartFlip();
    }

    public static int Pushing() {
        return GraphInterpreter$.MODULE$.Pushing();
    }

    public static GraphInterpreter currentInterpreter() {
        return GraphInterpreter$.MODULE$.currentInterpreter();
    }

    public static GraphInterpreter currentInterpreterOrNull() {
        return GraphInterpreter$.MODULE$.currentInterpreterOrNull();
    }

    public static Attributes[] singleNoAttribute() {
        return GraphInterpreter$.MODULE$.singleNoAttribute();
    }

    public GraphInterpreter(Materializer materializer, LoggingAdapter log, GraphStageLogic[] logics, Connection[] connections, Function4<GraphStageLogic, Object, Promise<Done>, Function1<Object, BoxedUnit>, BoxedUnit> onAsyncInput, boolean fuzzingMode, ActorRef context) {
        this.materializer = materializer;
        this.log = log;
        this.logics = logics;
        this.connections = connections;
        this.onAsyncInput = onAsyncInput;
        this.fuzzingMode = fuzzingMode;
        this.context = context;
        this.ChaseLimit = fuzzingMode ? 0 : 16;
        this.runningStages = logics.length;
        this.shutdownCounter = (int[])Array$.MODULE$.tabulate(logics.length, (Function1)(JFunction1.mcII.sp & Serializable)i -> logics[i].handlers().length, ClassTag$.MODULE$.apply(Integer.TYPE));
        this.eventQueue = new Connection[1 << 32 - Integer.numberOfLeadingZeros(connections.length - 1)];
        this.mask = this.eventQueue.length - 1;
        this.queueHead = 0;
        this.queueTail = 0;
        this.chaseCounter = 0;
        GraphInterpreter$.MODULE$.NoEvent();
        this.chasedPush = null;
        GraphInterpreter$.MODULE$.NoEvent();
        this.chasedPull = null;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public GraphStageLogic[] logics() {
        return this.logics;
    }

    public Connection[] connections() {
        return this.connections;
    }

    public Function4<GraphStageLogic, Object, Promise<Done>, Function1<Object, BoxedUnit>, BoxedUnit> onAsyncInput() {
        return this.onAsyncInput;
    }

    public boolean fuzzingMode() {
        return this.fuzzingMode;
    }

    public ActorRef context() {
        return this.context;
    }

    public GraphStageLogic activeStage() {
        return this.activeStage;
    }

    public void activeStage_$eq(GraphStageLogic x$1) {
        this.activeStage = x$1;
    }

    public Materializer subFusingMaterializer() {
        return this._subFusingMaterializer;
    }

    private String queueStatus() {
        IndexedSeq contents = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.queueHead), this.queueTail).map((Function1 & Serializable)idx -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)idx)));
        return new StringBuilder(8).append("(").append(this.eventQueue.length).append(", ").append(this.queueHead).append(", ").append(this.queueTail).append(")(").append(contents.mkString(", ")).append(")").toString();
    }

    public String Name() {
        if (this._Name == null) {
            this._Name = StringOps$.MODULE$.format$extension("%08X", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)System.identityHashCode(this))}));
            return this._Name;
        }
        return this._Name;
    }

    @InternalApi
    public GraphInterpreter nonNull() {
        return this;
    }

    public void setHandler(Connection connection, InHandler handler) {
        connection.inHandler_$eq(handler);
    }

    public void setHandler(Connection connection, OutHandler handler) {
        connection.outHandler_$eq(handler);
    }

    public boolean isSuspended() {
        return this.queueHead != this.queueTail;
    }

    public boolean isCompleted() {
        return this.runningStages == 0 && !this.isSuspended();
    }

    public void init(Materializer subMat) {
        this._subFusingMaterializer = subMat == null ? this.materializer() : subMat;
        for (int i = 0; i < this.logics().length; ++i) {
            GraphStageLogic logic = this.logics()[i];
            logic.interpreter_$eq(this);
            try {
                logic.beforePreStart();
                logic.preStart();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.log().error(e, "Error during preStart in [{}]: {}", (Object)logic.toString(), (Object)e.getMessage());
                    logic.failStage(e);
                }
                throw throwable;
            }
            this.afterStageHasRun(logic);
        }
    }

    public void finish() {
        for (int i = 0; i < this.logics().length; ++i) {
            GraphStageLogic logic = this.logics()[i];
            if (this.isStageCompleted(logic)) continue;
            this.finalizeStage(logic);
        }
    }

    private String inOwnerName(Connection connection) {
        return connection.inOwner().toString();
    }

    private String outOwnerName(Connection connection) {
        return connection.outOwner().toString();
    }

    private String inLogicName(Connection connection) {
        return this.logics()[connection.inOwner().stageId()].toString();
    }

    private String outLogicName(Connection connection) {
        return this.logics()[connection.outOwner().stageId()].toString();
    }

    private String shutdownCounters() {
        Object object = Predef$.MODULE$.intArrayOps(this.shutdownCounter);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> GraphInterpreter.shutdownCounters$$anonfun$1(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(String.class))).mkString(",");
    }

    public int execute(int eventLimit) {
        Object[] currentInterpreterHolder = GraphInterpreter$.org$apache$pekko$stream$impl$fusing$GraphInterpreter$$$_currentInterpreter.get();
        Object previousInterpreter = currentInterpreterHolder[0];
        currentInterpreterHolder[0] = this;
        int eventsRemaining = eventLimit;
        try {
            while (eventsRemaining > 0 && this.queueTail != this.queueHead) {
                Connection connection = this.dequeue();
                this.chaseCounter = package$.MODULE$.min(this.ChaseLimit, --eventsRemaining);
                try {
                    this.processEvent(connection);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        this.reportStageError$1(e);
                    }
                    throw throwable;
                }
                this.afterStageHasRun(this.activeStage());
                while (true) {
                    Connection connection2 = this.chasedPush;
                    GraphInterpreter$.MODULE$.NoEvent();
                    Object var11_11 = null;
                    if (!(connection2 == null ? var11_11 != null : !connection2.equals(var11_11))) break;
                    Connection connection3 = this.chasedPush;
                    GraphInterpreter$.MODULE$.NoEvent();
                    this.chasedPush = null;
                    try {
                        this.processPush(connection3);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable4 = throwable;
                        if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                            Throwable throwable5;
                            Throwable e = throwable5 = (Throwable)option.get();
                            this.reportStageError$1(e);
                        }
                        throw throwable;
                    }
                    this.afterStageHasRun(this.activeStage());
                }
                while (true) {
                    Connection connection4 = this.chasedPull;
                    GraphInterpreter$.MODULE$.NoEvent();
                    Object var18_18 = null;
                    if (!(connection4 == null ? var18_18 != null : !connection4.equals(var18_18))) break;
                    Connection connection5 = this.chasedPull;
                    GraphInterpreter$.MODULE$.NoEvent();
                    this.chasedPull = null;
                    try {
                        this.processPull(connection5);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable6 = throwable;
                        if (throwable6 != null && !(option = NonFatal$.MODULE$.unapply(throwable6)).isEmpty()) {
                            Throwable throwable7;
                            Throwable e = throwable7 = (Throwable)option.get();
                            this.reportStageError$1(e);
                        }
                        throw throwable;
                    }
                    this.afterStageHasRun(this.activeStage());
                }
                Connection connection6 = this.chasedPush;
                GraphInterpreter$.MODULE$.NoEvent();
                Object var25_25 = null;
                if (!(connection6 == null ? var25_25 != null : !connection6.equals(var25_25))) continue;
                this.enqueue(this.chasedPush);
                GraphInterpreter$.MODULE$.NoEvent();
                this.chasedPush = null;
            }
            this.chaseCounter = 0;
        }
        finally {
            currentInterpreterHolder[0] = previousInterpreter;
        }
        return eventsRemaining;
    }

    @InternalStableApi
    public void runAsyncInput(GraphStageLogic logic, Object evt, Promise<Done> promise, Function1<Object, BoxedUnit> handler) {
        if (!this.isStageCompleted(logic)) {
            Object[] currentInterpreterHolder = GraphInterpreter$.org$apache$pekko$stream$impl$fusing$GraphInterpreter$$$_currentInterpreter.get();
            Object previousInterpreter = currentInterpreterHolder[0];
            currentInterpreterHolder[0] = this;
            try {
                this.activeStage_$eq(logic);
                try {
                    handler.apply(evt);
                    if (promise != GraphStageLogic$.MODULE$.NoPromise()) {
                        promise.success((Object)Done$.MODULE$);
                        logic.onFeedbackDispatched(promise);
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        if (promise != GraphStageLogic$.MODULE$.NoPromise()) {
                            promise.failure(ex);
                            logic.onFeedbackDispatched(promise);
                        }
                        logic.failStage(ex);
                    }
                    throw throwable;
                }
                this.afterStageHasRun(logic);
            }
            finally {
                currentInterpreterHolder[0] = previousInterpreter;
            }
            return;
        }
    }

    @InternalStableApi
    private void processEvent(Connection connection) {
        this.activeStage_$eq(null);
        int code = connection.portState();
        if ((code & 0x34) == 4) {
            this.processPush(connection);
            return;
        }
        if ((code & 0x32) == 2) {
            this.processPull(connection);
            return;
        }
        if ((code & 0x30) == 16) {
            this.activeStage_$eq(connection.outOwner());
            connection.portState_$eq(connection.portState() | 0x20);
            this.completeConnection(connection.outOwner().stageId());
            Throwable cause = ((Cancelled)connection.slot()).cause();
            connection.slot_$eq(GraphInterpreter$Empty$.MODULE$);
            connection.outHandler().onDownstreamFinish(cause);
            return;
        }
        if ((code & 0x30) == 32) {
            if ((code & 4) == 0) {
                connection.portState_$eq(connection.portState() | 0x10);
                this.activeStage_$eq(connection.inOwner());
                this.completeConnection(connection.inOwner().stageId());
                if ((connection.portState() & 0x40) == 0) {
                    connection.inHandler().onUpstreamFinish();
                    return;
                }
                connection.inHandler().onUpstreamFailure(((Failed)connection.slot()).ex());
                return;
            }
            this.processPush(connection);
            this.enqueue(connection);
            return;
        }
    }

    @InternalStableApi
    private void processPush(Connection connection) {
        this.activeStage_$eq(connection.inOwner());
        connection.portState_$eq(connection.portState() ^ 5);
        connection.inHandler().onPush();
    }

    @InternalStableApi
    private void processPull(Connection connection) {
        this.activeStage_$eq(connection.outOwner());
        connection.portState_$eq(connection.portState() ^ 0xA);
        connection.outHandler().onPull();
    }

    private Connection dequeue() {
        int idx = this.queueHead & this.mask;
        if (this.fuzzingMode()) {
            int swapWith = ThreadLocalRandom.current().nextInt(this.queueTail - this.queueHead) + this.queueHead & this.mask;
            Connection ev = this.eventQueue[swapWith];
            this.eventQueue[swapWith] = this.eventQueue[idx];
            this.eventQueue[idx] = ev;
        }
        Connection elem = this.eventQueue[idx];
        this.eventQueue[idx] = GraphInterpreter$.MODULE$.NoEvent();
        ++this.queueHead;
        return elem;
    }

    public void enqueue(Connection connection) {
        this.eventQueue[this.queueTail & this.mask] = connection;
        ++this.queueTail;
    }

    public void afterStageHasRun(GraphStageLogic logic) {
        if (this.isStageCompleted(logic)) {
            --this.runningStages;
            this.finalizeStage(logic);
            return;
        }
    }

    public boolean isStageCompleted(GraphStageLogic stage) {
        return stage != null && this.shutdownCounter[stage.stageId()] == 0;
    }

    private void completeConnection(int stageId) {
        int activeConnections = this.shutdownCounter[stageId];
        if (activeConnections > 0) {
            this.shutdownCounter[stageId] = activeConnections - 1;
            return;
        }
    }

    public void setKeepGoing(GraphStageLogic logic, boolean enabled) {
        if (enabled) {
            int n = logic.stageId();
            this.shutdownCounter[n] = this.shutdownCounter[n] | 0x4000000;
            return;
        }
        int n = logic.stageId();
        this.shutdownCounter[n] = this.shutdownCounter[n] & 0x3FFFFFF;
    }

    @InternalStableApi
    public void finalizeStage(GraphStageLogic logic) {
        try {
            logic.postStop();
            logic.afterPostStop();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.log().error(e, "Error during postStop in [{}]: {}", (Object)logic.toString(), (Object)e.getMessage());
            }
            throw throwable;
        }
    }

    public void chasePush(Connection connection) {
        if (this.chaseCounter > 0) {
            Connection connection2 = this.chasedPush;
            GraphInterpreter$.MODULE$.NoEvent();
            Object var2_2 = null;
            if (!(connection2 != null ? !connection2.equals(var2_2) : var2_2 != null)) {
                --this.chaseCounter;
                this.chasedPush = connection;
                return;
            }
        }
        this.enqueue(connection);
    }

    public void chasePull(Connection connection) {
        if (this.chaseCounter > 0) {
            Connection connection2 = this.chasedPull;
            GraphInterpreter$.MODULE$.NoEvent();
            Object var2_2 = null;
            if (!(connection2 != null ? !connection2.equals(var2_2) : var2_2 != null)) {
                --this.chaseCounter;
                this.chasedPull = connection;
                return;
            }
        }
        this.enqueue(connection);
    }

    public void complete(Connection connection) {
        int currentState = connection.portState();
        connection.portState_$eq(currentState | 0x20);
        Connection connection2 = this.chasedPush;
        Connection connection3 = connection;
        if (!(connection2 != null ? !connection2.equals(connection3) : connection3 != null)) {
            GraphInterpreter$.MODULE$.NoEvent();
            this.chasedPush = null;
            this.enqueue(connection);
        } else if ((currentState & 0x36) == 0) {
            this.enqueue(connection);
        }
        if ((currentState & 0x20) == 0) {
            this.completeConnection(connection.outOwner().stageId());
            return;
        }
    }

    @InternalStableApi
    public void fail(Connection connection, Throwable ex) {
        int currentState = connection.portState();
        connection.portState_$eq(currentState | 0x20);
        if ((currentState & 0x30) == 0) {
            connection.portState_$eq(currentState | 0x60);
            connection.slot_$eq(GraphInterpreter$Failed$.MODULE$.apply(ex, connection.slot()));
            if ((currentState & 6) == 0) {
                this.enqueue(connection);
            } else if (this.chasedPush == connection) {
                GraphInterpreter$.MODULE$.NoEvent();
                this.chasedPush = null;
                this.enqueue(connection);
            }
        }
        if ((currentState & 0x20) == 0) {
            this.completeConnection(connection.outOwner().stageId());
            return;
        }
    }

    @InternalStableApi
    public void cancel(Connection connection, Throwable cause) {
        int currentState = connection.portState();
        connection.portState_$eq(currentState | 0x10);
        if ((currentState & 0x20) == 0) {
            connection.slot_$eq(GraphInterpreter$Cancelled$.MODULE$.apply(cause));
            if ((currentState & 0x16) == 0) {
                this.enqueue(connection);
            } else if (this.chasedPull == connection) {
                GraphInterpreter$.MODULE$.NoEvent();
                this.chasedPull = null;
                this.enqueue(connection);
            }
        }
        if ((currentState & 0x10) == 0) {
            this.completeConnection(connection.inOwner().stageId());
            return;
        }
    }

    public RunningInterpreter toSnapshot() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.logics());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        Object[] logicSnapshots = (LogicSnapshotImpl[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                GraphStageLogic logic = (GraphStageLogic)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return LogicSnapshotImpl$.MODULE$.apply(idx, logic.toString(), logic.attributes());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(LogicSnapshotImpl.class));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])this.logics());
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object3));
        Map logicIndexes = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                GraphStageLogic stage = (GraphStageLogic)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                GraphStageLogic graphStageLogic = (GraphStageLogic)Predef$.MODULE$.ArrowAssoc((Object)stage);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)graphStageLogic, (Object)BoxesRunTime.boxToInteger((int)idx));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Object object5 = Predef$.MODULE$.refArrayOps((Object[])this.connections());
        Object object6 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object5, (Function1 & Serializable)_$4 -> _$4 != null));
        Object[] connectionSnapshots = (ConnectionSnapshotImpl[])ArrayOps$.MODULE$.map$extension(object6, arg_0 -> GraphInterpreter.$anonfun$5((LogicSnapshotImpl[])logicSnapshots, logicIndexes, arg_0), ClassTag$.MODULE$.apply(ConnectionSnapshotImpl.class));
        Object object7 = Predef$.MODULE$.intArrayOps(this.shutdownCounter);
        Object object8 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object7));
        List stoppedStages = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.collect$extension(object8, (PartialFunction)new Serializable((LogicSnapshotImpl[])logicSnapshots){
            private final LogicSnapshotImpl[] logicSnapshots$2;
            {
                this.logicSnapshots$2 = logicSnapshots$3;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    int activeConnections = tuple2._1$mcI$sp();
                    int idx = tuple2._2$mcI$sp();
                    if (activeConnections < 1) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    int activeConnections = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (activeConnections < 1) {
                        return this.logicSnapshots$2[idx];
                    }
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(LogicSnapshotImpl.class))).toList();
        return RunningInterpreterImpl$.MODULE$.apply((Seq<LogicSnapshot>)Predef$.MODULE$.wrapRefArray(logicSnapshots).toVector(), (Seq<ConnectionSnapshot>)Predef$.MODULE$.wrapRefArray(connectionSnapshots).toVector(), this.queueStatus(), this.runningStages, (Seq<LogicSnapshot>)stoppedStages);
    }

    private final /* synthetic */ Connection $anonfun$1(int idx) {
        Connection conn = this.eventQueue[idx & this.mask];
        return conn;
    }

    private static final /* synthetic */ String shutdownCounters$$anonfun$1(int x) {
        if (x >= 0x4000000) {
            return new StringBuilder(11).append(x & 0x3FFFFFF).append("(KeepGoing)").toString();
        }
        return BoxesRunTime.boxToInteger((int)x).toString();
    }

    private final void reportStageError$1(Throwable e) {
        boolean bl;
        if (this.activeStage() == null) {
            throw e;
        }
        Option option = this.activeStage().attributes().get(ClassTag$.MODULE$.apply(Attributes.LogLevels.class));
        if (option instanceof Some) {
            Attributes.LogLevels levels = (Attributes.LogLevels)((Some)option).value();
            bl = levels.onFailure() != Attributes$LogLevels$.MODULE$.Off();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        boolean loggingEnabled = bl;
        if (loggingEnabled) {
            this.log().error(e, "Error in stage [{}]: {}", (Object)this.activeStage().toString(), (Object)e.getMessage());
        }
        this.activeStage().failStage(e);
        this.chaseCounter = 0;
        GraphInterpreter$.MODULE$.NoEvent();
        if (this.chasedPush != null) {
            this.enqueue(this.chasedPush);
            GraphInterpreter$.MODULE$.NoEvent();
            this.chasedPush = null;
        }
        GraphInterpreter$.MODULE$.NoEvent();
        if (this.chasedPull != null) {
            this.enqueue(this.chasedPull);
            GraphInterpreter$.MODULE$.NoEvent();
            this.chasedPull = null;
            return;
        }
    }

    private static final /* synthetic */ ConnectionSnapshotImpl $anonfun$5(LogicSnapshotImpl[] logicSnapshots$1, Map logicIndexes$1, Connection connection) {
        Mirror.Singleton singleton;
        int n = connection.id();
        LogicSnapshotImpl logicSnapshotImpl = logicSnapshots$1[BoxesRunTime.unboxToInt((Object)logicIndexes$1.apply((Object)connection.inOwner()))];
        LogicSnapshotImpl logicSnapshotImpl2 = logicSnapshots$1[BoxesRunTime.unboxToInt((Object)logicIndexes$1.apply((Object)connection.outOwner()))];
        int n2 = connection.portState();
        switch (n2) {
            case 1: 
            case 4: {
                singleton = ConnectionSnapshot$ShouldPull$.MODULE$;
                break;
            }
            case 2: 
            case 8: {
                singleton = ConnectionSnapshot$ShouldPush$.MODULE$;
                break;
            }
            default: {
                int x = n2;
                if ((x & 0x30) == 48) {
                    singleton = ConnectionSnapshot$Closed$.MODULE$;
                    break;
                }
                throw new IllegalStateException(new StringBuilder(34).append("Unexpected connection state for ").append(connection).append(": ").append(connection.portState()).toString());
            }
        }
        return ConnectionSnapshotImpl$.MODULE$.apply(n, logicSnapshotImpl, logicSnapshotImpl2, (ConnectionSnapshot.ConnectionState)singleton);
    }

    public static final class Cancelled
    implements Product,
    Serializable {
        private final Throwable cause;

        public static Cancelled apply(Throwable throwable) {
            return GraphInterpreter$Cancelled$.MODULE$.apply(throwable);
        }

        public static Cancelled fromProduct(Product product) {
            return GraphInterpreter$Cancelled$.MODULE$.fromProduct(product);
        }

        public static Cancelled unapply(Cancelled cancelled) {
            return GraphInterpreter$Cancelled$.MODULE$.unapply(cancelled);
        }

        public Cancelled(Throwable cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cancelled)) return false;
            Cancelled cancelled = (Cancelled)object;
            Throwable throwable = this.cause();
            Throwable throwable2 = cancelled.cause();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Cancelled;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Cancelled";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable cause() {
            return this.cause;
        }

        public Cancelled copy(Throwable cause) {
            return new Cancelled(cause);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public Throwable _1() {
            return this.cause();
        }
    }

    @InternalStableApi
    public static final class Connection {
        private int id;
        private GraphStageLogic inOwner;
        private GraphStageLogic outOwner;
        private InHandler inHandler;
        private OutHandler outHandler;
        private int portState;
        private Object slot;

        public Connection(int id, GraphStageLogic inOwner, GraphStageLogic outOwner, InHandler inHandler, OutHandler outHandler) {
            this.id = id;
            this.inOwner = inOwner;
            this.outOwner = outOwner;
            this.inHandler = inHandler;
            this.outHandler = outHandler;
            this.portState = 1;
            this.slot = GraphInterpreter$Empty$.MODULE$;
        }

        public int id() {
            return this.id;
        }

        public void id_$eq(int x$1) {
            this.id = x$1;
        }

        public GraphStageLogic inOwner() {
            return this.inOwner;
        }

        public void inOwner_$eq(GraphStageLogic x$1) {
            this.inOwner = x$1;
        }

        public GraphStageLogic outOwner() {
            return this.outOwner;
        }

        public void outOwner_$eq(GraphStageLogic x$1) {
            this.outOwner = x$1;
        }

        public InHandler inHandler() {
            return this.inHandler;
        }

        public void inHandler_$eq(InHandler x$1) {
            this.inHandler = x$1;
        }

        public OutHandler outHandler() {
            return this.outHandler;
        }

        public void outHandler_$eq(OutHandler x$1) {
            this.outHandler = x$1;
        }

        public int portState() {
            return this.portState;
        }

        public void portState_$eq(int x$1) {
            this.portState = x$1;
        }

        public Object slot() {
            return this.slot;
        }

        public void slot_$eq(Object x$1) {
            this.slot = x$1;
        }
    }

    public static abstract class DownstreamBoundaryStageLogic<T>
    extends GraphStageLogic {
        public DownstreamBoundaryStageLogic() {
            super(1, 0);
        }

        public abstract Inlet<T> in();
    }

    public static final class Failed
    implements Product,
    Serializable {
        private final Throwable ex;
        private final Object previousElem;

        public static Failed apply(Throwable throwable, Object object) {
            return GraphInterpreter$Failed$.MODULE$.apply(throwable, object);
        }

        public static Failed fromProduct(Product product) {
            return GraphInterpreter$Failed$.MODULE$.fromProduct(product);
        }

        public static Failed unapply(Failed failed) {
            return GraphInterpreter$Failed$.MODULE$.unapply(failed);
        }

        public Failed(Throwable ex, Object previousElem) {
            this.ex = ex;
            this.previousElem = previousElem;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Failed)) return false;
            Failed failed = (Failed)object;
            Throwable throwable = this.ex();
            Throwable throwable2 = failed.ex();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!BoxesRunTime.equals((Object)this.previousElem(), (Object)failed.previousElem())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Failed;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Failed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ex";
            }
            if (1 == n2) {
                return "previousElem";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable ex() {
            return this.ex;
        }

        public Object previousElem() {
            return this.previousElem;
        }

        public Failed copy(Throwable ex, Object previousElem) {
            return new Failed(ex, previousElem);
        }

        public Throwable copy$default$1() {
            return this.ex();
        }

        public Object copy$default$2() {
            return this.previousElem();
        }

        public Throwable _1() {
            return this.ex();
        }

        public Object _2() {
            return this.previousElem();
        }
    }

    public static abstract class UpstreamBoundaryStageLogic<T>
    extends GraphStageLogic {
        public UpstreamBoundaryStageLogic() {
            super(0, 1);
        }

        public abstract Outlet<T> out();
    }
}

