/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogSource;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Supervision;
import org.apache.pekko.stream.Supervision$Stop$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.impl.fusing.Log$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@InternalApi
public final class Log<T>
extends GraphStages.SimpleLinearGraphStage<T>
implements Product,
Serializable {
    private final String name;
    private final Function1 extract;
    private final Option logAdapter;

    public static <T> Log<T> apply(String string, Function1<T, Object> function1, Option<LoggingAdapter> option) {
        return Log$.MODULE$.apply(string, function1, option);
    }

    public static LogSource<Materializer> fromMaterializer() {
        return Log$.MODULE$.fromMaterializer();
    }

    public static Log<?> fromProduct(Product product) {
        return Log$.MODULE$.fromProduct(product);
    }

    public static <T> Log<T> unapply(Log<T> log) {
        return Log$.MODULE$.unapply(log);
    }

    public Log(String name, Function1<T, Object> extract, Option<LoggingAdapter> logAdapter) {
        this.name = name;
        this.extract = extract;
        this.logAdapter = logAdapter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Log)) return false;
        Log log = (Log)object;
        String string = this.name();
        String string2 = log.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Function1<T, Object> function1 = this.extract();
        Function1<T, Object> function12 = log.extract();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Option<LoggingAdapter> option = this.logAdapter();
        Option<LoggingAdapter> option2 = log.logAdapter();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof Log;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Log";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "name";
            }
            case 1: {
                return "extract";
            }
            case 2: {
                return "logAdapter";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String name() {
        return this.name;
    }

    public Function1<T, Object> extract() {
        return this.extract;
    }

    public Option<LoggingAdapter> logAdapter() {
        return this.logAdapter;
    }

    public String toString() {
        return "Log";
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new OutHandler(inheritedAttributes, this){
            private final Attributes inheritedAttributes$15;
            private Attributes.LogLevels logLevels;
            private LoggingAdapter log;
            private final /* synthetic */ Log $outer;
            {
                this.inheritedAttributes$15 = inheritedAttributes$34;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public Function1 decider() {
                return ((ActorAttributes.SupervisionStrategy)this.inheritedAttributes$15.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.SupervisionStrategy.class))).decider();
            }

            public void preStart() {
                LoggingAdapter l;
                this.logLevels = this.inheritedAttributes$15.get(Log$.org$apache$pekko$stream$impl$fusing$Log$$$DefaultLogLevels, ClassTag$.MODULE$.apply(Attributes.LogLevels.class));
                Option<LoggingAdapter> option = this.$outer.logAdapter();
                this.log = option instanceof Some ? (l = (LoggingAdapter)((Some)option).value()) : Logging$.MODULE$.apply(this.materializer().system(), (Object)this.materializer(), Log$.MODULE$.fromMaterializer());
            }

            public void onPush() {
                try {
                    T elem = this.grab(this.$outer.in());
                    if (this.isEnabled(this.logLevels.onElement())) {
                        this.log.log(this.logLevels.onElement(), "[{}] Element: {}", (Object)this.$outer.name(), this.$outer.extract().apply(elem));
                    }
                    this.push(this.$outer.out(), elem);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        Supervision.Directive directive = (Supervision.Directive)this.decider().apply((Object)ex);
                        if (Supervision$Stop$.MODULE$.equals(directive)) {
                            this.failStage(ex);
                        } else {
                            this.pull(this.$outer.in());
                        }
                    }
                    throw throwable;
                }
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onUpstreamFailure(Throwable cause) {
                if (this.isEnabled(this.logLevels.onFailure())) {
                    int n = this.logLevels.onFailure();
                    if (Logging$.MODULE$.ErrorLevel() == n) {
                        this.log.error(cause, "[{}] Upstream failed.", (Object)this.$outer.name());
                    } else {
                        int level = n;
                        this.log.log(level, "[{}] Upstream failed, cause: {}: {}", (Object)this.$outer.name(), (Object)Logging$.MODULE$.simpleName(cause.getClass()), (Object)cause.getMessage());
                    }
                }
                InHandler.onUpstreamFailure$(this, cause);
            }

            public void onUpstreamFinish() {
                if (this.isEnabled(this.logLevels.onFinish())) {
                    this.log.log(this.logLevels.onFinish(), "[{}] Upstream finished.", (Object)this.$outer.name());
                }
                InHandler.onUpstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) {
                if (this.isEnabled(this.logLevels.onFinish())) {
                    this.log.log(this.logLevels.onFinish(), "[{}] Downstream finished, cause: {}: {}", (Object)this.$outer.name(), (Object)Logging$.MODULE$.simpleName(cause.getClass()), (Object)cause.getMessage());
                }
                OutHandler.onDownstreamFinish$(this, cause);
            }

            private boolean isEnabled(int l) {
                return l != Log$.org$apache$pekko$stream$impl$fusing$Log$$$OffInt;
            }
        };
    }

    public <T> Log<T> copy(String name, Function1<T, Object> extract, Option<LoggingAdapter> logAdapter) {
        return new Log<T>(name, extract, logAdapter);
    }

    public <T> String copy$default$1() {
        return this.name();
    }

    public <T> Function1<T, Object> copy$default$2() {
        return this.extract();
    }

    public <T> Option<LoggingAdapter> copy$default$3() {
        return this.logAdapter();
    }

    public String _1() {
        return this.name();
    }

    public Function1<T, Object> _2() {
        return this.extract();
    }

    public Option<LoggingAdapter> _3() {
        return this.logAdapter();
    }
}

