/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker;
import org.apache.pekko.event.LogSource;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Supervision;
import org.apache.pekko.stream.Supervision$Stop$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.impl.fusing.LogWithMarker$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@InternalApi
public final class LogWithMarker<T>
extends GraphStages.SimpleLinearGraphStage<T>
implements Product,
Serializable {
    private final String name;
    private final Function1 marker;
    private final Function1 extract;
    private final Option logAdapter;

    public static <T> LogWithMarker<T> apply(String string, Function1<T, LogMarker> function1, Function1<T, Object> function12, Option<MarkerLoggingAdapter> option) {
        return LogWithMarker$.MODULE$.apply(string, function1, function12, option);
    }

    public static LogSource<Materializer> fromMaterializer() {
        return LogWithMarker$.MODULE$.fromMaterializer();
    }

    public static LogWithMarker<?> fromProduct(Product product) {
        return LogWithMarker$.MODULE$.fromProduct(product);
    }

    public static <T> LogWithMarker<T> unapply(LogWithMarker<T> logWithMarker) {
        return LogWithMarker$.MODULE$.unapply(logWithMarker);
    }

    public LogWithMarker(String name, Function1<T, LogMarker> marker, Function1<T, Object> extract, Option<MarkerLoggingAdapter> logAdapter) {
        this.name = name;
        this.marker = marker;
        this.extract = extract;
        this.logAdapter = logAdapter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LogWithMarker)) return false;
        LogWithMarker logWithMarker = (LogWithMarker)object;
        String string = this.name();
        String string2 = logWithMarker.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Function1<T, LogMarker> function1 = this.marker();
        Function1<T, LogMarker> function12 = logWithMarker.marker();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function1<T, Object> function13 = this.extract();
        Function1<T, Object> function14 = logWithMarker.extract();
        if (function13 == null) {
            if (function14 != null) {
                return false;
            }
        } else if (!function13.equals(function14)) return false;
        Option<MarkerLoggingAdapter> option = this.logAdapter();
        Option<MarkerLoggingAdapter> option2 = logWithMarker.logAdapter();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof LogWithMarker;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "LogWithMarker";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "name";
            }
            case 1: {
                return "marker";
            }
            case 2: {
                return "extract";
            }
            case 3: {
                return "logAdapter";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String name() {
        return this.name;
    }

    public Function1<T, LogMarker> marker() {
        return this.marker;
    }

    public Function1<T, Object> extract() {
        return this.extract;
    }

    public Option<MarkerLoggingAdapter> logAdapter() {
        return this.logAdapter;
    }

    public String toString() {
        return "LogWithMarker";
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new OutHandler(inheritedAttributes, this){
            private final Attributes inheritedAttributes$16;
            private Attributes.LogLevels logLevels;
            private MarkerLoggingAdapter log;
            private final /* synthetic */ LogWithMarker $outer;
            {
                this.inheritedAttributes$16 = inheritedAttributes$35;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public Function1 decider() {
                return ((ActorAttributes.SupervisionStrategy)this.inheritedAttributes$16.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.SupervisionStrategy.class))).decider();
            }

            public void preStart() {
                MarkerLoggingAdapter l;
                this.logLevels = this.inheritedAttributes$16.get(LogWithMarker$.org$apache$pekko$stream$impl$fusing$LogWithMarker$$$DefaultLogLevels, ClassTag$.MODULE$.apply(Attributes.LogLevels.class));
                Option<MarkerLoggingAdapter> option = this.$outer.logAdapter();
                this.log = option instanceof Some ? (l = (MarkerLoggingAdapter)((Some)option).value()) : Logging$.MODULE$.withMarker(this.materializer().system(), (Object)this.materializer(), LogWithMarker$.MODULE$.fromMaterializer());
            }

            public void onPush() {
                try {
                    T elem = this.grab(this.$outer.in());
                    if (this.isEnabled(this.logLevels.onElement())) {
                        this.log.log((LogMarker)this.$outer.marker().apply(elem), this.logLevels.onElement(), this.log.format("[{}] Element: {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), this.$outer.extract().apply(elem)})));
                    }
                    this.push(this.$outer.out(), elem);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = (Throwable)option.get();
                        Supervision.Directive directive = (Supervision.Directive)this.decider().apply((Object)ex);
                        if (Supervision$Stop$.MODULE$.equals(directive)) {
                            this.failStage(ex);
                        } else {
                            this.pull(this.$outer.in());
                        }
                    }
                    throw throwable;
                }
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onUpstreamFailure(Throwable cause) {
                if (this.isEnabled(this.logLevels.onFailure())) {
                    int n = this.logLevels.onFailure();
                    if (Logging$.MODULE$.ErrorLevel() == n) {
                        this.log.error(cause, "[{}] Upstream failed.", (Object)this.$outer.name());
                    } else {
                        int level = n;
                        this.log.log(level, "[{}] Upstream failed, cause: {}: {}", (Object)this.$outer.name(), (Object)Logging$.MODULE$.simpleName(cause.getClass()), (Object)cause.getMessage());
                    }
                }
                InHandler.onUpstreamFailure$(this, cause);
            }

            public void onUpstreamFinish() {
                if (this.isEnabled(this.logLevels.onFinish())) {
                    this.log.log(this.logLevels.onFinish(), "[{}] Upstream finished.", (Object)this.$outer.name());
                }
                InHandler.onUpstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) {
                if (this.isEnabled(this.logLevels.onFinish())) {
                    this.log.log(this.logLevels.onFinish(), "[{}] Downstream finished, cause: {}: {}", (Object)this.$outer.name(), (Object)Logging$.MODULE$.simpleName(cause.getClass()), (Object)cause.getMessage());
                }
                OutHandler.onDownstreamFinish$(this, cause);
            }

            private boolean isEnabled(int l) {
                return l != LogWithMarker$.org$apache$pekko$stream$impl$fusing$LogWithMarker$$$OffInt;
            }
        };
    }

    public <T> LogWithMarker<T> copy(String name, Function1<T, LogMarker> marker, Function1<T, Object> extract, Option<MarkerLoggingAdapter> logAdapter) {
        return new LogWithMarker<T>(name, marker, extract, logAdapter);
    }

    public <T> String copy$default$1() {
        return this.name();
    }

    public <T> Function1<T, LogMarker> copy$default$2() {
        return this.marker();
    }

    public <T> Function1<T, Object> copy$default$3() {
        return this.extract();
    }

    public <T> Option<MarkerLoggingAdapter> copy$default$4() {
        return this.logAdapter();
    }

    public String _1() {
        return this.name();
    }

    public Function1<T, LogMarker> _2() {
        return this.marker();
    }

    public Function1<T, Object> _3() {
        return this.extract();
    }

    public Option<MarkerLoggingAdapter> _4() {
        return this.logAdapter();
    }
}

