/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.InPort;
import org.apache.pekko.stream.OutPort;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.impl.GraphStageIsland$;
import org.apache.pekko.stream.impl.PhaseIsland;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.StreamLayout;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter;
import org.apache.pekko.stream.impl.fusing.GraphInterpreterShell;
import org.apache.pekko.stream.impl.fusing.GraphStageModule;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.reactivestreams.Publisher;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ClassTag$;

@InternalApi
public final class GraphStageIsland
implements PhaseIsland<GraphStageLogic> {
    private final Attributes effectiveAttributes;
    private final PhasedFusingActorMaterializer materializer;
    private final String islandName;
    private final Function1 subflowFuser;
    private final ArrayList<GraphStageLogic> logics;
    private GraphInterpreter.Connection[] connections;
    private int maxConnections;
    private List<GraphInterpreter.Connection> outConnections;
    private String fullIslandName;
    private final GraphInterpreterShell shell;

    public GraphStageIsland(Attributes effectiveAttributes, PhasedFusingActorMaterializer materializer, String islandName, Function1 subflowFuser) {
        this.effectiveAttributes = effectiveAttributes;
        this.materializer = materializer;
        this.islandName = islandName;
        this.subflowFuser = subflowFuser;
        this.logics = new ArrayList(16);
        this.connections = new GraphInterpreter.Connection[16];
        this.maxConnections = 0;
        this.outConnections = scala.package$.MODULE$.Nil();
        OptionVal$.MODULE$.None();
        this.fullIslandName = null;
        this.shell = new GraphInterpreterShell(null, null, effectiveAttributes, materializer);
    }

    public GraphInterpreterShell shell() {
        return this.shell;
    }

    @Override
    public String name() {
        return "Fusing GraphStages phase";
    }

    @Override
    public Tuple2<GraphStageLogic, Object> materializeAtomic(StreamLayout.AtomicModule<Shape, Object> mod, Attributes attributes) {
        Tuple2 matAndLogic;
        block0: {
            GraphStageModule stageModule = (GraphStageModule)mod;
            GraphStageWithMaterializedValue stage = stageModule.stage();
            matAndLogic = stage.createLogicAndMaterializedValue(attributes, this.materializer);
            GraphStageLogic logic = (GraphStageLogic)matAndLogic._1();
            logic.originalStage_$eq((GraphStageWithMaterializedValue)OptionVal.Some$.MODULE$.apply(stage));
            logic.attributes_$eq(attributes);
            this.logics.add(logic);
            logic.stageId_$eq(this.logics.size() - 1);
            String string = this.fullIslandName;
            OptionVal$.MODULE$.None();
            String string2 = string;
            if (null != null ? !((Object)null).equals(string2) : string2 != null) break block0;
            Attributes attributes2 = logic.attributes();
            this.fullIslandName = (String)OptionVal.Some$.MODULE$.apply((Object)new StringBuilder(1).append(this.islandName).append("-").append(attributes2.nameForActorRef(attributes2.nameForActorRef$default$1())).toString());
        }
        return matAndLogic;
    }

    public GraphInterpreter.Connection conn(int slot) {
        GraphInterpreter.Connection c2;
        GraphInterpreter.Connection c;
        this.maxConnections = package$.MODULE$.max(slot, this.maxConnections);
        if (this.maxConnections >= this.connections.length) {
            this.connections = Arrays.copyOf(this.connections, this.connections.length * 2);
        }
        if ((c = this.connections[slot]) != null) {
            return c;
        }
        this.connections[slot] = c2 = new GraphInterpreter.Connection(0, null, null, null, null);
        return c2;
    }

    public GraphInterpreter.Connection outConn() {
        GraphInterpreter.Connection connection = new GraphInterpreter.Connection(0, null, null, null, null);
        this.outConnections = this.outConnections.$colon$colon((Object)connection);
        return connection;
    }

    @Override
    public void assignPort(InPort in, int slot, GraphStageLogic logic) {
        GraphInterpreter.Connection connection = this.conn(slot);
        connection.inOwner_$eq(logic);
        connection.id_$eq(slot);
        connection.inHandler_$eq((InHandler)logic.handlers()[in.id()]);
        if (connection.inHandler() == null) {
            this.failOnMissingHandler(logic);
        }
        logic.portToConn()[in.id()] = connection;
    }

    @Override
    public void assignPort(OutPort out, int slot, GraphStageLogic logic) {
        GraphInterpreter.Connection connection = this.conn(slot);
        connection.outOwner_$eq(logic);
        connection.id_$eq(slot);
        connection.outHandler_$eq((OutHandler)logic.handlers()[logic.inCount() + out.id()]);
        if (connection.outHandler() == null) {
            this.failOnMissingHandler(logic);
        }
        logic.portToConn()[logic.inCount() + out.id()] = connection;
    }

    @Override
    public Publisher<Object> createPublisher(OutPort out, GraphStageLogic logic) {
        GraphInterpreter.Connection connection;
        ActorGraphInterpreter.ActorOutputBoundary boundary = new ActorGraphInterpreter.ActorOutputBoundary(this.shell(), out.toString());
        this.logics.add(boundary);
        boundary.stageId_$eq(this.logics.size() - 1);
        boundary.attributes_$eq(logic.attributes().and(Stages$DefaultAttributes$.MODULE$.outputBoundary()));
        boundary.portToConn()[boundary.in().id()] = connection = this.outConn();
        connection.inHandler_$eq((InHandler)boundary.handlers()[0]);
        connection.inOwner_$eq(boundary);
        connection.outOwner_$eq(logic);
        connection.id_$eq(-1);
        connection.outHandler_$eq((OutHandler)logic.handlers()[logic.inCount() + out.id()]);
        if (connection.outHandler() == null) {
            this.failOnMissingHandler(logic);
        }
        logic.portToConn()[logic.inCount() + out.id()] = connection;
        return boundary.publisher();
    }

    @Override
    public void takePublisher(int slot, Publisher<Object> publisher, Attributes attributes) {
        GraphInterpreter.Connection connection = this.conn(slot);
        int bufferSize = ((Attributes.InputBuffer)connection.inOwner().attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.InputBuffer.class))).max();
        ActorGraphInterpreter.BatchingActorInputBoundary boundary = new ActorGraphInterpreter.BatchingActorInputBoundary(bufferSize, this.shell(), publisher, "publisher.in");
        this.logics.add(boundary);
        boundary.stageId_$eq(this.logics.size() - 1);
        boundary.attributes_$eq(connection.inOwner().attributes().and(Stages$DefaultAttributes$.MODULE$.inputBoundary()));
        boundary.portToConn()[boundary.out().id() + boundary.inCount()] = connection;
        connection.outHandler_$eq((OutHandler)boundary.handlers()[0]);
        connection.outOwner_$eq(boundary);
    }

    @Override
    public void onIslandReady() {
        String string;
        String n;
        int totalConnections = this.maxConnections + this.outConnections.size() + 1;
        GraphInterpreter.Connection[] finalConnections = Arrays.copyOf(this.connections, totalConnections);
        List outConns = this.outConnections;
        for (int i = this.maxConnections + 1; i < totalConnections; ++i) {
            GraphInterpreter.Connection conn = (GraphInterpreter.Connection)outConns.head();
            outConns = (List)outConns.tail();
            if (conn.inHandler() == null) {
                this.failOnMissingHandler(conn.inOwner());
            } else if (conn.outHandler() == null) {
                this.failOnMissingHandler(conn.outOwner());
            }
            finalConnections[i] = conn;
            conn.id_$eq(i);
        }
        this.shell().connections_$eq(finalConnections);
        this.shell().logics_$eq(this.logics.toArray(GraphStageIsland$.org$apache$pekko$stream$impl$GraphStageIsland$$$emptyLogicArray));
        Function1 function1 = this.subflowFuser;
        Function1 function12 = (Function1)OptionVal.Some$.MODULE$.unapply((Object)function1);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)function12)) {
            Function1 function13;
            Function1 fuseIntoExistingInterpreter = function13 = (Function1)OptionVal$.MODULE$.get$extension((Object)function12);
            fuseIntoExistingInterpreter.apply((Object)this.shell());
            return;
        }
        Props props = ActorGraphInterpreter$.MODULE$.props(this.shell()).withDispatcher(((ActorAttributes.Dispatcher)this.effectiveAttributes.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class))).dispatcher()).withMailbox(PhasedFusingActorMaterializer$.MODULE$.MailboxConfigName());
        String string2 = this.fullIslandName;
        String string3 = (String)OptionVal.Some$.MODULE$.unapply((Object)string2);
        String actorName = !OptionVal$.MODULE$.isEmpty$extension((Object)string3) ? (n = (string = (String)OptionVal$.MODULE$.get$extension((Object)string3))) : this.islandName;
        ActorRef ref = this.materializer.actorOf(props, actorName);
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)new StringBuilder(29).append("Spawned actor [").append(ref).append("] with shell: ").append(this.shell()).toString());
            return;
        }
    }

    private void failOnMissingHandler(GraphStageLogic logic) {
        String string;
        Object object = Predef$.MODULE$.genericArrayOps((Object)logic.handlers());
        int missingHandlerIdx = ArrayOps$.MODULE$.indexWhere$extension(object, (Function1 & Serializable)_$5 -> _$5 == null, ArrayOps$.MODULE$.indexWhere$default$2$extension(object));
        boolean isIn = missingHandlerIdx < logic.inCount();
        GraphStageWithMaterializedValue graphStageWithMaterializedValue = logic.originalStage();
        GraphStageWithMaterializedValue graphStageWithMaterializedValue2 = (GraphStageWithMaterializedValue)OptionVal.Some$.MODULE$.unapply((Object)graphStageWithMaterializedValue);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)graphStageWithMaterializedValue2)) {
            GraphStageWithMaterializedValue graphStageWithMaterializedValue3;
            GraphStageWithMaterializedValue stage = graphStageWithMaterializedValue3 = (GraphStageWithMaterializedValue)OptionVal$.MODULE$.get$extension((Object)graphStageWithMaterializedValue2);
            string = isIn ? new StringBuilder(10).append("in port [").append(((Shape)stage.shape()).inlets().apply(missingHandlerIdx)).append("]").toString() : new StringBuilder(10).append("out port [").append(((Shape)stage.shape()).outlets().apply(missingHandlerIdx - logic.inCount())).toString();
        } else {
            string = isIn ? new StringBuilder(13).append("in port id [").append(missingHandlerIdx).append("]").toString() : new StringBuilder(14).append("out port id [").append(missingHandlerIdx).append("]").toString();
        }
        String portLabel = string;
        throw new IllegalStateException(new StringBuilder(148).append("No handler defined in stage [").append(logic.toString()).append("] for ").append(portLabel).append(".").append(" All inlets and outlets must be assigned a handler with setHandler in the constructor of your graph stage logic.").toString());
    }

    public String toString() {
        return "GraphStagePhase";
    }
}

