/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.util.NoSuchElementException;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.FlattenConcat$FlattenConcatLogic$2$;
import org.apache.pekko.stream.impl.fusing.MapAsync$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.util.Try;

@InternalApi
public final class FlattenConcat<T, M>
extends GraphStage<FlowShape<Graph<SourceShape<T>, M>, T>> {
    public final int org$apache$pekko$stream$impl$fusing$FlattenConcat$$parallelism;
    public final Inlet<Graph<SourceShape<T>, M>> org$apache$pekko$stream$impl$fusing$FlattenConcat$$in;
    public final Outlet<T> org$apache$pekko$stream$impl$fusing$FlattenConcat$$out;
    private final FlowShape shape;

    public FlattenConcat(int parallelism) {
        this.org$apache$pekko$stream$impl$fusing$FlattenConcat$$parallelism = parallelism;
        Predef$.MODULE$.require(parallelism >= 1, FlattenConcat::$init$$$anonfun$1);
        this.org$apache$pekko$stream$impl$fusing$FlattenConcat$$in = Inlet$.MODULE$.apply("flattenConcat.in");
        this.org$apache$pekko$stream$impl$fusing$FlattenConcat$$out = Outlet$.MODULE$.apply("flattenConcat.out");
        this.shape = FlowShape$.MODULE$.apply(this.org$apache$pekko$stream$impl$fusing$FlattenConcat$$in, this.org$apache$pekko$stream$impl$fusing$FlattenConcat$$out);
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.flattenConcat();
    }

    @Override
    public FlowShape<Graph<SourceShape<T>, M>, T> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes enclosingAttributes) {
        LazyRef lazyRef = new LazyRef();
        return this.FlattenConcatLogic$1(lazyRef, enclosingAttributes);
    }

    public String toString() {
        return new StringBuilder(27).append("FlattenConcat(parallelism=").append(this.org$apache$pekko$stream$impl$fusing$FlattenConcat$$parallelism).append(")").toString();
    }

    private static final Object $init$$$anonfun$1() {
        return "parallelism should >= 1";
    }

    private final FlattenConcat$FlattenConcatLogic$2$ FlattenConcatLogic$lzyINIT1$1(LazyRef FlattenConcatLogic$lzy1$1, Attributes enclosingAttributes$1) {
        FlattenConcat$FlattenConcatLogic$2$ flattenConcat$FlattenConcatLogic$2$;
        LazyRef lazyRef = FlattenConcatLogic$lzy1$1;
        synchronized (lazyRef) {
            flattenConcat$FlattenConcatLogic$2$ = (FlattenConcat$FlattenConcatLogic$2$)(FlattenConcatLogic$lzy1$1.initialized() ? FlattenConcatLogic$lzy1$1.value() : FlattenConcatLogic$lzy1$1.initialize((Object)new FlattenConcat$FlattenConcatLogic$2$(enclosingAttributes$1, this)));
        }
        return flattenConcat$FlattenConcatLogic$2$;
    }

    private final FlattenConcat$FlattenConcatLogic$2$ FlattenConcatLogic$1(LazyRef FlattenConcatLogic$lzy1$2, Attributes enclosingAttributes$2) {
        return (FlattenConcat$FlattenConcatLogic$2$)(FlattenConcatLogic$lzy1$2.initialized() ? FlattenConcatLogic$lzy1$2.value() : this.FlattenConcatLogic$lzyINIT1$1(FlattenConcatLogic$lzy1$2, enclosingAttributes$2));
    }

    public static final /* synthetic */ void org$apache$pekko$stream$impl$fusing$FlattenConcat$FlattenConcatLogic$2$$$_$$lessinit$greater$$anonfun$2(AsyncCallback $1$$1, InflightSource t) {
        $1$$1.invoke(t);
    }

    public static final class InflightCompletedFutureSource<T>
    extends InflightSource<T> {
        private final Try<T> result;
        private boolean _hasNext;

        public InflightCompletedFutureSource(Try<T> result) {
            this.result = result;
            this._hasNext = result.isSuccess();
        }

        @Override
        public boolean hasNext() {
            return this._hasNext;
        }

        @Override
        public T next() {
            if (this._hasNext) {
                this._hasNext = false;
                return (T)this.result.get();
            }
            throw new NoSuchElementException("next called after completion");
        }

        @Override
        public boolean hasFailed() {
            return this.result.isFailure();
        }

        @Override
        public Option<Throwable> failure() {
            return this.result.failed().toOption();
        }

        @Override
        public void tryPull() {
        }

        @Override
        public void cancel(Throwable cause) {
        }

        @Override
        public boolean isClosed() {
            return true;
        }
    }

    public static final class InflightIteratorSource<T>
    extends InflightSource<T> {
        private final Iterator<T> iterator;

        public InflightIteratorSource(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return (T)this.iterator.next();
        }

        @Override
        public void tryPull() {
        }

        @Override
        public void cancel(Throwable cause) {
        }

        @Override
        public boolean isClosed() {
            return !this.hasNext();
        }
    }

    public static final class InflightPendingFutureSource<T>
    extends InflightSource<T>
    implements Function1<Try<T>, BoxedUnit> {
        private final Function1<InflightSource<T>, BoxedUnit> cb;
        private Try<T> result;
        private boolean consumed;

        public InflightPendingFutureSource(Function1<InflightSource<T>, BoxedUnit> cb) {
            this.cb = cb;
            this.result = MapAsync$.MODULE$.NotYetThere();
            this.consumed = false;
        }

        public void apply(Try<T> result) {
            this.result = result;
            this.cb.apply((Object)this);
        }

        @Override
        public boolean hasNext() {
            return this.result != MapAsync$.MODULE$.NotYetThere() && !this.consumed && this.result.isSuccess();
        }

        @Override
        public T next() {
            if (!this.consumed) {
                this.consumed = true;
                return (T)this.result.get();
            }
            throw new NoSuchElementException("next called after completion");
        }

        @Override
        public boolean hasFailed() {
            return this.result != MapAsync$.MODULE$.NotYetThere() && this.result.isFailure();
        }

        @Override
        public Option<Throwable> failure() {
            if (this.result == MapAsync$.MODULE$.NotYetThere()) {
                return None$.MODULE$;
            }
            return this.result.failed().toOption();
        }

        @Override
        public void tryPull() {
        }

        @Override
        public void cancel(Throwable cause) {
        }

        @Override
        public boolean isClosed() {
            return this.consumed || this.hasFailed();
        }
    }

    public static abstract class InflightSource<T> {
        public abstract boolean hasNext();

        public abstract T next();

        public abstract void tryPull();

        public abstract void cancel(Throwable var1);

        public abstract boolean isClosed();

        public boolean hasFailed() {
            return this.failure().isDefined();
        }

        public Option<Throwable> failure() {
            return None$.MODULE$;
        }

        public void materialize() {
        }
    }
}

