/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.streamref;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.SinkRef;
import org.apache.pekko.stream.SourceRef;
import org.apache.pekko.stream.StreamRefResolver;
import org.apache.pekko.stream.impl.streamref.SinkRefImpl;
import org.apache.pekko.stream.impl.streamref.SinkRefImpl$;
import org.apache.pekko.stream.impl.streamref.SourceRefImpl;
import org.apache.pekko.stream.impl.streamref.SourceRefImpl$;

@InternalApi
public final class StreamRefResolverImpl
implements StreamRefResolver {
    private final ExtendedActorSystem system;

    public StreamRefResolverImpl(ExtendedActorSystem system) {
        this.system = system;
    }

    @Override
    public <T> String toSerializationFormat(SourceRef<T> ref) {
        SourceRef<T> sourceRef = ref;
        if (sourceRef instanceof SourceRefImpl) {
            ActorRef actorRef;
            SourceRefImpl sourceRefImpl = SourceRefImpl$.MODULE$.unapply((SourceRefImpl)sourceRef);
            ActorRef actorRef2 = actorRef = sourceRefImpl._1();
            return actorRef2.path().toSerializationFormatWithAddress(this.system.provider().getDefaultAddress());
        }
        SourceRef<T> other = sourceRef;
        throw new IllegalArgumentException(new StringBuilder(27).append("Unexpected SourceRef impl: ").append(other.getClass()).toString());
    }

    @Override
    public <T> String toSerializationFormat(SinkRef<T> ref) {
        SinkRef<T> sinkRef = ref;
        if (sinkRef instanceof SinkRefImpl) {
            ActorRef actorRef;
            SinkRefImpl sinkRefImpl = SinkRefImpl$.MODULE$.unapply((SinkRefImpl)sinkRef);
            ActorRef actorRef2 = actorRef = sinkRefImpl._1();
            return actorRef2.path().toSerializationFormatWithAddress(this.system.provider().getDefaultAddress());
        }
        SinkRef<T> other = sinkRef;
        throw new IllegalArgumentException(new StringBuilder(25).append("Unexpected SinkRef impl: ").append(other.getClass()).toString());
    }

    @Override
    public <T> SourceRef<T> resolveSourceRef(String serializedSourceRef) {
        return SourceRefImpl$.MODULE$.apply(this.system.provider().resolveActorRef(serializedSourceRef));
    }

    @Override
    public <T> SinkRef<T> resolveSinkRef(String serializedSinkRef) {
        return SinkRefImpl$.MODULE$.apply(this.system.provider().resolveActorRef(serializedSinkRef));
    }
}

