/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.pattern.RetrySupport$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$LogLevels$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.RestartSettings;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogicWithLogging;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NoStackTrace;

public abstract class RestartWithBackoffLogic<S extends Shape>
extends TimerGraphStageLogicWithLogging {
    private final String name;
    private final Attributes inheritedAttributes;
    public final RestartSettings org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings;
    public final boolean org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures;
    private int restartCount;
    private Deadline resetDeadline;
    private boolean finishing;

    public RestartWithBackoffLogic(String name, S shape, Attributes inheritedAttributes, RestartSettings settings, boolean onlyOnFailures) {
        this.name = name;
        this.inheritedAttributes = inheritedAttributes;
        this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings = settings;
        this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures = onlyOnFailures;
        super((Shape)shape);
        this.restartCount = 0;
        this.resetDeadline = settings.maxRestartsWithin().fromNow();
        this.finishing = false;
    }

    public int restartCount() {
        return this.restartCount;
    }

    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    public Deadline resetDeadline() {
        return this.resetDeadline;
    }

    public void resetDeadline_$eq(Deadline x$1) {
        this.resetDeadline = x$1;
    }

    public boolean finishing() {
        return this.finishing;
    }

    public void finishing_$eq(boolean x$1) {
        this.finishing = x$1;
    }

    @Override
    public Class<?> logSource() {
        return RestartWithBackoffLogic.class;
    }

    public abstract void startGraph();

    public abstract void backoff();

    private boolean loggingEnabled() {
        Option option = this.inheritedAttributes.get(ClassTag$.MODULE$.apply(Attributes.LogLevels.class));
        if (option instanceof Some) {
            Attributes.LogLevels levels = (Attributes.LogLevels)((Some)option).value();
            return levels.onFailure() != Attributes$LogLevels$.MODULE$.Off();
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    public final <T> GraphStageLogic.SubSinkInlet<T> createSubInlet(Outlet<T> out) {
        GraphStageLogic.SubSinkInlet sinkIn = new GraphStageLogic.SubSinkInlet(this, new StringBuilder(24).append("RestartWithBackoff").append(this.name).append(".subIn").toString());
        sinkIn.setHandler(new InHandler(out, sinkIn, this){
            private final Outlet out$1;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            {
                this.out$1 = out$2;
                this.sinkIn$1 = sinkIn$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onPush() {
                this.$outer.protected$push(this.out$1, this.sinkIn$1.grab());
            }

            public void onUpstreamFinish() {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.protected$complete(this.out$1);
                    return;
                }
                String string = new StringBuilder(38).append("Restarting stream due to completion [").append(this.$outer.restartCount() + 1).append("]").toString();
                OptionVal$.MODULE$.None();
                this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt(string, null, Logging$.MODULE$.InfoLevel());
                this.$outer.scheduleRestartTimer();
            }

            public void onUpstreamFailure(Throwable ex) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || !BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.restartOn().apply((Object)ex))) {
                    this.$outer.protected$fail(this.out$1, ex);
                    return;
                }
                this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt(new StringBuilder(37).append("Restarting stream due to failure [").append(this.$outer.restartCount() + 1).append("]: ").append(ex).toString(), (Throwable)OptionVal.Some$.MODULE$.apply((Object)ex), this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt$default$3());
                this.$outer.scheduleRestartTimer();
            }
        });
        this.setHandler(out, new OutHandler(sinkIn, this){
            private final GraphStageLogic.SubSinkInlet sinkIn$2;
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            {
                this.sinkIn$2 = sinkIn$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onPull() {
                this.sinkIn$2.pull();
            }

            public void onDownstreamFinish(Throwable cause) {
                this.$outer.finishing_$eq(true);
                this.sinkIn$2.cancel(cause);
            }
        });
        return sinkIn;
    }

    private int logLevel(int minLogLevel) {
        int level = this.restartCount() >= this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.logSettings().criticalLogLevelAfter() ? this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.logSettings().criticalLogLevel() : this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.logSettings().logLevel();
        return (Logging.LogLevel$.MODULE$.$greater$eq$extension(level, minLogLevel) || level == Logging$.MODULE$.OffLevel() ? new Logging.LogLevel(level) : new Logging.LogLevel(minLogLevel)).asInt();
    }

    public void org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt(String message, Throwable exc, int minLogLevel) {
        if (this.loggingEnabled()) {
            int n = this.logLevel(minLogLevel);
            if (Logging$.MODULE$.ErrorLevel() == n) {
                Throwable throwable = exc;
                Throwable throwable2 = (Throwable)OptionVal.Some$.MODULE$.unapply((Object)throwable);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)throwable2)) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)OptionVal$.MODULE$.get$extension((Object)throwable2);
                    this.log().error(e, message);
                    return;
                }
                this.log().error(message);
                return;
            }
            if (Logging$.MODULE$.WarningLevel() == n) {
                if (this.log().isWarningEnabled()) {
                    Throwable throwable;
                    Throwable e;
                    Throwable throwable4 = exc;
                    Throwable throwable5 = (Throwable)OptionVal.Some$.MODULE$.unapply((Object)throwable4);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)throwable5) && !((e = (throwable = (Throwable)OptionVal$.MODULE$.get$extension((Object)throwable5))) instanceof NoStackTrace)) {
                        this.log().warning(new StringBuilder(0).append(message).append(String.valueOf(Logging$.MODULE$.stackTraceFor(e))).toString());
                        return;
                    }
                    this.log().warning(message);
                    return;
                }
                return;
            }
            if (Logging$.MODULE$.InfoLevel() == n) {
                this.log().info(message);
                return;
            }
            if (Logging$.MODULE$.DebugLevel() == n) {
                this.log().debug(message);
                return;
            }
            return;
        }
    }

    public int org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$logIt$default$3() {
        return Logging$.MODULE$.ErrorLevel();
    }

    public final <T> GraphStageLogic.SubSourceOutlet<T> createSubOutlet(Inlet<T> in) {
        GraphStageLogic.SubSourceOutlet sourceOut = new GraphStageLogic.SubSourceOutlet(this, new StringBuilder(25).append("RestartWithBackoff").append(this.name).append(".subOut").toString());
        sourceOut.setHandler(new OutHandler(in, sourceOut, this){
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            {
                this.in$1 = in$3;
                this.sourceOut$1 = sourceOut$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onPull() {
                if (this.$outer.protected$isAvailable(this.in$1)) {
                    this.sourceOut$1.push(this.$outer.protected$grab(this.in$1));
                    return;
                }
                if (!this.$outer.protected$hasBeenPulled(this.in$1)) {
                    this.$outer.protected$pull(this.in$1);
                    return;
                }
            }

            public void onDownstreamFinish(Throwable cause) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures || !BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.restartOn().apply((Object)cause))) {
                    this.$outer.protected$cancel(this.in$1, cause);
                    return;
                }
                this.$outer.scheduleRestartTimer();
            }
        });
        this.setHandler(in, new InHandler(sourceOut, in, this){
            private final GraphStageLogic.SubSourceOutlet sourceOut$2;
            private final Inlet in$2;
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            {
                this.sourceOut$2 = sourceOut$4;
                this.in$2 = in$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onPush() {
                if (this.sourceOut$2.isAvailable()) {
                    this.sourceOut$2.push(this.$outer.protected$grab(this.in$2));
                    return;
                }
            }

            public void onUpstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sourceOut$2.complete();
            }

            public void onUpstreamFailure(Throwable ex) {
                this.$outer.finishing_$eq(true);
                this.sourceOut$2.fail(ex);
            }
        });
        return sourceOut;
    }

    public final boolean maxRestartsReached() {
        if (this.resetDeadline().isOverdue()) {
            this.log().debug("Last restart attempt was more than {} ago, resetting restart count", (Object)this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxRestartsWithin().toCoarsest());
            this.restartCount_$eq(0);
        }
        return this.restartCount() == this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxRestarts();
    }

    public final void scheduleRestartTimer() {
        FiniteDuration restartDelay = RetrySupport$.MODULE$.calculateDelay(this.restartCount(), this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.minBackoff(), this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxBackoff(), this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.randomFactor());
        this.log().debug("Restarting graph in {}", (Object)restartDelay.toCoarsest());
        this.scheduleOnce((Object)"RestartTimer", restartDelay);
        this.restartCount_$eq(this.restartCount() + 1);
        this.backoff();
    }

    @Override
    public void onTimer(Object timerKey) {
        this.startGraph();
        this.resetDeadline_$eq(this.org$apache$pekko$stream$scaladsl$RestartWithBackoffLogic$$settings.maxRestartsWithin().fromNow());
    }

    @Override
    public void preStart() {
        this.startGraph();
    }

    public <T> void protected$push(Outlet<T> out, T elem) {
        this.push(out, elem);
    }

    public <T> void protected$complete(Outlet<T> out) {
        this.complete(out);
    }

    public <T> void protected$fail(Outlet<T> out, Throwable ex) {
        this.fail(out, ex);
    }

    public <T> boolean protected$isAvailable(Inlet<T> in) {
        return this.isAvailable(in);
    }

    public <T> T protected$grab(Inlet<T> in) {
        return this.grab(in);
    }

    public <T> boolean protected$hasBeenPulled(Inlet<T> in) {
        return this.hasBeenPulled(in);
    }

    public <T> void protected$pull(Inlet<T> in) {
        this.pull(in);
    }

    public <T> void protected$cancel(Inlet<T> in, Throwable cause) {
        this.cancel(in, cause);
    }
}

