/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.InPort;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.OutPort;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.Shape$;
import org.apache.pekko.stream.impl.AtomicTraversalBuilder$;
import org.apache.pekko.stream.impl.CompletedTraversalBuilder$;
import org.apache.pekko.stream.impl.CompositeTraversalBuilder$;
import org.apache.pekko.stream.impl.IslandTag;
import org.apache.pekko.stream.impl.MaterializeAtomic$;
import org.apache.pekko.stream.impl.StreamLayout;
import org.apache.pekko.stream.impl.TraversalBuilder;
import org.apache.pekko.stream.impl.TraversalBuilder$;
import org.apache.pekko.stream.scaladsl.Keep$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class AtomicTraversalBuilder
implements TraversalBuilder,
Product,
Serializable {
    private final StreamLayout.AtomicModule module;
    private final int[] outToSlot;
    private final int unwiredOuts;
    private final Attributes attributes;
    private final int inSlots;

    public static AtomicTraversalBuilder apply(StreamLayout.AtomicModule<Shape, Object> atomicModule, int[] nArray, int n, Attributes attributes) {
        return AtomicTraversalBuilder$.MODULE$.apply(atomicModule, nArray, n, attributes);
    }

    public static AtomicTraversalBuilder fromProduct(Product product) {
        return AtomicTraversalBuilder$.MODULE$.fromProduct(product);
    }

    public static AtomicTraversalBuilder unapply(AtomicTraversalBuilder atomicTraversalBuilder) {
        return AtomicTraversalBuilder$.MODULE$.unapply(atomicTraversalBuilder);
    }

    public AtomicTraversalBuilder(StreamLayout.AtomicModule<Shape, Object> module, int[] outToSlot, int unwiredOuts, Attributes attributes) {
        this.module = module;
        this.outToSlot = outToSlot;
        this.unwiredOuts = unwiredOuts;
        this.attributes = attributes;
        this.inSlots = ((Shape)module.shape()).inlets().size();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)-1034453656);
        n = Statics.mix((int)n, (int)Statics.anyHash(this.module()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.outToSlot()));
        n = Statics.mix((int)n, (int)this.unwiredOuts());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.attributes()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AtomicTraversalBuilder)) return false;
        AtomicTraversalBuilder atomicTraversalBuilder = (AtomicTraversalBuilder)object;
        if (this.unwiredOuts() != atomicTraversalBuilder.unwiredOuts()) return false;
        StreamLayout.AtomicModule<Shape, Object> atomicModule = this.module();
        StreamLayout.AtomicModule<Shape, Object> atomicModule2 = atomicTraversalBuilder.module();
        if (atomicModule == null) {
            if (atomicModule2 != null) {
                return false;
            }
        } else if (!atomicModule.equals(atomicModule2)) return false;
        if (this.outToSlot() != atomicTraversalBuilder.outToSlot()) return false;
        Attributes attributes = this.attributes();
        Attributes attributes2 = atomicTraversalBuilder.attributes();
        if (attributes == null) {
            if (attributes2 == null) return true;
            return false;
        } else {
            if (!((Object)attributes).equals(attributes2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AtomicTraversalBuilder;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "AtomicTraversalBuilder";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "module";
            }
            case 1: {
                return "outToSlot";
            }
            case 2: {
                return "unwiredOuts";
            }
            case 3: {
                return "attributes";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public StreamLayout.AtomicModule<Shape, Object> module() {
        return this.module;
    }

    public int[] outToSlot() {
        return this.outToSlot;
    }

    @Override
    public int unwiredOuts() {
        return this.unwiredOuts;
    }

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    public TraversalBuilder add(TraversalBuilder submodule, Shape shape, Function2<Nothing$, Nothing$, Object> combineMat) {
        return CompositeTraversalBuilder$.MODULE$.apply(CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$1(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$2(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$3(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$4(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$5(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$6(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$7(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$8(), this.attributes(), CompositeTraversalBuilder$.MODULE$.$lessinit$greater$default$10()).add(this, (Shape)this.module().shape(), (Function2<Nothing$, Nothing$, Object>)Keep$.MODULE$.right()).add(submodule, shape, combineMat);
    }

    @Override
    public TraversalBuilder transformMat(Function1<Nothing$, Object> f) {
        return TraversalBuilder$.MODULE$.empty(TraversalBuilder$.MODULE$.empty$default$1()).add(this, (Shape)this.module().shape(), (Function2<Nothing$, Nothing$, Object>)Keep$.MODULE$.right()).transformMat(f);
    }

    @Override
    public int inSlots() {
        return this.inSlots;
    }

    @Override
    public int offsetOfModule(OutPort out) {
        return 0;
    }

    @Override
    public int offsetOf(InPort in) {
        return in.id();
    }

    @Override
    public boolean isTraversalComplete() {
        return false;
    }

    @Override
    public boolean isUnwired(OutPort out) {
        return true;
    }

    @Override
    public boolean isUnwired(InPort in) {
        return true;
    }

    @Override
    public TraversalBuilder wire(OutPort out, InPort in) {
        return this.assign(out, this.offsetOf(in) - this.offsetOfModule(out));
    }

    @Override
    public TraversalBuilder assign(OutPort out, int relativeSlot) {
        TraversalBuilder traversalBuilder;
        int[] newOutToSlot = Arrays.copyOf(this.outToSlot(), this.outToSlot().length);
        newOutToSlot[out.id()] = relativeSlot;
        int newUnwiredOuts = this.unwiredOuts() - 1;
        if (newUnwiredOuts == 0) {
            Seq<Inlet<?>> inlets = ((Shape)this.module().shape()).inlets();
            Map inToOffset = inlets.isEmpty() ? Predef$.MODULE$.Map().empty() : (Shape$.MODULE$.hasOnePort(inlets) ? new Map.Map1(inlets.head(), (Object)BoxesRunTime.boxToInteger((int)((InPort)inlets.head()).id())) : inlets.iterator().map((Function1 & Serializable)in -> {
                InPort inPort = (InPort)Predef$.MODULE$.ArrowAssoc(in);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)inPort, (Object)BoxesRunTime.boxToInteger((int)in.id()));
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            traversalBuilder = CompletedTraversalBuilder$.MODULE$.apply(MaterializeAtomic$.MODULE$.apply(this.module(), newOutToSlot), this.inSlots(), (Map<InPort, Object>)inToOffset, this.attributes(), CompletedTraversalBuilder$.MODULE$.$lessinit$greater$default$5());
        } else {
            traversalBuilder = this.copy(this.copy$default$1(), newOutToSlot, newUnwiredOuts, this.copy$default$4());
        }
        return traversalBuilder;
    }

    @Override
    public TraversalBuilder internalSetAttributes(Attributes attributes) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), attributes);
    }

    @Override
    public TraversalBuilder makeIsland(IslandTag islandTag) {
        return TraversalBuilder$.MODULE$.empty(TraversalBuilder$.MODULE$.empty$default$1()).add(this, (Shape)this.module().shape(), (Function2<Nothing$, Nothing$, Object>)Keep$.MODULE$.right()).makeIsland(islandTag);
    }

    public AtomicTraversalBuilder copy(StreamLayout.AtomicModule<Shape, Object> module, int[] outToSlot, int unwiredOuts, Attributes attributes) {
        return new AtomicTraversalBuilder(module, outToSlot, unwiredOuts, attributes);
    }

    public StreamLayout.AtomicModule<Shape, Object> copy$default$1() {
        return this.module();
    }

    public int[] copy$default$2() {
        return this.outToSlot();
    }

    public int copy$default$3() {
        return this.unwiredOuts();
    }

    public Attributes copy$default$4() {
        return this.attributes();
    }

    public StreamLayout.AtomicModule<Shape, Object> _1() {
        return this.module();
    }

    public int[] _2() {
        return this.outToSlot();
    }

    public int _3() {
        return this.unwiredOuts();
    }

    public Attributes _4() {
        return this.attributes();
    }
}

