/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.Done$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BufferOverflowException;
import org.apache.pekko.stream.BufferOverflowException$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.OverflowStrategies;
import org.apache.pekko.stream.OverflowStrategy;
import org.apache.pekko.stream.QueueOfferResult;
import org.apache.pekko.stream.QueueOfferResult$Dropped$;
import org.apache.pekko.stream.QueueOfferResult$Enqueued$;
import org.apache.pekko.stream.QueueOfferResult$Failure$;
import org.apache.pekko.stream.QueueOfferResult$QueueClosed$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.StreamDetachedException;
import org.apache.pekko.stream.impl.Buffer;
import org.apache.pekko.stream.impl.Buffer$;
import org.apache.pekko.stream.impl.QueueSource$Completion$;
import org.apache.pekko.stream.impl.QueueSource$Failure$;
import org.apache.pekko.stream.impl.QueueSource$Offer$;
import org.apache.pekko.stream.scaladsl.SourceQueueWithComplete;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.StageLogging;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Try;
import scala.util.hashing.MurmurHash3$;

@InternalApi
public final class QueueSource<T>
extends GraphStageWithMaterializedValue<SourceShape<T>, SourceQueueWithComplete<T>> {
    public final int org$apache$pekko$stream$impl$QueueSource$$maxBuffer;
    public final OverflowStrategy org$apache$pekko$stream$impl$QueueSource$$overflowStrategy;
    public final int org$apache$pekko$stream$impl$QueueSource$$maxConcurrentOffers;
    private final Outlet out;
    private final SourceShape shape;

    public QueueSource(int maxBuffer, OverflowStrategy overflowStrategy, int maxConcurrentOffers) {
        this.org$apache$pekko$stream$impl$QueueSource$$maxBuffer = maxBuffer;
        this.org$apache$pekko$stream$impl$QueueSource$$overflowStrategy = overflowStrategy;
        this.org$apache$pekko$stream$impl$QueueSource$$maxConcurrentOffers = maxConcurrentOffers;
        Predef$.MODULE$.require(maxConcurrentOffers > 0, QueueSource::$init$$$anonfun$1);
        this.out = Outlet$.MODULE$.apply("queueSource.out");
        this.shape = SourceShape$.MODULE$.of(this.out());
    }

    public Outlet<T> out() {
        return this.out;
    }

    @Override
    public SourceShape<T> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, SourceQueueWithComplete<T>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise completion = Promise$.MODULE$.apply();
        String name = inheritedAttributes.nameOrDefault(this.getClass().toString());
        OutHandler stageLogic = new OutHandler(name, completion, inheritedAttributes, this){
            private final Attributes inheritedAttributes$2;
            private final Promise completion$3;
            private final String name$3;
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private Buffer buffer;
            private Buffer pendingOffers;
            private boolean terminating;
            private final AsyncCallback callback;
            private final /* synthetic */ QueueSource $outer;
            {
                this.inheritedAttributes$2 = inheritedAttributes$1;
                this.completion$3 = completion$2;
                this.name$3 = name$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$(this);
                this.terminating = false;
                this.callback = this.getAsyncCallback((JProcedure1 & Serializable)x$1 -> {
                    Input input = x$1;
                    if (input instanceof Offer) {
                        Promise<QueueOfferResult> promise;
                        Offer offer = (Offer)input;
                        Offer<T> offer2 = QueueSource$Offer$.MODULE$.unapply(offer);
                        T t = offer2._1();
                        Promise<QueueOfferResult> promise2 = promise = offer2._2();
                        if (this.terminating()) {
                            promise2.success((Object)QueueOfferResult$Dropped$.MODULE$);
                            return;
                        }
                        T elem = t;
                        Promise<QueueOfferResult> promise3 = promise;
                        Offer offer3 = offer;
                        if ($outer$1.org$apache$pekko$stream$impl$QueueSource$$maxBuffer != 0) {
                            this.bufferElem(offer3);
                            if (this.isAvailable($outer.out())) {
                                this.push($outer.out(), this.buffer().dequeue());
                                return;
                            }
                            return;
                        }
                        if (this.isAvailable($outer.out())) {
                            this.push($outer.out(), elem);
                            promise3.success((Object)QueueOfferResult$Enqueued$.MODULE$);
                            return;
                        }
                        if (!this.pendingOffers().isFull()) {
                            this.pendingOffers().enqueue(offer3);
                            return;
                        }
                        OverflowStrategy overflowStrategy = $outer$1.org$apache$pekko$stream$impl$QueueSource$$overflowStrategy;
                        if (overflowStrategy instanceof OverflowStrategies.DropHead || overflowStrategy instanceof OverflowStrategies.DropBuffer) {
                            Product s = (Product)overflowStrategy;
                            this.log().log(((OverflowStrategy)s).logLevel(), "Dropping element because buffer is full and overflowStrategy is: [{}] in stream [{}]", (Object)s, (Object)name$2);
                            ((Offer)this.pendingOffers().dequeue()).promise().success((Object)QueueOfferResult$Dropped$.MODULE$);
                            this.pendingOffers().enqueue(offer3);
                            return;
                        }
                        if (overflowStrategy instanceof OverflowStrategies.DropTail || overflowStrategy instanceof OverflowStrategies.DropNew) {
                            Product s = (Product)overflowStrategy;
                            this.log().log(((OverflowStrategy)s).logLevel(), "Dropping element because buffer is full and overflowStrategy is: [{}] in stream [{}]", (Object)s, (Object)name$2);
                            promise3.success((Object)QueueOfferResult$Dropped$.MODULE$);
                            return;
                        }
                        if (overflowStrategy instanceof OverflowStrategies.Fail) {
                            OverflowStrategies.Fail s = (OverflowStrategies.Fail)overflowStrategy;
                            this.log().log(s.logLevel(), "Failing because buffer is full and overflowStrategy is: [Fail] in stream [{}]", (Object)name$2);
                            BufferOverflowException bufferOverflowException = BufferOverflowException$.MODULE$.apply(new StringBuilder(37).append("Buffer overflow (max capacity was: ").append($outer$1.org$apache$pekko$stream$impl$QueueSource$$maxBuffer).append(")!").toString());
                            promise3.success((Object)QueueOfferResult$Failure$.MODULE$.apply(bufferOverflowException));
                            completion$2.failure((Throwable)bufferOverflowException);
                            this.failStage(bufferOverflowException);
                            return;
                        }
                        if (overflowStrategy instanceof OverflowStrategies.Backpressure) {
                            OverflowStrategies.Backpressure s = (OverflowStrategies.Backpressure)overflowStrategy;
                            this.log().log(s.logLevel(), "Failing because buffer is full and overflowStrategy is: [Backpressure] in stream [{}]", (Object)name$2);
                            promise3.failure((Throwable)new IllegalStateException("You have to wait for previous offer to be resolved to send another request"));
                            return;
                        }
                        throw new MatchError((Object)overflowStrategy);
                    }
                    if (QueueSource$Completion$.MODULE$.equals(input)) {
                        if ($outer$1.org$apache$pekko$stream$impl$QueueSource$$maxBuffer != 0 && this.buffer().nonEmpty() || this.pendingOffers().nonEmpty()) {
                            this.terminating_$eq(true);
                            return;
                        }
                        completion$2.success((Object)Done$.MODULE$);
                        this.completeStage();
                        return;
                    }
                    if (input instanceof Failure) {
                        Throwable throwable;
                        Failure failure = QueueSource$Failure$.MODULE$.unapply((Failure)input);
                        Throwable ex = throwable = failure._1();
                        completion$2.failure(ex);
                        this.failStage(ex);
                        return;
                    }
                    throw new MatchError((Object)input);
                });
                this.setHandler($outer.out(), this);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            public Class logSource() {
                return QueueSource.class;
            }

            public Buffer buffer() {
                return this.buffer;
            }

            public void buffer_$eq(Buffer x$1) {
                this.buffer = x$1;
            }

            public Buffer pendingOffers() {
                return this.pendingOffers;
            }

            public void pendingOffers_$eq(Buffer x$1) {
                this.pendingOffers = x$1;
            }

            public boolean terminating() {
                return this.terminating;
            }

            public void terminating_$eq(boolean x$1) {
                this.terminating = x$1;
            }

            public void preStart() {
                if (this.$outer.org$apache$pekko$stream$impl$QueueSource$$maxBuffer > 0) {
                    this.buffer_$eq(Buffer$.MODULE$.apply(this.$outer.org$apache$pekko$stream$impl$QueueSource$$maxBuffer, this.inheritedAttributes$2));
                }
                this.pendingOffers_$eq(Buffer$.MODULE$.apply(this.$outer.org$apache$pekko$stream$impl$QueueSource$$maxConcurrentOffers, this.inheritedAttributes$2));
            }

            public void postStop() {
                StreamDetachedException exception = new StreamDetachedException();
                this.completion$3.tryFailure((Throwable)exception);
            }

            private void enqueueAndSuccess(Offer offer) {
                this.buffer().enqueue(offer.elem());
                offer.promise().success((Object)QueueOfferResult$Enqueued$.MODULE$);
            }

            private void bufferElem(Offer offer) {
                if (!this.buffer().isFull()) {
                    this.enqueueAndSuccess(offer);
                    return;
                }
                OverflowStrategy overflowStrategy = this.$outer.org$apache$pekko$stream$impl$QueueSource$$overflowStrategy;
                if (overflowStrategy instanceof OverflowStrategies.DropHead) {
                    OverflowStrategies.DropHead s = (OverflowStrategies.DropHead)overflowStrategy;
                    this.log().log(s.logLevel(), "Dropping the head element because buffer is full and overflowStrategy is: [DropHead] in stream [{}]", (Object)this.name$3);
                    this.buffer().dropHead();
                    this.enqueueAndSuccess(offer);
                    return;
                }
                if (overflowStrategy instanceof OverflowStrategies.DropTail) {
                    OverflowStrategies.DropTail s = (OverflowStrategies.DropTail)overflowStrategy;
                    this.log().log(s.logLevel(), "Dropping the tail element because buffer is full and overflowStrategy is: [DropTail] in stream [{}]", (Object)this.name$3);
                    this.buffer().dropTail();
                    this.enqueueAndSuccess(offer);
                    return;
                }
                if (overflowStrategy instanceof OverflowStrategies.DropBuffer) {
                    OverflowStrategies.DropBuffer s = (OverflowStrategies.DropBuffer)overflowStrategy;
                    this.log().log(s.logLevel(), "Dropping all the buffered elements because buffer is full and overflowStrategy is: [DropBuffer] in stream [{}]", (Object)this.name$3);
                    this.buffer().clear();
                    this.enqueueAndSuccess(offer);
                    return;
                }
                if (overflowStrategy instanceof OverflowStrategies.DropNew) {
                    OverflowStrategies.DropNew s = (OverflowStrategies.DropNew)overflowStrategy;
                    this.log().log(s.logLevel(), "Dropping the new element because buffer is full and overflowStrategy is: [DropNew] in stream [{}]", (Object)this.name$3);
                    offer.promise().success((Object)QueueOfferResult$Dropped$.MODULE$);
                    return;
                }
                if (overflowStrategy instanceof OverflowStrategies.Fail) {
                    OverflowStrategies.Fail s = (OverflowStrategies.Fail)overflowStrategy;
                    this.log().log(s.logLevel(), "Failing because buffer is full and overflowStrategy is: [Fail] in stream [{}]", (Object)this.name$3);
                    BufferOverflowException bufferOverflowException = BufferOverflowException$.MODULE$.apply(new StringBuilder(37).append("Buffer overflow (max capacity was: ").append(this.$outer.org$apache$pekko$stream$impl$QueueSource$$maxBuffer).append(")!").toString());
                    offer.promise().success((Object)QueueOfferResult$Failure$.MODULE$.apply(bufferOverflowException));
                    this.completion$3.failure((Throwable)bufferOverflowException);
                    this.failStage(bufferOverflowException);
                    return;
                }
                if (overflowStrategy instanceof OverflowStrategies.Backpressure) {
                    OverflowStrategies.Backpressure s = (OverflowStrategies.Backpressure)overflowStrategy;
                    this.log().log(s.logLevel(), "Backpressuring because buffer is full and overflowStrategy is: [Backpressure] in stream [{}]", (Object)this.name$3);
                    if (this.pendingOffers().isFull()) {
                        offer.promise().failure((Throwable)new IllegalStateException(new StringBuilder(130).append("Too many concurrent offers. Specified maximum is ").append(this.$outer.org$apache$pekko$stream$impl$QueueSource$$maxConcurrentOffers).append(". ").append("You have to wait for one previous future to be resolved to send another request").toString()));
                        return;
                    }
                    this.pendingOffers().enqueue(offer);
                    return;
                }
                throw new MatchError((Object)overflowStrategy);
            }

            public void onDownstreamFinish(Throwable cause) {
                while (this.pendingOffers().nonEmpty()) {
                    ((Offer)this.pendingOffers().dequeue()).promise().success((Object)QueueOfferResult$QueueClosed$.MODULE$);
                }
                this.completion$3.success((Object)Done$.MODULE$);
                this.completeStage();
            }

            public void onPull() {
                if (this.$outer.org$apache$pekko$stream$impl$QueueSource$$maxBuffer == 0) {
                    if (this.pendingOffers().nonEmpty()) {
                        Offer offer = (Offer)this.pendingOffers().dequeue();
                        this.push(this.$outer.out(), offer.elem());
                        offer.promise().success((Object)QueueOfferResult$Enqueued$.MODULE$);
                        if (this.terminating()) {
                            this.completion$3.success((Object)Done$.MODULE$);
                            this.completeStage();
                            return;
                        }
                        return;
                    }
                    return;
                }
                if (this.buffer().nonEmpty()) {
                    this.push(this.$outer.out(), this.buffer().dequeue());
                    while (this.pendingOffers().nonEmpty() && !this.buffer().isFull()) {
                        this.enqueueAndSuccess((Offer)this.pendingOffers().dequeue());
                    }
                    if (this.terminating() && this.buffer().isEmpty()) {
                        this.completion$3.success((Object)Done$.MODULE$);
                        this.completeStage();
                        return;
                    }
                    return;
                }
            }

            public Future watchCompletion() {
                return this.completion$3.future();
            }

            public Future offer(Object element) {
                Promise p = Promise$.MODULE$.apply();
                this.callback.invokeWithFeedback(QueueSource$Offer$.MODULE$.apply(element, (Promise<QueueOfferResult>)p)).onComplete(arg_0 -> QueueSource.org$apache$pekko$stream$impl$QueueSource$$anon$1$$_$offer$$anonfun$1(p, arg_0), ExecutionContexts$.MODULE$.parasitic());
                return p.future();
            }

            public void complete() {
                this.callback.invoke(QueueSource$Completion$.MODULE$);
            }

            public void fail(Throwable ex) {
                this.callback.invoke(QueueSource$Failure$.MODULE$.apply(ex));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$2(org.apache.pekko.stream.impl.QueueSource java.lang.String scala.concurrent.Promise org.apache.pekko.stream.impl.QueueSource$Input ), org$apache$pekko$stream$impl$QueueSource$$anon$1$$_$offer$$anonfun$1(scala.concurrent.Promise scala.util.Try )}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply((Object)stageLogic, (Object)stageLogic);
    }

    private static final Object $init$$$anonfun$1() {
        return "Max concurrent offers must be greater than 0";
    }

    public static final /* synthetic */ Object org$apache$pekko$stream$impl$QueueSource$$anon$1$$_$offer$$anonfun$1(Promise p$1, Try x$1) {
        Try try_ = x$1;
        if (try_ instanceof Success) {
            return BoxedUnit.UNIT;
        }
        if (try_ instanceof scala.util.Failure) {
            Throwable e = ((scala.util.Failure)try_).exception();
            return BoxesRunTime.boxToBoolean((boolean)p$1.tryFailure(e));
        }
        throw new MatchError((Object)try_);
    }

    public static final class Failure
    implements Input<Nothing$>,
    Product,
    Serializable {
        private final Throwable ex;

        public static Failure apply(Throwable throwable) {
            return QueueSource$Failure$.MODULE$.apply(throwable);
        }

        public static Failure fromProduct(Product product) {
            return QueueSource$Failure$.MODULE$.fromProduct(product);
        }

        public static Failure unapply(Failure failure) {
            return QueueSource$Failure$.MODULE$.unapply(failure);
        }

        public Failure(Throwable ex) {
            this.ex = ex;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1408943127, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Failure)) return false;
            Failure failure = (Failure)object;
            Throwable throwable = this.ex();
            Throwable throwable2 = failure.ex();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Failure;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Failure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ex";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable ex() {
            return this.ex;
        }

        public Failure copy(Throwable ex) {
            return new Failure(ex);
        }

        public Throwable copy$default$1() {
            return this.ex();
        }

        public Throwable _1() {
            return this.ex();
        }
    }

    public static interface Input<T> {
    }

    public static final class Offer<T>
    implements Input<T>,
    Product,
    Serializable {
        private final Object elem;
        private final Promise promise;

        public static <T> Offer<T> apply(T t, Promise<QueueOfferResult> promise) {
            return QueueSource$Offer$.MODULE$.apply(t, promise);
        }

        public static Offer<?> fromProduct(Product product) {
            return QueueSource$Offer$.MODULE$.fromProduct(product);
        }

        public static <T> Offer<T> unapply(Offer<T> offer) {
            return QueueSource$Offer$.MODULE$.unapply(offer);
        }

        public Offer(T elem, Promise<QueueOfferResult> promise) {
            this.elem = elem;
            this.promise = promise;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -380722404, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Offer)) return false;
            Offer offer = (Offer)object;
            if (!BoxesRunTime.equals(this.elem(), offer.elem())) return false;
            Promise<QueueOfferResult> promise = this.promise();
            Promise<QueueOfferResult> promise2 = offer.promise();
            if (promise != null) {
                if (!promise.equals(promise2)) return false;
                return true;
            }
            if (promise2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Offer;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Offer";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "elem";
            }
            if (1 == n2) {
                return "promise";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public T elem() {
            return (T)this.elem;
        }

        public Promise<QueueOfferResult> promise() {
            return this.promise;
        }

        public <T> Offer<T> copy(T elem, Promise<QueueOfferResult> promise) {
            return new Offer<T>(elem, promise);
        }

        public <T> T copy$default$1() {
            return this.elem();
        }

        public <T> Promise<QueueOfferResult> copy$default$2() {
            return this.promise();
        }

        public T _1() {
            return this.elem();
        }

        public Promise<QueueOfferResult> _2() {
            return this.promise();
        }
    }
}

