/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.fusing.AggregateWithBoundary$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.hashing.MurmurHash3$;

@InternalApi
public final class AggregateWithBoundary<In, Agg, Out>
extends GraphStage<FlowShape<In, Out>>
implements Product,
Serializable {
    private final Function0 allocate;
    private final Function2 aggregate;
    private final Function1 harvest;
    private final Option emitOnTimer;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public static <In, Agg, Out> AggregateWithBoundary<In, Agg, Out> apply(Function0<Agg> function0, Function2<Agg, In, Tuple2<Agg, Object>> function2, Function1<Agg, Out> function1, Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> option) {
        return AggregateWithBoundary$.MODULE$.apply(function0, function2, function1, option);
    }

    public static AggregateWithBoundary<?, ?, ?> fromProduct(Product product) {
        return AggregateWithBoundary$.MODULE$.fromProduct(product);
    }

    public static <In, Agg, Out> AggregateWithBoundary<In, Agg, Out> unapply(AggregateWithBoundary<In, Agg, Out> aggregateWithBoundary) {
        return AggregateWithBoundary$.MODULE$.unapply(aggregateWithBoundary);
    }

    public AggregateWithBoundary(Function0<Agg> allocate, Function2<Agg, In, Tuple2<Agg, Object>> aggregate, Function1<Agg, Out> harvest, Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> emitOnTimer) {
        this.allocate = allocate;
        this.aggregate = aggregate;
        this.harvest = harvest;
        this.emitOnTimer = emitOnTimer;
        emitOnTimer.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                FiniteDuration interval = (FiniteDuration)tuple2._2();
                Predef$.MODULE$.require(interval.gteq((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).milli()), () -> AggregateWithBoundary.$init$$$anonfun$1$$anonfun$1(interval));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.in = Inlet$.MODULE$.apply(new StringBuilder(3).append(this.getClass().getName()).append(".in").toString());
        this.out = Outlet$.MODULE$.apply(new StringBuilder(4).append(this.getClass().getName()).append(".out").toString());
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -711534919, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AggregateWithBoundary)) return false;
        AggregateWithBoundary aggregateWithBoundary = (AggregateWithBoundary)object;
        Function0<Agg> function0 = this.allocate();
        Function0<Agg> function02 = aggregateWithBoundary.allocate();
        if (function0 == null) {
            if (function02 != null) {
                return false;
            }
        } else if (!function0.equals(function02)) return false;
        Function2<Agg, In, Tuple2<Agg, Object>> function2 = this.aggregate();
        Function2<Agg, In, Tuple2<Agg, Object>> function22 = aggregateWithBoundary.aggregate();
        if (function2 == null) {
            if (function22 != null) {
                return false;
            }
        } else if (!function2.equals(function22)) return false;
        Function1<Agg, Out> function1 = this.harvest();
        Function1<Agg, Out> function12 = aggregateWithBoundary.harvest();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> option = this.emitOnTimer();
        Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> option2 = aggregateWithBoundary.emitOnTimer();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AggregateWithBoundary;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "AggregateWithBoundary";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "allocate";
            }
            case 1: {
                return "aggregate";
            }
            case 2: {
                return "harvest";
            }
            case 3: {
                return "emitOnTimer";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Function0<Agg> allocate() {
        return this.allocate;
    }

    public Function2<Agg, In, Tuple2<Agg, Object>> aggregate() {
        return this.aggregate;
    }

    public Function1<Agg, Out> harvest() {
        return this.harvest;
    }

    public Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> emitOnTimer() {
        return this.emitOnTimer;
    }

    public Inlet<In> in() {
        return this.in;
    }

    public Outlet<Out> out() {
        return this.out;
    }

    @Override
    public FlowShape<In, Out> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private Object aggregated;
            private final /* synthetic */ AggregateWithBoundary $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.aggregated = null;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public void preStart() {
                this.$outer.emitOnTimer().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        FiniteDuration interval = (FiniteDuration)tuple2._2();
                        this.scheduleWithFixedDelay((Object)new StringBuilder(5).append(this.getClass().getSimpleName()).append("Timer").toString(), interval, interval);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }

            public void onTimer(Object timerKey) {
                this.$outer.emitOnTimer().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Function1 isReadyOnTimer = (Function1)tuple2._1();
                        if (this.aggregated != null && BoxesRunTime.unboxToBoolean((Object)isReadyOnTimer.apply(this.aggregated))) {
                            this.harvestAndEmit();
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }

            public void onPush() {
                Tuple2 tuple2;
                if (this.aggregated == null) {
                    this.aggregated = this.$outer.allocate().apply();
                }
                if ((tuple2 = (Tuple2)this.$outer.aggregate().apply(this.aggregated, this.grab(this.$outer.in()))) == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object updated = tuple2._1();
                boolean result = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(updated, (Object)BoxesRunTime.boxToBoolean((boolean)result));
                Object updated2 = tuple22._1();
                boolean result2 = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
                this.aggregated = updated2;
                if (result2) {
                    this.harvestAndEmit();
                }
                if (this.isAvailable(this.$outer.out())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void onUpstreamFinish() {
                if (this.aggregated != null) {
                    this.emit(this.$outer.out(), this.$outer.harvest().apply(this.aggregated));
                }
                this.completeStage();
            }

            public void onPull() {
                if (!this.hasBeenPulled(this.$outer.in())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            private void harvestAndEmit() {
                this.emit(this.$outer.out(), this.$outer.harvest().apply(this.aggregated));
                this.aggregated = null;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{preStart$$anonfun$1(scala.Tuple2 ), onTimer$$anonfun$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public <In, Agg, Out> AggregateWithBoundary<In, Agg, Out> copy(Function0<Agg> allocate, Function2<Agg, In, Tuple2<Agg, Object>> aggregate, Function1<Agg, Out> harvest, Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> emitOnTimer) {
        return new AggregateWithBoundary<In, Agg, Out>(allocate, aggregate, harvest, emitOnTimer);
    }

    public <In, Agg, Out> Function0<Agg> copy$default$1() {
        return this.allocate();
    }

    public <In, Agg, Out> Function2<Agg, In, Tuple2<Agg, Object>> copy$default$2() {
        return this.aggregate();
    }

    public <In, Agg, Out> Function1<Agg, Out> copy$default$3() {
        return this.harvest();
    }

    public <In, Agg, Out> Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> copy$default$4() {
        return this.emitOnTimer();
    }

    public Function0<Agg> _1() {
        return this.allocate();
    }

    public Function2<Agg, In, Tuple2<Agg, Object>> _2() {
        return this.aggregate();
    }

    public Function1<Agg, Out> _3() {
        return this.harvest();
    }

    public Option<Tuple2<Function1<Agg, Object>, FiniteDuration>> _4() {
        return this.emitOnTimer();
    }

    private static final Object $init$$$anonfun$1$$anonfun$1(FiniteDuration interval$1) {
        return new StringBuilder(36).append("timer(").append(interval$1.toCoarsest()).append(") must not be smaller than 1ms").toString();
    }
}

