/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.GroupedAdjacentByWeighted$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.StrictOptimizedLinearSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@InternalApi
public final class GroupedAdjacentByWeighted<T, R>
extends GraphStage<FlowShape<T, Seq<T>>>
implements Product,
Serializable {
    private final Function1 f;
    private final long maxWeight;
    private final Function1 costFn;
    public final Inlet<T> org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in;
    public final Outlet<Seq<T>> org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out;
    private final FlowShape shape;

    public static <T, R> GroupedAdjacentByWeighted<T, R> apply(Function1<T, R> function1, long l, Function1<T, Object> function12) {
        return GroupedAdjacentByWeighted$.MODULE$.apply(function1, l, function12);
    }

    public static GroupedAdjacentByWeighted<?, ?> fromProduct(Product product) {
        return GroupedAdjacentByWeighted$.MODULE$.fromProduct(product);
    }

    public static <T, R> GroupedAdjacentByWeighted<T, R> unapply(GroupedAdjacentByWeighted<T, R> groupedAdjacentByWeighted) {
        return GroupedAdjacentByWeighted$.MODULE$.unapply(groupedAdjacentByWeighted);
    }

    public GroupedAdjacentByWeighted(Function1<T, R> f, long maxWeight, Function1<T, Object> costFn) {
        this.f = f;
        this.maxWeight = maxWeight;
        this.costFn = costFn;
        Predef$.MODULE$.require(f != null, GroupedAdjacentByWeighted::$init$$$anonfun$1);
        Predef$.MODULE$.require(maxWeight > 0L, GroupedAdjacentByWeighted::$init$$$anonfun$2);
        Predef$.MODULE$.require(costFn != null, GroupedAdjacentByWeighted::$init$$$anonfun$3);
        this.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in = Inlet$.MODULE$.apply("GroupedAdjacentByWeighted.in");
        this.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out = Outlet$.MODULE$.apply("GroupedAdjacentByWeighted.out");
        this.shape = FlowShape$.MODULE$.apply(this.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in, this.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)-804170418);
        n = Statics.mix((int)n, (int)Statics.anyHash(this.f()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.maxWeight()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.costFn()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GroupedAdjacentByWeighted)) return false;
        GroupedAdjacentByWeighted groupedAdjacentByWeighted = (GroupedAdjacentByWeighted)object;
        if (this.maxWeight() != groupedAdjacentByWeighted.maxWeight()) return false;
        Function1<T, R> function1 = this.f();
        Function1<T, R> function12 = groupedAdjacentByWeighted.f();
        if (function1 == null) {
            if (function12 != null) {
                return false;
            }
        } else if (!function1.equals(function12)) return false;
        Function1<T, Object> function13 = this.costFn();
        Function1<T, Object> function14 = groupedAdjacentByWeighted.costFn();
        if (function13 == null) {
            if (function14 == null) return true;
            return false;
        } else {
            if (!function13.equals(function14)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof GroupedAdjacentByWeighted;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "GroupedAdjacentByWeighted";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "f";
            }
            case 1: {
                return "maxWeight";
            }
            case 2: {
                return "costFn";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Function1<T, R> f() {
        return this.f;
    }

    public long maxWeight() {
        return this.maxWeight;
    }

    public Function1<T, Object> costFn() {
        return this.costFn;
    }

    @Override
    public FlowShape<T, Seq<T>> shape() {
        return this.shape;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.groupedAdjacentByWeighted();
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private ReusableBuilder builder;
            private long currentWeight;
            private boolean hasElements;
            private Object currentKey;
            private Seq pendingGroup;
            private final /* synthetic */ GroupedAdjacentByWeighted $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.builder = package$.MODULE$.Vector().newBuilder();
                this.currentWeight = 0L;
                this.hasElements = false;
                this.currentKey = OptionVal$.MODULE$.none();
                this.pendingGroup = (Seq)OptionVal$.MODULE$.none();
                this.setHandlers($outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in, $outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, this);
            }

            public void onPush() {
                T elem = this.grab(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in);
                long cost = BoxesRunTime.unboxToLong((Object)this.$outer.costFn().apply(elem));
                if (cost < 0L) {
                    this.failStage(new IllegalArgumentException(new StringBuilder(48).append("Negative weight [").append(cost).append("] for element [").append(elem).append("] is not allowed").toString()));
                    return;
                }
                Object elemKey = this.$outer.f().apply(elem);
                Predef$.MODULE$.require(elemKey != null, GroupedAdjacentByWeighted::org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$anon$1$$_$onPush$$anonfun$1);
                if (this.shouldPushDirectly(cost)) {
                    this.push(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{elem})));
                    return;
                }
                if (this.shouldStartNewGroup(elemKey, cost)) {
                    this.emitCurrentGroup();
                    this.handleNewElement(elem, cost, elemKey);
                    return;
                }
                this.addToCurrentGroup(elem, cost, elemKey);
                this.tryPullIfNeeded();
            }

            private boolean shouldPushDirectly(long cost) {
                return cost >= this.$outer.maxWeight() && !this.hasElements;
            }

            private boolean shouldStartNewGroup(Object elemKey, long cost) {
                Object object;
                Object key;
                Object object2 = this.currentKey;
                Object object3 = OptionVal.Some$.MODULE$.unapply(object2);
                if (!(OptionVal$.MODULE$.isEmpty$extension(object3) || BoxesRunTime.equals((Object)elemKey, (Object)(key = (object = OptionVal$.MODULE$.get$extension(object3)))) && this.currentWeight + cost <= this.$outer.maxWeight())) {
                    return true;
                }
                OptionVal$.MODULE$.None();
                Object object4 = object2;
                return !(null != null ? !((Object)null).equals(object4) : object4 != null) && cost > this.$outer.maxWeight();
            }

            private void emitCurrentGroup() {
                if (this.hasElements) {
                    Vector group = (Vector)this.builder.result();
                    this.resetGroup();
                    this.pushOrQueue((Seq)group);
                    return;
                }
            }

            private void handleNewElement(Object elem, long cost, Object key) {
                if (cost > this.$outer.maxWeight()) {
                    this.pushOrQueue((Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{elem})));
                } else {
                    this.addToCurrentGroup(elem, cost, key);
                }
                this.tryPullIfNeeded();
            }

            private void addToCurrentGroup(Object elem, long cost, Object key) {
                this.builder.$plus$eq(elem);
                this.hasElements = true;
                this.currentWeight += cost;
                this.currentKey = OptionVal.Some$.MODULE$.apply(key);
            }

            private void resetGroup() {
                this.builder.clear();
                this.hasElements = false;
                this.currentWeight = 0L;
                this.currentKey = OptionVal$.MODULE$.none();
            }

            private void pushOrQueue(Seq group) {
                Seq seq = this.pendingGroup;
                Seq seq2 = (Seq)OptionVal.Some$.MODULE$.unapply((Object)seq);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)seq2)) {
                    Seq seq3;
                    Seq pending = seq3 = (Seq)OptionVal$.MODULE$.get$extension((Object)seq2);
                    this.push(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, pending);
                    this.pendingGroup = (Seq)OptionVal.Some$.MODULE$.apply((Object)group);
                    return;
                }
                OptionVal$.MODULE$.None();
                Seq seq4 = seq;
                if (!(null != null ? !((Object)null).equals(seq4) : seq4 != null)) {
                    if (this.isAvailable(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out)) {
                        this.push(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, group);
                        return;
                    }
                    this.pendingGroup = (Seq)OptionVal.Some$.MODULE$.apply((Object)group);
                    return;
                }
                throw new MatchError((Object)new OptionVal((Object)seq));
            }

            private void tryPullIfNeeded() {
                Seq seq = this.pendingGroup;
                OptionVal$.MODULE$.None();
                Seq seq2 = seq;
                if (!(null != null ? !((Object)null).equals(seq2) : seq2 != null)) {
                    if (!this.hasBeenPulled(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in) && this.isAvailable(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out)) {
                        this.pull(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in);
                        return;
                    }
                }
            }

            public void onPull() {
                Seq seq = this.pendingGroup;
                Seq seq2 = (Seq)OptionVal.Some$.MODULE$.unapply((Object)seq);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)seq2)) {
                    Seq seq3;
                    Seq group = seq3 = (Seq)OptionVal$.MODULE$.get$extension((Object)seq2);
                    this.push(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, group);
                    this.pendingGroup = (Seq)OptionVal$.MODULE$.none();
                    return;
                }
                if (!this.hasBeenPulled(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in)) {
                    this.pull(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$in);
                    return;
                }
            }

            public void onUpstreamFinish() {
                Vector finalGroup = (Vector)this.builder.result();
                this.builder = null;
                Seq seq = this.pendingGroup;
                Seq seq2 = (Seq)OptionVal.Some$.MODULE$.unapply((Object)seq);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)seq2)) {
                    Seq seq3;
                    Seq group = seq3 = (Seq)OptionVal$.MODULE$.get$extension((Object)seq2);
                    if (finalGroup.nonEmpty()) {
                        this.emitMultiple(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, ((StrictOptimizedLinearSeqOps)new .colon.colon((Object)group, (List)new .colon.colon((Object)finalGroup, (List)Nil$.MODULE$))).iterator(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
                        return;
                    }
                    this.emit(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, group, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
                    return;
                }
                OptionVal$.MODULE$.None();
                Seq seq4 = seq;
                if (!(null != null ? !((Object)null).equals(seq4) : seq4 != null)) {
                    if (finalGroup.nonEmpty()) {
                        this.emit(this.$outer.org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$out, finalGroup, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
                        return;
                    }
                    this.completeStage();
                    return;
                }
                throw new MatchError((Object)new OptionVal((Object)seq));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$anon$1$$_$onPush$$anonfun$1(), onUpstreamFinish$$anonfun$1(), onUpstreamFinish$$anonfun$2(), onUpstreamFinish$$anonfun$3()}, serializedLambda);
            }
        };
    }

    public <T, R> GroupedAdjacentByWeighted<T, R> copy(Function1<T, R> f, long maxWeight, Function1<T, Object> costFn) {
        return new GroupedAdjacentByWeighted<T, R>(f, maxWeight, costFn);
    }

    public <T, R> Function1<T, R> copy$default$1() {
        return this.f();
    }

    public long copy$default$2() {
        return this.maxWeight();
    }

    public <T, R> Function1<T, Object> copy$default$3() {
        return this.costFn();
    }

    public Function1<T, R> _1() {
        return this.f();
    }

    public long _2() {
        return this.maxWeight();
    }

    public Function1<T, Object> _3() {
        return this.costFn();
    }

    private static final Object $init$$$anonfun$1() {
        return "f must not be null";
    }

    private static final Object $init$$$anonfun$2() {
        return "maxWeight must be greater than 0";
    }

    private static final Object $init$$$anonfun$3() {
        return "costFn must not be null";
    }

    public static final Object org$apache$pekko$stream$impl$fusing$GroupedAdjacentByWeighted$$anon$1$$_$onPush$$anonfun$1() {
        return "Element key must not be null";
    }
}

