/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.stage;

import java.io.Serializable;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.FunctionRef;
import org.apache.pekko.actor.Kill$;
import org.apache.pekko.actor.LocalActorRef;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.japi.function.Effect;
import org.apache.pekko.japi.function.Procedure;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Attributes$CancellationStrategy$AfterDelay$;
import org.apache.pekko.stream.Attributes$CancellationStrategy$CompleteStage$;
import org.apache.pekko.stream.Attributes$CancellationStrategy$FailStage$;
import org.apache.pekko.stream.Attributes$CancellationStrategy$PropagateFailure$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.SinkShape;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.StreamDetachedException;
import org.apache.pekko.stream.SubscriptionWithCancelException$NoMoreElementsNeeded$;
import org.apache.pekko.stream.SubscriptionWithCancelException$StageWasCompleted$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnComplete$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnError$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnNext$;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$Empty$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$Failed$;
import org.apache.pekko.stream.impl.fusing.SubSink;
import org.apache.pekko.stream.impl.fusing.SubSink$Cancel$;
import org.apache.pekko.stream.impl.fusing.SubSink$RequestOne$;
import org.apache.pekko.stream.impl.fusing.SubSource;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.ConcurrentAsyncCallbackState;
import org.apache.pekko.stream.stage.ConcurrentAsyncCallbackState$;
import org.apache.pekko.stream.stage.ConcurrentAsyncCallbackState$Event$;
import org.apache.pekko.stream.stage.ConcurrentAsyncCallbackState$Initialized$;
import org.apache.pekko.stream.stage.ConcurrentAsyncCallbackState$Pending$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageLogic$;
import org.apache.pekko.stream.stage.GraphStageLogic$DoNothing$;
import org.apache.pekko.stream.stage.GraphStageLogic$EagerTerminateInput$;
import org.apache.pekko.stream.stage.GraphStageLogic$EagerTerminateOutput$;
import org.apache.pekko.stream.stage.GraphStageLogic$IgnoreTerminateInput$;
import org.apache.pekko.stream.stage.GraphStageLogic$IgnoreTerminateOutput$;
import org.apache.pekko.stream.stage.GraphStageLogic$StageActorRefNotInitializedException$;
import org.apache.pekko.stream.stage.GraphStageLogic$TotallyIgnorantInput$;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction0;

public abstract class GraphStageLogic {
    private final int inCount;
    private final int outCount;
    private int stageId;
    private Attributes attributes;
    private GraphStageWithMaterializedValue originalStage;
    private final Object[] handlers;
    private final GraphInterpreter.Connection[] portToConn;
    private GraphInterpreter _interpreter;
    @InternalApi
    private Throwable lastCancellationCause;
    private List<ConcurrentAsyncCallback<?>> callbacksWaitingForInterpreter;
    public final AtomicReference<Set<Promise<Done>>> org$apache$pekko$stream$stage$GraphStageLogic$$asyncCallbacksInProgress;
    private StageActor _stageActor;
    private scala.collection.immutable.Set<Object> _subInletsAndOutlets;

    public static Promise<Done> NoPromise() {
        return GraphStageLogic$.MODULE$.NoPromise();
    }

    public GraphStageLogic(int inCount, int outCount) {
        this.inCount = inCount;
        this.outCount = outCount;
        this.stageId = Integer.MIN_VALUE;
        this.attributes = Attributes$.MODULE$.none();
        OptionVal$.MODULE$.None();
        this.originalStage = null;
        this.handlers = new Object[inCount + outCount];
        this.portToConn = new GraphInterpreter.Connection[this.handlers().length];
        this.callbacksWaitingForInterpreter = package$.MODULE$.Nil();
        this.org$apache$pekko$stream$stage$GraphStageLogic$$asyncCallbacksInProgress = new AtomicReference(ConcurrentHashMap.newKeySet());
        this._subInletsAndOutlets = Predef$.MODULE$.Set().empty();
    }

    public int inCount() {
        return this.inCount;
    }

    public int outCount() {
        return this.outCount;
    }

    public GraphStageLogic(Shape shape) {
        this(shape.inlets().size(), shape.outlets().size());
    }

    public int stageId() {
        return this.stageId;
    }

    public void stageId_$eq(int x$1) {
        this.stageId = x$1;
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public void attributes_$eq(Attributes x$1) {
        this.attributes = x$1;
    }

    public GraphStageWithMaterializedValue originalStage() {
        return this.originalStage;
    }

    public void originalStage_$eq(GraphStageWithMaterializedValue x$1) {
        this.originalStage = x$1;
    }

    public Object[] handlers() {
        return this.handlers;
    }

    public InHandler inHandler(int id) {
        if (id > this.inCount()) {
            throw new IllegalArgumentException(new StringBuilder(28).append(id).append(" not in inHandler range ").append(this.inCount()).append(" in ").append(this).toString());
        }
        if (this.inCount() < 1) {
            throw new IllegalArgumentException(new StringBuilder(56).append("Tried to access inHandler ").append(id).append(" but there are no in ports in ").append(this).toString());
        }
        return (InHandler)this.handlers()[id];
    }

    public OutHandler outHandler(int id) {
        if (id > this.outCount()) {
            throw new IllegalArgumentException(new StringBuilder(29).append(id).append(" not in outHandler range ").append(this.outCount()).append(" in ").append(this).toString());
        }
        if (this.outCount() < 1) {
            throw new IllegalArgumentException(new StringBuilder(55).append("Tried to access outHandler ").append(id).append(" but there are no out ports ").append(this).toString());
        }
        return (OutHandler)this.handlers()[this.inCount() + id];
    }

    public GraphInterpreter.Connection[] portToConn() {
        return this.portToConn;
    }

    public void interpreter_$eq(GraphInterpreter gi) {
        this._interpreter = gi;
    }

    public GraphInterpreter interpreter() {
        if (this._interpreter == null) {
            throw new IllegalStateException("not yet initialized: only setHandler is allowed in GraphStageLogic constructor. To access materializer use Source/Flow/Sink.fromMaterializer factory");
        }
        return this._interpreter;
    }

    public Materializer materializer() {
        return this.interpreter().materializer();
    }

    public Materializer subFusingMaterializer() {
        return this.interpreter().subFusingMaterializer();
    }

    public final InHandler eagerTerminateInput() {
        return GraphStageLogic$EagerTerminateInput$.MODULE$;
    }

    public final InHandler ignoreTerminateInput() {
        return GraphStageLogic$IgnoreTerminateInput$.MODULE$;
    }

    public final InHandler conditionalTerminateInput(Function0<Object> predicate) {
        return new ConditionalTerminateInput(predicate);
    }

    public final InHandler totallyIgnorantInput() {
        return GraphStageLogic$TotallyIgnorantInput$.MODULE$;
    }

    public final OutHandler eagerTerminateOutput() {
        return GraphStageLogic$EagerTerminateOutput$.MODULE$;
    }

    public final OutHandler ignoreTerminateOutput() {
        return GraphStageLogic$IgnoreTerminateOutput$.MODULE$;
    }

    public final OutHandler conditionalTerminateOutput(Function0<Object> predicate) {
        return new ConditionalTerminateOutput(predicate);
    }

    public final void setHandler(Inlet<?> in, InHandler handler) {
        this.handlers()[in.id()] = handler;
        if (this._interpreter != null) {
            this._interpreter.setHandler(this.conn(in), handler);
            return;
        }
    }

    public final void setHandlers(Inlet<?> in, Outlet<?> out, InHandler handler) {
        this.setHandler(in, handler);
        this.setHandler(out, (OutHandler)((Object)handler));
    }

    public final InHandler getHandler(Inlet<?> in) {
        return (InHandler)this.handlers()[in.id()];
    }

    public final void setHandler(Outlet<?> out, OutHandler handler) {
        this.handlers()[out.id() + this.inCount()] = handler;
        if (this._interpreter != null) {
            this._interpreter.setHandler(this.conn(out), handler);
            return;
        }
    }

    private GraphInterpreter.Connection conn(Inlet<?> in) {
        return this.portToConn()[in.id()];
    }

    private GraphInterpreter.Connection conn(Outlet<?> out) {
        return this.portToConn()[out.id() + this.inCount()];
    }

    public final OutHandler getHandler(Outlet<?> out) {
        return (OutHandler)this.handlers()[out.id() + this.inCount()];
    }

    private OutHandler getNonEmittingHandler(Outlet<?> out) {
        OutHandler outHandler = this.getHandler(out);
        if (outHandler instanceof Emitting && ((Emitting)outHandler).org$apache$pekko$stream$stage$GraphStageLogic$Emitting$$$outer() == this) {
            Emitting e = (Emitting)outHandler;
            return e.previous();
        }
        OutHandler other = outHandler;
        return other;
    }

    public final <T> void pull(Inlet<T> in) {
        GraphInterpreter.Connection connection = this.conn(in);
        GraphInterpreter it = this.interpreter();
        int portState = connection.portState();
        if ((portState & 0x31) == 1) {
            connection.portState_$eq(portState ^ 3);
            it.chasePull(connection);
            return;
        }
        if (this.isClosed(in)) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Cannot pull closed port (").append(in).append(")").toString());
        }
        if (this.hasBeenPulled(in)) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Cannot pull port (").append(in).append(") twice").toString());
        }
        connection.portState_$eq(portState ^ 3);
    }

    public final <T> void tryPull(Inlet<T> in) {
        if (!this.isClosed(in)) {
            this.pull(in);
            return;
        }
    }

    public final <T> void cancel(Inlet<T> in) {
        this.cancel(in, (Throwable)SubscriptionWithCancelException$NoMoreElementsNeeded$.MODULE$);
    }

    public final <T> void cancel(Inlet<T> in, Throwable cause) {
        this.cancel(this.conn(in), cause);
    }

    private <T> void cancel(GraphInterpreter.Connection connection, Throwable cause) {
        Attributes.CancellationStrategy.Strategy strategy = ((Attributes.CancellationStrategy)this.attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.CancellationStrategy.class))).strategy();
        if (strategy instanceof Attributes.CancellationStrategy.AfterDelay) {
            Attributes.CancellationStrategy.AfterDelay afterDelay = Attributes$CancellationStrategy$AfterDelay$.MODULE$.unapply((Attributes.CancellationStrategy.AfterDelay)strategy);
            FiniteDuration finiteDuration = afterDelay._1();
            Attributes.CancellationStrategy.Strategy strategy2 = afterDelay._2();
            FiniteDuration delay = finiteDuration;
            connection.inHandler_$eq(GraphStageLogic$EagerTerminateInput$.MODULE$);
            AsyncCallback callback = this.getAsyncCallback((Function1<T, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    GraphInterpreter.Connection connection = (GraphInterpreter.Connection)tuple2._1();
                    Throwable cause = (Throwable)tuple2._2();
                    this.doCancel(connection, cause);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            this.materializer().scheduleOnce(delay, () -> callback.invoke(Tuple2$.MODULE$.apply((Object)connection, (Object)cause)));
            return;
        }
        this.doCancel(connection, cause);
    }

    private <T> void doCancel(GraphInterpreter.Connection connection, Throwable cause) {
        this.interpreter().cancel(connection, cause);
    }

    public final <T> T grab(Inlet<T> in) {
        GraphInterpreter.Connection connection = this.conn(in);
        Object elem = connection.slot();
        if ((connection.portState() & 0x51) == 1 && elem != GraphInterpreter$Empty$.MODULE$) {
            connection.slot_$eq(GraphInterpreter$Empty$.MODULE$);
            return (T)elem;
        }
        if (!this.isAvailable(in)) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Cannot get element from already empty input port (").append(in).append(")").toString());
        }
        if ((connection.portState() & 0x41) == 65) {
            GraphInterpreter.Failed failed = (GraphInterpreter.Failed)connection.slot();
            Object elem2 = failed.previousElem();
            connection.slot_$eq(GraphInterpreter$Failed$.MODULE$.apply(failed.ex(), GraphInterpreter$Empty$.MODULE$));
            return (T)elem2;
        }
        Object elem3 = connection.slot();
        connection.slot_$eq(GraphInterpreter$Empty$.MODULE$);
        return (T)elem3;
    }

    public final <T> boolean hasBeenPulled(Inlet<T> in) {
        return (this.conn(in).portState() & 0x11) == 0;
    }

    public final <T> boolean isAvailable(Inlet<T> in) {
        boolean normalArrived;
        GraphInterpreter.Connection connection = this.conn(in);
        boolean bl = normalArrived = (this.conn(in).portState() & 0x51) == 1;
        if (normalArrived) {
            return connection.slot() != GraphInterpreter$Empty$.MODULE$;
        }
        if ((connection.portState() & 0x51) == 17) {
            Object object = connection.slot();
            return !GraphInterpreter$Empty$.MODULE$.equals(object) && !(object instanceof GraphInterpreter.Cancelled);
            {
            }
        }
        if ((connection.portState() & 0x41) == 65) {
            Object object = connection.slot();
            if (object instanceof GraphInterpreter.Failed) {
                GraphInterpreter.Failed failed = GraphInterpreter$Failed$.MODULE$.unapply((GraphInterpreter.Failed)object);
                Throwable throwable = failed._1();
                Object object2 = failed._2();
                Object elem = object2;
                return elem != GraphInterpreter$Empty$.MODULE$;
            }
            return false;
        }
        return false;
    }

    public final <T> boolean isClosed(Inlet<T> in) {
        return (this.conn(in).portState() & 0x10) != 0;
    }

    public final <T> void push(Outlet<T> out, T elem) {
        GraphInterpreter.Connection connection = this.conn(out);
        GraphInterpreter it = this.interpreter();
        int portState = connection.portState();
        connection.portState_$eq(portState ^ 0xC);
        if ((portState & 0x38) == 8 && elem != null) {
            connection.slot_$eq(elem);
            it.chasePush(connection);
            return;
        }
        connection.portState_$eq(portState);
        ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(elem);
        if (this.isClosed(out)) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Cannot push closed port (").append(out).append(")").toString());
        }
        if (!this.isAvailable(out)) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Cannot push port (").append(out).append(") twice, or before it being pulled").toString());
        }
        connection.portState_$eq(portState ^ 0xC);
    }

    public final void setKeepGoing(boolean enabled) {
        this.interpreter().setKeepGoing(this, enabled);
    }

    public final <T> void complete(Outlet<T> out) {
        OutHandler outHandler = this.getHandler(out);
        if (outHandler instanceof Emitting && ((Emitting)outHandler).org$apache$pekko$stream$stage$GraphStageLogic$Emitting$$$outer() == this) {
            Emitting e = (Emitting)outHandler;
            e.addFollowUp(new EmittingCompletion(e.out(), e.previous()));
            return;
        }
        this.interpreter().complete(this.conn(out));
    }

    public final <T> void fail(Outlet<T> out, Throwable ex) {
        this.interpreter().fail(this.conn(out), ex);
    }

    public final void completeStage() {
        OptionVal$.MODULE$.None();
        this.internalCompleteStage(SubscriptionWithCancelException$StageWasCompleted$.MODULE$, null);
    }

    public Throwable lastCancellationCause() {
        return this.lastCancellationCause;
    }

    public void lastCancellationCause_$eq(Throwable x$1) {
        this.lastCancellationCause = x$1;
    }

    public final void cancelStage(Throwable cause) {
        this.internalCancelStage(cause, ((Attributes.CancellationStrategy)this.attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.CancellationStrategy.class))).strategy());
    }

    private void internalCancelStage(Throwable cause, Attributes.CancellationStrategy.Strategy strategy) {
        Attributes.CancellationStrategy.Strategy strategy2;
        while (true) {
            Attributes.CancellationStrategy.Strategy strategy3;
            Attributes.CancellationStrategy.Strategy andThen;
            if (Attributes$CancellationStrategy$CompleteStage$.MODULE$.equals(strategy2 = strategy)) {
                OptionVal$.MODULE$.None();
                this.internalCompleteStage(cause, null);
                return;
            }
            if (Attributes$CancellationStrategy$FailStage$.MODULE$.equals(strategy2)) {
                this.internalCompleteStage(cause, (Throwable)OptionVal.Some$.MODULE$.apply((Object)cause));
                return;
            }
            if (Attributes$CancellationStrategy$PropagateFailure$.MODULE$.equals(strategy2)) {
                Throwable throwable = cause;
                if (SubscriptionWithCancelException$NoMoreElementsNeeded$.MODULE$.equals(throwable) || SubscriptionWithCancelException$StageWasCompleted$.MODULE$.equals(throwable)) {
                    OptionVal$.MODULE$.None();
                    this.internalCompleteStage(cause, null);
                    return;
                }
                this.internalCompleteStage(cause, (Throwable)OptionVal.Some$.MODULE$.apply((Object)cause));
                return;
            }
            if (!(strategy2 instanceof Attributes.CancellationStrategy.AfterDelay)) break;
            Attributes.CancellationStrategy.AfterDelay afterDelay = Attributes$CancellationStrategy$AfterDelay$.MODULE$.unapply((Attributes.CancellationStrategy.AfterDelay)strategy2);
            FiniteDuration finiteDuration = afterDelay._1();
            strategy = andThen = (strategy3 = afterDelay._2());
        }
        throw new MatchError((Object)strategy2);
    }

    public final void failStage(Throwable ex) {
        this.internalCompleteStage(ex, (Throwable)OptionVal.Some$.MODULE$.apply((Object)ex));
    }

    private void internalCompleteStage(Throwable cancelCause, Throwable optionalFailureCause) {
        for (int i = 0; i < this.portToConn().length; ++i) {
            if (i < this.inCount()) {
                this.cancel(this.portToConn()[i], cancelCause);
                continue;
            }
            if (OptionVal$.MODULE$.isDefined$extension((Object)optionalFailureCause)) {
                this.interpreter().fail(this.portToConn()[i], (Throwable)OptionVal$.MODULE$.get$extension((Object)optionalFailureCause));
                continue;
            }
            Object object = this.handlers()[i];
            if (object instanceof Emitting && ((Emitting)object).org$apache$pekko$stream$stage$GraphStageLogic$Emitting$$$outer() == this) {
                Emitting e = (Emitting)object;
                e.addFollowUp(new EmittingCompletion(e.out(), e.previous()));
                continue;
            }
            this.interpreter().complete(this.portToConn()[i]);
        }
        this.cleanUpSubstreams(optionalFailureCause);
        this.setKeepGoing(false);
    }

    private void cleanUpSubstreams(Throwable optionalFailureCause) {
        this._subInletsAndOutlets.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof SubSinkInlet && ((SubSinkInlet)object).org$apache$pekko$stream$stage$GraphStageLogic$SubSinkInlet$$$outer() == this) {
                SubSinkInlet inlet = (SubSinkInlet)object;
                SubSink subSink = (SubSink)inlet.sink();
                Throwable throwable = optionalFailureCause;
                Throwable throwable2 = (Throwable)OptionVal.Some$.MODULE$.unapply((Object)throwable);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)throwable2)) {
                    Throwable throwable3;
                    Throwable cause = throwable3 = (Throwable)OptionVal$.MODULE$.get$extension((Object)throwable2);
                    subSink.cancelSubstream(cause);
                    return;
                }
                subSink.cancelSubstream();
                return;
            }
            if (object instanceof SubSourceOutlet && ((SubSourceOutlet)object).org$apache$pekko$stream$stage$GraphStageLogic$SubSourceOutlet$$$outer() == this) {
                SubSourceOutlet outlet = (SubSourceOutlet)object;
                SubSource subSource = (SubSource)outlet.source();
                Throwable throwable = optionalFailureCause;
                Throwable throwable4 = (Throwable)OptionVal.Some$.MODULE$.unapply((Object)throwable);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)throwable4)) {
                    Throwable throwable5;
                    Throwable cause = throwable5 = (Throwable)OptionVal$.MODULE$.get$extension((Object)throwable4);
                    subSource.failSubstream(cause);
                    return;
                }
                subSource.completeSubstream();
                return;
            }
            Object wat = object;
            throw new IllegalStateException(new StringBuilder(64).append("Stage _subInletsAndOutlets contained unexpected element of type ").append(wat.getClass().toString()).toString());
        });
        this._subInletsAndOutlets = Predef$.MODULE$.Set().empty();
    }

    public final <T> boolean isAvailable(Outlet<T> out) {
        return (this.conn(out).portState() & 0x28) == 8;
    }

    public final <T> boolean isClosed(Outlet<T> out) {
        return (this.conn(out).portState() & 0x20) != 0;
    }

    public final <T> void readN(Inlet<T> in, int n, Function1<scala.collection.immutable.Seq<T>, BoxedUnit> andThen, Function1<scala.collection.immutable.Seq<T>, BoxedUnit> onClose) {
        if (n < 0) {
            throw new IllegalArgumentException("cannot read negative number of elements");
        }
        if (n == 0) {
            andThen.apply((Object)package$.MODULE$.Nil());
            return;
        }
        Object[] result = new Object[n];
        IntRef pos = IntRef.create((int)0);
        if (this.isAvailable(in)) {
            ScalaRunTime$.MODULE$.array_update((Object)result, pos.elem, this.grab(in));
            ++pos.elem;
        }
        if (n != pos.elem) {
            this.requireNotReading(in);
            if (!this.hasBeenPulled(in)) {
                this.pull(in);
            }
            this.setHandler(in, new Reading<T>(this, in, n - pos.elem, this.getHandler(in), (JProcedure1 & Serializable)elem -> {
                ScalaRunTime$.MODULE$.array_update(result, pos$1.elem, elem);
                ++pos$1.elem;
                if (pos$1.elem == n) {
                    Object object = Predef$.MODULE$.genericArrayOps(result);
                    andThen.apply((Object)ArrayOps$.MODULE$.toSeq$extension(object));
                    return;
                }
            }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Object object = Predef$.MODULE$.genericArrayOps(result);
                Object object2 = Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.take$extension(object, pos$2.elem));
                onClose.apply((Object)ArrayOps$.MODULE$.toSeq$extension(object2));
            }));
            return;
        }
        Object object = Predef$.MODULE$.genericArrayOps((Object)result);
        andThen.apply((Object)ArrayOps$.MODULE$.toSeq$extension(object));
    }

    public final <T> void readN(Inlet<T> in, int n, Procedure<java.util.List<T>> andThen, Procedure<java.util.List<T>> onClose) {
        this.readN(in, n, (Function1<scala.collection.immutable.Seq<T>, BoxedUnit>)(JProcedure1 & Serializable)seq -> andThen.apply((Object)package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)seq).asJava()), (Function1<scala.collection.immutable.Seq<T>, BoxedUnit>)(JProcedure1 & Serializable)seq -> onClose.apply((Object)package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)seq).asJava()));
    }

    public final <T> void read(Inlet<T> in, Function1<T, BoxedUnit> andThen, Function0<BoxedUnit> onClose) {
        if (this.isAvailable(in)) {
            T elem = this.grab(in);
            andThen.apply(elem);
            return;
        }
        if (this.isClosed(in)) {
            onClose.apply$mcV$sp();
            return;
        }
        this.requireNotReading(in);
        if (!this.hasBeenPulled(in)) {
            this.pull(in);
        }
        this.setHandler(in, new Reading<T>(this, in, 1, this.getHandler(in), andThen, onClose));
    }

    public final <T> void read(Inlet<T> in, Procedure<T> andThen, Effect onClose) {
        this.read(in, (Function1<T, BoxedUnit>)(JProcedure1 & Serializable)param -> andThen.apply(param), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> onClose.apply());
    }

    public final void abortReading(Inlet<?> in) {
        InHandler inHandler = this.getHandler(in);
        if (inHandler instanceof Reading && ((Reading)inHandler).org$apache$pekko$stream$stage$GraphStageLogic$Reading$$$outer() == this) {
            Reading r = (Reading)inHandler;
            this.setHandler(in, r.previous());
            return;
        }
    }

    private void requireNotReading(Inlet<?> in) {
        if (this.getHandler(in) instanceof Reading) {
            throw new IllegalStateException(new StringBuilder(25).append("already reading on inlet ").append(in).toString());
        }
    }

    public final <T> void emitMultiple(Outlet<T> out, Iterable<T> elems, Function0<BoxedUnit> andThen) {
        this.emitMultiple(out, elems.iterator(), andThen);
    }

    public final <T> void emitMultiple(Outlet<T> out, Iterable<T> elems) {
        this.emitMultiple(out, elems, (Function0<BoxedUnit>)GraphStageLogic$DoNothing$.MODULE$);
    }

    public final <T> void emitMultiple(Outlet<T> out, java.util.Iterator<T> elems) {
        this.emitMultiple(out, package.JavaConverters$.MODULE$.IteratorHasAsScala(elems).asScala(), (Function0<BoxedUnit>)GraphStageLogic$DoNothing$.MODULE$);
    }

    public final <T> void emitMultiple(Outlet<T> out, java.util.Iterator<T> elems, Effect andThen) {
        this.emitMultiple(out, package.JavaConverters$.MODULE$.IteratorHasAsScala(elems).asScala(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> andThen.apply());
    }

    public final <T> void emitMultiple(Outlet<T> out, Iterator<T> elems, Function0<BoxedUnit> andThen) {
        if (elems.hasNext()) {
            if (this.isAvailable(out)) {
                this.push(out, elems.next());
                if (elems.hasNext()) {
                    this.setOrAddEmitting(out, new EmittingIterator<T>(this, out, elems, this.getNonEmittingHandler(out), andThen));
                    return;
                }
                andThen.apply$mcV$sp();
                return;
            }
            this.setOrAddEmitting(out, new EmittingIterator<T>(this, out, elems, this.getNonEmittingHandler(out), andThen));
            return;
        }
        andThen.apply$mcV$sp();
    }

    public final <T> void emitMultiple(Outlet<T> out, Spliterator<T> elems, Function0<BoxedUnit> andThen) {
        EmittingSpliterator<T> iter = new EmittingSpliterator<T>(this, out, elems, this.getNonEmittingHandler(out), andThen);
        if (this.isAvailable(out)) {
            if (!iter.tryPush()) {
                andThen.apply$mcV$sp();
                return;
            }
            this.setOrAddEmitting(out, iter);
            return;
        }
        this.setOrAddEmitting(out, iter);
    }

    public final <T> void emitMultiple(Outlet<T> out, Iterator<T> elems) {
        this.emitMultiple(out, elems, (Function0<BoxedUnit>)GraphStageLogic$DoNothing$.MODULE$);
    }

    public final <T> void emit(Outlet<T> out, T elem, Function0<BoxedUnit> andThen) {
        if (this.isAvailable(out)) {
            this.push(out, elem);
            andThen.apply$mcV$sp();
            return;
        }
        this.setOrAddEmitting(out, new EmittingSingle<T>(this, out, elem, this.getNonEmittingHandler(out), andThen));
    }

    public final <T> void emit(Outlet<T> out, T elem) {
        this.emit(out, elem, GraphStageLogic$DoNothing$.MODULE$);
    }

    public final <T> void emit(Outlet<T> out, T elem, Effect andThen) {
        this.emit(out, elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> andThen.apply());
    }

    public final void abortEmitting(Outlet<?> out) {
        OutHandler outHandler = this.getHandler(out);
        if (outHandler instanceof Emitting && ((Emitting)outHandler).org$apache$pekko$stream$stage$GraphStageLogic$Emitting$$$outer() == this) {
            Emitting e = (Emitting)outHandler;
            this.setHandler(out, e.previous());
            return;
        }
    }

    private <T> void setOrAddEmitting(Outlet<T> out, Emitting<T> next) {
        OutHandler outHandler = this.getHandler(out);
        if (outHandler instanceof Emitting && ((Emitting)outHandler).org$apache$pekko$stream$stage$GraphStageLogic$Emitting$$$outer() == this) {
            Emitting e = (Emitting)outHandler;
            e.addFollowUp(next);
            return;
        }
        this.setHandler(out, next);
    }

    public final <Out, In extends Out> void passAlong(Inlet<In> from, Outlet<Out> to, boolean doFinish, boolean doFail, boolean doPull) {
        public class Org_apache_pekko_stream_stage_GraphStageLogic$PassAlongHandler$1
        implements InHandler,
        Function0<BoxedUnit> {
            private final Inlet from$1;
            private final Outlet to$1;
            private final boolean doFinish$1;
            private final boolean doFail$1;
            private final /* synthetic */ GraphStageLogic $outer;

            public Org_apache_pekko_stream_stage_GraphStageLogic$PassAlongHandler$1(Inlet from$2, Outlet to$2, boolean doFinish$2, boolean doFail$2, GraphStageLogic $outer) {
                this.from$1 = from$2;
                this.to$1 = to$2;
                this.doFinish$1 = doFinish$2;
                this.doFail$1 = doFail$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.tryPull(this.from$1);
            }

            public void onPush() {
                T elem = this.$outer.grab(this.from$1);
                this.$outer.emit(this.to$1, elem, this);
            }

            public void onUpstreamFinish() {
                if (this.doFinish$1) {
                    this.$outer.completeStage();
                    return;
                }
            }

            public void onUpstreamFailure(Throwable ex) {
                if (this.doFail$1) {
                    this.$outer.failStage(ex);
                    return;
                }
            }

            public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$_$PassAlongHandler$$$outer() {
                return this.$outer;
            }
        }
        Org_apache_pekko_stream_stage_GraphStageLogic$PassAlongHandler$1 ph = new Org_apache_pekko_stream_stage_GraphStageLogic$PassAlongHandler$1(from, to, doFinish, doFail, this);
        if (this._interpreter != null) {
            if (this.isAvailable(from)) {
                this.emit(to, this.grab(from), ph);
            }
            if (doFinish && this.isClosed(from)) {
                this.completeStage();
            }
        }
        this.setHandler(from, ph);
        if (doPull) {
            this.tryPull(from);
            return;
        }
    }

    public boolean passAlong$default$3() {
        return true;
    }

    public boolean passAlong$default$4() {
        return true;
    }

    public boolean passAlong$default$5() {
        return false;
    }

    public final <T> AsyncCallback<T> getAsyncCallback(Function1<T, BoxedUnit> handler) {
        ConcurrentAsyncCallback<T> callback = new ConcurrentAsyncCallback<T>(this, handler);
        if (this._interpreter != null) {
            callback.onStart();
        } else {
            this.callbacksWaitingForInterpreter = this.callbacksWaitingForInterpreter.$colon$colon(callback);
        }
        return callback;
    }

    public final <T> AsyncCallback<T> createAsyncCallback(Procedure<T> handler) {
        return this.getAsyncCallback((Function1<T, BoxedUnit>)(JProcedure1 & Serializable)param -> handler.apply(param));
    }

    public final StageActor stageActor() {
        StageActor stageActor = this._stageActor;
        if (stageActor == null) {
            throw GraphStageLogic$StageActorRefNotInitializedException$.MODULE$.apply();
        }
        StageActor ref = stageActor;
        return ref;
    }

    public void org$apache$pekko$stream$stage$GraphStageLogic$$created(SubSinkInlet<?> inlet) {
        this._subInletsAndOutlets = (scala.collection.immutable.Set)this._subInletsAndOutlets.$plus(inlet);
    }

    public void org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(SubSinkInlet<?> inlet) {
        this._subInletsAndOutlets = (scala.collection.immutable.Set)this._subInletsAndOutlets.$minus(inlet);
    }

    public void org$apache$pekko$stream$stage$GraphStageLogic$$created(SubSourceOutlet<?> outlet) {
        this._subInletsAndOutlets = (scala.collection.immutable.Set)this._subInletsAndOutlets.$plus(outlet);
    }

    public void org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(SubSourceOutlet<?> outlet) {
        this._subInletsAndOutlets = (scala.collection.immutable.Set)this._subInletsAndOutlets.$minus(outlet);
    }

    public final StageActor getStageActor(Function1<Tuple2<ActorRef, Object>, BoxedUnit> receive) {
        return this.getEagerStageActor(this.interpreter().materializer(), receive);
    }

    @InternalApi
    public StageActor getEagerStageActor(Materializer eagerMaterializer, Function1<Tuple2<ActorRef, Object>, BoxedUnit> receive) {
        StageActor stageActor = this._stageActor;
        if (stageActor == null) {
            this._stageActor = new StageActor(eagerMaterializer, (Function1<Function1<Tuple2<ActorRef, Object>, BoxedUnit>, AsyncCallback<Tuple2<ActorRef, Object>>>)(Function1 & Serializable)handler -> this.getAsyncCallback((Function1)handler), receive, this.stageActorName());
            return this._stageActor;
        }
        StageActor existing = stageActor;
        existing.become(receive);
        return existing;
    }

    public String stageActorName() {
        return "";
    }

    public void beforePreStart() {
        this.callbacksWaitingForInterpreter.foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.onStart());
        this.callbacksWaitingForInterpreter = package$.MODULE$.Nil();
    }

    public void afterPostStop() {
        Set callbacks;
        if (this._stageActor != null) {
            this._stageActor.stop();
            this._stageActor = null;
        }
        if ((callbacks = (Set)this.org$apache$pekko$stream$stage$GraphStageLogic$$asyncCallbacksInProgress.getAndSet(null)) != null && !callbacks.isEmpty()) {
            StreamDetachedException exception = this.org$apache$pekko$stream$stage$GraphStageLogic$$streamDetachedException();
            callbacks.forEach(t -> t.tryFailure((Throwable)exception));
        }
        OptionVal$.MODULE$.None();
        this.cleanUpSubstreams(null);
    }

    public void onFeedbackDispatched(Promise<Done> promise) {
        Set<Promise<Done>> callbacks = this.org$apache$pekko$stream$stage$GraphStageLogic$$asyncCallbacksInProgress.get();
        if (callbacks != null) {
            callbacks.remove(promise);
            return;
        }
    }

    public StreamDetachedException org$apache$pekko$stream$stage$GraphStageLogic$$streamDetachedException() {
        return new StreamDetachedException(new StringBuilder(73).append("Stage with GraphStageLogic ").append(this).append(" stopped before async invocation was processed").toString());
    }

    public void preStart() throws Exception {
    }

    public void postStop() throws Exception {
    }

    public String toString() {
        Option option = this.attributes().get(ClassTag$.MODULE$.apply(Attributes.Name.class));
        if (option instanceof Some) {
            Attributes.Name name = (Attributes.Name)((Some)option).value();
            Option option2 = this.attributes().get(ClassTag$.MODULE$.apply(Attributes.SourceLocation.class));
            if (option2 instanceof Some) {
                Attributes.SourceLocation location = (Attributes.SourceLocation)((Some)option2).value();
                return new StringBuilder(3).append(this.getClass().getName()).append("-").append(name.n()).append("(").append(location.locationName()).append(")").toString();
            }
            if (None$.MODULE$.equals(option2)) {
                return new StringBuilder(1).append(this.getClass().getName()).append("-").append(name.n()).toString();
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return this.getClass().getName();
        }
        throw new MatchError(option);
    }

    public static final Object org$apache$pekko$stream$stage$GraphStageLogic$Reading$$_$$lessinit$greater$$anonfun$1() {
        return "number of elements to read must be positive!";
    }

    public static final /* synthetic */ void org$apache$pekko$stream$stage$GraphStageLogic$SubSinkInlet$$_$$lessinit$greater$$anonfun$2(AsyncCallback $1$$1, ActorSubscriberMessage t) {
        $1$$1.invoke(t);
    }

    public final class ConcurrentAsyncCallback<T>
    extends AtomicReference<ConcurrentAsyncCallbackState.State<T>>
    implements AsyncCallback<T> {
        private final Function1<T, BoxedUnit> handler;
        private final /* synthetic */ GraphStageLogic $outer;

        public ConcurrentAsyncCallback(GraphStageLogic $outer, Function1<T, BoxedUnit> handler) {
            this.handler = handler;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(ConcurrentAsyncCallbackState$.MODULE$.NoPendingEvents());
        }

        public void onStart() {
            do {
                ConcurrentAsyncCallbackState.State state;
                if ((state = (ConcurrentAsyncCallbackState.State)this.getAndSet(ConcurrentAsyncCallbackState$.MODULE$.NoPendingEvents())) instanceof ConcurrentAsyncCallbackState.Pending) {
                    ConcurrentAsyncCallbackState.Pending pending = ConcurrentAsyncCallbackState$Pending$.MODULE$.unapply((ConcurrentAsyncCallbackState.Pending)state);
                    List list = pending._1();
                    List l = list;
                    if (!l.nonEmpty()) continue;
                    l.reverse().foreach((Function1)(JProcedure1 & Serializable)evt -> this.onAsyncInput(evt.e(), evt.handlingPromise()));
                    continue;
                }
                ConcurrentAsyncCallbackState.State s = state;
                throw new IllegalStateException(new StringBuilder(28).append("Unexpected callback state [").append(s).append("]").toString());
            } while (!this.compareAndSet(ConcurrentAsyncCallbackState$.MODULE$.NoPendingEvents(), ConcurrentAsyncCallbackState$Initialized$.MODULE$));
        }

        @Override
        public Future<Done> invokeWithFeedback(T event) {
            Promise promise = Promise$.MODULE$.apply();
            if (this.addToWaiting$1(promise)) {
                this.invokeWithPromise(event, (Promise<Done>)promise);
                return promise.future();
            }
            return Future$.MODULE$.failed((Throwable)this.$outer.org$apache$pekko$stream$stage$GraphStageLogic$$streamDetachedException());
        }

        @Override
        public void invoke(T event) {
            this.invokeWithPromise(event, GraphStageLogic$.MODULE$.NoPromise());
        }

        private void invokeWithPromise(T event, Promise<Done> promise) {
            ConcurrentAsyncCallbackState.State state;
            block2: {
                ConcurrentAsyncCallbackState.Event<T> event2;
                List list;
                List l;
                ConcurrentAsyncCallbackState.Pending pending;
                ConcurrentAsyncCallbackState.Pending list2;
                do {
                    ConcurrentAsyncCallbackState.Pending pending2;
                    if (ConcurrentAsyncCallbackState$Initialized$.MODULE$.equals(state = (ConcurrentAsyncCallbackState.State)this.get())) {
                        this.onAsyncInput(event, promise);
                        return;
                    }
                    if (!(state instanceof ConcurrentAsyncCallbackState.Pending) || !((list = (pending2 = ConcurrentAsyncCallbackState$Pending$.MODULE$.unapply(pending = (ConcurrentAsyncCallbackState.Pending)state))._1()) instanceof List)) break block2;
                } while (!this.compareAndSet(list2 = pending, ConcurrentAsyncCallbackState$Pending$.MODULE$.apply((l = list).$colon$colon(event2 = ConcurrentAsyncCallbackState$Event$.MODULE$.apply(event, promise)))));
                return;
            }
            throw new MatchError((Object)state);
        }

        private void onAsyncInput(T event, Promise<Done> promise) {
            this.$outer.interpreter().onAsyncInput().apply((Object)this.$outer, event, promise, this.handler);
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$ConcurrentAsyncCallback$$$outer() {
            return this.$outer;
        }

        private final boolean addToWaiting$1(Promise promise$1) {
            Set<Promise<Done>> callbacks = this.$outer.org$apache$pekko$stream$stage$GraphStageLogic$$asyncCallbacksInProgress.get();
            if (callbacks != null) {
                callbacks.add((Promise<Done>)promise$1);
                return this.$outer.org$apache$pekko$stream$stage$GraphStageLogic$$asyncCallbacksInProgress.get() != null;
            }
            return false;
        }
    }

    public static class ConditionalTerminateInput
    implements InHandler {
        private final Function0<Object> predicate;

        public ConditionalTerminateInput(Function0<Object> predicate) {
            this.predicate = predicate;
        }

        @Override
        public void onPush() {
        }

        @Override
        public void onUpstreamFinish() {
            if (this.predicate.apply$mcZ$sp()) {
                GraphInterpreter$.MODULE$.currentInterpreter().activeStage().completeStage();
                return;
            }
        }
    }

    public static class ConditionalTerminateOutput
    implements OutHandler {
        private final Function0<Object> predicate;

        public ConditionalTerminateOutput(Function0<Object> predicate) {
            this.predicate = predicate;
        }

        @Override
        public void onPull() {
        }

        @Override
        public void onDownstreamFinish(Throwable cause) {
            if (this.predicate.apply$mcZ$sp()) {
                GraphInterpreter$.MODULE$.currentInterpreter().activeStage().cancelStage(cause);
                return;
            }
        }
    }

    public abstract class Emitting<T>
    implements OutHandler {
        private final Outlet out;
        private final OutHandler previous;
        private final Function0<BoxedUnit> andThen;
        private Emitting followUps;
        private Emitting followUpsTail;
        private final /* synthetic */ GraphStageLogic $outer;

        public Emitting(GraphStageLogic $outer, Outlet<T> out, OutHandler previous, Function0<BoxedUnit> andThen) {
            this.out = out;
            this.previous = previous;
            this.andThen = andThen;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Outlet<T> out() {
            return this.out;
        }

        public OutHandler previous() {
            return this.previous;
        }

        private Emitting<T> followUps() {
            return this.followUps;
        }

        private void followUps_$eq(Emitting<T> x$0) {
            this.followUps = x$0;
        }

        private Emitting<T> followUpsTail() {
            return this.followUpsTail;
        }

        private void followUpsTail_$eq(Emitting<T> x$0) {
            this.followUpsTail = x$0;
        }

        public void followUp() {
            this.$outer.setHandler(this.out(), this.previous());
            this.andThen.apply$mcV$sp();
            if (this.followUps() != null) {
                Emitting<T> next;
                OutHandler currentHandler = this.$outer.getHandler(this.out());
                if (currentHandler instanceof Emitting) {
                    this.addFollowUp((Emitting)currentHandler);
                }
                if ((next = this.dequeue()) instanceof EmittingCompletion) {
                    if (super.followUps() != null) {
                        this.$outer.setHandler(this.out(), this.dequeueHeadAndAddToTail(next));
                        return;
                    }
                    this.$outer.complete(this.out());
                    return;
                }
                this.$outer.setHandler(this.out(), next);
                return;
            }
        }

        public void addFollowUp(Emitting<T> e) {
            if (this.followUps() == null) {
                this.followUps_$eq(e);
                this.followUpsTail_$eq(e);
                return;
            }
            super.followUps_$eq(e);
            this.followUpsTail_$eq(e);
        }

        private Emitting<T> dequeueHeadAndAddToTail(Emitting<T> head) {
            Emitting<T> next = super.dequeue();
            next.addFollowUp(head);
            super.followUps_$eq(null);
            super.followUpsTail_$eq(null);
            return next;
        }

        private Emitting<T> dequeue() {
            Emitting<T> ret = this.followUps();
            super.followUpsTail_$eq(this.followUpsTail());
            return ret;
        }

        @Override
        public void onDownstreamFinish(Throwable cause) {
            this.previous().onDownstreamFinish(cause);
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$Emitting$$$outer() {
            return this.$outer;
        }
    }

    public class EmittingCompletion<T>
    extends Emitting<T> {
        public EmittingCompletion(Outlet<T> _out, OutHandler _previous) {
            if (GraphStageLogic.this == null) {
                throw new NullPointerException();
            }
            super(GraphStageLogic.this, _out, _previous, GraphStageLogic$DoNothing$.MODULE$);
        }

        @Override
        public void onPull() {
            GraphStageLogic.this.complete(this.out());
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$EmittingCompletion$$$outer() {
            return GraphStageLogic.this;
        }
    }

    public class EmittingIterator<T>
    extends Emitting<T> {
        private final Iterator<T> elems;
        private final /* synthetic */ GraphStageLogic $outer;

        public EmittingIterator(GraphStageLogic $outer, Outlet<T> _out, Iterator<T> elems, OutHandler _previous, Function0<BoxedUnit> _andThen) {
            this.elems = elems;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, _out, _previous, _andThen);
        }

        @Override
        public void onPull() {
            this.$outer.push(this.out(), this.elems.next());
            if (!this.elems.hasNext()) {
                this.followUp();
                return;
            }
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$EmittingIterator$$$outer() {
            return this.$outer;
        }
    }

    public class EmittingSingle<T>
    extends Emitting<T> {
        private final T elem;
        private final /* synthetic */ GraphStageLogic $outer;

        public EmittingSingle(GraphStageLogic $outer, Outlet<T> _out, T elem, OutHandler _previous, Function0<BoxedUnit> _andThen) {
            this.elem = elem;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, _out, _previous, _andThen);
        }

        @Override
        public void onPull() {
            this.$outer.push(this.out(), this.elem);
            this.followUp();
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$EmittingSingle$$$outer() {
            return this.$outer;
        }
    }

    public final class EmittingSpliterator<T>
    extends Emitting<T>
    implements Consumer<T> {
        private final Spliterator<T> elems;
        private final /* synthetic */ GraphStageLogic $outer;

        public EmittingSpliterator(GraphStageLogic $outer, Outlet<T> _out, Spliterator<T> elems, OutHandler _previous, Function0<BoxedUnit> _andThen) {
            this.elems = elems;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, _out, _previous, _andThen);
        }

        @Override
        public void onPull() {
            if (!this.elems.tryAdvance(this)) {
                this.followUp();
                return;
            }
        }

        public boolean tryPush() {
            return this.elems.tryAdvance(this);
        }

        @Override
        public void accept(T elem) {
            this.$outer.push(this.out(), elem);
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$EmittingSpliterator$$$outer() {
            return this.$outer;
        }
    }

    public class Reading<T>
    implements InHandler {
        private final Inlet<T> in;
        private int n;
        private final InHandler previous;
        private final Function1<T, BoxedUnit> andThen;
        private final Function0<BoxedUnit> onComplete;
        private final /* synthetic */ GraphStageLogic $outer;

        public Reading(GraphStageLogic $outer, Inlet<T> in, int n, InHandler previous, Function1<T, BoxedUnit> andThen, Function0<BoxedUnit> onComplete) {
            this.in = in;
            this.n = n;
            this.previous = previous;
            this.andThen = andThen;
            this.onComplete = onComplete;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Predef$.MODULE$.require(this.n() > 0, GraphStageLogic::org$apache$pekko$stream$stage$GraphStageLogic$Reading$$_$$lessinit$greater$$anonfun$1);
        }

        private int n() {
            return this.n;
        }

        private void n_$eq(int x$0) {
            this.n = x$0;
        }

        public InHandler previous() {
            return this.previous;
        }

        @Override
        public void onPush() {
            T elem = this.$outer.grab(this.in);
            this.n_$eq(this.n() - 1);
            if (this.n() > 0) {
                this.$outer.pull(this.in);
            } else {
                this.$outer.setHandler(this.in, this.previous());
            }
            this.andThen.apply(elem);
        }

        @Override
        public void onUpstreamFinish() {
            this.$outer.setHandler(this.in, this.previous());
            this.onComplete.apply$mcV$sp();
            this.previous().onUpstreamFinish();
        }

        @Override
        public void onUpstreamFailure(Throwable ex) {
            this.$outer.setHandler(this.in, this.previous());
            this.previous().onUpstreamFailure(ex);
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$Reading$$$outer() {
            return this.$outer;
        }
    }

    public static final class StageActor {
        private final Materializer materializer;
        private final AsyncCallback<Tuple2<ActorRef, Object>> callback;
        private final FunctionRef functionRef;
        private volatile Function1<Tuple2<ActorRef, Object>, BoxedUnit> behavior;

        @InternalApi
        public StageActor(Materializer materializer, Function1<Function1<Tuple2<ActorRef, Object>, BoxedUnit>, AsyncCallback<Tuple2<ActorRef, Object>>> getAsyncCallback, Function1<Tuple2<ActorRef, Object>, BoxedUnit> initialReceive, String name) {
            this.materializer = materializer;
            this.callback = (AsyncCallback)getAsyncCallback.apply((JProcedure1 & Serializable)pack -> this.internalReceive((Tuple2<ActorRef, Object>)pack));
            JProcedure2 & Serializable f = (JProcedure2 & Serializable)(x$1, x$2) -> {
                Object object;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null && (PoisonPill$.MODULE$.equals(object = tuple2._2()) || Kill$.MODULE$.equals(object))) {
                    Mirror.Singleton m = (Mirror.Singleton)object;
                    materializer.logger().warning("{} message sent to StageActor({}) will be ignored, since it is not a real Actor.Use a custom message type to communicate with it instead.", (Object)m, (Object)this.functionRef.path());
                    return;
                }
                Tuple2 pair = tuple2;
                this.callback.invoke((Tuple2<ActorRef, Object>)pair);
            };
            this.functionRef = this.cell().addFunctionRef((Function2)f, name);
            this.behavior = initialReceive;
        }

        private ActorCell cell() {
            ActorRef actorRef = this.materializer.supervisor();
            if (actorRef instanceof LocalActorRef) {
                LocalActorRef ref = (LocalActorRef)actorRef;
                return ref.underlying();
            }
            ActorRef unknown = actorRef;
            throw new IllegalStateException(new StringBuilder(47).append("Stream supervisor must be a local actor, was [").append(unknown.getClass().getName()).append("]").toString());
        }

        public ActorRef ref() {
            return this.functionRef;
        }

        public void internalReceive(Tuple2<ActorRef, Object> pack) {
            Object object = pack._2();
            if (object instanceof Terminated) {
                Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                ActorRef actorRef = terminated._1();
                ActorRef ref = actorRef;
                if (this.functionRef.isWatching(ref)) {
                    this.functionRef.unwatch(ref);
                    this.behavior.apply(pack);
                    return;
                }
                return;
            }
            this.behavior.apply(pack);
        }

        public void become(Function1<Tuple2<ActorRef, Object>, BoxedUnit> receive) {
            this.behavior = receive;
        }

        public void stop() {
            this.cell().removeFunctionRef(this.functionRef);
        }

        public void watch(ActorRef actorRef) {
            this.functionRef.watch(actorRef);
        }

        public void unwatch(ActorRef actorRef) {
            this.functionRef.unwatch(actorRef);
        }
    }

    public static final class StageActorRefNotInitializedException
    extends RuntimeException
    implements Product {
        public static StageActorRefNotInitializedException apply() {
            return GraphStageLogic$StageActorRefNotInitializedException$.MODULE$.apply();
        }

        public static StageActorRefNotInitializedException fromProduct(Product product) {
            return GraphStageLogic$StageActorRefNotInitializedException$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(StageActorRefNotInitializedException stageActorRefNotInitializedException) {
            return GraphStageLogic$StageActorRefNotInitializedException$.MODULE$.unapply(stageActorRefNotInitializedException);
        }

        public StageActorRefNotInitializedException() {
            super("You must first call getStageActor, to initialize the Actors behavior");
        }

        public int hashCode() {
            return -1008897966;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StageActorRefNotInitializedException)) return false;
            StageActorRefNotInitializedException stageActorRefNotInitializedException = (StageActorRefNotInitializedException)object;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof StageActorRefNotInitializedException;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "StageActorRefNotInitializedException";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public StageActorRefNotInitializedException copy() {
            return new StageActorRefNotInitializedException();
        }
    }

    public class SubSinkInlet<T> {
        private final String name;
        private InHandler handler;
        private T elem;
        private boolean closed;
        private boolean pulled;
        private final SubSink<T> _sink;
        private final /* synthetic */ GraphStageLogic $outer;

        public SubSinkInlet(GraphStageLogic $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.elem = null;
            this.closed = false;
            this.pulled = false;
            AsyncCallback asyncCallback = $outer.getAsyncCallback((JProcedure1 & Serializable)msg -> {
                if (!this.closed) {
                    ActorSubscriberMessage actorSubscriberMessage = msg;
                    if (actorSubscriberMessage instanceof ActorSubscriberMessage.OnNext) {
                        Object object;
                        ActorSubscriberMessage.OnNext onNext = ActorSubscriberMessage$OnNext$.MODULE$.unapply((ActorSubscriberMessage.OnNext)actorSubscriberMessage);
                        Object e = object = onNext._1();
                        this.elem = e;
                        this.pulled = false;
                        this.handler.onPush();
                        return;
                    }
                    if (ActorSubscriberMessage$OnComplete$.MODULE$.equals(actorSubscriberMessage)) {
                        this.closed = true;
                        this.handler.onUpstreamFinish();
                        $outer.org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(this);
                        return;
                    }
                    if (actorSubscriberMessage instanceof ActorSubscriberMessage.OnError) {
                        Throwable throwable;
                        ActorSubscriberMessage.OnError onError = ActorSubscriberMessage$OnError$.MODULE$.unapply((ActorSubscriberMessage.OnError)actorSubscriberMessage);
                        Throwable ex = throwable = onError._1();
                        this.closed = true;
                        this.handler.onUpstreamFailure(ex);
                        $outer.org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(this);
                        return;
                    }
                    throw new MatchError((Object)actorSubscriberMessage);
                }
            });
            this._sink = new SubSink(name, (Function1<ActorSubscriberMessage, BoxedUnit>)((JProcedure1 & Serializable)arg_0 -> GraphStageLogic.org$apache$pekko$stream$stage$GraphStageLogic$SubSinkInlet$$_$$lessinit$greater$$anonfun$2(asyncCallback, arg_0)));
            $outer.org$apache$pekko$stream$stage$GraphStageLogic$$created(this);
        }

        public Graph<SinkShape<T>, NotUsed> sink() {
            return this._sink;
        }

        public void setHandler(InHandler handler) {
            this.handler = handler;
        }

        public boolean isAvailable() {
            return this.elem != null;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean hasBeenPulled() {
            return this.pulled && !this.isClosed();
        }

        public T grab() {
            if (this.elem == null) {
                throw new IllegalArgumentException(new StringBuilder(63).append("cannot grab element from port (").append(this).append(") when data have not yet arrived").toString());
            }
            T ret = this.elem;
            this.elem = null;
            return ret;
        }

        public void pull() {
            if (this.pulled) {
                throw new IllegalArgumentException(new StringBuilder(25).append("cannot pull port (").append(this).append(") twice").toString());
            }
            if (this.closed) {
                throw new IllegalArgumentException(new StringBuilder(26).append("cannot pull closed port (").append(this).append(")").toString());
            }
            this.pulled = true;
            this._sink.pullSubstream();
        }

        public void cancel() {
            this.cancel(SubscriptionWithCancelException$NoMoreElementsNeeded$.MODULE$);
        }

        public void cancel(Throwable cause) {
            this.closed = true;
            this._sink.cancelSubstream(cause);
            this.$outer.org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(this);
        }

        public String toString() {
            return new StringBuilder(14).append("SubSinkInlet(").append(this.name).append(")").toString();
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$SubSinkInlet$$$outer() {
            return this.$outer;
        }
    }

    public class SubSourceOutlet<T> {
        private final String name;
        private OutHandler handler;
        private boolean available;
        private boolean closed;
        private final SubSource<T> _source;
        private final /* synthetic */ GraphStageLogic $outer;

        public SubSourceOutlet(GraphStageLogic $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.available = false;
            this.closed = false;
            AsyncCallback<SubSink.Command> callback = $outer.getAsyncCallback((JProcedure1 & Serializable)x$1 -> {
                SubSink.Command command = x$1;
                if (SubSink$RequestOne$.MODULE$.equals(command)) {
                    if (!this.closed) {
                        this.available = true;
                        this.handler.onPull();
                        return;
                    }
                    return;
                }
                if (command instanceof SubSink.Cancel) {
                    Throwable throwable;
                    SubSink.Cancel cancel = SubSink$Cancel$.MODULE$.unapply((SubSink.Cancel)command);
                    Throwable cause = throwable = cancel._1();
                    if (!this.closed) {
                        this.available = false;
                        this.closed = true;
                        this.handler.onDownstreamFinish(cause);
                        $outer.org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(this);
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)command);
            });
            this._source = new SubSource(name, callback);
            $outer.org$apache$pekko$stream$stage$GraphStageLogic$$created(this);
        }

        public void timeout(FiniteDuration d) {
            if (this._source.timeout(d)) {
                this.closed = true;
                return;
            }
        }

        public Graph<SourceShape<T>, NotUsed> source() {
            return this._source;
        }

        public void setHandler(OutHandler handler) {
            this.handler = handler;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void push(T elem) {
            if (!this.isAvailable()) {
                throw new IllegalArgumentException(new StringBuilder(52).append("Cannot push port (").append(this).append(") twice, or before it being pulled").toString());
            }
            this.available = false;
            this._source.pushSubstream(elem);
        }

        public void complete() {
            this.available = false;
            this.closed = true;
            this._source.completeSubstream();
            this.$outer.org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(this);
        }

        public void fail(Throwable ex) {
            this.available = false;
            this.closed = true;
            this._source.failSubstream(ex);
            this.$outer.org$apache$pekko$stream$stage$GraphStageLogic$$completedOrFailed(this);
        }

        public String toString() {
            return new StringBuilder(17).append("SubSourceOutlet(").append(this.name).append(")").toString();
        }

        public final /* synthetic */ GraphStageLogic org$apache$pekko$stream$stage$GraphStageLogic$SubSourceOutlet$$$outer() {
            return this.$outer;
        }
    }
}

