/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.io.Closeable;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import org.apache.pekko.testkit.SocketUtil;
import org.apache.pekko.testkit.SocketUtil$Both$;
import org.apache.pekko.testkit.SocketUtil$Tcp$;
import org.apache.pekko.testkit.SocketUtil$Udp$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class SocketUtil$ {
    public static SocketUtil$ MODULE$;
    private final String RANDOM_LOOPBACK_ADDRESS;
    private final boolean canBindOnAlternativeLoopbackAddresses;

    static {
        new SocketUtil$();
    }

    public String RANDOM_LOOPBACK_ADDRESS() {
        return this.RANDOM_LOOPBACK_ADDRESS;
    }

    private boolean canBindOnAlternativeLoopbackAddresses() {
        return this.canBindOnAlternativeLoopbackAddresses;
    }

    public int temporaryLocalPort(boolean udp) {
        return this.temporaryServerAddress("localhost", udp).getPort();
    }

    public int temporaryLocalPort(SocketUtil.Protocol protocol) {
        if (SocketUtil$Tcp$.MODULE$.equals(protocol)) {
            return this.temporaryLocalPort(false);
        }
        if (SocketUtil$Udp$.MODULE$.equals(protocol)) {
            return this.temporaryLocalPort(true);
        }
        if (SocketUtil$Both$.MODULE$.equals(protocol)) {
            return SocketUtil$.findBoth$1(5);
        }
        throw new MatchError((Object)protocol);
    }

    public boolean temporaryLocalPort$default$1() {
        return false;
    }

    public InetSocketAddress temporaryServerAddress(String address, boolean udp) {
        return (InetSocketAddress)this.temporaryServerAddresses(1, address, udp).head();
    }

    public String temporaryServerAddress$default$1() {
        return this.RANDOM_LOOPBACK_ADDRESS();
    }

    public boolean temporaryServerAddress$default$2() {
        return false;
    }

    public IndexedSeq<InetSocketAddress> temporaryServerAddresses(int numberOfAddresses, String hostname, boolean udp) {
        return (IndexedSeq)((TraversableLike)package$.MODULE$.Vector().fill(numberOfAddresses, (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            String string = MODULE$.RANDOM_LOOPBACK_ADDRESS();
            String address = !(string != null ? !string.equals(hostname) : hostname != null) ? (MODULE$.canBindOnAlternativeLoopbackAddresses() ? new StringBuilder(8).append("127.20.").append(Random$.MODULE$.nextInt(256)).append(".").append(Random$.MODULE$.nextInt(255)).toString() : "127.0.0.1") : hostname;
            InetSocketAddress addr = new InetSocketAddress(address, 0);
            try {
                if (!udp) {
                    ServerSocket ss = ServerSocketChannel.open().socket();
                    ss.bind(addr);
                    return new Tuple2((Object)ss, (Object)new InetSocketAddress(address, ss.getLocalPort()));
                }
                DatagramSocket ds = DatagramChannel.open().socket();
                ds.bind(addr);
                tuple2 = new Tuple2((Object)ds, (Object)new InetSocketAddress(address, ds.getLocalPort()));
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    throw new RuntimeException(new StringBuilder(24).append("Binding to ").append(addr).append(" failed with ").append(ex.getMessage()).toString(), ex);
                }
                throw throwable;
            }
            return tuple2;
        })).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Closeable, InetSocketAddress>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    Closeable socket = (Closeable)x1._1();
                    InetSocketAddress address = (InetSocketAddress)x1._2();
                    socket.close();
                    return (B1)address;
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Tuple2<Closeable, InetSocketAddress> x1) {
                return x1 != null;
            }
        }, Vector$.MODULE$.canBuildFrom());
    }

    public String temporaryServerAddresses$default$2() {
        return this.RANDOM_LOOPBACK_ADDRESS();
    }

    public boolean temporaryServerAddresses$default$3() {
        return false;
    }

    public Tuple2<String, Object> temporaryServerHostnameAndPort(String string) {
        InetSocketAddress socketAddress = this.temporaryServerAddress(string, this.temporaryServerAddress$default$2());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)socketAddress.getHostString()), (Object)BoxesRunTime.boxToInteger((int)socketAddress.getPort()));
    }

    public String temporaryServerHostnameAndPort$default$1() {
        return this.RANDOM_LOOPBACK_ADDRESS();
    }

    public int temporaryUdpIpv6Port(NetworkInterface iface) {
        DatagramSocket serverSocket = DatagramChannel.open(StandardProtocolFamily.INET6).socket();
        serverSocket.bind(new InetSocketAddress(iface.getInetAddresses().nextElement(), 0));
        int port = serverSocket.getLocalPort();
        serverSocket.close();
        return port;
    }

    public InetSocketAddress notBoundServerAddress(String address) {
        return new InetSocketAddress(address, 0);
    }

    public InetSocketAddress notBoundServerAddress() {
        return this.notBoundServerAddress("127.0.0.1");
    }

    private static final /* synthetic */ boolean liftedTree1$1() {
        try {
            MODULE$.temporaryServerAddress("127.20.0.0", MODULE$.temporaryServerAddress$default$2());
            return true;
        }
        catch (Throwable throwable) {
            if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                return false;
            }
            throw throwable;
        }
    }

    private static final int findBoth$1(int tries) {
        int n;
        block7: {
            if (tries == 0) {
                throw new RuntimeException("Unable to find a port that is free for tcp and udp");
            }
            int tcpPort = MODULE$.temporaryLocalPort(false);
            try (DatagramSocket ds = DatagramChannel.open().socket();){
                try {
                    ds.bind(new InetSocketAddress("localhost", tcpPort));
                    n = tcpPort;
                }
                catch (Throwable throwable) {
                    if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                        n = SocketUtil$.findBoth$1(tries - 1);
                        break block7;
                    }
                    throw throwable;
                }
            }
        }
        return n;
    }

    private SocketUtil$() {
        MODULE$ = this;
        this.RANDOM_LOOPBACK_ADDRESS = "RANDOM_LOOPBACK_ADDRESS";
        this.canBindOnAlternativeLoopbackAddresses = SocketUtil$.liftedTree1$1();
    }
}

