/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.testkit.package$;
import org.apache.pekko.testkit.package$TestDuration$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;

public final class TestKit$ {
    public static TestKit$ MODULE$;
    @InternalApi
    private final AtomicInteger testActorId;

    static {
        new TestKit$();
    }

    public AtomicInteger testActorId() {
        return this.testActorId;
    }

    public boolean awaitCond(Function0<Object> p, Duration max, Duration interval, boolean noThrow) {
        Duration stop = this.now().$plus(max);
        while (!p.apply$mcZ$sp()) {
            Duration poll$4_toSleep = stop.$minus(this.now());
            if (poll$4_toSleep.$less$eq((Object)Duration$.MODULE$.Zero())) {
                if (noThrow) {
                    return false;
                }
                throw new AssertionError((Object)new StringBuilder(16).append("timeout ").append(max).append(" expired").toString());
            }
            Thread.sleep(poll$4_toSleep.min(interval).toMillis());
        }
        return true;
    }

    public Duration awaitCond$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis();
    }

    public boolean awaitCond$default$4() {
        return false;
    }

    public Duration now() {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(System.nanoTime())).nanos();
    }

    public void shutdownActorSystem(ActorSystem actorSystem, Duration duration, boolean verifySystemShutdown) {
        FiniteDuration finiteDuration;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration2 = (FiniteDuration)duration;
            finiteDuration = package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(finiteDuration2), actorSystem);
        } else {
            finiteDuration = package$TestDuration$.MODULE$.dilated$extension(package$.MODULE$.TestDuration(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds()), actorSystem).min(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        }
        FiniteDuration d = finiteDuration;
        actorSystem.terminate();
        try {
            Await$.MODULE$.ready((Awaitable)actorSystem.whenTerminated(), (Duration)d);
            return;
        }
        catch (TimeoutException timeoutException) {
            String msg = new StringOps(Predef$.MODULE$.augmentString("Failed to stop [%s] within [%s] \n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{actorSystem.name(), d, ((ActorSystemImpl)actorSystem).printTree()}));
            if (verifySystemShutdown) {
                throw new RuntimeException(msg);
            }
            Predef$.MODULE$.println((Object)msg);
            return;
        }
    }

    public Duration shutdownActorSystem$default$2() {
        return Duration$.MODULE$.Undefined();
    }

    public boolean shutdownActorSystem$default$3() {
        return false;
    }

    private final boolean poll$4(Function0 p$2, Duration stop$6, boolean noThrow$1, Duration max$6, Duration interval$4) {
        while (!p$2.apply$mcZ$sp()) {
            Duration toSleep = stop$6.$minus(this.now());
            if (toSleep.$less$eq((Object)Duration$.MODULE$.Zero())) {
                if (noThrow$1) {
                    return false;
                }
                throw new AssertionError((Object)new StringBuilder(16).append("timeout ").append(max$6).append(" expired").toString());
            }
            Thread.sleep(toSleep.min(interval$4).toMillis());
        }
        return true;
    }

    private TestKit$() {
        MODULE$ = this;
        this.testActorId = new AtomicInteger(0);
    }
}

