/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.dispatch.DefaultSystemMessageQueue;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Mailbox;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.MessageQueue;
import org.apache.pekko.testkit.CallingThreadDispatcherQueues;
import org.apache.pekko.testkit.CallingThreadDispatcherQueues$;
import org.apache.pekko.util.Switch;
import org.apache.pekko.util.Switch$;
import scala.Function0;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;

public class CallingThreadMailbox
extends Mailbox
implements DefaultSystemMessageQueue {
    private final MailboxType mailboxType;
    private final ActorSystem system;
    private final ActorRef self;
    private final ThreadLocal<MessageQueue> q;
    private final MessageQueue messageQueue;
    private final ReentrantLock ctdLock;
    private final Switch suspendSwitch;

    public CallingThreadMailbox(Cell _receiver, MailboxType mailboxType) {
        this.mailboxType = mailboxType;
        super(null);
        this.system = _receiver.system();
        this.self = _receiver.self();
        this.q = new ThreadLocal<MessageQueue>(this){
            private final /* synthetic */ CallingThreadMailbox $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public MessageQueue initialValue() {
                MessageQueue queue = this.$outer.mailboxType().create((Option)Some$.MODULE$.apply((Object)this.$outer.self()), (Option)Some$.MODULE$.apply((Object)this.$outer.system()));
                ((CallingThreadDispatcherQueues)CallingThreadDispatcherQueues$.MODULE$.apply(this.$outer.system())).registerQueue(this.$outer, queue);
                return queue;
            }
        };
        this.messageQueue = this.q.get();
        this.ctdLock = new ReentrantLock();
        this.suspendSwitch = new Switch(Switch$.MODULE$.$lessinit$greater$default$1());
    }

    public MailboxType mailboxType() {
        return this.mailboxType;
    }

    public ActorSystem system() {
        return this.system;
    }

    public ActorRef self() {
        return this.self;
    }

    public MessageQueue messageQueue() {
        return this.messageQueue;
    }

    public void enqueue(ActorRef receiver, Envelope msg) {
        this.q.get().enqueue(receiver, msg);
    }

    public Envelope dequeue() {
        throw new UnsupportedOperationException("CallingThreadMailbox cannot dequeue normally");
    }

    public boolean hasMessages() {
        return this.q.get().hasMessages();
    }

    public int numberOfMessages() {
        return 0;
    }

    public MessageQueue queue() {
        return this.q.get();
    }

    public ReentrantLock ctdLock() {
        return this.ctdLock;
    }

    public Switch suspendSwitch() {
        return this.suspendSwitch;
    }

    public void cleanUp() {
        this.suspendSwitch().locked((Function0 & Serializable)() -> {
            this.cleanUp$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private final void cleanUp$$anonfun$1() {
        MessageQueue qq = this.queue();
        ((CallingThreadDispatcherQueues)CallingThreadDispatcherQueues$.MODULE$.apply((ActorSystem)this.actor().system())).gatherFromAllOtherQueues(this, qq);
        super.cleanUp();
        qq.cleanUp((ActorRef)this.actor().self(), this.actor().dispatcher().mailboxes().deadLetterMailbox().messageQueue());
        this.q.remove();
    }
}

