/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.io.Closeable;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import org.apache.pekko.testkit.SocketUtil;
import org.apache.pekko.testkit.SocketUtil$Both$;
import org.apache.pekko.testkit.SocketUtil$Tcp$;
import org.apache.pekko.testkit.SocketUtil$Udp$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class SocketUtil$
implements Serializable {
    private static final String RANDOM_LOOPBACK_ADDRESS;
    private static final boolean canBindOnAlternativeLoopbackAddresses;
    public static final SocketUtil$Tcp$ Tcp;
    public static final SocketUtil$Udp$ Udp;
    public static final SocketUtil$Both$ Both;
    public static final SocketUtil$ MODULE$;

    private SocketUtil$() {
    }

    static {
        MODULE$ = new SocketUtil$();
        RANDOM_LOOPBACK_ADDRESS = "RANDOM_LOOPBACK_ADDRESS";
        canBindOnAlternativeLoopbackAddresses = MODULE$.liftedTree1$1();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SocketUtil$.class);
    }

    public String RANDOM_LOOPBACK_ADDRESS() {
        return RANDOM_LOOPBACK_ADDRESS;
    }

    public int temporaryLocalPort(boolean udp) {
        return this.temporaryServerAddress("localhost", udp).getPort();
    }

    public boolean temporaryLocalPort$default$1() {
        return false;
    }

    public int temporaryLocalPort(SocketUtil.Protocol protocol) {
        SocketUtil.Protocol protocol2 = protocol;
        if (SocketUtil$Tcp$.MODULE$.equals(protocol2)) {
            return this.temporaryLocalPort(false);
        }
        if (SocketUtil$Udp$.MODULE$.equals(protocol2)) {
            return this.temporaryLocalPort(true);
        }
        if (SocketUtil$Both$.MODULE$.equals(protocol2)) {
            return this.findBoth$1(5);
        }
        throw new MatchError((Object)protocol2);
    }

    public InetSocketAddress temporaryServerAddress(String address, boolean udp) {
        return (InetSocketAddress)this.temporaryServerAddresses(1, address, udp).head();
    }

    public String temporaryServerAddress$default$1() {
        return this.RANDOM_LOOPBACK_ADDRESS();
    }

    public boolean temporaryServerAddress$default$2() {
        return false;
    }

    public IndexedSeq<InetSocketAddress> temporaryServerAddresses(int numberOfAddresses, String hostname, boolean udp) {
        return (IndexedSeq)((StrictOptimizedIterableOps)package$.MODULE$.Vector().fill(numberOfAddresses, () -> this.temporaryServerAddresses$$anonfun$1(hostname, udp))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Closeable socket = (Closeable)tuple2._1();
                    InetSocketAddress address = (InetSocketAddress)tuple2._2();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Closeable socket = (Closeable)tuple2._1();
                    InetSocketAddress address = (InetSocketAddress)tuple2._2();
                    socket.close();
                    return address;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public String temporaryServerAddresses$default$2() {
        return this.RANDOM_LOOPBACK_ADDRESS();
    }

    public boolean temporaryServerAddresses$default$3() {
        return false;
    }

    public Tuple2<String, Object> temporaryServerHostnameAndPort(String string) {
        InetSocketAddress socketAddress = this.temporaryServerAddress(string, this.temporaryServerAddress$default$2());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)socketAddress.getHostString());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)socketAddress.getPort()));
    }

    public String temporaryServerHostnameAndPort$default$1() {
        return this.RANDOM_LOOPBACK_ADDRESS();
    }

    public int temporaryUdpIpv6Port(NetworkInterface iface) {
        DatagramSocket serverSocket = DatagramChannel.open(StandardProtocolFamily.INET6).socket();
        serverSocket.bind(new InetSocketAddress(iface.getInetAddresses().nextElement(), 0));
        int port = serverSocket.getLocalPort();
        serverSocket.close();
        return port;
    }

    public InetSocketAddress notBoundServerAddress(String address) {
        return new InetSocketAddress(address, 0);
    }

    public InetSocketAddress notBoundServerAddress() {
        return this.notBoundServerAddress("127.0.0.1");
    }

    private final boolean liftedTree1$1() {
        boolean bl;
        try {
            this.temporaryServerAddress("127.20.0.0", this.temporaryServerAddress$default$2());
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private final int findBoth$1(int tries) {
        int n;
        block7: {
            if (tries == 0) {
                throw new RuntimeException("Unable to find a port that is free for tcp and udp");
            }
            int tcpPort = this.temporaryLocalPort(false);
            try (DatagramSocket ds = DatagramChannel.open().socket();){
                try {
                    ds.bind(new InetSocketAddress("localhost", tcpPort));
                    n = tcpPort;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        n = this.findBoth$1(tries - 1);
                        break block7;
                    }
                    throw throwable;
                }
            }
        }
        return n;
    }

    private final Tuple2 temporaryServerAddresses$$anonfun$1(String hostname$1, boolean udp$1) {
        Tuple2 tuple2;
        String other;
        String string = hostname$1;
        String string2 = this.RANDOM_LOOPBACK_ADDRESS();
        String string3 = string;
        String string4 = !(string2 != null ? !string2.equals(string3) : string3 != null) ? (canBindOnAlternativeLoopbackAddresses ? new StringBuilder(8).append("127.20.").append(Random$.MODULE$.nextInt(256)).append(".").append(Random$.MODULE$.nextInt(255)).toString() : "127.0.0.1") : (other = string);
        String address = string4;
        InetSocketAddress addr = new InetSocketAddress(address, 0);
        try {
            if (udp$1) {
                DatagramSocket ds = DatagramChannel.open().socket();
                ds.bind(addr);
                tuple2 = Tuple2$.MODULE$.apply((Object)ds, (Object)new InetSocketAddress(address, ds.getLocalPort()));
            } else {
                ServerSocket ss = ServerSocketChannel.open().socket();
                ss.bind(addr);
                tuple2 = Tuple2$.MODULE$.apply((Object)ss, (Object)new InetSocketAddress(address, ss.getLocalPort()));
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                throw new RuntimeException(new StringBuilder(24).append("Binding to ").append(addr).append(" failed with ").append(ex.getMessage()).toString(), ex);
            }
            throw throwable;
        }
        return tuple2;
    }
}

