/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.actor.IllegalActorStateException$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.RepointableActorRef;
import org.apache.pekko.actor.UnstartedCell;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Envelope$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.testkit.CallingThreadDispatcher$;
import org.apache.pekko.testkit.TestActorRef$;
import org.apache.pekko.testkit.TestActorRef$InternalGetActor$;
import org.apache.pekko.testkit.TestKitExtension$;
import org.apache.pekko.testkit.TestKitSettings;
import org.apache.pekko.util.Timeout;
import scala.Function0;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class TestActorRef<T extends Actor>
extends LocalActorRef {
    private final ActorSystem _system;
    private final Props props;
    private final MessageDispatcher dispatcher;

    public static <T extends Actor> TestActorRef<T> apply(ActorRef actorRef, ClassTag<T> classTag, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(actorRef, classTag, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(ActorRef actorRef, String string, ClassTag<T> classTag, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(actorRef, string, classTag, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(ClassTag<T> classTag, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(classTag, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(Function0<T> function0, ClassTag<T> classTag, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(function0, classTag, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(Function0<T> function0, String string, ClassTag<T> classTag, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(function0, string, classTag, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(Props props, ActorRef actorRef, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(props, actorRef, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(Props props, ActorRef actorRef, String string, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(props, actorRef, string, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(Props props, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(props, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(Props props, String string, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(props, string, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> apply(String string, ClassTag<T> classTag, ActorSystem actorSystem) {
        return TestActorRef$.MODULE$.apply(string, classTag, actorSystem);
    }

    public static <T extends Actor> TestActorRef<T> create(ActorSystem actorSystem, Props props) {
        return TestActorRef$.MODULE$.create(actorSystem, props);
    }

    public static <T extends Actor> TestActorRef<T> create(ActorSystem actorSystem, Props props, ActorRef actorRef) {
        return TestActorRef$.MODULE$.create(actorSystem, props, actorRef);
    }

    public static <T extends Actor> TestActorRef<T> create(ActorSystem actorSystem, Props props, ActorRef actorRef, String string) {
        return TestActorRef$.MODULE$.create(actorSystem, props, actorRef, string);
    }

    public static <T extends Actor> TestActorRef<T> create(ActorSystem actorSystem, Props props, String string) {
        return TestActorRef$.MODULE$.create(actorSystem, props, string);
    }

    public static String randomName() {
        return TestActorRef$.MODULE$.randomName();
    }

    public TestActorRef(ActorSystem _system, Props _props, ActorRef _supervisor, String name) {
        Boolean bl;
        this._system = _system;
        ActorRef actorRef = _supervisor;
        if (actorRef instanceof LocalActorRef) {
            LocalActorRef l = (LocalActorRef)actorRef;
            bl = BoxesRunTime.boxToBoolean((boolean)l.underlying().reserveChild(name));
        } else if (actorRef instanceof RepointableActorRef) {
            RepointableActorRef r = (RepointableActorRef)actorRef;
            Cell cell = r.underlying();
            if (cell instanceof UnstartedCell) {
                throw new IllegalStateException("cannot attach a TestActor to an unstarted top-level actor, ensure that it is started by sending a message and observing the reply");
            }
            if (cell instanceof ActorCell) {
                ActorCell c = (ActorCell)cell;
                bl = BoxesRunTime.boxToBoolean((boolean)c.reserveChild(name));
            } else {
                Cell o = cell;
                _system.log().error("trying to attach child {} to unknown type of supervisor cell {}, this is not going to end well", (Object)name, (Object)o.getClass());
                bl = BoxedUnit.UNIT;
            }
        } else {
            ActorRef s = actorRef;
            _system.log().error("trying to attach child {} to unknown type of supervisor {}, this is not going to end well", (Object)name, (Object)s.getClass());
            bl = BoxedUnit.UNIT;
        }
        Boolean disregard = bl;
        String string = _props.deploy().dispatcher();
        String string2 = "";
        String string3 = _props.deploy().dispatcher();
        String string4 = "";
        Props props = _props.withDispatcher(!(string3 != null ? !string3.equals(string4) : string4 != null) ? CallingThreadDispatcher$.MODULE$.Id() : _props.dispatcher());
        String string5 = _props.deploy().dispatcher();
        String string6 = "";
        Props props2 = _props.withDispatcher(!(string5 != null ? !string5.equals(string6) : string6 != null) ? CallingThreadDispatcher$.MODULE$.Id() : _props.dispatcher());
        MessageDispatcher dispatcher = _system.dispatchers().lookup(props2.dispatcher());
        super((ActorSystemImpl)_system, _props.withDispatcher(!(string != null ? !string.equals(string2) : string2 != null) ? CallingThreadDispatcher$.MODULE$.Id() : _props.dispatcher()), _system.dispatchers().lookup(props.dispatcher()), _system.mailboxes().getMailboxType(props2, dispatcher.configurator().config()), (InternalActorRef)_supervisor, _supervisor.path().$div(name));
        String string7 = _props.deploy().dispatcher();
        String string8 = "";
        this.props = _props.withDispatcher(!(string7 != null ? !string7.equals(string8) : string8 != null) ? CallingThreadDispatcher$.MODULE$.Id() : _props.dispatcher());
        this.dispatcher = _system.dispatchers().lookup(this.props().dispatcher());
        this.underlying().start();
    }

    public Props props() {
        return this.props;
    }

    public MessageDispatcher dispatcher() {
        return this.dispatcher;
    }

    public ActorCell newActorCell(ActorSystemImpl system, InternalActorRef ref, Props props, MessageDispatcher dispatcher, InternalActorRef supervisor) {
        return new ActorCell(system, ref, props, dispatcher, supervisor){

            public void autoReceiveMessage(Envelope msg) {
                Object object = msg.message();
                if (TestActorRef$InternalGetActor$.MODULE$.equals(object)) {
                    ActorRef actorRef = this.sender();
                    Actor actor = this.actor();
                    actorRef.$bang((Object)actor, actorRef.$bang$default$2((Object)actor));
                    return;
                }
                super.autoReceiveMessage(msg);
            }
        };
    }

    public void receive(Object o) {
        this.receive(o, this.underlying().system().deadLetters());
    }

    public void receive(Object o, ActorRef sender) {
        try {
            this.underlying().currentMessage_$eq(Envelope$.MODULE$.apply(o, sender == null ? this.underlying().system().deadLetters() : sender, (ActorSystem)this.underlying().system()));
            this.underlying().receiveMessage(o);
        }
        finally {
            this.underlying().currentMessage_$eq(null);
        }
    }

    public T underlyingActor() {
        if (this.isTerminated()) {
            throw IllegalActorStateException$.MODULE$.apply("underlying actor is terminated");
        }
        Actor actor = this.underlying().actor();
        if (actor == null) {
            Timeout t = ((TestKitSettings)TestKitExtension$.MODULE$.apply(this._system)).DefaultTimeout();
            ActorRef actorRef = package$.MODULE$.ask((ActorRef)this);
            return (T)((Actor)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)TestActorRef$InternalGetActor$.MODULE$, t, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)TestActorRef$InternalGetActor$.MODULE$)), (Duration)t.duration()));
        }
        Actor ref = actor;
        return (T)ref;
    }

    public ActorRef watch(ActorRef subject) {
        return this.underlying().watch(subject);
    }

    public ActorRef unwatch(ActorRef subject) {
        return this.underlying().unwatch(subject);
    }

    public String toString() {
        return new StringBuilder(11).append("TestActor[").append(this.path()).append("]").toString();
    }
}

