/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Mailbox;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.MessageDispatcherConfigurator;
import org.apache.pekko.dispatch.MessageQueue;
import org.apache.pekko.dispatch.TaskInvocation;
import org.apache.pekko.dispatch.sysmsg.Resume$;
import org.apache.pekko.dispatch.sysmsg.Suspend$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.testkit.CallingThreadDispatcher$;
import org.apache.pekko.testkit.CallingThreadDispatcherQueues;
import org.apache.pekko.testkit.CallingThreadDispatcherQueues$;
import org.apache.pekko.testkit.CallingThreadMailbox;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class CallingThreadDispatcher
extends MessageDispatcher {
    private final LoggingAdapter log = Logging$.MODULE$.apply((LoggingBus)this.eventStream(), CallingThreadDispatcher.class, LogSource$.MODULE$.fromAnyClass());

    public static String Id() {
        return CallingThreadDispatcher$.MODULE$.Id();
    }

    public CallingThreadDispatcher(MessageDispatcherConfigurator _configurator) {
        super(_configurator);
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public String id() {
        return CallingThreadDispatcher$.MODULE$.Id();
    }

    public Mailbox createMailbox(Cell actor, MailboxType mailboxType) {
        return new CallingThreadMailbox(actor, mailboxType);
    }

    public void shutdown() {
    }

    public int throughput() {
        return 0;
    }

    public Duration throughputDeadlineTime() {
        return Duration$.MODULE$.Zero();
    }

    public boolean registerForExecution(Mailbox mbox, boolean hasMessageHint, boolean hasSystemMessageHint) {
        return false;
    }

    public FiniteDuration shutdownTimeout() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
    }

    public void register(ActorCell actor) {
        super.register(actor);
        Mailbox mailbox = actor.mailbox();
        if (mailbox instanceof CallingThreadMailbox) {
            CallingThreadMailbox mbox = (CallingThreadMailbox)mailbox;
            MessageQueue queue = mbox.queue();
            this.runQueue(mbox, queue, this.runQueue$default$3());
            return;
        }
        Mailbox x = mailbox;
        throw ActorInitializationException$.MODULE$.apply(new StringBuilder(35).append("expected CallingThreadMailbox, got ").append(x.getClass()).toString());
    }

    public void unregister(ActorCell actor) {
        None$ none$;
        Mailbox mailbox = actor.mailbox();
        if (mailbox instanceof CallingThreadMailbox) {
            CallingThreadMailbox m = (CallingThreadMailbox)mailbox;
            none$ = Some$.MODULE$.apply((Object)m);
        } else {
            none$ = None$.MODULE$;
        }
        None$ mbox2 = none$;
        super.unregister(actor);
        CallingThreadDispatcherQueues callingThreadDispatcherQueues = (CallingThreadDispatcherQueues)CallingThreadDispatcherQueues$.MODULE$.apply((ActorSystem)actor.system());
        mbox2.foreach((Function1)(JProcedure1 & Serializable)mbox -> callingThreadDispatcherQueues.unregisterQueues((CallingThreadMailbox)((Object)mbox)));
    }

    public void suspend(ActorCell actor) {
        Mailbox mailbox = actor.mailbox();
        if (mailbox instanceof CallingThreadMailbox) {
            CallingThreadMailbox m = (CallingThreadMailbox)mailbox;
            m.suspendSwitch().switchOn();
            m.suspend();
            return;
        }
        Mailbox m = mailbox;
        m.systemEnqueue((ActorRef)actor.self(), (SystemMessage)Suspend$.MODULE$.apply());
    }

    public void resume(ActorCell actor) {
        Mailbox mailbox = actor.mailbox();
        if (mailbox instanceof CallingThreadMailbox) {
            CallingThreadMailbox mbox = (CallingThreadMailbox)mailbox;
            MessageQueue queue = mbox.queue();
            boolean switched = mbox.suspendSwitch().switchOff((Function0 & Serializable)() -> {
                CallingThreadDispatcher.$anonfun$2(actor, mbox, queue);
                return BoxedUnit.UNIT;
            });
            if (switched) {
                this.runQueue(mbox, queue, this.runQueue$default$3());
                return;
            }
            return;
        }
        Mailbox m = mailbox;
        m.systemEnqueue((ActorRef)actor.self(), (SystemMessage)Resume$.MODULE$.apply(null));
    }

    public void systemDispatch(ActorCell receiver, SystemMessage message) {
        Mailbox mailbox = receiver.mailbox();
        if (mailbox instanceof CallingThreadMailbox) {
            CallingThreadMailbox mbox = (CallingThreadMailbox)mailbox;
            mbox.systemEnqueue((ActorRef)receiver.self(), message);
            this.runQueue(mbox, mbox.queue(), this.runQueue$default$3());
            return;
        }
        Mailbox m = mailbox;
        m.systemEnqueue((ActorRef)receiver.self(), message);
    }

    public void dispatch(ActorCell receiver, Envelope handle) {
        Mailbox mailbox = receiver.mailbox();
        if (mailbox instanceof CallingThreadMailbox) {
            CallingThreadMailbox mbox = (CallingThreadMailbox)mailbox;
            MessageQueue queue = mbox.queue();
            boolean execute = BoxesRunTime.unboxToBoolean((Object)mbox.suspendSwitch().fold(() -> CallingThreadDispatcher.$anonfun$3(receiver, handle, queue), () -> CallingThreadDispatcher.$anonfun$4(receiver, handle, queue)));
            if (execute) {
                this.runQueue(mbox, queue, this.runQueue$default$3());
                return;
            }
            return;
        }
        Mailbox m = mailbox;
        m.enqueue((ActorRef)receiver.self(), handle);
    }

    public void executeTask(TaskInvocation invocation) {
        invocation.run();
    }

    private void runQueue(CallingThreadMailbox mbox, MessageQueue queue, InterruptedException interruptedEx) {
        while (!mbox.ctdLock().isHeldByCurrentThread()) {
            boolean gotLock;
            boolean bl;
            InterruptedException intex = interruptedEx;
            try {
                bl = mbox.ctdLock().tryLock(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                intex = ie;
                bl = gotLock = false;
            }
            if (gotLock) {
                InterruptedException interruptedException;
                try {
                    interruptedException = this.process$1(mbox, queue, intex);
                }
                finally {
                    mbox.ctdLock().unlock();
                }
                InterruptedException ie = interruptedException;
                this.throwInterruptionIfExistsOrSet$1(ie);
                return;
            }
            if (mbox.hasSystemMessages() || mbox.hasMessages()) {
                interruptedEx = intex;
                continue;
            }
            this.throwInterruptionIfExistsOrSet$1(intex);
            return;
        }
    }

    private InterruptedException runQueue$default$3() {
        return null;
    }

    private static final void $anonfun$2(ActorCell actor$1, CallingThreadMailbox mbox$2, MessageQueue queue$1) {
        ((CallingThreadDispatcherQueues)CallingThreadDispatcherQueues$.MODULE$.apply((ActorSystem)actor$1.system())).gatherFromAllOtherQueues(mbox$2, queue$1);
        mbox$2.resume();
    }

    private static final boolean $anonfun$3(ActorCell receiver$1, Envelope handle$1, MessageQueue queue$2) {
        queue$2.enqueue((ActorRef)receiver$1.self(), handle$1);
        return false;
    }

    private static final boolean $anonfun$4(ActorCell receiver$2, Envelope handle$2, MessageQueue queue$3) {
        queue$3.enqueue((ActorRef)receiver$2.self(), handle$2);
        return true;
    }

    private final InterruptedException checkThreadInterruption$1(InterruptedException intEx) {
        if (Thread.interrupted()) {
            InterruptedException ie = new InterruptedException("Interrupted during message processing");
            this.log().error((Throwable)ie, "Interrupted during message processing");
            return ie;
        }
        return intEx;
    }

    private final void throwInterruptionIfExistsOrSet$1(InterruptedException intEx) {
        InterruptedException ie = this.checkThreadInterruption$1(intEx);
        if (ie != null) {
            Thread.interrupted();
            throw ie;
        }
    }

    private static final Envelope $anonfun$5() {
        return null;
    }

    private static final Envelope $anonfun$6(CallingThreadMailbox mbox$4, MessageQueue queue$5) {
        if (mbox$4.isClosed()) {
            return null;
        }
        return queue$5.dequeue();
    }

    private final InterruptedException process$1(CallingThreadMailbox mbox$3, MessageQueue queue$4, InterruptedException intEx) {
        InterruptedException intex;
        while (true) {
            boolean recurse;
            boolean bl;
            intex = intEx;
            mbox$3.processAllSystemMessages();
            Envelope handle = (Envelope)mbox$3.suspendSwitch().fold(CallingThreadDispatcher::$anonfun$5, () -> CallingThreadDispatcher.$anonfun$6(mbox$3, queue$4));
            if (handle != null) {
                try {
                    mbox$3.actor().invoke(handle);
                    intex = this.checkThreadInterruption$1(intex);
                    bl = true;
                }
                catch (InterruptedException ie) {
                    this.log().error((Throwable)ie, "Interrupted during message processing");
                    Thread.interrupted();
                    intex = ie;
                    bl = true;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        this.log().error(e, "Error during message processing");
                        bl = false;
                    }
                    throw throwable;
                }
            } else {
                bl = false;
            }
            if (!(recurse = bl)) break;
            intEx = intex;
        }
        return intex;
    }
}

