/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.testkit;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public class ExplicitlyTriggeredScheduler
implements Scheduler {
    private final LoggingAdapter log;
    private final AtomicLong currentTime;
    public final ConcurrentHashMap<Item, Object> org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled;

    public ExplicitlyTriggeredScheduler(Config config, LoggingAdapter log, ThreadFactory tf) {
        this.log = log;
        this.currentTime = new AtomicLong();
        this.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled = new ConcurrentHashMap();
    }

    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
        return this.schedule(initialDelay, (Option<FiniteDuration>)Some$.MODULE$.apply((Object)interval), runnable);
    }

    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        return this.schedule(delay, (Option<FiniteDuration>)None$.MODULE$, runnable);
    }

    public void timePasses(FiniteDuration amount) {
        Thread.sleep(100L);
        long newTime = this.currentTime.get() + amount.toMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug(new StringBuilder(61).append("Time proceeds from ").append(this.currentTime.get()).append(" to ").append(newTime).append(", currently scheduled for this period:").append(this.scheduledTasks(newTime).map((Function1 & Serializable)item -> new StringBuilder(3).append("\n- ").append(item).toString())).toString());
        }
        this.executeTasks(newTime);
        this.currentTime.set(newTime);
    }

    private Seq<Tuple2<Item, Object>> scheduledTasks(long runTo) {
        return (Seq)((SeqOps)((IterableOnceOps)package.JavaConverters$.MODULE$.SetHasAsScala(this.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled.entrySet()).asScala().map((Function1 & Serializable)s -> Tuple2$.MODULE$.apply(s.getKey(), s.getValue()))).toSeq().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return v <= runTo;
            }
            throw new MatchError((Object)tuple2);
        })).sortBy((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToLong((Object)_$1._2()), (Ordering)Ordering.Long$.MODULE$);
    }

    public final void executeTasks(long runTo) {
        Tuple2 tuple2;
        Option option;
        while ((option = this.scheduledTasks(runTo).headOption()) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Item task = (Item)tuple2._1();
            long time = BoxesRunTime.unboxToLong((Object)tuple2._2());
            this.currentTime.set(time);
            Try runResult = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ExplicitlyTriggeredScheduler.$anonfun$1(task);
                return BoxedUnit.UNIT;
            });
            this.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled.remove(task);
            if (!runResult.isSuccess()) continue;
            task.interval().foreach((Function1 & Serializable)i -> BoxesRunTime.unboxToLong((Object)this.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled.put(task, BoxesRunTime.boxToLong((long)(time + i.toMillis())))));
        }
    }

    private Cancellable schedule(FiniteDuration initialDelay, Option<FiniteDuration> interval, Runnable runnable) {
        long firstTime = this.currentTime.get() + initialDelay.toMillis();
        Item item = new Item(interval, runnable);
        this.log.debug("Scheduled item for {}: {}", (Object)BoxesRunTime.boxToLong((long)firstTime), (Object)item);
        this.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled.put(item, BoxesRunTime.boxToLong((long)firstTime));
        if (initialDelay.$less$eq((Object)Duration$.MODULE$.Zero())) {
            this.executeTasks(this.currentTime.get());
        }
        return new Cancellable(item, this){
            private final Item item$1;
            private boolean cancelled;
            private final /* synthetic */ ExplicitlyTriggeredScheduler $outer;
            {
                this.item$1 = item$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cancelled = false;
            }

            public boolean cancelled() {
                return this.cancelled;
            }

            public void cancelled_$eq(boolean x$1) {
                this.cancelled = x$1;
            }

            public boolean cancel() {
                int before = this.$outer.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled.size();
                this.$outer.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled.remove(this.item$1);
                this.cancelled_$eq(true);
                return before > this.$outer.org$apache$pekko$testkit$ExplicitlyTriggeredScheduler$$scheduled.size();
            }

            public boolean isCancelled() {
                return this.cancelled();
            }
        };
    }

    public double maxFrequency() {
        return 42.0;
    }

    public long currentTimeMs() {
        return this.currentTime.get();
    }

    private static final void $anonfun$1(Item task$1) {
        task$1.runnable().run();
    }

    public class Item {
        private final Option interval;
        private final Runnable runnable;

        public Item(Option<FiniteDuration> interval, Runnable runnable) {
            this.interval = interval;
            this.runnable = runnable;
        }

        public Option<FiniteDuration> interval() {
            return this.interval;
        }

        public Runnable runnable() {
            return this.runnable;
        }
    }
}

